/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.Date;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.ScenarioRenameShuffleInstance;
import org.alfresco.filesys.repo.rules.commands.SoftRenameFileCommand;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ScenarioRenameCreateShuffleInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioRenameShuffleInstance.class);
    private Date startTime = new Date();
    private long timeout = 30000L;
    private boolean isComplete = false;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;
    InternalState state = InternalState.NONE;
    String from;
    String to;

    ScenarioRenameCreateShuffleInstance() {
    }

    @Override
    public Command evaluate(Operation operation) {
        Date now = new Date();
        if (now.getTime() > this.startTime.getTime() + this.getTimeout()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Instance timed out");
            }
            this.isComplete = true;
            return null;
        }
        switch (this.state) {
            case NONE: {
                if (!(operation instanceof RenameFileOperation)) break;
                logger.debug((Object)"New scenario initialised");
                RenameFileOperation r = (RenameFileOperation)operation;
                this.from = r.getFrom();
                this.to = r.getTo();
                this.state = InternalState.INITIALISED;
                SoftRenameFileCommand r1 = new SoftRenameFileCommand(this.from, this.to, r.getRootNodeRef(), r.getFromPath(), r.getToPath());
                this.isComplete = true;
                return r1;
            }
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    public String toString() {
        return "ScenarioRenameCreateShuffleInstance from:" + this.from + " to:" + this.to;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    static enum InternalState {
        NONE,
        INITIALISED,
        LOOK_FOR_DELETE;

    }
}

