/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.LocalTransform;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.UnsupportedTransformationException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformOptionGroup;
import org.alfresco.transform.config.TransformOptionValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractLocalTransform
implements LocalTransform {
    protected static final Log log = LogFactory.getLog(LocalTransform.class);
    protected final String name;
    protected final MimetypeService mimetypeService;
    protected final NodeService nodeService;
    protected final TransformerDebug transformerDebug;
    protected final Set<String> transformsTransformOptionNames = new HashSet<String>();
    private final LocalTransformServiceRegistry localTransformServiceRegistry;
    private final boolean strictMimeTypeCheck;
    private final Map<String, Set<String>> strictMimetypeExceptions;
    private final boolean retryTransformOnDifferentMimeType;
    private static final ThreadLocal<Integer> depth = ThreadLocal.withInitial(() -> 0);

    AbstractLocalTransform(String name, TransformerDebug transformerDebug, MimetypeService mimetypeService, boolean strictMimeTypeCheck, Map<String, Set<String>> strictMimetypeExceptions, boolean retryTransformOnDifferentMimeType, Set<TransformOption> transformsTransformOptions, LocalTransformServiceRegistry localTransformServiceRegistry, NodeService nodeService) {
        this.name = name;
        this.transformerDebug = transformerDebug;
        this.mimetypeService = mimetypeService;
        this.strictMimeTypeCheck = strictMimeTypeCheck;
        this.strictMimetypeExceptions = strictMimetypeExceptions;
        this.retryTransformOnDifferentMimeType = retryTransformOnDifferentMimeType;
        this.localTransformServiceRegistry = localTransformServiceRegistry;
        this.nodeService = nodeService;
        AbstractLocalTransform.addOptionNames(this.transformsTransformOptionNames, transformsTransformOptions);
    }

    public abstract boolean isAvailable();

    protected abstract void transformImpl(ContentReader var1, ContentWriter var2, Map<String, String> var3, String var4, String var5, String var6, String var7, String var8, NodeRef var9) throws UnsupportedTransformationException, ContentIOException;

    @Override
    public String getName() {
        return this.name;
    }

    public Set<String> getTransformsTransformOptionNames() {
        return this.transformsTransformOptionNames;
    }

    @Override
    public void transform(ContentReader reader, ContentWriter writer, Map<String, String> transformOptions, String renditionName, NodeRef sourceNodeRef) {
        if (this.isAvailable()) {
            String sourceMimetype = reader.getMimetype();
            String targetMimetype = writer.getMimetype();
            String sourceExtension = this.mimetypeService.getExtension(sourceMimetype);
            String targetExtension = this.mimetypeService.getExtension(targetMimetype);
            if (sourceExtension == null || targetExtension == null) {
                throw new AlfrescoRuntimeException("Unknown extensions for mimetypes: \n   source mimetype: " + sourceMimetype + "\n   source extension: " + sourceExtension + "\n   target mimetype: " + targetMimetype + "\n   target extension: " + targetExtension);
            }
            transformOptions = this.getStrippedTransformOptions(transformOptions);
            this.transformWithDebug(reader, writer, transformOptions, renditionName, sourceNodeRef, sourceMimetype, targetMimetype, sourceExtension, targetExtension);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Local transformation completed: \n   source: " + String.valueOf(reader) + "\n   target: " + String.valueOf(writer) + "\n   options: " + String.valueOf(transformOptions)));
            }
        } else if (log.isDebugEnabled()) {
            transformOptions = this.getStrippedTransformOptions(transformOptions);
            log.debug((Object)("Local transformer not available: \n   source: " + String.valueOf(reader) + "\n   target: " + String.valueOf(writer) + "\n   options: " + String.valueOf(transformOptions)));
        }
    }

    private void transformWithDebug(ContentReader reader, ContentWriter writer, Map<String, String> transformOptions, String renditionName, NodeRef sourceNodeRef, String sourceMimetype, String targetMimetype, String sourceExtension, String targetExtension) {
        try {
            try {
                depth.set(depth.get() + 1);
                if (this.transformerDebug.isEnabled()) {
                    this.transformerDebug.pushTransform("Local:" + this.name, reader.getContentUrl(), sourceMimetype, targetMimetype, reader.getSize(), transformOptions, renditionName, sourceNodeRef);
                }
                this.strictMimetypeCheck(reader, sourceNodeRef, sourceMimetype);
                this.transformImpl(reader, writer, transformOptions, sourceMimetype, targetMimetype, sourceExtension, targetExtension, renditionName, sourceNodeRef);
            }
            catch (Throwable e) {
                this.retryWithDifferentMimetype(reader, writer, targetMimetype, transformOptions, renditionName, sourceNodeRef, e);
                this.transformerDebug.popTransform();
                depth.set(depth.get() - 1);
            }
        }
        finally {
            this.transformerDebug.popTransform();
            depth.set(depth.get() - 1);
        }
    }

    private void strictMimetypeCheck(ContentReader reader, NodeRef sourceNodeRef, String declaredMimetype) {
        Set<String> allowedMimetypes;
        String detectedMimetype;
        if (this.mimetypeService != null && this.strictMimeTypeCheck && depth.get() == 1 && !this.strictMimetypeCheck(declaredMimetype, detectedMimetype = this.mimetypeService.getMimetypeIfNotMatches(reader.getReader())) && (allowedMimetypes = this.strictMimetypeExceptions.get(declaredMimetype)) != null && allowedMimetypes.contains(detectedMimetype)) {
            String filename = this.transformerDebug.getFilename(sourceNodeRef, true);
            String readerSourceMimetype = reader.getMimetype();
            String message = "Transformation of (" + filename + ") has not taken place because the declared mimetype (" + readerSourceMimetype + ") does not match the detected mimetype (" + detectedMimetype + ").";
            log.warn((Object)message);
            throw new UnsupportedTransformationException(message);
        }
    }

    private boolean strictMimetypeCheck(String declaredMimetype, String detectedMimetype) {
        if (detectedMimetype == null) {
            return true;
        }
        Set<String> detectedMimetypes = this.strictMimetypeExceptions.get(declaredMimetype);
        return detectedMimetypes != null && detectedMimetypes.contains(detectedMimetype);
    }

    private void retryWithDifferentMimetype(ContentReader reader, ContentWriter writer, String targetMimetype, Map<String, String> transformOptions, String renditionName, NodeRef sourceNodeRef, Throwable e) {
        if (this.mimetypeService != null && this.localTransformServiceRegistry != null) {
            String differentType = this.mimetypeService.getMimetypeIfNotMatches(reader.getReader());
            if (differentType == null) {
                this.transformerDebug.debug("          Failed", e);
                throw new ContentIOException("Content conversion failed: \n   reader: " + String.valueOf(reader) + "\n   writer: " + String.valueOf(writer) + "\n   options: " + String.valueOf(transformOptions), e);
            }
            this.transformerDebug.debug("          Failed: Mimetype was '" + differentType + "'", e);
            String claimedMimetype = reader.getMimetype();
            if (this.retryTransformOnDifferentMimeType) {
                reader = reader.getReader();
                reader.setMimetype(differentType);
                long sourceSizeInBytes = reader.getSize();
                LocalTransform localTransform = this.localTransformServiceRegistry.getLocalTransform(differentType, sourceSizeInBytes, targetMimetype, transformOptions, renditionName);
                if (localTransform == null) {
                    this.transformerDebug.debug("          Failed", e);
                    throw new ContentIOException("Content conversion failed: \n   reader: " + String.valueOf(reader) + "\n   writer: " + String.valueOf(writer) + "\n   options: " + String.valueOf(transformOptions) + "\n   claimed mime type: " + claimedMimetype + "\n   detected mime type: " + differentType + "\n   transformer not found\n", e);
                }
                localTransform.transform(reader, writer, transformOptions, renditionName, sourceNodeRef);
            } else {
                throw new ContentIOException("Content conversion failed: \n   reader: " + String.valueOf(reader) + "\n   writer: " + String.valueOf(writer) + "\n   options: " + String.valueOf(transformOptions) + "\n   claimed mime type: " + claimedMimetype + "\n   detected mime type: " + differentType, e);
            }
        }
    }

    private static void addOptionNames(Set<String> transformsTransformOptionNames, Set<TransformOption> transformsTransformOptions) {
        for (TransformOption transformOption : transformsTransformOptions) {
            if (transformOption instanceof TransformOptionValue) {
                transformsTransformOptionNames.add(((TransformOptionValue)transformOption).getName());
                continue;
            }
            AbstractLocalTransform.addOptionNames(transformsTransformOptionNames, ((TransformOptionGroup)transformOption).getTransformOptions());
        }
    }

    public Map<String, String> getStrippedTransformOptions(Map<String, String> transformOptions) {
        Set<String> optionNames = transformOptions.keySet();
        if (this.transformsTransformOptionNames.containsAll(optionNames)) {
            return transformOptions;
        }
        HashMap<String, String> strippedTransformOptions = new HashMap<String, String>(transformOptions.size());
        for (Map.Entry<String, String> entry : transformOptions.entrySet()) {
            String key = entry.getKey();
            if (!this.transformsTransformOptionNames.contains(key)) continue;
            String value = entry.getValue();
            strippedTransformOptions.put(key, value);
        }
        return strippedTransformOptions;
    }
}

