/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.authentication;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.id.State;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.external.ExternalUserAuthenticator;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceMetadataKey;
import org.alfresco.repo.security.authentication.identityservice.authentication.AdditionalHeadersHttpServletRequestWrapper;
import org.alfresco.repo.security.authentication.identityservice.authentication.AdminAuthenticationCookiesService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractIdentityServiceAuthenticator
implements ExternalUserAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIdentityServiceAuthenticator.class);
    private static final String ALFRESCO_ACCESS_TOKEN = "ALFRESCO_ACCESS_TOKEN";
    private static final String ALFRESCO_REFRESH_TOKEN = "ALFRESCO_REFRESH_TOKEN";
    private static final String ALFRESCO_TOKEN_EXPIRATION = "ALFRESCO_TOKEN_EXPIRATION";
    protected IdentityServiceConfig identityServiceConfig;
    protected IdentityServiceFacade identityServiceFacade;
    protected AdminAuthenticationCookiesService cookiesService;
    protected RemoteUserMapper remoteUserMapper;

    protected abstract String getConfiguredRedirectPath();

    protected abstract Set<String> getConfiguredScopes();

    @Override
    public String getUserId(HttpServletRequest request, HttpServletResponse response) {
        String username = this.remoteUserMapper.getRemoteUser(request);
        if (username != null) {
            return username;
        }
        String bearerToken = this.cookiesService.getCookie(ALFRESCO_ACCESS_TOKEN, request);
        if (bearerToken != null) {
            bearerToken = this.refreshTokenIfNeeded(request, response, bearerToken);
        } else {
            String code = request.getParameter("code");
            if (code != null) {
                bearerToken = this.retrieveTokenUsingAuthCode(request, response, code);
            }
        }
        if (bearerToken == null) {
            return null;
        }
        HttpServletRequest wrappedRequest = this.newRequestWrapper(Map.of("Authorization", "Bearer " + bearerToken), request);
        return this.remoteUserMapper.getRemoteUser(wrappedRequest);
    }

    @Override
    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Responding with the authentication challenge");
            }
            String authenticationRequest = this.buildAuthRequestUrl(request);
            response.sendRedirect(authenticationRequest);
        }
        catch (IOException e) {
            LOGGER.error("Error while trying to respond with the authentication challenge: {}", (Object)e.getMessage(), (Object)e);
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getRedirectUri(String requestURL) {
        return this.buildRedirectUri(requestURL, this.getConfiguredRedirectPath());
    }

    public String buildAuthRequestUrl(HttpServletRequest request) {
        ClientRegistration clientRegistration = this.identityServiceFacade.getClientRegistration();
        State state = new State();
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)clientRegistration.getProviderDetails().getAuthorizationUri()).queryParam("client_id", new Object[]{clientRegistration.getClientId()}).queryParam("redirect_uri", new Object[]{this.getRedirectUri(request.getRequestURL().toString())}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{String.join((CharSequence)"+", this.getConfiguredScopes(clientRegistration))}).queryParam("state", new Object[]{state.toString()});
        if (StringUtils.isNotBlank((CharSequence)this.identityServiceConfig.getAudience())) {
            builder.queryParam("audience", new Object[]{this.identityServiceConfig.getAudience()});
        }
        return builder.build().toUriString();
    }

    private Set<String> getConfiguredScopes(ClientRegistration clientRegistration) {
        return Optional.ofNullable(clientRegistration.getProviderDetails()).map(ClientRegistration.ProviderDetails::getConfigurationMetadata).map(metadata -> metadata.get(IdentityServiceMetadataKey.SCOPES_SUPPORTED.getValue())).filter(Scope.class::isInstance).map(Scope.class::cast).map(this::getSupportedScopes).orElse(clientRegistration.getScopes());
    }

    private Set<String> getSupportedScopes(Scope scopes) {
        Set<String> configuredScopes = this.getConfiguredScopes();
        return scopes.stream().map(Identifier::getValue).filter(configuredScopes::contains).collect(Collectors.toSet());
    }

    protected String buildRedirectUri(String requestURL, String overridePath) {
        try {
            URI originalUri = new URI(requestURL);
            String path = overridePath != null ? overridePath : originalUri.getPath();
            URI redirectUri = new URI(originalUri.getScheme(), originalUri.getAuthority(), path, originalUri.getQuery(), originalUri.getFragment());
            return redirectUri.toASCIIString();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Redirect URI construction failed: {}", (Object)e.getMessage(), (Object)e);
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    public void challenge(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.sendRedirect(this.buildAuthRequestUrl(request));
        }
        catch (IOException e) {
            throw new AuthenticationException("Auth redirect failed", (Throwable)e);
        }
    }

    protected String retrieveTokenUsingAuthCode(HttpServletRequest request, HttpServletResponse response, String code) {
        try {
            IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization = this.identityServiceFacade.authorize(IdentityServiceFacade.AuthorizationGrant.authorizationCode(code, this.getRedirectUri(request.getRequestURL().toString())));
            this.addCookies(response, accessTokenAuthorization);
            return accessTokenAuthorization.getAccessToken().getTokenValue();
        }
        catch (IdentityServiceFacade.AuthorizationException exception) {
            LOGGER.warn("Error while trying to retrieve token using Authorization Code: {}", (Object)exception.getMessage());
            return null;
        }
    }

    protected String refreshTokenIfNeeded(HttpServletRequest request, HttpServletResponse response, String bearerToken) {
        String refreshToken = this.cookiesService.getCookie(ALFRESCO_REFRESH_TOKEN, request);
        String authTokenExpiration = this.cookiesService.getCookie(ALFRESCO_TOKEN_EXPIRATION, request);
        try {
            if (AbstractIdentityServiceAuthenticator.isAuthTokenExpired(authTokenExpiration)) {
                bearerToken = this.refreshAuthToken(refreshToken, response);
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Token refresh failed: {}", (Object)e.getMessage());
            }
            bearerToken = null;
            this.resetCookies(response);
        }
        return bearerToken;
    }

    private static boolean isAuthTokenExpired(String authTokenExpiration) {
        return authTokenExpiration == null || Instant.now().compareTo(Instant.ofEpochMilli(Long.parseLong(authTokenExpiration))) >= 0;
    }

    private String refreshAuthToken(String refreshToken, HttpServletResponse response) {
        IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization = this.identityServiceFacade.authorize(IdentityServiceFacade.AuthorizationGrant.refreshToken(refreshToken));
        if (accessTokenAuthorization == null || accessTokenAuthorization.getAccessToken() == null) {
            throw new AuthenticationException("Refresh token response is invalid.");
        }
        this.addCookies(response, accessTokenAuthorization);
        return accessTokenAuthorization.getAccessToken().getTokenValue();
    }

    protected void addCookies(HttpServletResponse response, IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization) {
        this.cookiesService.addCookie(ALFRESCO_ACCESS_TOKEN, accessTokenAuthorization.getAccessToken().getTokenValue(), response);
        this.cookiesService.addCookie(ALFRESCO_TOKEN_EXPIRATION, String.valueOf(accessTokenAuthorization.getAccessToken().getExpiresAt().toEpochMilli()), response);
        this.cookiesService.addCookie(ALFRESCO_REFRESH_TOKEN, accessTokenAuthorization.getRefreshTokenValue(), response);
    }

    protected void resetCookies(HttpServletResponse response) {
        this.cookiesService.resetCookie(ALFRESCO_TOKEN_EXPIRATION, response);
        this.cookiesService.resetCookie(ALFRESCO_ACCESS_TOKEN, response);
        this.cookiesService.resetCookie(ALFRESCO_REFRESH_TOKEN, response);
    }

    protected HttpServletRequest newRequestWrapper(Map<String, String> headers, HttpServletRequest request) {
        return new AdditionalHeadersHttpServletRequestWrapper(headers, request);
    }

    public void setIdentityServiceConfig(IdentityServiceConfig config) {
        this.identityServiceConfig = config;
    }

    public void setIdentityServiceFacade(IdentityServiceFacade facade) {
        this.identityServiceFacade = facade;
    }

    public void setCookiesService(AdminAuthenticationCookiesService service) {
        this.cookiesService = service;
    }

    public void setRemoteUserMapper(RemoteUserMapper mapper) {
        this.remoteUserMapper = mapper;
    }
}

