/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

public class DateUtil {
    private DateUtil() {
    }

    public static int calculateDays(long startMs, long endMs) {
        int days;
        DateTime startDateTime = new DateTime(startMs).withTimeAtStartOfDay();
        DateTime endDateTime = new DateTime(endMs).withTimeAtStartOfDay();
        if (endDateTime.isBefore((ReadableInstant)startDateTime)) {
            Interval interval = new Interval((ReadableInstant)endDateTime, (ReadableInstant)startDateTime);
            Period period = interval.toPeriod(PeriodType.days());
            days = 0 - period.getDays();
        } else {
            Interval interval = new Interval((ReadableInstant)startDateTime, (ReadableInstant)endDateTime);
            Period period = interval.toPeriod(PeriodType.days());
            days = period.getDays();
        }
        return days;
    }

    public static int calculateMs(long startMs, long endMs) {
        int milliseconds;
        DateTime endDateTime = new DateTime(endMs);
        DateTime startDateTime = new DateTime(startMs);
        if (endDateTime.isBefore((ReadableInstant)startDateTime)) {
            Interval interval = new Interval((ReadableInstant)endDateTime, (ReadableInstant)startDateTime);
            Period period = interval.toPeriod(PeriodType.millis());
            milliseconds = 0 - period.getMillis();
        } else {
            Interval interval = new Interval((ReadableInstant)startDateTime, (ReadableInstant)endDateTime);
            Period period = interval.toPeriod(PeriodType.millis());
            milliseconds = period.getMillis();
        }
        return milliseconds;
    }
}

