/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.sync;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactoryImpl;
import org.alfresco.repo.security.person.PersonServiceImpl;
import org.alfresco.repo.security.sync.ChainingUserRegistrySynchronizer;
import org.alfresco.repo.security.sync.ChainingUserRegistrySynchronizerStatus;
import org.alfresco.repo.security.sync.NodeDescription;
import org.alfresco.repo.security.sync.SynchronizeDiagnostic;
import org.alfresco.repo.security.sync.SynchronizeDirectoryEndEvent;
import org.alfresco.repo.security.sync.SynchronizeEndEvent;
import org.alfresco.repo.security.sync.UserRegistry;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.repo.security.sync.ldap.AbstractDirectoryServiceUserAccountStatusInterpreter;
import org.alfresco.repo.security.sync.ldap.LDAPUserAccountStatusInterpreter;
import org.alfresco.repo.security.sync.ldap.LDAPUserRegistry;
import org.alfresco.repo.security.sync.ldap_ad.LDAPADUserAccountStatusInterpreter;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Category(value={LuceneTests.class})
public class ChainingUserRegistrySynchronizerTest
extends TestCase {
    private static final String[] CONFIG_LOCATIONS = new String[]{"classpath:alfresco/application-context.xml", "classpath:sync-test-context.xml"};
    private static ApplicationContext context = new ClassPathXmlApplicationContext(CONFIG_LOCATIONS);
    private UserRegistrySynchronizer synchronizer;
    private MockApplicationContextManager applicationContextManager;
    private NamespaceService namespaceService;
    private PersonService personService;
    private AuthorityService authorityService;
    private NodeService nodeService;
    private AuthenticationContext authenticationContext;
    private RetryingTransactionHelper retryingTransactionHelper;
    private boolean homeFolderCreationEager;
    private static final Log logger = LogFactory.getLog(ChainingUserRegistrySynchronizerTest.class);

    protected void setUp() throws Exception {
        this.synchronizer = (UserRegistrySynchronizer)context.getBean("testUserRegistrySynchronizer");
        this.applicationContextManager = (MockApplicationContextManager)context.getBean("testApplicationContextManager");
        this.personService = (PersonService)context.getBean("personService");
        this.authorityService = (AuthorityService)context.getBean("authorityService");
        this.nodeService = (NodeService)context.getBean("nodeService");
        this.authenticationContext = (AuthenticationContext)context.getBean("authenticationContext");
        this.authenticationContext.setSystemUserAsCurrentUser();
        this.retryingTransactionHelper = (RetryingTransactionHelper)context.getBean("retryingTransactionHelper");
        this.setHomeFolderCreationEager(false);
        this.namespaceService = (NamespaceService)context.getBean("namespaceService");
    }

    protected void tearDown() throws Exception {
        this.authenticationContext.clearCurrentSecurityContext();
        this.setHomeFolderCreationEager(true);
    }

    private void setUpTestUsersAndGroups() throws Exception {
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z0", new NodeDescription[]{this.newPerson("U6")}, new NodeDescription[]{this.newGroup("G1", new String[0])}), new MockUserRegistry("Z1", new NodeDescription[]{this.newPerson("U1"), this.newPerson("U2"), this.newPerson("U7")}, new NodeDescription[]{this.newGroup("G2", "U1", "G3"), this.newGroup("G3", "U2", "G4", "G5"), this.newGroup("G4", new String[0]), this.newGroup("G5", new String[0])}), new MockUserRegistry("Z2", new NodeDescription[]{this.newPerson("U1"), this.newPerson("U3"), this.newPerson("U4"), this.newPerson("U5")}, new NodeDescription[]{this.newGroup("G2", "U1", "U3", "U4"), this.newGroup("G6", "U3", "U4", "G7"), this.newGroup("G7", "U5")}));
        this.synchronizer.synchronize(true, true);
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z0", "U6", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z0", "G1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U2", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G2", "U1", "G3");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G3", "U2", "G4", "G5");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U3", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G6", "U3", "U4", "G7");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G7", "U5");
                return null;
            }
        }, false, true);
    }

    public void tearDownTestUsersAndGroups() throws Exception {
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z0", new NodeDescription[]{this.newPerson("U1"), this.newPerson("U2"), this.newPerson("U3"), this.newPerson("U4"), this.newPerson("U5"), this.newPerson("U6"), this.newPerson("U7")}, new NodeDescription[]{this.newGroup("G1", new String[0]), this.newGroup("G2", new String[0]), this.newGroup("G3", new String[0]), this.newGroup("G4", new String[0]), this.newGroup("G5", new String[0]), this.newGroup("G6", new String[0]), this.newGroup("G7", new String[0])}), new MockUserRegistry("Z1", new NodeDescription[0], new NodeDescription[0]), new MockUserRegistry("Z2", new NodeDescription[0], new NodeDescription[0]));
        this.synchronizer.synchronize(true, true);
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z0", new NodeDescription[0], new NodeDescription[0]), new MockUserRegistry("Z1", new NodeDescription[0], new NodeDescription[0]), new MockUserRegistry("Z2", new NodeDescription[0], new NodeDescription[0]));
        this.synchronizer.synchronize(true, true);
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U1");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U2");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U3");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U4");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U5");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U6");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U7");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G1");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G2");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G3");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G4");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G5");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G6");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G7");
                return null;
            }
        }, false, true);
    }

    public void setHomeFolderCreationEager(boolean homeFolderCreationEager) {
        this.homeFolderCreationEager = homeFolderCreationEager;
        ((PersonServiceImpl)this.personService).setHomeFolderCreationEager(homeFolderCreationEager);
    }

    public void testDifferentialUpdate() throws Exception {
        this.setUpTestUsersAndGroups();
        this.applicationContextManager.removeZone("Z0");
        this.applicationContextManager.updateZone("Z1", new NodeDescription[]{this.newPerson("U1", "changeofemail@alfresco.com"), this.newPerson("U6"), this.newPerson("U7")}, new NodeDescription[]{this.newGroup("G1", "U1", "U6", "UDangling", "G2"), this.newGroup("G2", "U1", "GDangling", "G1"), this.newGroupWithDisplayName("G5", "Amazing Group", "U6", "U7", "G4")});
        this.applicationContextManager.updateZone("Z2", new NodeDescription[]{this.newPerson("U1", "shouldbeignored@alfresco.com"), this.newPerson("U5", "u5email@alfresco.com"), this.newPerson("U6"), this.newPerson("U8")}, new NodeDescription[]{this.newGroup("G2", "U1", "U3", "U4", "U6"), this.newGroup("G7", new String[0]), this.newGroup("G8", "U4", "U8")});
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        (this).ChainingUserRegistrySynchronizerTest.this.synchronizer.synchronize(false, false);
                        return null;
                    }
                });
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertEmailEquals("U1", "changeofemail@alfresco.com");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U2", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U6", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U7", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G1", "U1", "U6");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G2", "U1", "G1");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G3", "U2", "G4", "G5");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G5", "U6", "U7", "G4");
                ChainingUserRegistrySynchronizerTest.this.assertGroupDisplayNameEquals("G5", "Amazing Group");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U3", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertEmailEquals("U5", "u5email@alfresco.com");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U8", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G6", "U3", "U4", "G7");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G7", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G8", "U4", "U8");
                return null;
            }
        });
        this.tearDownTestUsersAndGroups();
    }

    public void testForcedUpdate() throws Exception {
        this.setUpTestUsersAndGroups();
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z1", new NodeDescription[]{this.newPerson("U2"), this.newPerson("u3"), this.newPerson("U6")}, new NodeDescription[]{this.newGroup("G1", "U6", "G5"), this.newGroup("G2", "G1"), this.newGroup("G3", "U2", "G5"), this.newGroup("G5", "U6", "G2"), this.newGroup("G6", "u3")}), new MockUserRegistry("Z2", new NodeDescription[]{this.newPerson("U1", "somenewemail@alfresco.com"), this.newPerson("U3"), this.newPerson("U6"), this.newPerson("U8")}, new NodeDescription[]{this.newGroup("G2", "U1", "U3", "U4", "U6"), this.newGroup("G6", "U3", "U4", "G7"), this.newGroupWithDisplayName("G7", "Late Arrival", "U4", "U5"), this.newGroup("G8", "U1", "U8")}));
        this.synchronizer.synchronize(true, true);
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U2", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "u3", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U6", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G1", "U6");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G2", "G1");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G3", "U2", "G5");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G4");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G5", "U6", "G2");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G6", "u3");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertEmailEquals("U1", "somenewemail@alfresco.com");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U4");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U5");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U8", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G7", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertGroupDisplayNameEquals("G7", "Late Arrival");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G8", "U1", "U8");
                return null;
            }
        }, false, true);
        this.tearDownTestUsersAndGroups();
    }

    private void testLDAPDisableUserAccount(AbstractDirectoryServiceUserAccountStatusInterpreter userAccountStatusInterpreter, String enabledAccountPropertyValue, String disabledAccountPropertyValue) throws Exception {
        MockUserRegistry mockUserRegistry = new MockUserRegistry("ldap1", new NodeDescription[]{this.newPersonWithUserAccountStatusProperty("EnabledUser", enabledAccountPropertyValue), this.newPersonWithUserAccountStatusProperty("DisabledUser", disabledAccountPropertyValue)}, new NodeDescription[0]);
        MockLDAPUserRegistry mockLDAPUserRegistry = new MockLDAPUserRegistry(mockUserRegistry);
        mockLDAPUserRegistry.setUserAccountStatusInterpreter(userAccountStatusInterpreter);
        this.applicationContextManager.setUserRegistries(mockLDAPUserRegistry);
        ChainingUserRegistrySynchronizer chainingSynchronizer = (ChainingUserRegistrySynchronizer)this.synchronizer;
        chainingSynchronizer.setExternalUserControl("true");
        chainingSynchronizer.setExternalUserControlSubsystemName("ldap1");
        this.synchronizer.synchronize(false, false);
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                NodeRef enabledUserRef = ChainingUserRegistrySynchronizerTest.this.personService.getPerson("EnabledUser", false);
                ChainingUserRegistrySynchronizerTest.assertFalse((boolean)ChainingUserRegistrySynchronizerTest.this.nodeService.hasAspect(enabledUserRef, ContentModel.ASPECT_PERSON_DISABLED));
                NodeRef disabledUserRef = ChainingUserRegistrySynchronizerTest.this.personService.getPerson("DisabledUser", false);
                ChainingUserRegistrySynchronizerTest.assertTrue((boolean)ChainingUserRegistrySynchronizerTest.this.nodeService.hasAspect(disabledUserRef, ContentModel.ASPECT_PERSON_DISABLED));
                return null;
            }
        }, false, true);
    }

    public void testLDAPDisableUserAccountWithActiveDirectoryProperty() throws Exception {
        LDAPADUserAccountStatusInterpreter ldapadUserAccountStatusInterpreter = new LDAPADUserAccountStatusInterpreter();
        this.testLDAPDisableUserAccount((AbstractDirectoryServiceUserAccountStatusInterpreter)ldapadUserAccountStatusInterpreter, "512", "514");
    }

    public void testLDAPDisableUserAccountWithNetscapDSProperty() throws Exception {
        LDAPUserAccountStatusInterpreter ldapUserAccountStatusInterpreter = new LDAPUserAccountStatusInterpreter();
        ldapUserAccountStatusInterpreter.setAcceptNullArgument(true);
        ldapUserAccountStatusInterpreter.setDisabledAccountPropertyValue("true");
        this.testLDAPDisableUserAccount((AbstractDirectoryServiceUserAccountStatusInterpreter)ldapUserAccountStatusInterpreter, null, "true");
    }

    public void testLDAPDisableUserAccountWithOpenLDAPProperty() throws Exception {
        LDAPUserAccountStatusInterpreter ldapUserAccountStatusInterpreter = new LDAPUserAccountStatusInterpreter();
        ldapUserAccountStatusInterpreter.setAcceptNullArgument(true);
        ldapUserAccountStatusInterpreter.setDisabledAccountPropertyValue("000001010000Z");
        this.testLDAPDisableUserAccount((AbstractDirectoryServiceUserAccountStatusInterpreter)ldapUserAccountStatusInterpreter, null, "000001010000Z");
    }

    public void testForcedUpdateWithoutDeletions() throws Exception {
        UserRegistrySynchronizer synchronizer = (UserRegistrySynchronizer)context.getBean("testUserRegistrySynchronizerPreventDeletions");
        this.setUpTestUsersAndGroups();
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z0", new NodeDescription[]{this.newPerson("U2"), this.newPerson("U3"), this.newPerson("U4")}, new NodeDescription[]{this.newGroup("G1", new String[0]), this.newGroup("G2", new String[0])}), new MockUserRegistry("Z1", new NodeDescription[]{this.newPerson("U5"), this.newPerson("u6")}, new NodeDescription[0]), new MockUserRegistry("Z2", new NodeDescription[]{this.newPerson("U6")}, new NodeDescription[0]));
        synchronizer.synchronize(true, true);
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z0", "U6", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U7", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G6", "U3", "U4", "G7");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U5", new String[0]);
                return null;
            }
        }, false, true);
        this.tearDownTestUsersAndGroups();
    }

    public void testCaseChange() throws Exception {
        this.setUpTestUsersAndGroups();
        final TreeMap personNodes = new TreeMap();
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                personNodes.put("u1", ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U1", false));
                personNodes.put("u2", ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U2", false));
                personNodes.put("u6", ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U6", false));
                return null;
            }
        }, false, true);
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z1", new NodeDescription[]{this.newPerson("u1"), this.newPerson("u2"), this.newPerson("u6"), this.newPerson("U7")}, new NodeDescription[]{this.newGroup("g1", "u6"), this.newGroup("g2", "u1", "G3"), this.newGroup("G3", "u2", "g4", "g5"), this.newGroup("g4", new String[0]), this.newGroup("g5", new String[0])}), new MockUserRegistry("Z2", new NodeDescription[]{this.newPerson("U1"), this.newPerson("U3"), this.newPerson("U4"), this.newPerson("U5")}, new NodeDescription[]{this.newGroup("G2", "U1", "U3", "U4"), this.newGroup("G6", "U3", "U4", "G7"), this.newGroup("G7", "U5")}));
        this.synchronizer.synchronize(true, true);
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "u1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "u2", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "u6", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "g1", "u6");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "g2", "u1", "G3");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G3", "u2", "g4", "g5");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "g4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "g5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U3", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G2", "U3", "U4");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G6", "U3", "U4", "G7");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G7", "U5");
                ChainingUserRegistrySynchronizerTest.assertEquals(personNodes.get("u1"), (Object)ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U1", false));
                ChainingUserRegistrySynchronizerTest.assertEquals(personNodes.get("u2"), (Object)ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U2", false));
                ChainingUserRegistrySynchronizerTest.assertEquals(personNodes.get("u6"), (Object)ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U6", false));
                return null;
            }
        }, false, true);
        this.tearDownTestUsersAndGroups();
    }

    public void testDifferentialUpdateWithHomeFolderCreation() throws Exception {
        this.setHomeFolderCreationEager(!this.homeFolderCreationEager);
        this.testDifferentialUpdate();
    }

    public void testForcedUpdateWithHomeFolderCreation() throws Exception {
        this.setHomeFolderCreationEager(!this.homeFolderCreationEager);
        this.testDifferentialUpdate();
    }

    public void testCaseChangeWithHomeFolderCreation() throws Exception {
        this.setHomeFolderCreationEager(!this.homeFolderCreationEager);
        this.testDifferentialUpdate();
    }

    public void testVolume() throws Exception {
        ArrayList<NodeDescription> persons = new ArrayList<NodeDescription>(new RandomPersonCollection(100));
        ArrayList<NodeDescription> groups = new ArrayList<NodeDescription>(new RandomGroupCollection(50, persons));
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z0", persons, groups));
        this.synchronizer.synchronize(true, true);
        this.tearDownTestUsersAndGroups();
    }

    public void testTestSynchronize() throws Exception {
        String TEST_REGISTRY_NAME = "Z0";
        String TEST_REGISTRY_NAME_BAD = "XX";
        ArrayList<NodeDescription> persons = new ArrayList<NodeDescription>(new RandomPersonCollection(100));
        ArrayList<NodeDescription> groups = new ArrayList<NodeDescription>(new RandomGroupCollection(50, persons));
        MockUserRegistry testRegistry = new MockUserRegistry(TEST_REGISTRY_NAME, persons, groups);
        this.applicationContextManager.setUserRegistries(testRegistry);
        Collection<String> instances = this.applicationContextManager.getInstanceIds();
        try {
            ChainingUserRegistrySynchronizerTest.assertTrue((String)"pre-condition test registry isActive", (boolean)testRegistry.isActive());
            ChainingUserRegistrySynchronizerTest.assertTrue((String)"pre-condition test registry in application context", (boolean)instances.contains(TEST_REGISTRY_NAME));
            ChainingUserRegistrySynchronizerTest.assertFalse((String)"pre-condition test registry isActive", (boolean)instances.contains(TEST_REGISTRY_NAME_BAD));
            if (this.synchronizer instanceof ChainingUserRegistrySynchronizer) {
                ChainingUserRegistrySynchronizer chainingSynchronizer = (ChainingUserRegistrySynchronizer)this.synchronizer;
                SynchronizeDiagnostic diagnostic = chainingSynchronizer.testSynchronize(TEST_REGISTRY_NAME);
                ChainingUserRegistrySynchronizerTest.assertTrue((String)"diagnostic is active", (boolean)diagnostic.isActive());
                ChainingUserRegistrySynchronizerTest.assertNotNull((String)"diagnostic users are null", (Object)diagnostic.getUsers());
                ChainingUserRegistrySynchronizerTest.assertNotNull((String)"diagnostic groups are null", (Object)diagnostic.getGroups());
                testRegistry.setActive(false);
                diagnostic = chainingSynchronizer.testSynchronize(TEST_REGISTRY_NAME);
                ChainingUserRegistrySynchronizerTest.assertFalse((String)"diagnostic is still active", (boolean)diagnostic.isActive());
                ChainingUserRegistrySynchronizerTest.assertNotNull((String)"diagnostic users are null", (Object)diagnostic.getUsers());
                ChainingUserRegistrySynchronizerTest.assertNotNull((String)"diagnostic groups are null", (Object)diagnostic.getGroups());
                try {
                    chainingSynchronizer.testSynchronize(TEST_REGISTRY_NAME_BAD);
                    ChainingUserRegistrySynchronizerTest.fail((String)"bad user registry not detected");
                }
                catch (AuthenticationException authenticationException) {}
            } else {
                ChainingUserRegistrySynchronizerTest.fail((String)"test not run - synchroniser is not a ChainingUserRegistrySynchronizer");
            }
        }
        finally {
            this.tearDownTestUsersAndGroups();
        }
    }

    public void testSyncStatus() throws Exception {
        Date testStart = new Date();
        try {
            ChainingUserRegistrySynchronizerStatus status;
            ArrayList<NodeDescription> persons = new ArrayList<NodeDescription>(new RandomPersonCollection(3));
            ArrayList<NodeDescription> groups = new ArrayList<NodeDescription>(new RandomGroupCollection(4, persons));
            MockUserRegistry testRegistry = new MockUserRegistry("Z0", persons, groups);
            this.applicationContextManager.setUserRegistries(testRegistry);
            this.synchronizer.synchronize(true, true);
            if (this.synchronizer instanceof ChainingUserRegistrySynchronizerStatus) {
                status = (ChainingUserRegistrySynchronizerStatus)this.synchronizer;
                ChainingUserRegistrySynchronizerTest.assertTrue((String)"end time not updated", (boolean)status.getSyncEndTime().after(testStart));
                ChainingUserRegistrySynchronizerTest.assertTrue((String)"start time not updated", (boolean)status.getSyncStartTime().after(testStart));
                ChainingUserRegistrySynchronizerTest.assertEquals((String)"sync status is not complete", (String)"COMPLETE", (String)status.getSynchronizationStatus());
                ChainingUserRegistrySynchronizerTest.assertNotNull((String)"last run on server is null", (Object)status.getLastRunOnServer());
                ChainingUserRegistrySynchronizerTest.assertNull((Object)status.getLastErrorMessage());
                ChainingUserRegistrySynchronizerTest.assertEquals((String)"sync status is not complete", (String)"COMPLETE", (String)status.getSynchronizationStatus("Z0"));
            } else {
                ChainingUserRegistrySynchronizerTest.fail((String)"test not run");
            }
            testRegistry.setThrowError(true);
            testStart = new Date();
            try {
                this.synchronizer.synchronize(true, true);
                ChainingUserRegistrySynchronizerTest.fail((String)"error not thrown");
            }
            catch (AlfrescoRuntimeException alfrescoRuntimeException) {
                status = (ChainingUserRegistrySynchronizerStatus)this.synchronizer;
                ChainingUserRegistrySynchronizerTest.assertTrue((String)"end time not updated", (boolean)status.getSyncEndTime().after(testStart));
                ChainingUserRegistrySynchronizerTest.assertTrue((String)"start time not updated", (boolean)status.getSyncStartTime().after(testStart));
                ChainingUserRegistrySynchronizerTest.assertEquals((String)"sync status is not complete", (String)"COMPLETE_ERROR", (String)status.getSynchronizationStatus());
                ChainingUserRegistrySynchronizerTest.assertNotNull((String)"last run on server is null", (Object)status.getLastRunOnServer());
                ChainingUserRegistrySynchronizerTest.assertNotNull((Object)status.getLastErrorMessage());
                ChainingUserRegistrySynchronizerTest.assertEquals((String)"sync status is not complete", (String)"COMPLETE_ERROR", (String)status.getSynchronizationStatus("Z0"));
                ChainingUserRegistrySynchronizerTest.assertNotNull((Object)status.getSynchronizationLastError("Z0"));
            }
        }
        finally {
            this.tearDownTestUsersAndGroups();
        }
    }

    public void testSyncInexistentProperty() throws Exception {
        try {
            this.executeMockedLDAPSyncWithoutActiveDirectoryEmailProp();
            Map userProperties = this.nodeService.getProperties(this.personService.getPerson("U1"));
            ChainingUserRegistrySynchronizerTest.assertTrue((String)"User must have the email property even though it's null", (boolean)userProperties.containsKey(ContentModel.PROP_EMAIL));
            ChainingUserRegistrySynchronizerTest.assertTrue((String)"User's email must be null on first sync.", (userProperties.get(ContentModel.PROP_EMAIL) == null ? 1 : 0) != 0);
        }
        finally {
            this.tearDownTestUsersAndGroups();
        }
    }

    public void testSyncDeletedProperty() throws Exception {
        try {
            logger.info((Object)"testSyncDeletedProperty executing..");
            this.executeMockedLDAPSyncWithActiveDirectoryEmailProp();
            Map userProperties = this.nodeService.getProperties(this.personService.getPerson("U1"));
            ChainingUserRegistrySynchronizerTest.assertTrue((String)"User's email must be not null.", (boolean)((Serializable)userProperties.get(ContentModel.PROP_EMAIL)).equals("U1@alfresco.com"));
            this.executeMockedLDAPSyncWithoutActiveDirectoryEmailProp();
            userProperties = this.nodeService.getProperties(this.personService.getPerson("U1"));
            ChainingUserRegistrySynchronizerTest.assertTrue((String)"User must have the email property even though it's null", (boolean)userProperties.containsKey(ContentModel.PROP_EMAIL));
            ChainingUserRegistrySynchronizerTest.assertTrue((String)"User's email must be null on a 2rd sync, since the email property was removed at the AD level.", (userProperties.get(ContentModel.PROP_EMAIL) == null ? 1 : 0) != 0);
        }
        finally {
            logger.info((Object)"testSyncDeletedProperty executing finally");
            this.tearDownTestUsersAndGroups();
            logger.info((Object)"testSyncDeletedProperty finished finally");
        }
    }

    private void executeMockedLDAPSyncWithActiveDirectoryEmailProp() throws Exception {
        this.executeMockedLDAPSync(true);
    }

    private void executeMockedLDAPSyncWithoutActiveDirectoryEmailProp() throws Exception {
        this.executeMockedLDAPSync(false);
    }

    private void executeMockedLDAPSync(boolean withEmail) throws NamingException, Exception {
        MockUserRegistry mockUserRegistry = new MockUserRegistry("Z0", new NodeDescription[0], new NodeDescription[0]);
        MockLDAPUserRegistry mockLDAPUserRegistry = new MockLDAPUserRegistry(mockUserRegistry);
        LDAPInitialDirContextFactoryImpl mockedLdapInitialDirContextFactory = this.getMockedLDAPSearchResult(withEmail);
        mockLDAPUserRegistry.setLDAPInitialDirContextFactory((LDAPInitialDirContextFactory)mockedLdapInitialDirContextFactory);
        mockLDAPUserRegistry.setEnableProgressEstimation(false);
        mockLDAPUserRegistry.setUserIdAttributeName("sAMAccountName");
        Map<String, String> personAttributeMapping = this.getMockedLdapAttributeMapping();
        mockLDAPUserRegistry.setPersonAttributeMapping(personAttributeMapping);
        mockLDAPUserRegistry.setNamespaceService(this.namespaceService);
        mockLDAPUserRegistry.afterPropertiesSet();
        this.applicationContextManager.setUserRegistries(mockLDAPUserRegistry);
        ChainingUserRegistrySynchronizer chainingSynchronizer = (ChainingUserRegistrySynchronizer)this.synchronizer;
        chainingSynchronizer.synchronize(false, false);
    }

    private LDAPInitialDirContextFactoryImpl getMockedLDAPSearchResult(boolean withEmail) throws NamingException {
        NamingEnumeration mockedNamingEnumeration = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        Mockito.when((Object)mockedNamingEnumeration.hasMore()).thenReturn((Object)true).thenReturn((Object)false);
        BasicAttributes attributes = new BasicAttributes();
        attributes.put(new BasicAttribute("sAMAccountName", "U1"));
        attributes.put(new BasicAttribute("givenName", "U1"));
        if (withEmail) {
            attributes.put(new BasicAttribute("mail", "U1@alfresco.com"));
        }
        SearchResult mockedSearchResult = new SearchResult("CN:U1", (Object)null, attributes);
        mockedSearchResult.setNameInNamespace("CN:U1");
        Mockito.when((Object)((SearchResult)mockedNamingEnumeration.next())).thenReturn((Object)mockedSearchResult);
        InitialDirContext mockedInitialDirContext = (InitialDirContext)Mockito.mock(InitialDirContext.class);
        Mockito.when(mockedInitialDirContext.search((String)Mockito.any(), ArgumentMatchers.anyString(), (SearchControls)Mockito.any(SearchControls.class))).thenReturn((Object)mockedNamingEnumeration);
        LDAPInitialDirContextFactoryImpl mockedLdapInitialDirContextFactory = (LDAPInitialDirContextFactoryImpl)Mockito.mock(LDAPInitialDirContextFactoryImpl.class);
        Mockito.when((Object)mockedLdapInitialDirContextFactory.getDefaultIntialDirContext(0)).thenReturn((Object)mockedInitialDirContext);
        return mockedLdapInitialDirContextFactory;
    }

    private Map<String, String> getMockedLdapAttributeMapping() {
        HashMap<String, String> personAttributeMapping = new HashMap<String, String>();
        personAttributeMapping.put("cm:userName", "sAMAccountName");
        personAttributeMapping.put("cm:firstName", "givenName");
        personAttributeMapping.put("cm:email", "mail");
        return personAttributeMapping;
    }

    public void dontTestAssocs() throws Exception {
        List groups = (List)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeDescription>>(){

            public List<NodeDescription> execute() throws Throwable {
                return new ArrayList<NodeDescription>(new RandomGroupCollection(1000, ChainingUserRegistrySynchronizerTest.this.authorityService.getAllAuthoritiesInZone("AUTH.EXT.Z0", null)));
            }
        }, true, true);
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z0", Collections.emptyList(), groups));
        this.synchronizer.synchronize(true, true);
        this.tearDownTestUsersAndGroups();
    }

    private NodeDescription newGroup(String name, String ... members) {
        return this.newGroupWithDisplayName(name, name, members);
    }

    private NodeDescription newGroupWithDisplayName(String name, String displayName, String ... members) {
        String longName = this.longName(name);
        NodeDescription group = new NodeDescription(longName);
        PropertyMap properties = group.getProperties();
        properties.put((Object)ContentModel.PROP_AUTHORITY_NAME, (Object)longName);
        properties.put((Object)ContentModel.PROP_AUTHORITY_DISPLAY_NAME, (Object)displayName);
        if (members.length > 0) {
            Set assocs = group.getChildAssociations();
            String[] stringArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String member = stringArray[n2];
                assocs.add(this.longName(member));
                ++n2;
            }
        }
        group.setLastModified(new Date());
        return group;
    }

    private NodeDescription newPerson(String userName) {
        return this.newPerson(userName, userName + "@alfresco.com");
    }

    private NodeDescription newPerson(String userName, String email) {
        NodeDescription person = new NodeDescription(userName);
        PropertyMap properties = person.getProperties();
        properties.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
        properties.put((Object)ContentModel.PROP_FIRSTNAME, (Object)(userName + "F"));
        properties.put((Object)ContentModel.PROP_LASTNAME, (Object)(userName + "L"));
        properties.put((Object)ContentModel.PROP_EMAIL, (Object)email);
        person.setLastModified(new Date());
        return person;
    }

    private NodeDescription newPersonWithUserAccountStatusProperty(String userName, String userAccountPropertyValue) {
        NodeDescription person = this.newPerson(userName, userName + "@somedomain.com");
        person.getProperties().put((Object)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"userAccountStatusProperty"), (Object)userAccountPropertyValue);
        person.setLastModified(new Date());
        return person;
    }

    private void assertExists(String zone, String name, String ... members) {
        String longName = this.longName(name);
        ChainingUserRegistrySynchronizerTest.assertTrue((boolean)this.authorityService.authorityExists(longName));
        if (zone == null) {
            TreeSet<String> zones = new TreeSet<String>();
            zones.add("APP.DEFAULT");
            zones.add("AUTH.ALF");
            ChainingUserRegistrySynchronizerTest.assertEquals(zones, (Object)this.authorityService.getAuthorityZones(longName));
        } else {
            ChainingUserRegistrySynchronizerTest.assertTrue((boolean)this.authorityService.getAuthorityZones(longName).contains("AUTH.EXT." + zone));
        }
        if (AuthorityType.getAuthorityType((String)longName).equals((Object)AuthorityType.GROUP)) {
            HashSet<String> memberSet = new HashSet<String>(members.length * 2);
            String[] stringArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String member = stringArray[n2];
                memberSet.add(this.longName(member));
                ++n2;
            }
            ChainingUserRegistrySynchronizerTest.assertEquals(memberSet, (Object)this.authorityService.getContainedAuthorities(null, longName, true));
        } else {
            ChainingUserRegistrySynchronizerTest.assertTrue((boolean)this.personService.personExists(name));
            ChainingUserRegistrySynchronizerTest.assertEquals((String)this.personService.getUserIdentifier(name), (String)name);
            NodeRef person = this.personService.getPerson(name, false);
            ChainingUserRegistrySynchronizerTest.assertNotNull((String)("Person for " + name + " should exist"), (Object)person);
            NodeRef homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER));
            if (this.homeFolderCreationEager) {
                ChainingUserRegistrySynchronizerTest.assertNotNull((String)("Home folder for " + name + " should exist"), (Object)homeFolder);
            } else {
                ChainingUserRegistrySynchronizerTest.assertNull((String)("Home folder for " + name + " should not exist"), (Object)homeFolder);
            }
        }
    }

    private void assertNotExists(String name) {
        String longName = this.longName(name);
        ChainingUserRegistrySynchronizerTest.assertFalse((boolean)this.authorityService.authorityExists(longName));
        ChainingUserRegistrySynchronizerTest.assertNull((Object)this.authorityService.getAuthorityZones(longName));
        if (!AuthorityType.getAuthorityType((String)longName).equals((Object)AuthorityType.GROUP)) {
            ChainingUserRegistrySynchronizerTest.assertFalse((boolean)this.personService.personExists(name));
        }
    }

    private void assertEmailEquals(String personName, String email) {
        NodeRef personRef = this.personService.getPerson(personName, false);
        ChainingUserRegistrySynchronizerTest.assertEquals((Object)email, (Object)this.nodeService.getProperty(personRef, ContentModel.PROP_EMAIL));
    }

    private void assertGroupDisplayNameEquals(String name, String displayName) {
        ChainingUserRegistrySynchronizerTest.assertEquals((String)displayName, (String)this.authorityService.getAuthorityDisplayName(this.longName(name)));
    }

    private String longName(String shortName) {
        return this.authorityService.getName(shortName.toLowerCase().startsWith("g") ? AuthorityType.GROUP : AuthorityType.USER, shortName);
    }

    public static interface IMockUserRegistry
    extends UserRegistry,
    ActivateableBean {
        public String getZoneId();

        public void updateState(Collection<NodeDescription> var1, Collection<NodeDescription> var2);
    }

    public static class MockApplicationContextManager
    implements ChildApplicationContextManager {
        private Map<String, ApplicationContext> contexts = Collections.emptyMap();

        public void setUserRegistries(IMockUserRegistry ... registries) {
            this.contexts = new LinkedHashMap<String, ApplicationContext>(registries.length * 2);
            IMockUserRegistry[] iMockUserRegistryArray = registries;
            int n = registries.length;
            int n2 = 0;
            while (n2 < n) {
                IMockUserRegistry registry = iMockUserRegistryArray[n2];
                StaticApplicationContext context = new StaticApplicationContext();
                context.getDefaultListableBeanFactory().registerSingleton("userRegistry", (Object)registry);
                this.contexts.put(registry.getZoneId(), (ApplicationContext)context);
                ++n2;
            }
        }

        public void removeZone(String zoneId) {
            this.contexts.remove(zoneId);
        }

        public void updateZone(String zoneId, NodeDescription[] persons, NodeDescription[] groups) {
            ApplicationContext context = this.contexts.get(zoneId);
            IMockUserRegistry registry = (IMockUserRegistry)context.getBean("userRegistry");
            registry.updateState(Arrays.asList(persons), Arrays.asList(groups));
        }

        public ApplicationContext getApplicationContext(String id) {
            return this.contexts.get(id);
        }

        public Collection<String> getInstanceIds() {
            return this.contexts.keySet();
        }
    }

    private class MockLDAPUserRegistry
    extends LDAPUserRegistry
    implements IMockUserRegistry {
        MockUserRegistry mockUserRegistry;

        public MockLDAPUserRegistry(MockUserRegistry mockUserRegistry) {
            this.mockUserRegistry = mockUserRegistry;
        }

        public void setActive(boolean active) {
            this.mockUserRegistry.setActive(active);
        }

        public boolean isActive() {
            return this.mockUserRegistry.isActive();
        }

        public Set<QName> getPersonMappedProperties() {
            return this.mockUserRegistry.getPersonMappedProperties();
        }

        public Collection<NodeDescription> getPersons(Date modifiedSince) {
            Collection persons = this.mockUserRegistry.getPersons(modifiedSince);
            return !persons.isEmpty() ? persons : super.getPersons(modifiedSince);
        }

        public Collection<String> getPersonNames() {
            return this.mockUserRegistry.getPersonNames();
        }

        public Collection<String> getGroupNames() {
            return this.mockUserRegistry.getGroupNames();
        }

        public Collection<NodeDescription> getGroups(Date modifiedSince) {
            return this.mockUserRegistry.getGroups(modifiedSince);
        }

        @Override
        public String getZoneId() {
            return this.mockUserRegistry.getZoneId();
        }

        @Override
        public void updateState(Collection<NodeDescription> persons, Collection<NodeDescription> groups) {
            this.mockUserRegistry.updateState(persons, groups);
        }
    }

    public static class MockUserRegistry
    implements IMockUserRegistry {
        private boolean isActive = true;
        private boolean throwError = false;
        private String zoneId;
        private Collection<NodeDescription> persons;
        private Collection<NodeDescription> groups;

        public MockUserRegistry(String zoneId, Collection<NodeDescription> persons, Collection<NodeDescription> groups) {
            this.zoneId = zoneId;
            this.persons = persons;
            this.groups = groups;
        }

        @Override
        public void updateState(Collection<NodeDescription> persons, Collection<NodeDescription> groups) {
            ArrayList<NodeDescription> newPersons = new ArrayList<NodeDescription>(this.persons);
            this.mergeNodeDescriptions(newPersons, persons, ContentModel.PROP_USERNAME, false);
            this.persons = newPersons;
            ArrayList<NodeDescription> newGroups = new ArrayList<NodeDescription>(this.groups);
            this.mergeNodeDescriptions(newGroups, groups, ContentModel.PROP_AUTHORITY_NAME, true);
            this.groups = newGroups;
        }

        private void mergeNodeDescriptions(List<NodeDescription> oldNodes, Collection<NodeDescription> newNodes, QName idProp, boolean caseSensitive) {
            String id;
            LinkedHashMap<String, NodeDescription> nodeMap = new LinkedHashMap<String, NodeDescription>(newNodes.size() * 2);
            for (NodeDescription node : newNodes) {
                id = (String)node.getProperties().get((Object)idProp);
                if (!caseSensitive) {
                    id = id.toLowerCase();
                }
                nodeMap.put(id, node);
            }
            int i = 0;
            while (i < oldNodes.size()) {
                NodeDescription newNode;
                NodeDescription oldNode = oldNodes.get(i);
                id = (String)oldNode.getProperties().get((Object)idProp);
                if (!caseSensitive) {
                    id = id.toLowerCase();
                }
                if ((newNode = (NodeDescription)nodeMap.remove(id)) == null) {
                    oldNodes.remove(i);
                    --i;
                } else if (!oldNode.getProperties().equals((Object)newNode.getProperties()) || !oldNode.getChildAssociations().equals(newNode.getChildAssociations())) {
                    oldNodes.set(i, newNode);
                }
                ++i;
            }
            oldNodes.addAll(nodeMap.values());
        }

        public void setThrowError(boolean throwError) {
            this.throwError = throwError;
        }

        public MockUserRegistry(String zoneId, NodeDescription[] persons, NodeDescription[] groups) {
            this(zoneId, Arrays.asList(persons), Arrays.asList(groups));
        }

        @Override
        public String getZoneId() {
            return this.zoneId;
        }

        public Collection<String> getGroupNames() {
            LinkedList<String> groupNames = new LinkedList<String>();
            for (NodeDescription group : this.groups) {
                groupNames.add((String)group.getProperties().get((Object)ContentModel.PROP_AUTHORITY_NAME));
            }
            return groupNames;
        }

        public Collection<String> getPersonNames() {
            LinkedList<String> personNames = new LinkedList<String>();
            for (NodeDescription person : this.persons) {
                personNames.add((String)person.getProperties().get((Object)ContentModel.PROP_USERNAME));
            }
            return personNames;
        }

        public Collection<NodeDescription> getGroups(Date modifiedSince) {
            if (this.throwError) {
                throw new AlfrescoRuntimeException("test error");
            }
            return this.filterNodeDescriptions(this.groups, modifiedSince);
        }

        private Collection<NodeDescription> filterNodeDescriptions(Collection<NodeDescription> nodes, Date modifiedSince) {
            if (modifiedSince == null) {
                return nodes;
            }
            LinkedList<NodeDescription> filteredNodes = new LinkedList<NodeDescription>();
            for (NodeDescription node : nodes) {
                Date modified = node.getLastModified();
                if (modifiedSince.compareTo(modified) >= 0) continue;
                filteredNodes.add(node);
            }
            return filteredNodes;
        }

        public Collection<NodeDescription> getPersons(Date modifiedSince) {
            return this.filterNodeDescriptions(this.persons, modifiedSince);
        }

        public Set<QName> getPersonMappedProperties() {
            return new HashSet<QName>(Arrays.asList(ContentModel.PROP_USERNAME, ContentModel.PROP_FIRSTNAME, ContentModel.PROP_LASTNAME, ContentModel.PROP_EMAIL, ContentModel.PROP_ORGID, ContentModel.PROP_ORGANIZATION, ContentModel.PROP_HOME_FOLDER_PROVIDER));
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }

    public class RandomGroupCollection
    extends AbstractCollection<NodeDescription> {
        private Random generator = new Random(1628876500L);
        private final int size;
        private final List<String> authorities;

        public RandomGroupCollection(int size, Set<String> authorities) {
            this.size = size;
            this.authorities = new ArrayList<String>(authorities);
        }

        public RandomGroupCollection(int size, Collection<NodeDescription> persons) {
            this.size = size;
            this.authorities = new ArrayList<String>(persons.size());
            for (NodeDescription nodeDescription : persons) {
                this.authorities.add((String)nodeDescription.getProperties().get((Object)ContentModel.PROP_USERNAME));
            }
        }

        @Override
        public Iterator<NodeDescription> iterator() {
            return new Iterator<NodeDescription>(){
                private int pos;

                @Override
                public boolean hasNext() {
                    return this.pos < RandomGroupCollection.this.size;
                }

                @Override
                public NodeDescription next() {
                    ++this.pos;
                    String[] authorityNames = new String[this.pos == RandomGroupCollection.this.size ? RandomGroupCollection.this.size : 17];
                    int i = 0;
                    while (i < authorityNames.length) {
                        int index = this.pos == RandomGroupCollection.this.size ? i : RandomGroupCollection.this.generator.nextInt(RandomGroupCollection.this.authorities.size());
                        authorityNames[i] = ((RandomGroupCollection)RandomGroupCollection.this).ChainingUserRegistrySynchronizerTest.this.authorityService.getShortName(RandomGroupCollection.this.authorities.get(index));
                        ++i;
                    }
                    NodeDescription group = ChainingUserRegistrySynchronizerTest.this.newGroup("G" + GUID.generate(), authorityNames);
                    RandomGroupCollection.this.authorities.add((String)group.getProperties().get((Object)ContentModel.PROP_AUTHORITY_NAME));
                    return group;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    public class RandomPersonCollection
    extends AbstractCollection<NodeDescription> {
        private final int size;

        public RandomPersonCollection(int size) {
            this.size = size;
        }

        @Override
        public Iterator<NodeDescription> iterator() {
            return new Iterator<NodeDescription>(){
                private int pos;

                @Override
                public boolean hasNext() {
                    return this.pos < RandomPersonCollection.this.size;
                }

                @Override
                public NodeDescription next() {
                    ++this.pos;
                    return ChainingUserRegistrySynchronizerTest.this.newPerson("U" + GUID.generate());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    public static class TestSynchronizeEventListener
    implements ApplicationListener<ApplicationEvent> {
        private ChainingUserRegistrySynchronizer synchronizer;

        public void setSynchronizer(ChainingUserRegistrySynchronizer synchronizer) {
            this.synchronizer = synchronizer;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (SynchronizeEndEvent.class.isAssignableFrom(event.getClass()) || SynchronizeDirectoryEndEvent.class.isAssignableFrom(event.getClass())) {
                ChainingUserRegistrySynchronizerTest.assertEquals(null, (Object)this.synchronizer.getSyncEndTime());
            }
        }
    }
}

