/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.ModelValidator;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;

public class DictionaryModelType
implements ContentServicePolicies.OnContentUpdatePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnDeleteNodePolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnSetNodeTypePolicy,
NodeServicePolicies.BeforeCreateNodePolicy {
    private static Log logger = LogFactory.getLog(DictionaryModelType.class);
    private static final String KEY_PENDING_MODELS = "dictionaryModelType.pendingModels";
    private static final String KEY_PENDING_DELETE_MODELS = "dictionaryModelType.pendingDeleteModels";
    private static final String KEY_WORKING_COPY = "dictionaryModelType.workingCopy";
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"DictionaryModelType");
    private static final String MODEL_IN_USE = "cmm.service.model_in_use";
    public static final String ALFRESCO_MODEL_ADMINISTRATORS_AUTHORITY = "ALFRESCO_MODEL_ADMINISTRATORS";
    public static final String GROUP_ALFRESCO_MODEL_ADMINISTRATORS_AUTHORITY = "GROUP_ALFRESCO_MODEL_ADMINISTRATORS";
    private DictionaryDAO dictionaryDAO;
    private NamespaceDAO namespaceDAO;
    private NodeService nodeService;
    private ContentService contentService;
    private PolicyComponent policyComponent;
    private TenantService tenantService;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private DictionaryModelTypeTransactionListener transactionListener;
    private ModelValidator modelValidator;
    private boolean doValidation = true;
    private AuthorityService authorityService;

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setModelValidator(ModelValidator modelValidator) {
        this.modelValidator = modelValidator;
    }

    public void setNamespaceDAO(NamespaceDAO namespaceDAO) {
        this.namespaceDAO = namespaceDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setDoValidation(boolean doValidation) {
        this.doValidation = doValidation;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void init() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("init : bind class behaviours for " + String.valueOf(ContentModel.TYPE_DICTIONARY_MODEL)));
        }
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onContentUpdate"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onRemoveAspect"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onSetNodeType"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onSetNodeType"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeCreateNode"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "beforeCreateNode"));
        this.transactionListener = new DictionaryModelTypeTransactionListener(this.nodeService, this.contentService);
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        Boolean value;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onContentUpdate: nodeRef=" + String.valueOf(nodeRef) + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
        }
        if ((value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_ACTIVE)) != null && value.booleanValue()) {
            this.queueModel(nodeRef);
        }
    }

    private void queueModel(NodeRef nodeRef) {
        CopyOnWriteArraySet<NodeRef> pendingModels = (CopyOnWriteArraySet<NodeRef>)AlfrescoTransactionSupport.getResource((Object)KEY_PENDING_MODELS);
        if (pendingModels == null) {
            pendingModels = new CopyOnWriteArraySet<NodeRef>();
            AlfrescoTransactionSupport.bindResource((Object)KEY_PENDING_MODELS, pendingModels);
        }
        pendingModels.add(this.tenantService.getName(nodeRef));
        AlfrescoTransactionSupport.bindListener(this.transactionListener);
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onUpdateProperties: nodeRef=" + String.valueOf(nodeRef) + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
        }
        Boolean beforeValue = (Boolean)before.get(ContentModel.PROP_MODEL_ACTIVE);
        Boolean afterValue = (Boolean)after.get(ContentModel.PROP_MODEL_ACTIVE);
        if (beforeValue == null && afterValue != null) {
            if (afterValue.booleanValue()) {
                this.modelValidator.validateModelNamespacePrefix(nodeRef);
            }
            this.queueModel(nodeRef);
        } else if (afterValue == null && beforeValue != null) {
            this.queueModel(nodeRef);
        } else if (beforeValue != null && afterValue != null && !beforeValue.equals(afterValue)) {
            if (afterValue.booleanValue()) {
                this.modelValidator.validateModelNamespacePrefix(nodeRef);
            }
            this.queueModel(nodeRef);
        }
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspect) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onRemoveAspect: nodeRef=" + String.valueOf(nodeRef) + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
        }
        if (aspect.equals((Object)ContentModel.ASPECT_WORKING_COPY)) {
            AlfrescoTransactionSupport.bindResource((Object)KEY_WORKING_COPY, (Object)nodeRef);
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        boolean workingCopy = this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY);
        NodeRef wcNodeRef = (NodeRef)AlfrescoTransactionSupport.getResource((Object)KEY_WORKING_COPY);
        if (wcNodeRef != null && wcNodeRef.equals((Object)nodeRef)) {
            workingCopy = true;
        }
        boolean isVersionNode = nodeRef.getStoreRef().getIdentifier().equals("version2Store");
        if (!workingCopy && !isVersionNode) {
            QName modelName = (QName)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_NAME);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("beforeDeleteNode: nodeRef=" + String.valueOf(nodeRef) + " validate model delete (modelName=" + String.valueOf(modelName) + ")"));
            }
            if (modelName != null) {
                if (!this.modelValidator.canDeleteModel(modelName)) {
                    throw AlfrescoRuntimeException.create((String)MODEL_IN_USE, (Object[])new Object[]{modelName});
                }
                CopyOnWriteArraySet<NodeRef> pendingModelDeletes = (CopyOnWriteArraySet<NodeRef>)AlfrescoTransactionSupport.getResource((Object)KEY_PENDING_DELETE_MODELS);
                if (pendingModelDeletes == null) {
                    pendingModelDeletes = new CopyOnWriteArraySet<NodeRef>();
                    AlfrescoTransactionSupport.bindResource((Object)KEY_PENDING_DELETE_MODELS, pendingModelDeletes);
                }
                pendingModelDeletes.add(this.tenantService.getName(nodeRef));
                AlfrescoTransactionSupport.bindListener(this.transactionListener);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("beforeDeleteNode: nodeRef=" + String.valueOf(nodeRef) + " ignored (" + (workingCopy ? " workingCopy " : "") + (isVersionNode ? " isVersionNode " : "") + ") [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
        }
    }

    @Override
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        Boolean value;
        NodeRef nodeRef = childAssocRef.getChildRef();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onCreateNode: nodeRef=" + String.valueOf(nodeRef) + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
        }
        if (this.nodeService.getType(nodeRef).equals((Object)ContentModel.TYPE_DICTIONARY_MODEL) && (value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_ACTIVE)) != null && value.booleanValue()) {
            this.queueModel(nodeRef);
        }
    }

    @Override
    public void onSetNodeType(NodeRef nodeRef, QName oldType, QName newType) {
        String userName = AuthenticationUtil.getFullyAuthenticatedUser();
        if (!this.isUserNameAModelAdminAuthority(userName)) {
            throw new InvalidTypeException(newType);
        }
    }

    @Override
    public void beforeCreateNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
        String userName = AuthenticationUtil.getFullyAuthenticatedUser();
        if (!this.isUserNameAModelAdminAuthority(userName)) {
            throw new InvalidTypeException(nodeTypeQName);
        }
    }

    private boolean isUserNameAModelAdminAuthority(String userName) {
        if (userName == null) {
            return false;
        }
        return this.authorityService.isAdminAuthority(userName) || this.authorityService.getAuthoritiesForUser(userName).contains(GROUP_ALFRESCO_MODEL_ADMINISTRATORS_AUTHORITY) || AuthenticationUtil.isRunAsUserTheSystemUser();
    }

    public class DictionaryModelTypeTransactionListener
    extends TransactionListenerAdapter {
        private String id = GUID.generate();
        private NodeService nodeService;
        private ContentService contentService;

        public DictionaryModelTypeTransactionListener(NodeService nodeService, ContentService contentService) {
            this.nodeService = nodeService;
            this.contentService = contentService;
        }

        @Override
        public void afterCommit() {
            String tenantDomain;
            Set pendingModels = (Set)AlfrescoTransactionSupport.getResource((Object)DictionaryModelType.KEY_PENDING_MODELS);
            Set pendingDeleteModels = (Set)AlfrescoTransactionSupport.getResource((Object)DictionaryModelType.KEY_PENDING_DELETE_MODELS);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("afterCommit: " + Thread.currentThread().getName() + " pendingModelsCnt=" + String.valueOf(pendingModels != null ? Integer.valueOf(pendingModels.size()) : "0") + ", pendingDeleteModelsCnt=" + String.valueOf(pendingDeleteModels != null ? Integer.valueOf(pendingDeleteModels.size()) : "0")));
            }
            HashSet<String> systemTenants = new HashSet<String>(10);
            if (pendingModels != null) {
                AlfrescoTransactionSupport.unbindResource((Object)DictionaryModelType.KEY_PENDING_MODELS);
                for (NodeRef nodeRef : pendingModels) {
                    tenantDomain = DictionaryModelType.this.tenantService.getDomain(nodeRef.getStoreRef().getIdentifier());
                    systemTenants.add(tenantDomain);
                }
            }
            if (pendingDeleteModels != null) {
                AlfrescoTransactionSupport.unbindResource((Object)DictionaryModelType.KEY_PENDING_DELETE_MODELS);
                for (NodeRef nodeRef : pendingDeleteModels) {
                    tenantDomain = DictionaryModelType.this.tenantService.getDomain(nodeRef.getStoreRef().getIdentifier());
                    systemTenants.add(tenantDomain);
                }
            }
            if (systemTenants.size() > 0) {
                for (final String tenantName : systemTenants) {
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            return (Void)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                                public Void doWork() {
                                    ((DictionaryModelTypeTransactionListener)(this).DictionaryModelTypeTransactionListener.this).DictionaryModelType.this.dictionaryDAO.init();
                                    if (logger.isTraceEnabled()) {
                                        logger.trace((Object)("afterCommit: Dictionary destroyed [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                                    }
                                    return null;
                                }
                            }, (String)tenantName);
                        }
                    };
                    DictionaryModelType.this.transactionService.getRetryingTransactionHelper().doInTransaction(work, true, true);
                }
            }
        }

        @Override
        public void beforeCommit(boolean readOnly) {
            Set pendingModels;
            if (DictionaryModelType.this.jobLockService != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("beforeCommit: " + Thread.currentThread().getName() + " attempt to get transactional lock [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                }
                try {
                    DictionaryModelType.this.jobLockService.getTransactionalLock(LOCK_QNAME, 60000L, 3000L, 10);
                }
                catch (LockAcquisitionException lae) {
                    throw new ConcurrencyFailureException(lae.getMessage());
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("beforeCommit: " + Thread.currentThread().getName() + " got transactional lock [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                }
            }
            if ((pendingModels = (Set)AlfrescoTransactionSupport.getResource((Object)DictionaryModelType.KEY_PENDING_MODELS)) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("beforeCommit: pendinpolicy-context.xmlgModelsCnt=" + pendingModels.size() + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                }
                for (NodeRef pendingNodeRef : pendingModels) {
                    String tenantDomain = DictionaryModelType.this.tenantService.getDomain(pendingNodeRef.getStoreRef().getIdentifier());
                    String tenantSystemUserName = DictionaryModelType.this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain);
                    final NodeRef nodeRef = DictionaryModelType.this.tenantService.getBaseName(pendingNodeRef);
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                        public Object doWork() {
                            if (!DictionaryModelTypeTransactionListener.this.nodeService.exists(nodeRef)) {
                                return null;
                            }
                            boolean isActive = false;
                            Boolean value = (Boolean)DictionaryModelTypeTransactionListener.this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_ACTIVE);
                            if (value != null) {
                                isActive = value;
                            }
                            if (!DictionaryModelTypeTransactionListener.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
                                if (isActive) {
                                    ContentReader contentReader = DictionaryModelTypeTransactionListener.this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
                                    if (contentReader != null) {
                                        M2Model m2Model = null;
                                        InputStream is = null;
                                        try {
                                            is = contentReader.getContentInputStream();
                                            m2Model = M2Model.createModel((InputStream)is);
                                        }
                                        catch (Throwable throwable) {
                                            if (is != null) {
                                                try {
                                                    is.close();
                                                }
                                                catch (IOException iOException) {
                                                    logger.error((Object)("Failed to close input stream for " + String.valueOf(nodeRef)));
                                                }
                                            }
                                            throw throwable;
                                        }
                                        if (is != null) {
                                            try {
                                                is.close();
                                            }
                                            catch (IOException iOException) {
                                                logger.error((Object)("Failed to close input stream for " + String.valueOf(nodeRef)));
                                            }
                                        }
                                        CompiledModel compiledModel = m2Model.compile(((DictionaryModelTypeTransactionListener)DictionaryModelTypeTransactionListener.this).DictionaryModelType.this.dictionaryDAO, ((DictionaryModelTypeTransactionListener)DictionaryModelTypeTransactionListener.this).DictionaryModelType.this.namespaceDAO, true);
                                        ModelDefinition modelDefinition = compiledModel.getModelDefinition();
                                        Map props = DictionaryModelTypeTransactionListener.this.nodeService.getProperties(nodeRef);
                                        props.put(ContentModel.PROP_MODEL_NAME, modelDefinition.getName());
                                        props.put(ContentModel.PROP_MODEL_DESCRIPTION, modelDefinition.getDescription(null));
                                        props.put(ContentModel.PROP_MODEL_AUTHOR, modelDefinition.getAuthor());
                                        props.put(ContentModel.PROP_MODEL_PUBLISHED_DATE, modelDefinition.getPublishedDate());
                                        props.put(ContentModel.PROP_MODEL_VERSION, modelDefinition.getVersion());
                                        DictionaryModelTypeTransactionListener.this.nodeService.setProperties(nodeRef, props);
                                        if (((DictionaryModelTypeTransactionListener)DictionaryModelTypeTransactionListener.this).DictionaryModelType.this.doValidation) {
                                            ((DictionaryModelTypeTransactionListener)DictionaryModelTypeTransactionListener.this).DictionaryModelType.this.modelValidator.validateModel(compiledModel);
                                        }
                                        if (logger.isTraceEnabled()) {
                                            logger.trace((Object)("beforeCommit: activating nodeRef=" + String.valueOf(nodeRef) + " (" + String.valueOf(modelDefinition.getName()) + ") [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                                        }
                                    }
                                } else {
                                    QName modelName = (QName)DictionaryModelTypeTransactionListener.this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_NAME);
                                    if (modelName != null) {
                                        if (!((DictionaryModelTypeTransactionListener)DictionaryModelTypeTransactionListener.this).DictionaryModelType.this.modelValidator.canDeleteModel(modelName)) {
                                            throw AlfrescoRuntimeException.create((String)DictionaryModelType.MODEL_IN_USE, (Object[])new Object[]{modelName});
                                        }
                                        if (logger.isTraceEnabled()) {
                                            logger.trace((Object)("beforeCommit: deactivating nodeRef=" + String.valueOf(nodeRef) + " (" + String.valueOf(modelName) + ") [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                                        }
                                    }
                                }
                            }
                            return null;
                        }
                    }, (String)tenantSystemUserName);
                }
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof DictionaryModelTypeTransactionListener) {
                DictionaryModelTypeTransactionListener that = (DictionaryModelTypeTransactionListener)obj;
                return this.id.equals(that.id);
            }
            return false;
        }
    }
}

