/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Difference;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.validator.AbstractDbValidator;
import org.alfresco.util.schemacomp.validator.DbValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractDbObjectTest {
    private ConcreteDbObject dbObject;
    @Mock
    private Results differences;
    private DiffContext ctx;
    @Mock
    private Dialect dialect;

    @Before
    public void setUp() throws Exception {
        this.dbObject = new ConcreteDbObject("the_object");
        this.ctx = new DiffContext(this.dialect, this.differences, null, null);
    }

    @Test
    public void sameAs() {
        this.dbObject.setName(null);
        Assert.assertFalse((String)"Not the same.", (boolean)this.dbObject.sameAs(null));
        Assert.assertFalse((String)"Not the same.", (boolean)this.dbObject.sameAs((DbObject)new ConcreteDbObject("other_obj_name")));
        Assert.assertTrue((String)"The very same", (boolean)this.dbObject.sameAs((DbObject)this.dbObject));
        this.dbObject.setName("the_name");
        Assert.assertFalse((String)"Not the same.", (boolean)this.dbObject.sameAs(null));
        Assert.assertFalse((String)"Not the same.", (boolean)this.dbObject.sameAs((DbObject)new ConcreteDbObject("different_name")));
        Assert.assertFalse((String)"Not the same type", (boolean)this.dbObject.sameAs((DbObject)new AnotherConcreteDbObject("the_name")));
        Assert.assertTrue((String)"Logically the same object.", (boolean)this.dbObject.sameAs((DbObject)new ConcreteDbObject("the_name")));
        Assert.assertTrue((String)"The very same object with non-null name", (boolean)this.dbObject.sameAs((DbObject)this.dbObject));
    }

    @Test
    public void diff() {
        ConcreteDbObject otherObject = new ConcreteDbObject("the_other_object");
        this.dbObject.diff((DbObject)otherObject, this.ctx);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.differences});
        ((Results)inOrder.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty((DbObject)this.dbObject, "name"), new DbProperty((DbObject)otherObject, "name"));
        ((Results)inOrder.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty((DbObject)this.dbObject, "someProp"), new DbProperty((DbObject)otherObject, "someProp"));
    }

    @Test
    public void canGetValidators() {
        List validators = this.dbObject.getValidators();
        Assert.assertEquals((long)0L, (long)validators.size());
        this.dbObject.setValidators(null);
        validators = this.dbObject.getValidators();
        Assert.assertEquals((long)0L, (long)validators.size());
        this.dbObject.setValidators(this.validatorList(new DbValidator[]{new TestValidator1(), new TestValidator2()}));
        validators = this.dbObject.getValidators();
        Assert.assertEquals((long)2L, (long)validators.size());
        Assert.assertEquals(TestValidator1.class, ((DbValidator)validators.get(0)).getClass());
        Assert.assertEquals(TestValidator2.class, ((DbValidator)validators.get(1)).getClass());
    }

    private List<DbValidator> validatorList(DbValidator ... validators) {
        return Arrays.asList(validators);
    }

    public static class AnotherConcreteDbObject
    extends AbstractDbObject {
        public AnotherConcreteDbObject(String name) {
            super(null, name);
        }

        public void accept(DbObjectVisitor visitor) {
        }
    }

    public static class ConcreteDbObject
    extends AbstractDbObject {
        private String someProp = "property value";

        public ConcreteDbObject(String name) {
            super(null, name);
        }

        protected void doDiff(DbObject right, DiffContext ctx) {
            Results differences = ctx.getComparisonResults();
            differences.add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty((DbObject)this, "someProp"), new DbProperty(right, "someProp"));
        }

        public void accept(DbObjectVisitor visitor) {
        }

        public String getSomeProp() {
            return this.someProp;
        }
    }

    private static class TestValidator
    extends AbstractDbValidator {
        private TestValidator() {
        }

        public void validate(DbObject reference, DbObject target, DiffContext ctx) {
        }
    }

    private static class TestValidator1
    extends TestValidator {
        private TestValidator1() {
        }
    }

    private static class TestValidator2
    extends TestValidator {
        private TestValidator2() {
        }
    }
}

