/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event2.NodeEventConsolidator;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class EventConsolidatorUnitTest {
    private final NodeResourceHelper nodeResourceHelper = (NodeResourceHelper)Mockito.mock(NodeResourceHelper.class);
    private NodeEventConsolidator eventConsolidator;

    @Before
    public void setUp() throws Exception {
        this.eventConsolidator = new NodeEventConsolidator(this.nodeResourceHelper);
    }

    @Test
    public void testGetMappedAspectsBeforeRemovedAndAddedEmpty() {
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        Set mappedAspectsBefore = this.eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)0L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectRemoved() {
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        HashSet<String> removed = new HashSet<String>();
        HashSet added = new HashSet();
        removed.add("cm:contains");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = this.eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)3L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectAdded() {
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        HashSet removed = new HashSet();
        HashSet<String> added = new HashSet<String>();
        added.add("cm:auditable");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = this.eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)1L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectAddedAndRemoved() {
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        HashSet<String> removed = new HashSet<String>();
        removed.add("cm:contains");
        HashSet<String> added = new HashSet<String>();
        added.add("cm:contains");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = this.eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)2L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectRemovedAndAdded() {
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        currentAspects.add("cm:contains");
        HashSet<String> removed = new HashSet<String>();
        removed.add("cm:contains");
        HashSet<String> added = new HashSet<String>();
        added.add("cm:contains");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = this.eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)0L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectAddedTwiceRemovedOnce() {
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        currentAspects.add("cm:contains");
        HashSet removed = new HashSet();
        HashSet<String> added = new HashSet<String>();
        added.add("cm:contains");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = this.eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)2L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectRemovedTwiceAddedOnce() {
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        currentAspects.add("cm:contains");
        HashSet<String> removed = new HashSet<String>();
        removed.add("cm:contains");
        HashSet<String> added = new HashSet<String>();
        added.add("cm:contains");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = this.eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)2L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_FilteredAspectAdded() {
        this.eventConsolidator.addAspect(ContentModel.ASPECT_COPIEDFROM);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        HashSet removed = new HashSet();
        HashSet added = new HashSet();
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)this.eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = this.eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)0L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testAddAspect() {
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)1L, (long)this.eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)0L, (long)this.eventConsolidator.getAspectsRemoved().size());
        Assert.assertTrue((boolean)this.eventConsolidator.getAspectsAdded().contains(ContentModel.ASSOC_CONTAINS));
    }

    @Test
    public void testRemoveAspect() {
        this.eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)0L, (long)this.eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)1L, (long)this.eventConsolidator.getAspectsRemoved().size());
        Assert.assertTrue((boolean)this.eventConsolidator.getAspectsRemoved().contains(ContentModel.ASSOC_CONTAINS));
    }

    @Test
    public void testAddAspectRemoveAspect() {
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)0L, (long)this.eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)0L, (long)this.eventConsolidator.getAspectsRemoved().size());
    }

    @Test
    public void testRemoveAspectAddAspect() {
        this.eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)0L, (long)this.eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)0L, (long)this.eventConsolidator.getAspectsRemoved().size());
    }

    @Test
    public void testAddAspectTwiceRemoveAspectOnce() {
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)1L, (long)this.eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)0L, (long)this.eventConsolidator.getAspectsRemoved().size());
        Assert.assertTrue((boolean)this.eventConsolidator.getAspectsAdded().contains(ContentModel.ASSOC_CONTAINS));
    }

    @Test
    public void testAddAspectOnceRemoveAspectTwice() {
        this.eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        this.eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)0L, (long)this.eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)1L, (long)this.eventConsolidator.getAspectsRemoved().size());
        Assert.assertTrue((boolean)this.eventConsolidator.getAspectsRemoved().contains(ContentModel.ASSOC_CONTAINS));
    }

    @Test
    public void testOnMoveNodeWithPrimaryParent() {
        ChildAssociationRef oldAssociationMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        ChildAssociationRef newAssociationMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        NodeRef parentRefMock = (NodeRef)Mockito.mock(NodeRef.class);
        BDDMockito.given((Object)newAssociationMock.isPrimary()).willReturn((Object)true);
        BDDMockito.given((Object)oldAssociationMock.getParentRef()).willReturn((Object)parentRefMock);
        this.eventConsolidator.onMoveNode(oldAssociationMock, newAssociationMock);
        ((ChildAssociationRef)BDDMockito.then((Object)newAssociationMock).should()).getChildRef();
        ((ChildAssociationRef)BDDMockito.then((Object)newAssociationMock).should()).isPrimary();
        BDDMockito.then((Object)newAssociationMock).shouldHaveNoMoreInteractions();
        ((NodeResourceHelper)BDDMockito.then((Object)this.nodeResourceHelper).should()).getPrimaryHierarchy(parentRefMock, true);
        Assert.assertTrue((String)"Node event consolidator should contain event type: UPDATED", (boolean)this.eventConsolidator.getEventTypes().contains(EventType.NODE_UPDATED));
    }

    @Test
    public void testOnMoveNodeAfterSecondaryParentAdded() {
        ChildAssociationRef oldAssociationMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        ChildAssociationRef newAssociationMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        NodeRef nodeRefMock = (NodeRef)Mockito.mock(NodeRef.class);
        NodeRef parentRefMock = (NodeRef)Mockito.mock(NodeRef.class);
        List secondaryParentsMock = (List)Mockito.mock(List.class);
        BDDMockito.given((Object)newAssociationMock.isPrimary()).willReturn((Object)false);
        BDDMockito.given((Object)newAssociationMock.getChildRef()).willReturn((Object)nodeRefMock);
        BDDMockito.given((Object)newAssociationMock.getParentRef()).willReturn((Object)parentRefMock);
        BDDMockito.given((Object)parentRefMock.getId()).willReturn((Object)"parent-id");
        BDDMockito.given((Object)this.nodeResourceHelper.getSecondaryParents((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn((Object)secondaryParentsMock);
        this.eventConsolidator.onMoveNode(oldAssociationMock, newAssociationMock);
        ((ChildAssociationRef)BDDMockito.then((Object)newAssociationMock).should()).isPrimary();
        ((ChildAssociationRef)BDDMockito.then((Object)newAssociationMock).should(Mockito.times((int)2))).getChildRef();
        ((ChildAssociationRef)BDDMockito.then((Object)newAssociationMock).should(Mockito.times((int)2))).getParentRef();
        BDDMockito.then((Object)newAssociationMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)oldAssociationMock).shouldHaveNoInteractions();
        ((NodeResourceHelper)BDDMockito.then((Object)this.nodeResourceHelper).should()).getSecondaryParents(nodeRefMock);
        ((List)BDDMockito.then((Object)secondaryParentsMock).should()).remove("parent-id");
        BDDMockito.then((Object)secondaryParentsMock).shouldHaveNoMoreInteractions();
        Assert.assertTrue((String)"Node event consolidator should contain event type: UPDATED", (boolean)this.eventConsolidator.getEventTypes().contains(EventType.NODE_UPDATED));
        Assert.assertEquals((Object)secondaryParentsMock, (Object)this.eventConsolidator.getSecondaryParentsBefore());
    }

    @Test
    public void testOnMoveNodeBeforeSecondaryParentRemoved() {
        ChildAssociationRef oldAssociationMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        ChildAssociationRef newAssociationMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        NodeRef nodeRefMock = (NodeRef)Mockito.mock(NodeRef.class);
        NodeRef parentRefMock = (NodeRef)Mockito.mock(NodeRef.class);
        List secondaryParentsMock = (List)Mockito.mock(List.class);
        BDDMockito.given((Object)newAssociationMock.isPrimary()).willReturn((Object)false);
        BDDMockito.given((Object)newAssociationMock.getChildRef()).willReturn((Object)nodeRefMock);
        BDDMockito.given((Object)oldAssociationMock.getParentRef()).willReturn((Object)parentRefMock);
        BDDMockito.given((Object)parentRefMock.getId()).willReturn((Object)"parent-id");
        BDDMockito.given((Object)this.nodeResourceHelper.getSecondaryParents((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn((Object)secondaryParentsMock);
        this.eventConsolidator.onMoveNode(oldAssociationMock, newAssociationMock);
        ((ChildAssociationRef)BDDMockito.then((Object)newAssociationMock).should()).isPrimary();
        ((ChildAssociationRef)BDDMockito.then((Object)newAssociationMock).should(Mockito.times((int)2))).getChildRef();
        ((ChildAssociationRef)BDDMockito.then((Object)newAssociationMock).should()).getParentRef();
        BDDMockito.then((Object)newAssociationMock).shouldHaveNoMoreInteractions();
        ((ChildAssociationRef)BDDMockito.then((Object)oldAssociationMock).should(Mockito.times((int)3))).getParentRef();
        BDDMockito.then((Object)oldAssociationMock).shouldHaveNoMoreInteractions();
        ((NodeResourceHelper)BDDMockito.then((Object)this.nodeResourceHelper).should()).getSecondaryParents(nodeRefMock);
        ((List)BDDMockito.then((Object)secondaryParentsMock).should()).contains("parent-id");
        ((List)BDDMockito.then((Object)secondaryParentsMock).should()).add("parent-id");
        BDDMockito.then((Object)secondaryParentsMock).shouldHaveNoMoreInteractions();
        Assert.assertTrue((String)"Node event consolidator should contain event type: NODE_UPDATED", (boolean)this.eventConsolidator.getEventTypes().contains(EventType.NODE_UPDATED));
        Assert.assertEquals((Object)secondaryParentsMock, (Object)this.eventConsolidator.getSecondaryParentsBefore());
    }
}

