/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.ref.GetActualNodeRefMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.rating.RatingServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VirtualRatingServiceExtensionTest
extends VirtualizationIntegrationTest {
    private static final String LIKES_RATING_SCHEME = "likesRatingScheme";
    private static final String FIVE_STAR_RATING_SCHEME = "fiveStarRatingScheme";
    private RatingService ratingService;
    private NodeRef vf1Node2;
    private NodeRef virtualContent;
    private String user1;
    private String user2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ratingService = (RatingService)this.ctx.getBean("ratingService", RatingService.class);
        this.user1 = "user1";
        this.user2 = "user2";
        this.vf1Node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        this.virtualContent = this.createContent(this.vf1Node2, "virtualContent").getChildRef();
    }

    private void applyRatingAs(final NodeRef targetNode, final float rating, final String ratingSchemeName, String asUser) throws RatingServiceException {
        String fau = AuthenticationUtil.getFullyAuthenticatedUser();
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)asUser);
            AuthenticationUtil.RunAsWork<Void> applyRatingsAsWork = new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    VirtualRatingServiceExtensionTest.this.ratingService.applyRating(targetNode, rating, ratingSchemeName);
                    return null;
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)applyRatingsAsWork, (String)asUser);
        }
        finally {
            AuthenticationUtil.setFullyAuthenticatedUser((String)fau);
        }
    }

    @Test
    public void testApplyRatings() throws Exception {
        Reference reference = Reference.fromNodeRef((NodeRef)this.virtualContent);
        Assert.assertNotNull((Object)reference);
        NodeRef actualNodeRef = (NodeRef)reference.execute((ProtocolMethod)new GetActualNodeRefMethod(this.environment));
        this.applyRatingAs(this.virtualContent, 1.0f, LIKES_RATING_SCHEME, this.user1);
        this.applyRatingAs(this.virtualContent, 1.0f, LIKES_RATING_SCHEME, this.user2);
        double delta = 1.0E-7;
        Assert.assertEquals((double)1.0, (double)this.ratingService.getAverageRating(this.virtualContent, LIKES_RATING_SCHEME), (double)delta);
        Assert.assertEquals((double)1.0, (double)this.ratingService.getAverageRating(actualNodeRef, LIKES_RATING_SCHEME), (double)delta);
        this.applyRatingAs(this.virtualContent, 1.0f, FIVE_STAR_RATING_SCHEME, this.user1);
        this.applyRatingAs(this.virtualContent, 3.0f, FIVE_STAR_RATING_SCHEME, this.user2);
        Assert.assertEquals((double)2.0, (double)this.ratingService.getAverageRating(this.virtualContent, FIVE_STAR_RATING_SCHEME), (double)delta);
        Assert.assertEquals((double)2.0, (double)this.ratingService.getAverageRating(actualNodeRef, FIVE_STAR_RATING_SCHEME), (double)delta);
    }
}

