/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import org.alfresco.repo.virtual.ref.NotUuidNodeIdRadixHasher;
import org.junit.Assert;
import org.junit.Test;

public class NotUuidNodeIdRadixHasherTest {
    @Test
    public void testRadix36Hashing() {
        NotUuidNodeIdRadixHasher nodeIdHasher = new NotUuidNodeIdRadixHasher(36);
        String id = "wf-email-html-ftl";
        String hashedId = nodeIdHasher.hash(id);
        String expected = "1e9lat6m0tvszgcle5scyylab8s";
        Assert.assertEquals((Object)expected, (Object)hashedId);
    }

    @Test
    public void testRadix36Lookup() {
        NotUuidNodeIdRadixHasher nodeIdHasher = new NotUuidNodeIdRadixHasher(36);
        String hashedUuid = "1e9lat6m0tvszgcle5scyylab8s";
        String id = nodeIdHasher.lookup(hashedUuid);
        String expected = "wf-email-html-ftl";
        Assert.assertEquals((Object)expected, (Object)id);
    }

    @Test
    public void testRadix16Hashing() {
        NotUuidNodeIdRadixHasher nodeIdHasher = new NotUuidNodeIdRadixHasher(16);
        String id = "wf-email-html-ftl";
        String hashedId = nodeIdHasher.hash(id);
        String expected = "77662d656d61696c2d68746d6c2d66746c";
        Assert.assertEquals((Object)expected, (Object)hashedId);
    }

    @Test
    public void testRadix16Lookup() {
        NotUuidNodeIdRadixHasher nodeIdHasher = new NotUuidNodeIdRadixHasher(16);
        String hashedUuid = "77662d656d61696c2d68746d6c2d66746c";
        String id = nodeIdHasher.lookup(hashedUuid);
        String expected = "wf-email-html-ftl";
        Assert.assertEquals((Object)expected, (Object)id);
    }

    @Test(expected=RuntimeException.class)
    public void testHashForEmptyUuid() {
        NotUuidNodeIdRadixHasher nodeIdHasher = new NotUuidNodeIdRadixHasher(36);
        String uuid = "";
        nodeIdHasher.hash(uuid);
    }

    @Test(expected=RuntimeException.class)
    public void testLookupForEmptyUuid() {
        NotUuidNodeIdRadixHasher nodeIdHasher = new NotUuidNodeIdRadixHasher(36);
        String hashedUuid = "";
        nodeIdHasher.lookup(hashedUuid);
    }
}

