/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class TransactionStats {
    private Map<OpType, SummaryStatistics> timings = new HashMap<OpType, SummaryStatistics>();

    public long getCount(OpType op) {
        SummaryStatistics stats = this.getTimings(op);
        return stats.getN();
    }

    public SummaryStatistics getTimings(OpType op) {
        SummaryStatistics opTimings = this.timings.get((Object)op);
        if (opTimings == null) {
            opTimings = new SummaryStatistics();
            this.timings.put(op, opTimings);
        }
        return opTimings;
    }

    public void record(long start, long end, OpType op) {
        if (end < start) {
            throw new IllegalArgumentException("End time [" + end + "] occurs before start time [" + start + "].");
        }
        double timeTaken = end - start;
        this.addTiming(op, timeTaken);
    }

    private void addTiming(OpType op, double time) {
        SummaryStatistics opTimings = this.getTimings(op);
        opTimings.addValue(time);
    }

    public static enum OpType {
        GET_HIT,
        GET_MISS,
        PUT,
        REMOVE,
        CLEAR;

    }
}

