/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class LuceneUtils {
    private static final SimpleDateFormat LUCENE_DATETIME_FORMAT = new SimpleDateFormat("yyyy\\-MM\\-dd'T'HH:mm:ss");

    public static String getLuceneDateString(Date date) {
        return LUCENE_DATETIME_FORMAT.format(date);
    }

    public static String createDateRangeQuery(Date fromDate, Date toDate, QName dateProperty, DictionaryService dictionaryService, NamespaceService namespaceService) {
        if (dateProperty == null) {
            throw new NullPointerException("dateProperty cannot be null");
        }
        PropertyDefinition propDef = dictionaryService.getProperty(dateProperty);
        if (propDef == null) {
            throw new NullPointerException("dateProperty '" + String.valueOf(dateProperty) + "' not recognised.");
        }
        QName propDefType = propDef.getDataType().getName();
        if (!DataTypeDefinition.DATE.equals((Object)propDefType) && !DataTypeDefinition.DATETIME.equals((Object)propDefType)) {
            throw new IllegalArgumentException("Illegal property type '" + String.valueOf(dateProperty) + "' [" + String.valueOf(propDefType) + "]");
        }
        QName propertyName = propDef.getName();
        String shortFormQName = propertyName.toPrefixString((NamespacePrefixResolver)namespaceService);
        String prefix = shortFormQName.substring(0, shortFormQName.indexOf(58));
        String localName = propertyName.getLocalName();
        StringBuilder luceneQuery = new StringBuilder();
        luceneQuery.append(" +@").append(prefix).append("\\:").append(localName).append(":[");
        if (fromDate != null) {
            luceneQuery.append(LuceneUtils.getLuceneDateString(fromDate));
        } else {
            luceneQuery.append("1970\\-01\\-01T00:00:00");
        }
        luceneQuery.append(" TO ");
        if (toDate != null) {
            luceneQuery.append(LuceneUtils.getLuceneDateString(toDate));
        } else {
            luceneQuery.append("3000\\-12\\-31T00:00:00");
        }
        luceneQuery.append("] ");
        return luceneQuery.toString();
    }
}

