/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jscript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowInstance;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowTask;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.mozilla.javascript.Scriptable;

public class JscriptWorkflowPath
implements Serializable {
    static final long serialVersionUID = 8271566861210368614L;
    private final String id;
    private boolean active;
    private WorkflowNode node;
    private JscriptWorkflowInstance instance;
    private ServiceRegistry serviceRegistry;
    private final Scriptable scope;

    public JscriptWorkflowPath(String id, WorkflowNode node, JscriptWorkflowInstance instance, ServiceRegistry serviceRegistry, Scriptable scope) {
        this.id = id;
        this.node = node;
        this.instance = instance;
        this.active = false;
        this.serviceRegistry = serviceRegistry;
        this.scope = scope;
    }

    public JscriptWorkflowPath(WorkflowPath cmrWorkflowPath, ServiceRegistry serviceRegistry, Scriptable scope) {
        this.id = cmrWorkflowPath.id;
        this.node = cmrWorkflowPath.node;
        this.instance = new JscriptWorkflowInstance(cmrWorkflowPath.instance, serviceRegistry, scope);
        this.active = cmrWorkflowPath.active;
        this.serviceRegistry = serviceRegistry;
        this.scope = scope;
    }

    public String getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public WorkflowNode getNode() {
        return this.node;
    }

    public JscriptWorkflowInstance getInstance() {
        return this.instance;
    }

    public Scriptable getTasks() {
        WorkflowService workflowService = this.serviceRegistry.getWorkflowService();
        List<WorkflowTask> cmrTasks = workflowService.getTasksForWorkflowPath(this.id);
        ArrayList<JscriptWorkflowTask> tasks = new ArrayList<JscriptWorkflowTask>();
        for (WorkflowTask cmrTask : cmrTasks) {
            tasks.add(new JscriptWorkflowTask(cmrTask, this.serviceRegistry, this.scope));
        }
        Scriptable tasksScriptable = (Scriptable)new ValueConverter().convertValueForScript(this.serviceRegistry, this.scope, null, tasks);
        return tasksScriptable;
    }

    public JscriptWorkflowPath signal(String transitionId) {
        WorkflowPath path = this.serviceRegistry.getWorkflowService().signal(this.id, transitionId);
        return new JscriptWorkflowPath(path, this.serviceRegistry, this.scope);
    }
}

