/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.virtual.ref.AbstractReferenceParserTest;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.PlainReferenceParser;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.ReferenceParseException;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;

public class PlainReferenceParserTest
extends AbstractReferenceParserTest {
    private static Log logger = LogFactory.getLog(PlainReferenceParserTest.class);

    @Test
    public void testRecursiveReferenceParser() throws Exception {
        this.assertRecursiveReferenceParser(Encodings.PLAIN.encoding);
    }

    @Test
    public void testParseClasspathResource() throws Exception {
        Reference pr = new PlainReferenceParser().parse("virtual:classpath:/org/alfresco/");
        Reference r = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/org/alfresco/"));
        PlainReferenceParserTest.assertEquals((Object)r, (Object)pr);
        Reference prp1 = new PlainReferenceParser().parse("virtual:classpath:/org/alfresco/:r:repository:node:workspace:SpacesStore:0029-222-333-444");
        RepositoryResource rr1 = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/0029-222-333-444")));
        List<Parameter> params1 = Arrays.asList(new ResourceParameter((Resource)rr1));
        Reference rp1 = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/org/alfresco/"), params1);
        PlainReferenceParserTest.assertEquals((Object)rp1, (Object)prp1);
        Reference prp2 = new PlainReferenceParser().parse("virtual:classpath:/org/alfresco/:r:repository:node:workspace:SpacesStore:0029-222-333-444:r:repository:path:/Data Dictionary/Virtual Folders/claim.json");
        RepositoryResource rr21 = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/0029-222-333-444")));
        RepositoryResource rr22 = new RepositoryResource((RepositoryLocation)new RepositoryPath("/Data Dictionary/Virtual Folders/claim.json"));
        List<Parameter> params2 = Arrays.asList(new ResourceParameter((Resource)rr21), new ResourceParameter((Resource)rr22));
        Reference rp2 = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/org/alfresco/"), params2);
        PlainReferenceParserTest.assertEquals((Object)rp2, (Object)prp2);
    }

    @Test
    public void testParseRepositoryNodeRef() throws Exception {
        Reference reference = new PlainReferenceParser().parse("virtual:repository:node:workspace:SpacesStore:0029-222-333-444");
        PlainReferenceParserTest.assertEquals((Object)reference, (Object)new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/0029-222-333-444")))));
    }

    @Test
    public void testParseRepositoryPath() throws Exception {
        Reference reference = new PlainReferenceParser().parse("virtual:repository:path:/Foo/Bar");
        PlainReferenceParserTest.assertEquals((Object)reference, (Object)new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new RepositoryResource((RepositoryLocation)new RepositoryPath("/Foo/Bar"))));
    }

    @Test
    public void testParseNodeProtocol() throws Exception {
        Reference reference = new PlainReferenceParser().parse("node:repository:node:workspace:SpacesStore:0029-222-333-444:r:repository:node:workspace:SpacesStore:0029-122-333-0023:ref:node:repository:node:workspace:SpacesStore:0029-222-333-444:r:repository:path:/Foo/Bar:s:smf_smartFolder:*");
        RepositoryResource rr = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/0029-122-333-0023")));
        List<Parameter> params = Arrays.asList(new ResourceParameter((Resource)rr), new ReferenceParameter(reference));
        reference = new PlainReferenceParser().parse("node:repository:node:workspace:SpacesStore:0029-222-333-444:r:repository:path:/Foo/Bar");
        rr = new RepositoryResource((RepositoryLocation)new RepositoryPath("/Foo/Bar"));
        params = Arrays.asList(new ResourceParameter((Resource)rr));
        PlainReferenceParserTest.assertEquals((Object)reference, (Object)new Reference(Encodings.PLAIN.encoding, Protocols.NODE.protocol, (Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/0029-222-333-444"))), params));
        reference = new PlainReferenceParser().parse("node:repository:node:workspace:SpacesStore:0029-222-333-444:r:repository:path:/Foo/Bar:s:smf_smartFolder");
        rr = new RepositoryResource((RepositoryLocation)new RepositoryPath("/Foo/Bar"));
        params = Arrays.asList(new ResourceParameter((Resource)rr), new StringParameter("smf_smartFolder"));
        PlainReferenceParserTest.assertEquals((Object)reference, (Object)new Reference(Encodings.PLAIN.encoding, Protocols.NODE.protocol, (Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/0029-222-333-444"))), params));
    }

    @Test
    public void testReferenceDelimiter() {
        Reference parsedRef = new PlainReferenceParser().parse("vanilla:repository:path:/Company Home/Data Dictionary/:ref:vanilla:classpath:/org/alfresco/repo/virtual/node/vanilla.js:s:/Images/ JPG images/:r:repository:node:workspace:SpacesStore:67c8f11d-0936-4295-88a0-12b85764c76f:r:repository:node:workspace:SpacesStore:6428d7cc-feaa-4e32-a983-0b357439a994:*");
        List<Parameter> params = Arrays.asList(new StringParameter("/Images/ JPG images/"), new ResourceParameter((Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f")))), new ResourceParameter((Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/6428d7cc-feaa-4e32-a983-0b357439a994")))));
        Reference innerRef = new Reference(Encodings.PLAIN.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("/org/alfresco/repo/virtual/node/vanilla.js"), params);
        List<Parameter> prms = Arrays.asList(new ReferenceParameter(innerRef));
        Reference createdRef = new Reference(Encodings.PLAIN.encoding, Protocols.VANILLA.protocol, (Resource)new RepositoryResource((RepositoryLocation)new RepositoryPath("/Company Home/Data Dictionary/")), prms);
        PlainReferenceParserTest.assertEquals((Object)parsedRef, (Object)createdRef);
        Reference parsedRef1 = new PlainReferenceParser().parse("node:repository:path:/Company Home/Data Dictionary/:ref:vanilla:classpath:/org/alfresco/repo/virtual/node/vanilla.js:s:/My Documents:r:repository:node:workspace:SpacesStore:67c8f11d-0936-4295-88a0-12b85764c76f:r:repository:node:workspace:SpacesStore:6428d7cc-feaa-4e32-a983-0b357439a994:*:ref:vanilla:classpath:/org/alfresco/repo/virtual/node/vanilla.js:s:/My Documents:r:repository:node:workspace:SpacesStore:67c8f11d-0936-4295-88a0-12b85764c76f:r:repository:node:workspace:SpacesStore:6428d7cc-feaa-4e32-a983-0b357439a994:*");
        List<Parameter> params1 = Arrays.asList(new StringParameter("/My Documents"), new ResourceParameter((Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f")))), new ResourceParameter((Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/6428d7cc-feaa-4e32-a983-0b357439a994")))));
        Reference innerRef1 = new Reference(Encodings.PLAIN.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("/org/alfresco/repo/virtual/node/vanilla.js"), params1);
        Reference innerRef2 = new Reference(Encodings.PLAIN.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("/org/alfresco/repo/virtual/node/vanilla.js"), params1);
        List<Parameter> prms1 = Arrays.asList(new ReferenceParameter(innerRef1), new ReferenceParameter(innerRef2));
        Reference createdRef1 = new Reference(Encodings.PLAIN.encoding, Protocols.NODE.protocol, (Resource)new RepositoryResource((RepositoryLocation)new RepositoryPath("/Company Home/Data Dictionary/")), prms1);
        PlainReferenceParserTest.assertEquals((Object)parsedRef1, (Object)createdRef1);
        Reference parsedRef2 = new PlainReferenceParser().parse("virtual:classpath:/Company Home/:ref:vanilla:classpath:/org/alfresco/repo/virtual/node/vanilla.js:s:/My Documents/+=?Folder:r:repository:path:/this/ repo/ path/:r:classpath:/org/alfresco/repo/virtual/template.js:*:ref:vanilla:classpath:virtual.js:*");
        List<Parameter> params2 = Arrays.asList(new StringParameter("/My Documents/+=?Folder"), new ResourceParameter((Resource)new RepositoryResource((RepositoryLocation)new RepositoryPath("/this/ repo/ path/"))), new ResourceParameter((Resource)new ClasspathResource("/org/alfresco/repo/virtual/template.js")));
        Reference innerRef3 = new Reference(Encodings.PLAIN.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("/org/alfresco/repo/virtual/node/vanilla.js"), params2);
        Reference innerRef4 = new Reference(Encodings.PLAIN.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("virtual.js"));
        List<Parameter> prms2 = Arrays.asList(new ReferenceParameter(innerRef3), new ReferenceParameter(innerRef4));
        Reference createdRef2 = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/Company Home/"), prms2);
        PlainReferenceParserTest.assertEquals((Object)parsedRef2, (Object)createdRef2);
    }

    protected void assertReferenceParseException(String reference) {
        try {
            new PlainReferenceParser().parse(reference);
            PlainReferenceParserTest.fail((String)("\"" + reference + "\" should not be parsed!"));
        }
        catch (ReferenceParseException e) {
            logger.info((Object)e);
        }
    }

    @Test
    public void testParseError1() throws Exception {
        this.assertReferenceParseException("x:folder:classpath:/org/alfresco/");
        this.assertReferenceParseException("plain:folder:classpath:/org/alfresco/");
        this.assertReferenceParseException("folder:x:/org/alfresco/");
        this.assertReferenceParseException("folder:classpath:");
        this.assertReferenceParseException("folder:classpath:/org/alfresco/:x:u");
    }
}

