/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.jscript.MetaDataExtractAction;
import org.alfresco.repo.jscript.ScriptAction;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MetaDataExtractActionTest {
    @Test
    public void testIsContentChangedReturnsTrue() {
        MetaDataExtractAction action = new MetaDataExtractAction();
        ContentService contentService = (ContentService)Mockito.mock(ContentService.class);
        ContentReader reader = (ContentReader)Mockito.mock(ContentReader.class);
        FormData formData = (FormData)Mockito.mock(FormData.class);
        FormData.FieldData fieldData = (FormData.FieldData)Mockito.mock(FormData.FieldData.class);
        String nodeRefStr = "workspace://SpacesStore/abc/def";
        Mockito.when((Object)contentService.getReader((NodeRef)Mockito.any(), (QName)Mockito.any())).thenReturn((Object)reader);
        Mockito.when((Object)reader.getContentString()).thenReturn((Object)"oldContent");
        Mockito.when((Object)formData.getFieldData("prop_cm_content")).thenReturn((Object)fieldData);
        Mockito.when((Object)fieldData.getValue()).thenReturn((Object)"newContent");
        action.setContentService(contentService);
        boolean result = action.isContentChanged(nodeRefStr, formData);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsContentChangedReturnsFalse() {
        MetaDataExtractAction action = new MetaDataExtractAction();
        ContentService contentService = (ContentService)Mockito.mock(ContentService.class);
        ContentReader reader = (ContentReader)Mockito.mock(ContentReader.class);
        FormData formData = (FormData)Mockito.mock(FormData.class);
        FormData.FieldData fieldData = (FormData.FieldData)Mockito.mock(FormData.FieldData.class);
        String nodeRefStr = "workspace://SpacesStore/abc/def";
        Mockito.when((Object)contentService.getReader((NodeRef)Mockito.any(), (QName)Mockito.any())).thenReturn((Object)reader);
        Mockito.when((Object)reader.getContentString()).thenReturn((Object)"sameContent");
        Mockito.when((Object)formData.getFieldData("prop_cm_content")).thenReturn((Object)fieldData);
        Mockito.when((Object)fieldData.getValue()).thenReturn((Object)"sameContent");
        action.setContentService(contentService);
        boolean result = action.isContentChanged(nodeRefStr, formData);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testCreateWhenContentChangedReturnsScriptAction() {
        MetaDataExtractAction action = new MetaDataExtractAction();
        ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        ActionService actionService = (ActionService)Mockito.mock(ActionService.class);
        ActionDefinition actionDefinition = (ActionDefinition)Mockito.mock(ActionDefinition.class);
        Action alfrescoAction = (Action)Mockito.mock(Action.class);
        ActionCondition actionCondition = (ActionCondition)Mockito.mock(ActionCondition.class);
        Mockito.when((Object)serviceRegistry.getActionService()).thenReturn((Object)actionService);
        Mockito.when((Object)actionService.getActionDefinition(Mockito.anyString())).thenReturn((Object)actionDefinition);
        Mockito.when((Object)actionService.createAction(Mockito.anyString())).thenReturn((Object)alfrescoAction);
        Mockito.when((Object)actionService.createActionCondition(Mockito.anyString())).thenReturn((Object)actionCondition);
        action.setServiceRegistry(serviceRegistry);
        ScriptAction result = action.create(true);
        Assert.assertNotNull((String)"ScriptAction should not be null when content has changed", (Object)result);
    }
}

