/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.TempFileProvider;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;

public class AlfrescoCmisStreamInterceptor
implements MethodInterceptor {
    private MimetypeService mimetypeService;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        reusableContentStreams = null;
        try {
            parameterTypes = mi.getMethod().getParameterTypes();
            arguments = mi.getArguments();
            i = 0;
            while (i < parameterTypes.length) {
                if (ContentStream.class.isAssignableFrom(parameterTypes[i]) && (contentStream = (ContentStream)arguments[i]) != null) {
                    if (reusableContentStreams == null) {
                        reusableContentStreams = new ArrayList<ReusableContentStream>();
                    }
                    reusableContentStream = new ReusableContentStream(contentStream);
                    if (contentStream.getMimeType() == null) {
                        mimeType = this.mimetypeService.guessMimetype(reusableContentStream.getFileName(), (ContentReader)new FileContentReader(reusableContentStream.file));
                        reusableContentStream.setMimeType(mimeType);
                    }
                    reusableContentStreams.add(reusableContentStream);
                    arguments[i] = reusableContentStream;
                }
                ++i;
            }
            var10_9 = mi.proceed();
            return var10_9;
        }
        finally {
            if (reusableContentStreams == null) return var10_9;
            ** for (contentStream : reusableContentStreams)
        }
lbl-1000:
        // 1 sources

        {
            contentStream.close();
            continue;
        }
lbl26:
        // 1 sources

        return var10_9;
    }

    private static class ReusableContentStream
    extends ContentStreamImpl {
        private static final long serialVersionUID = 8992465629472248502L;
        private File file;

        public ReusableContentStream(ContentStream contentStream) throws Exception {
            this.setLength(contentStream.getBigLength());
            this.setMimeType(contentStream.getMimeType());
            this.setFileName(contentStream.getFileName());
            this.file = TempFileProvider.createTempFile((InputStream)contentStream.getStream(), (String)"cmis", (String)"contentStream");
        }

        public InputStream getStream() {
            InputStream stream = super.getStream();
            if (stream == null && this.file != null) {
                try {
                    stream = new FileInputStream(this.file){

                        @Override
                        public void close() throws IOException {
                            this.setStream(null);
                            super.close();
                        }
                    };
                }
                catch (Exception e) {
                    throw new AlfrescoRuntimeException("Expected to be able to reopen temporary file", (Throwable)e);
                }
                this.setStream(stream);
            }
            return stream;
        }

        public void close() {
            try {
                this.file.delete();
            }
            finally {
                this.file = null;
            }
        }
    }
}

