/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.permissions.Ace;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.domain.permissions.AclCrudDAO;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.domain.permissions.AclEntity;
import org.alfresco.repo.domain.permissions.AclMember;
import org.alfresco.repo.domain.permissions.AclMemberEntity;
import org.alfresco.repo.domain.permissions.AclUpdateEntity;
import org.alfresco.repo.domain.permissions.Authority;
import org.alfresco.repo.domain.permissions.Permission;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.ACEType;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlEntry;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.security.permissions.SimpleAccessControlEntry;
import org.alfresco.repo.security.permissions.SimpleAccessControlList;
import org.alfresco.repo.security.permissions.SimpleAccessControlListProperties;
import org.alfresco.repo.security.permissions.impl.AclChange;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AclDAOImpl
implements AclDAO {
    private static Log logger = LogFactory.getLog(AclDAOImpl.class);
    private QNameDAO qnameDAO;
    private AclCrudDAO aclCrudDAO;
    private NodeDAO nodeDAO;
    private TenantService tenantService;
    private SimpleCache<Serializable, AccessControlList> aclCache;
    private static final String RESOURCE_KEY_ACL_CHANGE_SET_ID = "acl.change.set.id";
    private static final String RESOURCE_KEY_ACL_CHANGE_SET_COMMIT_TIME_MS = "acl.change.commit.set.time.ms";
    private UpdateChangeSetListener updateChangeSetListener = new UpdateChangeSetListener();

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setAclCrudDAO(AclCrudDAO aclCrudDAO) {
        this.aclCrudDAO = aclCrudDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setAclCache(SimpleCache<Serializable, AccessControlList> aclCache) {
        this.aclCache = aclCache;
    }

    @Override
    public Long createAccessControlList() {
        return this.createAccessControlList(this.getDefaultProperties()).getId();
    }

    @Override
    public AccessControlListProperties getDefaultProperties() {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setInherits(true);
        properties.setVersioned(false);
        return properties;
    }

    @Override
    public Acl createAccessControlList(AccessControlListProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties cannot be null");
        }
        if (properties.getAclType() == null) {
            throw new IllegalArgumentException("ACL Type must be defined");
        }
        switch (properties.getAclType()) {
            case OLD: {
                if (properties.isVersioned() != Boolean.TRUE) break;
                throw new IllegalArgumentException("Old acls can not be versioned");
            }
            case SHARED: {
                throw new IllegalArgumentException("Can not create shared acls direct - use get inherited");
            }
            case DEFINING: 
            case LAYERED: {
                break;
            }
            case FIXED: {
                if (properties.getInherits() == Boolean.TRUE) {
                    throw new IllegalArgumentException("Fixed ACLs can not inherit");
                }
            }
            case GLOBAL: {
                if (properties.getInherits() != Boolean.TRUE) break;
                throw new IllegalArgumentException("Fixed ACLs can not inherit");
            }
        }
        return this.createAccessControlList(properties, null, null);
    }

    @Override
    public Acl createAccessControlList(AccessControlListProperties properties, List<AccessControlEntry> aces, Long inherited) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties cannot be null");
        }
        AclEntity acl = new AclEntity();
        if (properties.getAclId() != null) {
            acl.setAclId(properties.getAclId());
        } else {
            acl.setAclId(GUID.generate());
        }
        acl.setAclType(properties.getAclType());
        acl.setAclVersion(1L);
        switch (properties.getAclType()) {
            case FIXED: 
            case GLOBAL: {
                acl.setInherits(Boolean.FALSE);
            }
        }
        if (properties.getInherits() != null) {
            acl.setInherits(properties.getInherits());
        } else {
            acl.setInherits(Boolean.TRUE);
        }
        acl.setLatest(Boolean.TRUE);
        switch (properties.getAclType()) {
            case OLD: {
                acl.setVersioned(Boolean.FALSE);
                break;
            }
            case LAYERED: {
                if (properties.isVersioned() != null) {
                    acl.setVersioned(properties.isVersioned());
                    break;
                }
                acl.setVersioned(Boolean.TRUE);
                break;
            }
            default: {
                if (properties.isVersioned() != null) {
                    acl.setVersioned(properties.isVersioned());
                    break;
                }
                acl.setVersioned(Boolean.FALSE);
            }
        }
        acl.setAclChangeSetId(this.getCurrentChangeSetId());
        acl.setRequiresVersion(false);
        AclEntity createdAcl = (AclEntity)this.aclCrudDAO.createAcl(acl);
        long created = createdAcl.getId();
        ArrayList<Ace> toAdd = new ArrayList<Ace>();
        ArrayList<SimpleAccessControlEntry> excluded = new ArrayList<SimpleAccessControlEntry>();
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        if (aces != null && aces.size() > 0) {
            for (AccessControlEntry ace : aces) {
                if (ace.getPosition() != null && ace.getPosition() != 0) {
                    throw new IllegalArgumentException("Invalid position");
                }
                Authority authority = this.aclCrudDAO.getOrCreateAuthority(ace.getAuthority());
                Permission permission = this.aclCrudDAO.getOrCreatePermission(ace.getPermission());
                if (ace.getContext() != null) {
                    throw new UnsupportedOperationException();
                }
                Ace entry = this.aclCrudDAO.getOrCreateAce(permission, authority, ace.getAceType(), ace.getAccessStatus());
                SimpleAccessControlEntry exclude = new SimpleAccessControlEntry();
                exclude.setAceType(ace.getAceType());
                exclude.setAuthority(ace.getAuthority());
                exclude.setPermission(ace.getPermission());
                exclude.setPosition(0);
                toAdd.add(entry);
                excluded.add(exclude);
            }
        }
        Long toInherit = null;
        if (inherited != null) {
            toInherit = this.getInheritedAccessControlList(inherited);
        }
        this.getWritable(created, toInherit, excluded, toAdd, toInherit, false, changes, WriteMode.CREATE_AND_INHERIT);
        return this.getAcl(created);
    }

    private void getWritable(Long id, Long parent, List<? extends AccessControlEntry> exclude, List<Ace> toAdd, Long inheritsFrom, boolean cascade, List<AclChange> changes, WriteMode mode) {
        ArrayList<Ace> inherited = null;
        ArrayList<Integer> positions = null;
        if (mode == WriteMode.ADD_INHERITED || mode == WriteMode.INSERT_INHERITED || mode == WriteMode.CHANGE_INHERITED || mode == WriteMode.CREATE_AND_INHERIT) {
            inherited = new ArrayList<Ace>();
            positions = new ArrayList<Integer>();
            List<Object> members = parent != null ? this.aclCrudDAO.getAclMembersByAcl(parent) : Collections.emptyList();
            for (AclMember member : members) {
                Ace aceEntity = this.aclCrudDAO.getAce(member.getAceId());
                if (mode == WriteMode.INSERT_INHERITED && member.getPos() == 0) {
                    inherited.add(aceEntity);
                    positions.add(member.getPos());
                    continue;
                }
                inherited.add(aceEntity);
                positions.add(member.getPos());
            }
        }
        this.getWritable(id, parent, new HashSet<Long>(), exclude, toAdd, inheritsFrom, inherited, positions, cascade, 0, changes, mode, false);
    }

    private void getWritable(Long id, Long parent, Set<Long> visitedAcls, List<? extends AccessControlEntry> exclude, List<Ace> toAdd, Long inheritsFrom, List<Ace> inherited, List<Integer> positions, boolean cascade, int depth, List<AclChange> changes, WriteMode mode, boolean requiresVersion) {
        AclChange current = this.getWritable(id, parent, exclude, toAdd, inheritsFrom, inherited, positions, depth, mode, requiresVersion);
        changes.add(current);
        boolean cascadeVersion = requiresVersion;
        if (!cascadeVersion) {
            boolean bl = cascadeVersion = !current.getBefore().equals(current.getAfter());
        }
        if (cascade) {
            List<Long> inheritors = this.aclCrudDAO.getAclsThatInheritFromAcl(id);
            for (Long nextId : inheritors) {
                if (visitedAcls.contains(nextId)) {
                    if (!logger.isWarnEnabled()) continue;
                    StringBuilder message = new StringBuilder("ACL cycle detected! Repeated ALC id = '").append(nextId).append("', inherited ACL id = '").append(id).append("', already visited ACLs: '").append(visitedAcls).append("'. Skipping processing of the ACL id...");
                    logger.warn((Object)message.toString());
                    continue;
                }
                this.getWritable(nextId, current.getAfter(), visitedAcls, exclude, toAdd, current.getAfter(), inherited, positions, cascade, depth + 1, changes, mode, cascadeVersion);
            }
        }
    }

    private AclChange getWritable(Long id, Long parent, List<? extends AccessControlEntry> exclude, List<Ace> acesToAdd, Long inheritsFrom, List<Ace> inherited, List<Integer> positions, int depth, WriteMode mode, boolean requiresVersion) {
        AclUpdateEntity acl = this.aclCrudDAO.getAclForUpdate(id);
        if (!acl.isLatest().booleanValue()) {
            return new AclChangeImpl(id, id, acl.getAclType(), acl.getAclType());
        }
        ArrayList<Long> toAdd = new ArrayList<Long>(0);
        if (acesToAdd != null) {
            for (Ace ace : acesToAdd) {
                toAdd.add(ace.getId());
            }
        }
        if (!acl.isVersioned().booleanValue()) {
            switch (mode) {
                case COPY_UPDATE_AND_INHERIT: {
                    this.removeAcesFromAcl(id, exclude, depth);
                    this.aclCrudDAO.addAclMembersToAcl(acl.getId(), toAdd, depth);
                    break;
                }
                case CHANGE_INHERITED: {
                    this.replaceInherited(id, acl, inherited, positions, depth);
                    break;
                }
                case ADD_INHERITED: {
                    this.addInherited(acl, inherited, positions, depth);
                    break;
                }
                case TRUNCATE_INHERITED: {
                    this.truncateInherited(id, depth);
                    break;
                }
                case INSERT_INHERITED: {
                    this.insertInherited(id, acl, inherited, positions, depth);
                    break;
                }
                case REMOVE_INHERITED: {
                    this.removeInherited(id, depth);
                    break;
                }
                case CREATE_AND_INHERIT: {
                    this.aclCrudDAO.addAclMembersToAcl(acl.getId(), toAdd, depth);
                    this.addInherited(acl, inherited, positions, depth);
                }
            }
            if (inheritsFrom != null) {
                acl.setInheritsFrom(inheritsFrom);
            }
            acl.setAclChangeSetId(this.getCurrentChangeSetId());
            this.aclCrudDAO.updateAcl(acl);
            return new AclChangeImpl(id, id, acl.getAclType(), acl.getAclType());
        }
        if (acl.getAclChangeSetId().longValue() == this.getCurrentChangeSetId() && !requiresVersion && !acl.getRequiresVersion().booleanValue()) {
            switch (mode) {
                case COPY_UPDATE_AND_INHERIT: {
                    this.removeAcesFromAcl(id, exclude, depth);
                    this.aclCrudDAO.addAclMembersToAcl(acl.getId(), toAdd, depth);
                    break;
                }
                case CHANGE_INHERITED: {
                    this.replaceInherited(id, acl, inherited, positions, depth);
                    break;
                }
                case ADD_INHERITED: {
                    this.addInherited(acl, inherited, positions, depth);
                    break;
                }
                case TRUNCATE_INHERITED: {
                    this.truncateInherited(id, depth);
                    break;
                }
                case INSERT_INHERITED: {
                    this.insertInherited(id, acl, inherited, positions, depth);
                    break;
                }
                case REMOVE_INHERITED: {
                    this.removeInherited(id, depth);
                    break;
                }
                case CREATE_AND_INHERIT: {
                    this.aclCrudDAO.addAclMembersToAcl(acl.getId(), toAdd, depth);
                    this.addInherited(acl, inherited, positions, depth);
                }
            }
            if (inheritsFrom != null) {
                acl.setInheritsFrom(inheritsFrom);
            }
            this.aclCrudDAO.updateAcl(acl);
            return new AclChangeImpl(id, id, acl.getAclType(), acl.getAclType());
        }
        AclEntity newAcl = new AclEntity();
        newAcl.setAclChangeSetId(this.getCurrentChangeSetId());
        newAcl.setAclId(acl.getAclId());
        newAcl.setAclType(acl.getAclType());
        newAcl.setAclVersion(acl.getAclVersion() + 1L);
        newAcl.setInheritedAcl(-1L);
        newAcl.setInherits(acl.getInherits());
        newAcl.setInheritsFrom(inheritsFrom != null ? inheritsFrom : acl.getInheritsFrom());
        newAcl.setLatest(Boolean.TRUE);
        newAcl.setVersioned(Boolean.TRUE);
        newAcl.setRequiresVersion(Boolean.FALSE);
        AclEntity createdAcl = (AclEntity)this.aclCrudDAO.createAcl(newAcl);
        long created = createdAcl.getId();
        List<AclMember> members = this.aclCrudDAO.getAclMembersByAcl(id);
        if (members.size() > 0) {
            ArrayList<Pair<Long, Integer>> aceIdsWithDepths = new ArrayList<Pair<Long, Integer>>(members.size());
            for (AclMember member : members) {
                aceIdsWithDepths.add((Pair<Long, Integer>)new Pair((Object)member.getAceId(), (Object)member.getPos()));
            }
            this.aclCrudDAO.addAclMembersToAcl(newAcl.getId(), aceIdsWithDepths);
        }
        switch (mode) {
            case COPY_UPDATE_AND_INHERIT: {
                this.removeAcesFromAcl(newAcl.getId(), exclude, depth);
                this.aclCrudDAO.addAclMembersToAcl(newAcl.getId(), toAdd, depth);
                break;
            }
            case CHANGE_INHERITED: {
                this.replaceInherited(newAcl.getId(), newAcl, inherited, positions, depth);
                break;
            }
            case ADD_INHERITED: {
                this.addInherited(newAcl, inherited, positions, depth);
                break;
            }
            case TRUNCATE_INHERITED: {
                this.truncateInherited(newAcl.getId(), depth);
                break;
            }
            case INSERT_INHERITED: {
                this.insertInherited(newAcl.getId(), newAcl, inherited, positions, depth);
                break;
            }
            case REMOVE_INHERITED: {
                this.removeInherited(newAcl.getId(), depth);
                break;
            }
            case CREATE_AND_INHERIT: {
                this.aclCrudDAO.addAclMembersToAcl(acl.getId(), toAdd, depth);
                this.addInherited(acl, inherited, positions, depth);
            }
        }
        if (newAcl.getAclType() == ACLType.SHARED && parent != null) {
            Long writableParentAcl = this.getWritable(parent, null, null, null, null, null, null, 0, WriteMode.COPY_ONLY, false).getAfter();
            AclUpdateEntity parentAcl = this.aclCrudDAO.getAclForUpdate(writableParentAcl);
            parentAcl.setInheritedAcl(created);
            this.aclCrudDAO.updateAcl(parentAcl);
        }
        acl.setLatest(Boolean.FALSE);
        acl.setRequiresVersion(Boolean.FALSE);
        this.aclCrudDAO.updateAcl(acl);
        return new AclChangeImpl(id, created, acl.getAclType(), newAcl.getAclType());
    }

    private void removeAcesFromAcl(Long id, List<? extends AccessControlEntry> exclude, int depth) {
        if (exclude == null) {
            this.aclCrudDAO.deleteAclMembersByAcl(id);
        } else {
            AcePatternMatcher excluder = new AcePatternMatcher(exclude);
            List<Map<String, Object>> results = this.aclCrudDAO.getAcesAndAuthoritiesByAcl(id);
            ArrayList<Long> memberIds = new ArrayList<Long>(results.size());
            for (Map<String, Object> result : results) {
                Long result_aclmemId = (Long)result.get("aclmemId");
                if (exclude == null || !excluder.matches(this.aclCrudDAO, result, depth)) continue;
                memberIds.add(result_aclmemId);
            }
            this.aclCrudDAO.deleteAclMembers(memberIds);
        }
    }

    private void replaceInherited(Long id, Acl acl, List<Ace> inherited, List<Integer> positions, int depth) {
        this.truncateInherited(id, depth);
        this.addInherited(acl, inherited, positions, depth);
    }

    private void truncateInherited(Long id, int depth) {
        List<AclMember> members = this.aclCrudDAO.getAclMembersByAcl(id);
        ArrayList<Long> membersToDelete = new ArrayList<Long>(members.size());
        for (AclMember member : members) {
            if (member.getPos() <= depth) continue;
            membersToDelete.add(member.getId());
        }
        if (membersToDelete.size() > 0) {
            this.aclCrudDAO.deleteAclMembers(membersToDelete);
        }
    }

    private void removeInherited(Long id, int depth) {
        List<AclMemberEntity> members = this.aclCrudDAO.getAclMembersByAclForUpdate(id);
        ArrayList<Long> membersToDelete = new ArrayList<Long>(members.size());
        for (AclMemberEntity member : members) {
            if (member.getPos() == depth + 1) {
                membersToDelete.add(member.getId());
                continue;
            }
            if (member.getPos() <= depth + 1) continue;
            member.setPos(member.getPos() - 1);
            this.aclCrudDAO.updateAclMember(member);
        }
        if (membersToDelete.size() > 0) {
            this.aclCrudDAO.deleteAclMembers(membersToDelete);
        }
    }

    private void addInherited(Acl acl, List<Ace> inherited, List<Integer> positions, int depth) {
        if (inherited != null && inherited.size() > 0) {
            ArrayList<Pair<Long, Integer>> aceIdsWithDepths = new ArrayList<Pair<Long, Integer>>(inherited.size());
            int i = 0;
            while (i < inherited.size()) {
                Ace add = inherited.get(i);
                Integer position = positions.get(i);
                aceIdsWithDepths.add((Pair<Long, Integer>)new Pair((Object)add.getId(), (Object)(position + depth + 1)));
                ++i;
            }
            this.aclCrudDAO.addAclMembersToAcl(acl.getId(), aceIdsWithDepths);
        }
    }

    private void insertInherited(Long id, AclEntity acl, List<Ace> inherited, List<Integer> positions, int depth) {
        List<AclMemberEntity> members = this.aclCrudDAO.getAclMembersByAclForUpdate(id);
        for (AclMemberEntity member : members) {
            if (member.getPos() <= depth) continue;
            member.setPos(member.getPos() + 1);
            this.aclCrudDAO.updateAclMember(member);
        }
        this.addInherited(acl, inherited, positions, depth);
    }

    @Override
    public List<AclChange> deleteAccessControlEntries(String authority) {
        LinkedList<AclChange> aclChanges = new LinkedList<AclChange>();
        Authority authEntity = this.aclCrudDAO.getAuthority(authority);
        if (authEntity == null) {
            return aclChanges;
        }
        ArrayList<Long> aces = new ArrayList<Long>();
        List<AclMember> members = this.aclCrudDAO.getAclMembersByAuthority(authority);
        boolean leaveAuthority = false;
        if (members.size() > 0) {
            HashSet<AclUpdateEntity> acls = new HashSet<AclUpdateEntity>(members.size() * 2);
            ArrayList<Long> membersToDelete = new ArrayList<Long>(members.size());
            for (AclMember member : members) {
                List<Long> nodeIds;
                Long aclMemberId = member.getId();
                Long aclId = member.getAclId();
                Long aceId = member.getAceId();
                boolean hasAnotherTenantNodes = false;
                if (AuthenticationUtil.isMtEnabled() && (nodeIds = this.aclCrudDAO.getADMNodesByAcl(aclId, -1)).size() > 0) {
                    for (Long nodeId : nodeIds) {
                        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(nodeId);
                        if (nodePair == null) {
                            logger.warn((Object)("Node does not exist: " + String.valueOf(nodeId)));
                            continue;
                        }
                        NodeRef nodeRef = (NodeRef)nodePair.getSecond();
                        try {
                            this.tenantService.checkDomain(nodeRef.getStoreRef().getIdentifier());
                        }
                        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
                            hasAnotherTenantNodes = true;
                            leaveAuthority = true;
                            break;
                        }
                    }
                }
                if (hasAnotherTenantNodes) continue;
                AclUpdateEntity list = this.aclCrudDAO.getAclForUpdate(aclId);
                aclChanges.add(new AclChangeImpl(aclId, aclId, list.getAclType(), list.getAclType()));
                acls.add(list);
                membersToDelete.add(aclMemberId);
                aces.add(aceId);
            }
            this.aclCrudDAO.deleteAclMembers(membersToDelete);
            for (AclUpdateEntity acl : acls) {
                acl.setAclChangeSetId(this.getCurrentChangeSetId());
                this.aclCrudDAO.updateAcl(acl);
            }
        }
        if (!leaveAuthority) {
            this.aclCrudDAO.deleteAces(aces);
            List<Ace> unreferenced = this.aclCrudDAO.getAcesByAuthority(authEntity.getId());
            if (unreferenced.size() > 0) {
                ArrayList<Long> unrefencedAcesToDelete = new ArrayList<Long>(unreferenced.size());
                for (Ace ace : unreferenced) {
                    unrefencedAcesToDelete.add(ace.getId());
                }
                this.aclCrudDAO.deleteAces(unrefencedAcesToDelete);
            }
            if (authEntity != null) {
                this.aclCrudDAO.deleteAuthority(authEntity.getId());
            }
        }
        return aclChanges;
    }

    @Override
    public void deleteAclForNode(long aclId) {
        Long defining;
        Acl dbAcl = this.getAcl(aclId);
        if (dbAcl.getAclType() == ACLType.DEFINING) {
            this.aclCrudDAO.deleteAclMembersByAcl(aclId);
            this.aclCrudDAO.deleteAcl(aclId);
        }
        if (dbAcl.getAclType() == ACLType.SHARED && this.aclCrudDAO.getAcl(defining = dbAcl.getInheritsFrom()) == null && this.getADMNodesByAcl(aclId, 1).size() == 0) {
            this.aclCrudDAO.deleteAclMembersByAcl(aclId);
            this.aclCrudDAO.deleteAcl(aclId);
        }
    }

    @Override
    public List<AclChange> deleteAccessControlList(Long id) {
        if (logger.isDebugEnabled()) {
            int maxForDebug = 11;
            List<Long> nodeIds = this.getADMNodesByAcl(id, maxForDebug);
            for (Long nodeId : nodeIds) {
                logger.debug((Object)("deleteAccessControlList: Found nodeId=" + String.valueOf(nodeId) + ", aclId=" + String.valueOf(id)));
            }
        }
        ArrayList<AclChange> acls = new ArrayList<AclChange>();
        AclUpdateEntity acl = this.aclCrudDAO.getAclForUpdate(id);
        if (!acl.isLatest().booleanValue()) {
            throw new UnsupportedOperationException("Old ACL versions can not be updated");
        }
        if (acl.getAclType() == ACLType.SHARED) {
            throw new UnsupportedOperationException("Delete is not supported for shared acls - they are deleted with the defining acl");
        }
        if (acl.getAclType() == ACLType.DEFINING || acl.getAclType() == ACLType.LAYERED) {
            if (acl.getInheritedAcl() != null && acl.getInheritedAcl() != -1L) {
                Acl inherited = this.aclCrudDAO.getAcl(acl.getInheritedAcl());
                this.getWritable(inherited.getId(), acl.getInheritsFrom(), null, null, null, true, acls, WriteMode.REMOVE_INHERITED);
                Acl unusedInherited = null;
                for (AclChange change : acls) {
                    if (change.getBefore() == null || !change.getBefore().equals(inherited.getId())) continue;
                    unusedInherited = this.aclCrudDAO.getAcl(change.getAfter());
                }
                Long newId = unusedInherited.getId();
                List<Long> inheritors = this.aclCrudDAO.getAclsThatInheritFromAcl(newId);
                for (Long nextId : inheritors) {
                    this.getWritable(nextId, acl.getInheritsFrom(), null, null, acl.getInheritsFrom(), true, acls, WriteMode.REMOVE_INHERITED);
                }
                this.aclCrudDAO.deleteAclMembersByAcl(newId);
                this.aclCrudDAO.deleteAcl(unusedInherited.getId());
                if (inherited.isVersioned().booleanValue()) {
                    AclUpdateEntity inheritedForUpdate = this.aclCrudDAO.getAclForUpdate(inherited.getId());
                    if (inheritedForUpdate != null) {
                        inheritedForUpdate.setLatest(Boolean.FALSE);
                        this.aclCrudDAO.updateAcl(inheritedForUpdate);
                    }
                } else {
                    this.aclCrudDAO.deleteAcl(inherited.getId());
                }
            }
        } else {
            List<Long> inheritors = this.aclCrudDAO.getAclsThatInheritFromAcl(id);
            for (Long nextId : inheritors) {
                this.getWritable(nextId, acl.getInheritsFrom(), null, null, null, true, acls, WriteMode.REMOVE_INHERITED);
            }
        }
        if (acl.isVersioned().booleanValue()) {
            acl.setLatest(Boolean.FALSE);
            acl.setAclChangeSetId(this.getCurrentChangeSetId());
            this.aclCrudDAO.updateAcl(acl);
        } else {
            this.aclCrudDAO.deleteAclMembersByAcl(id);
            this.aclCrudDAO.deleteAcl(acl.getId());
        }
        acls.add(new AclChangeImpl(id, null, acl.getAclType(), null));
        return acls;
    }

    @Override
    public List<AclChange> deleteLocalAccessControlEntries(Long id) {
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        SimpleAccessControlEntry pattern = new SimpleAccessControlEntry();
        pattern.setPosition(0);
        this.getWritable(id, null, Collections.singletonList(pattern), null, null, true, changes, WriteMode.COPY_UPDATE_AND_INHERIT);
        return changes;
    }

    @Override
    public List<AclChange> deleteInheritedAccessControlEntries(Long id) {
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        SimpleAccessControlEntry pattern = new SimpleAccessControlEntry();
        pattern.setPosition(-1);
        this.getWritable(id, null, Collections.singletonList(pattern), null, null, true, changes, WriteMode.COPY_UPDATE_AND_INHERIT);
        return changes;
    }

    @Override
    public List<AclChange> deleteAccessControlEntries(Long id, AccessControlEntry pattern) {
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        this.getWritable(id, null, Collections.singletonList(pattern), null, null, true, changes, WriteMode.COPY_UPDATE_AND_INHERIT);
        return changes;
    }

    @Override
    public Acl getAcl(Long id) {
        return this.aclCrudDAO.getAcl(id);
    }

    @Override
    public AccessControlListProperties getAccessControlListProperties(Long id) {
        ParameterCheck.mandatory((String)"id", (Object)id);
        return this.aclCrudDAO.getAcl(id);
    }

    @Override
    public void setCheckAclConsistency() {
        this.aclCrudDAO.setCheckAclConsistency();
    }

    @Override
    public AccessControlList getAccessControlList(Long id) {
        AccessControlListProperties properties = this.getAccessControlListProperties(id);
        if (properties == null) {
            return null;
        }
        AccessControlList aclCached = (AccessControlList)this.aclCache.get((Serializable)((Object)properties));
        if (aclCached != null) {
            return aclCached;
        }
        SimpleAccessControlList acl = new SimpleAccessControlList();
        acl.setProperties(properties);
        List<Map<String, Object>> results = this.aclCrudDAO.getAcesAndAuthoritiesByAcl(id);
        ArrayList<AccessControlEntry> entries = new ArrayList<AccessControlEntry>(results.size());
        for (Map<String, Object> result : results) {
            Boolean aceIsAllowed = (Boolean)result.get("allowed");
            Integer aceType = (Integer)result.get("applies");
            String authority = (String)result.get("authority");
            Long permissionId = (Long)result.get("permissionId");
            Integer position = (Integer)result.get("pos");
            SimpleAccessControlEntry sacEntry = new SimpleAccessControlEntry();
            sacEntry.setAccessStatus(aceIsAllowed != false ? AccessStatus.ALLOWED : AccessStatus.DENIED);
            sacEntry.setAceType(ACEType.getACETypeFromId(aceType));
            sacEntry.setAuthority(authority);
            Permission perm = this.aclCrudDAO.getPermission(permissionId);
            QName permTypeQName = (QName)this.qnameDAO.getQName(perm.getTypeQNameId()).getSecond();
            SimplePermissionReference permissionRefernce = SimplePermissionReference.getPermissionReference(permTypeQName, perm.getName());
            sacEntry.setPermission(permissionRefernce);
            sacEntry.setPosition(position);
            entries.add(sacEntry);
        }
        Collections.sort(entries);
        acl.setEntries(entries);
        this.aclCache.put((Serializable)((Object)properties), (Object)acl);
        return acl;
    }

    @Override
    public Long getInheritedAccessControlList(Long id) {
        AclUpdateEntity acl = this.aclCrudDAO.getAclForUpdate(id);
        if (acl.getAclType() == ACLType.OLD) {
            return null;
        }
        if (acl.getInheritedAcl() != null && acl.getInheritedAcl() != -1L) {
            return acl.getInheritedAcl();
        }
        Long inheritedAclId = null;
        if (acl.getAclType() == ACLType.DEFINING || acl.getAclType() == ACLType.LAYERED) {
            ArrayList<AclChange> changes = new ArrayList<AclChange>();
            SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
            properties.setAclType(ACLType.SHARED);
            properties.setInherits(Boolean.TRUE);
            properties.setVersioned(acl.isVersioned());
            Long sharedId = this.createAccessControlList(properties, null, null).getId();
            this.getWritable(sharedId, id, null, null, id, true, changes, WriteMode.ADD_INHERITED);
            acl.setInheritedAcl(sharedId);
            inheritedAclId = sharedId;
        } else {
            acl.setInheritedAcl(acl.getId());
            inheritedAclId = acl.getId();
        }
        acl.setAclChangeSetId(this.getCurrentChangeSetId());
        this.aclCrudDAO.updateAcl(acl);
        return inheritedAclId;
    }

    @Override
    public List<AclChange> mergeInheritedAccessControlList(Long inherited, Long target) {
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        Acl targetAcl = this.aclCrudDAO.getAcl(target);
        Acl inheritedAcl = null;
        if (inherited != null) {
            inheritedAcl = this.aclCrudDAO.getAcl(inherited);
        } else if (targetAcl.getInheritsFrom() != null) {
            String searchAclId;
            Long actualInheritor;
            inheritedAcl = this.aclCrudDAO.getAcl(targetAcl.getInheritsFrom());
            if (inheritedAcl == null) {
                throw new IllegalStateException("No old inheritance definition to use");
            }
            if (!inheritedAcl.isLatest().booleanValue() && (inheritedAcl = this.aclCrudDAO.getAcl(actualInheritor = this.aclCrudDAO.getLatestAclByGuid(searchAclId = inheritedAcl.getAclId()))) == null) {
                throw new IllegalStateException("No ACL found");
            }
        } else {
            return changes;
        }
        Acl test = inheritedAcl;
        HashSet<Long> visitedAcls = new HashSet<Long>();
        while (test != null) {
            Long testId = test.getId();
            if (testId != null && testId.equals(target)) {
                throw new IllegalStateException("Cyclical ACL detected");
            }
            if (visitedAcls.contains(testId)) {
                throw new IllegalStateException("Cyclical InheritsFrom detected. AclId: " + String.valueOf(testId));
            }
            visitedAcls.add(testId);
            Long parent = test.getInheritsFrom();
            test = parent == null || parent == -1L ? null : this.aclCrudDAO.getAcl(test.getInheritsFrom());
        }
        if (targetAcl.getAclType() != ACLType.DEFINING && targetAcl.getAclType() != ACLType.LAYERED) {
            throw new IllegalArgumentException("Only defining ACLs can have their inheritance set");
        }
        if (!targetAcl.getInherits().booleanValue()) {
            return changes;
        }
        Long actualInheritedId = inheritedAcl.getId();
        if (inheritedAcl.getAclType() == ACLType.DEFINING || inheritedAcl.getAclType() == ACLType.LAYERED) {
            actualInheritedId = this.getInheritedAccessControlList(actualInheritedId);
        }
        this.getWritable(target, actualInheritedId, null, null, actualInheritedId, true, changes, WriteMode.CHANGE_INHERITED);
        return changes;
    }

    @Override
    public List<AclChange> setAccessControlEntry(Long id, AccessControlEntry ace) {
        Acl target = this.aclCrudDAO.getAcl(id);
        if (target.getAclType() == ACLType.SHARED) {
            throw new IllegalArgumentException("Shared ACLs are immutable");
        }
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        if (ace.getPosition() != null && ace.getPosition() != 0) {
            throw new IllegalArgumentException("Invalid position");
        }
        Authority authority = this.aclCrudDAO.getOrCreateAuthority(ace.getAuthority());
        Permission permission = this.aclCrudDAO.getOrCreatePermission(ace.getPermission());
        if (ace.getContext() != null) {
            throw new UnsupportedOperationException();
        }
        Ace entry = this.aclCrudDAO.getOrCreateAce(permission, authority, ace.getAceType(), ace.getAccessStatus());
        SimpleAccessControlEntry exclude = new SimpleAccessControlEntry();
        exclude.setAceType(ace.getAceType());
        exclude.setAuthority(ace.getAuthority());
        exclude.setPermission(ace.getPermission());
        exclude.setPosition(0);
        ArrayList<Ace> toAdd = new ArrayList<Ace>(1);
        toAdd.add(entry);
        this.getWritable(id, null, Collections.singletonList(exclude), toAdd, null, true, changes, WriteMode.COPY_UPDATE_AND_INHERIT);
        return changes;
    }

    @Override
    public List<AclChange> enableInheritance(Long id, Long parent) {
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        AclUpdateEntity acl = this.aclCrudDAO.getAclForUpdate(id);
        switch (acl.getAclType()) {
            case FIXED: 
            case GLOBAL: {
                throw new IllegalArgumentException("Fixed and global permissions can not inherit");
            }
            case OLD: {
                acl.setInherits(Boolean.TRUE);
                acl.setAclChangeSetId(this.getCurrentChangeSetId());
                this.aclCrudDAO.updateAcl(acl);
                changes.add(new AclChangeImpl(id, id, acl.getAclType(), acl.getAclType()));
                return changes;
            }
            case SHARED: {
                throw new IllegalArgumentException("Shared acls should be replace by creating a definig ACL, wiring it up for inhertitance, and then applying inheritance to any children. It can not be done by magic ");
            }
        }
        if (!acl.getInherits().booleanValue()) {
            this.getWritable(id, null, null, null, null, false, changes, WriteMode.COPY_ONLY);
            acl = this.aclCrudDAO.getAclForUpdate(((AclChange)changes.get(0)).getAfter());
            acl.setInherits(Boolean.TRUE);
            acl.setAclChangeSetId(this.getCurrentChangeSetId());
            this.aclCrudDAO.updateAcl(acl);
        } else {
            this.getWritable(id, null, null, null, null, false, changes, WriteMode.COPY_ONLY);
        }
        List<AclChange> merged = this.mergeInheritedAccessControlList(parent, ((AclChange)changes.get(0)).getAfter());
        changes.addAll(merged);
        return changes;
    }

    @Override
    public List<AclChange> disableInheritance(Long id, boolean setInheritedOnAcl) {
        AclUpdateEntity acl = this.aclCrudDAO.getAclForUpdate(id);
        ArrayList<AclChange> changes = new ArrayList<AclChange>(1);
        switch (acl.getAclType()) {
            case FIXED: 
            case GLOBAL: {
                return Collections.singletonList(new AclChangeImpl(id, id, acl.getAclType(), acl.getAclType()));
            }
            case OLD: {
                acl.setInherits(Boolean.FALSE);
                acl.setAclChangeSetId(this.getCurrentChangeSetId());
                this.aclCrudDAO.updateAcl(acl);
                changes.add(new AclChangeImpl(id, id, acl.getAclType(), acl.getAclType()));
                return changes;
            }
            case SHARED: {
                throw new IllegalArgumentException("Shared ACL must inherit");
            }
        }
        return this.disableInheritanceImpl(id, setInheritedOnAcl, acl);
    }

    private Long getCopy(Long toCopy, Long toInheritFrom, ACLCopyMode mode) {
        switch (mode) {
            case INHERIT: {
                if (toCopy.equals(toInheritFrom)) {
                    return this.getInheritedAccessControlList(toCopy);
                }
                throw new UnsupportedOperationException();
            }
            case COW: {
                AclUpdateEntity aclToCopy = this.aclCrudDAO.getAclForUpdate(toCopy);
                aclToCopy.setRequiresVersion(true);
                aclToCopy.setAclChangeSetId(this.getCurrentChangeSetId());
                this.aclCrudDAO.updateAcl(aclToCopy);
                Long inheritedId = this.getInheritedAccessControlList(toCopy);
                if (inheritedId != null && !inheritedId.equals(toCopy)) {
                    AclUpdateEntity inheritedAcl = this.aclCrudDAO.getAclForUpdate(inheritedId);
                    inheritedAcl.setRequiresVersion(true);
                    inheritedAcl.setAclChangeSetId(this.getCurrentChangeSetId());
                    this.aclCrudDAO.updateAcl(inheritedAcl);
                }
                return toCopy;
            }
            case REDIRECT: {
                if (toInheritFrom != null && toInheritFrom.equals(toCopy)) {
                    return this.getInheritedAccessControlList(toInheritFrom);
                }
                AclUpdateEntity aclToCopy = this.aclCrudDAO.getAclForUpdate(toCopy);
                Acl aclToInheritFrom = null;
                if (toInheritFrom != null) {
                    aclToInheritFrom = this.aclCrudDAO.getAcl(toInheritFrom);
                }
                switch (aclToCopy.getAclType()) {
                    case DEFINING: 
                    case LAYERED: {
                        if (toInheritFrom == null) {
                            return toCopy;
                        }
                        List<AclChange> changes = this.mergeInheritedAccessControlList(toInheritFrom, toCopy);
                        for (AclChange change : changes) {
                            if (!change.getBefore().equals(toCopy)) continue;
                            return change.getAfter();
                        }
                        throw new UnsupportedOperationException();
                    }
                    case SHARED: {
                        if (aclToInheritFrom != null) {
                            return this.getInheritedAccessControlList(toInheritFrom);
                        }
                        throw new UnsupportedOperationException();
                    }
                    case OLD: 
                    case FIXED: 
                    case GLOBAL: {
                        return toCopy;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case COPY: {
                AclUpdateEntity aclToCopy = this.aclCrudDAO.getAclForUpdate(toCopy);
                Acl aclToInheritFrom = null;
                if (toInheritFrom != null) {
                    aclToInheritFrom = this.aclCrudDAO.getAcl(toInheritFrom);
                }
                switch (aclToCopy.getAclType()) {
                    case DEFINING: {
                        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
                        properties.setAclType(ACLType.DEFINING);
                        properties.setInherits(aclToCopy.getInherits());
                        properties.setVersioned(true);
                        Long id = this.createAccessControlList(properties).getId();
                        AccessControlList indirectAcl = this.getAccessControlList(toCopy);
                        for (AccessControlEntry entry : indirectAcl.getEntries()) {
                            if (entry.getPosition() != 0) continue;
                            this.setAccessControlEntry(id, entry);
                        }
                        if (aclToInheritFrom != null) {
                            this.mergeInheritedAccessControlList(toInheritFrom, id);
                        }
                        return id;
                    }
                    case SHARED: {
                        if (aclToInheritFrom != null) {
                            return this.getInheritedAccessControlList(toInheritFrom);
                        }
                        return null;
                    }
                    case OLD: 
                    case FIXED: 
                    case GLOBAL: 
                    case LAYERED: {
                        return toCopy;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Acl getAclCopy(Long toCopy, Long toInheritFrom, ACLCopyMode mode) {
        return this.getAclEntityCopy(toCopy, toInheritFrom, mode);
    }

    private Acl getAclEntityCopy(Long toCopy, Long toInheritFrom, ACLCopyMode mode) {
        Long id = this.getCopy(toCopy, toInheritFrom, mode);
        if (id == null) {
            return null;
        }
        return this.aclCrudDAO.getAcl(id);
    }

    @Override
    public List<Long> getADMNodesByAcl(long aclEntityId, int maxResults) {
        return this.aclCrudDAO.getADMNodesByAcl(aclEntityId, maxResults);
    }

    @Override
    public Acl createLayeredAcl(Long indirectedAcl) {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.LAYERED);
        Acl acl = this.createAccessControlList(properties);
        long id = acl.getId();
        if (indirectedAcl != null) {
            this.mergeInheritedAccessControlList(indirectedAcl, id);
        }
        return acl;
    }

    private List<AclChange> disableInheritanceImpl(Long id, boolean setInheritedOnAcl, AclEntity aclIn) {
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        if (!aclIn.getInherits().booleanValue()) {
            return Collections.emptyList();
        }
        this.getWritable(id, null, null, null, null, false, changes, WriteMode.COPY_ONLY);
        AclUpdateEntity acl = this.aclCrudDAO.getAclForUpdate(((AclChange)changes.get(0)).getAfter());
        Long inheritsFrom = acl.getInheritsFrom();
        acl.setInherits(Boolean.FALSE);
        acl.setAclChangeSetId(this.getCurrentChangeSetId());
        this.aclCrudDAO.updateAcl(acl);
        this.getWritable(acl.getId(), null, null, null, null, true, changes, WriteMode.TRUNCATE_INHERITED);
        if (inheritsFrom != null && inheritsFrom != -1L && setInheritedOnAcl) {
            List<AclMember> members = this.aclCrudDAO.getAclMembersByAcl(inheritsFrom);
            for (AclMember member : members) {
                Ace ace = this.aclCrudDAO.getAce(member.getAceId());
                Authority authority = this.aclCrudDAO.getAuthority(ace.getAuthorityId());
                SimpleAccessControlEntry entry = new SimpleAccessControlEntry();
                entry.setAccessStatus(ace.isAllowed() ? AccessStatus.ALLOWED : AccessStatus.DENIED);
                entry.setAceType(ace.getAceType());
                entry.setAuthority(authority.getAuthority());
                Permission perm = this.aclCrudDAO.getPermission(ace.getPermissionId());
                QName permTypeQName = (QName)this.qnameDAO.getQName(perm.getTypeQNameId()).getSecond();
                SimplePermissionReference permissionRefernce = SimplePermissionReference.getPermissionReference(permTypeQName, perm.getName());
                entry.setPermission(permissionRefernce);
                entry.setPosition(0);
                this.setAccessControlEntry(id, entry);
            }
        }
        return changes;
    }

    @Override
    public Long getCurrentChangeSetCommitTime() {
        return (Long)AlfrescoTransactionSupport.getResource((Object)RESOURCE_KEY_ACL_CHANGE_SET_COMMIT_TIME_MS);
    }

    private long getCurrentChangeSetId() {
        Long changeSetId = (Long)AlfrescoTransactionSupport.getResource((Object)RESOURCE_KEY_ACL_CHANGE_SET_ID);
        if (changeSetId == null) {
            changeSetId = this.aclCrudDAO.createAclChangeSet();
            AlfrescoTransactionSupport.bindResource((Object)RESOURCE_KEY_ACL_CHANGE_SET_ID, (Object)changeSetId);
            AlfrescoTransactionSupport.bindListener(this.updateChangeSetListener);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New change set = " + String.valueOf(changeSetId)));
            }
        }
        return changeSetId;
    }

    @Override
    public void renameAuthority(String before, String after) {
        this.aclCrudDAO.renameAuthority(before, after);
        this.aclCache.clear();
    }

    @Override
    public void fixSharedAcl(Long shared, Long defining) {
        if (defining == null) {
            throw new IllegalArgumentException("Null defining acl");
        }
        if (shared == null) {
            throw new IllegalArgumentException("Null shared acl");
        }
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        this.getWritable(shared, defining, null, null, defining, true, changes, WriteMode.CHANGE_INHERITED);
    }

    @Override
    public Long getMaxChangeSetCommitTime() {
        return this.aclCrudDAO.getMaxChangeSetCommitTime();
    }

    @Override
    public Long getMaxChangeSetIdByCommitTime(long maxCommitTime) {
        return this.aclCrudDAO.getMaxChangeSetIdByCommitTime(maxCommitTime);
    }

    private static class AcePatternMatcher {
        private List<? extends AccessControlEntry> patterns;

        AcePatternMatcher(List<? extends AccessControlEntry> patterns) {
            this.patterns = patterns;
        }

        boolean matches(AclCrudDAO aclCrudDAO, Map<String, Object> result, int position) {
            if (this.patterns == null) {
                return true;
            }
            for (AccessControlEntry accessControlEntry : this.patterns) {
                if (!this.checkPattern(aclCrudDAO, result, position, accessControlEntry)) continue;
                return true;
            }
            return false;
        }

        private boolean checkPattern(AclCrudDAO aclCrudDAO, Map<String, Object> result, int position, AccessControlEntry pattern) {
            Long permId;
            Boolean result_aceIsAllowed = (Boolean)result.get("allowed");
            Integer result_aceType = (Integer)result.get("applies");
            String result_authority = (String)result.get("authority");
            Long result_permissionId = (Long)result.get("permissionId");
            Integer result_position = (Integer)result.get("pos");
            if (pattern.getAccessStatus() != null && pattern.getAccessStatus() != (result_aceIsAllowed != false ? AccessStatus.ALLOWED : AccessStatus.DENIED)) {
                return false;
            }
            if (pattern.getAceType() != null && pattern.getAceType() != ACEType.getACETypeFromId(result_aceType)) {
                return false;
            }
            if (pattern.getAuthority() != null && pattern.getAuthorityType() != AuthorityType.WILDCARD && !pattern.getAuthority().equals(result_authority)) {
                return false;
            }
            if (pattern.getContext() != null) {
                throw new IllegalArgumentException("Context not yet supported");
            }
            if (pattern.getPermission() != null && !(permId = aclCrudDAO.getPermission(pattern.getPermission()).getId()).equals(result_permissionId)) {
                return false;
            }
            return pattern.getPosition() == null || !(pattern.getPosition() >= 0 ? result_position != position : pattern.getPosition() == -1 && result_position <= position);
        }
    }

    static class AclChangeImpl
    implements AclChange {
        private Long before;
        private Long after;
        private ACLType typeBefore;
        private ACLType typeAfter;

        public AclChangeImpl(Long before, Long after, ACLType typeBefore, ACLType typeAfter) {
            this.before = before;
            this.after = after;
            this.typeAfter = typeAfter;
            this.typeBefore = typeBefore;
        }

        @Override
        public Long getAfter() {
            return this.after;
        }

        @Override
        public Long getBefore() {
            return this.before;
        }

        public void setAfter(Long after) {
            this.after = after;
        }

        public void setBefore(Long before) {
            this.before = before;
        }

        @Override
        public ACLType getTypeAfter() {
            return this.typeAfter;
        }

        public void setTypeAfter(ACLType typeAfter) {
            this.typeAfter = typeAfter;
        }

        @Override
        public ACLType getTypeBefore() {
            return this.typeBefore;
        }

        public void setTypeBefore(ACLType typeBefore) {
            this.typeBefore = typeBefore;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(").append(this.getBefore()).append(",").append((Object)this.getTypeBefore()).append(")");
            builder.append(" - > ");
            builder.append("(").append(this.getAfter()).append(",").append((Object)this.getTypeAfter()).append(")");
            return builder.toString();
        }
    }

    private class UpdateChangeSetListener
    extends TransactionListenerAdapter {
        private UpdateChangeSetListener() {
        }

        @Override
        public void beforeCommit(boolean readOnly) {
            if (readOnly) {
                return;
            }
            Long changeSetId = (Long)AlfrescoTransactionSupport.getResource((Object)AclDAOImpl.RESOURCE_KEY_ACL_CHANGE_SET_ID);
            if (changeSetId == null) {
                return;
            }
            long commitTimeMs = System.currentTimeMillis();
            AlfrescoTransactionSupport.bindResource((Object)AclDAOImpl.RESOURCE_KEY_ACL_CHANGE_SET_COMMIT_TIME_MS, (Object)commitTimeMs);
            AclDAOImpl.this.aclCrudDAO.updateAclChangeSet(changeSetId, commitTimeMs);
        }
    }

    private static enum WriteMode {
        TRUNCATE_INHERITED,
        ADD_INHERITED,
        CHANGE_INHERITED,
        REMOVE_INHERITED,
        INSERT_INHERITED,
        COPY_UPDATE_AND_INHERIT,
        COPY_ONLY,
        CREATE_AND_INHERIT;

    }
}

