/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.TaskComponent;
import org.alfresco.repo.workflow.WorkflowComponent;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowNotificationUtils;
import org.alfresco.repo.workflow.WorkflowPackageComponent;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.workflow.WorkflowAdminService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowInstanceQuery;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkflowServiceImpl
implements WorkflowService {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.workflow");
    private TransactionService transactionService;
    private AuthorityService authorityService;
    private BPMEngineRegistry registry;
    private WorkflowPackageComponent workflowPackageComponent;
    private NodeService nodeService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private NodeService protectedNodeService;
    private WorkflowNotificationUtils workflowNotificationUtils;
    private WorkflowAdminService workflowAdminService;
    private int maxAuthoritiesForPooledTasks = 100;
    private int maxPooledTasks = -1;
    private boolean deployWorkflowsInTenant = false;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setBPMEngineRegistry(BPMEngineRegistry registry) {
        this.registry = registry;
    }

    public void setWorkflowAdminService(WorkflowAdminService workflowAdminService) {
        this.workflowAdminService = workflowAdminService;
    }

    public void setWorkflowPackageComponent(WorkflowPackageComponent workflowPackageComponent) {
        this.workflowPackageComponent = workflowPackageComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setProtectedNodeService(NodeService protectedNodeService) {
        this.protectedNodeService = protectedNodeService;
    }

    public void setWorkflowNotification(WorkflowNotificationUtils service) {
        this.workflowNotificationUtils = service;
    }

    public void setMaxAuthoritiesForPooledTasks(int maxAuthoritiesForPooledTasks) {
        this.maxAuthoritiesForPooledTasks = maxAuthoritiesForPooledTasks;
    }

    public void setMaxPooledTasks(int maxPooledTasks) {
        this.maxPooledTasks = maxPooledTasks;
    }

    @Override
    public WorkflowDeployment deployDefinition(String engineId, InputStream workflowDefinition, String mimetype) {
        return this.deployDefinition(engineId, workflowDefinition, mimetype, null);
    }

    @Override
    public WorkflowDeployment deployDefinition(String engineId, InputStream workflowDefinition, String mimetype, String name) {
        return this.deployDefinition(engineId, workflowDefinition, mimetype, name, false);
    }

    @Override
    public WorkflowDeployment deployDefinition(String engineId, InputStream workflowDefinition, String mimetype, String name, boolean fullAccess) {
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        WorkflowDeployment deployment = component.deployDefinition(workflowDefinition, mimetype, name, fullAccess);
        if (logger.isDebugEnabled() && deployment.getProblems().length > 0) {
            String[] stringArray = deployment.getProblems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String problem = stringArray[n2];
                logger.debug((Object)("Workflow definition '" + deployment.getDefinition().getTitle() + "' problem: " + problem));
                ++n2;
            }
        }
        return deployment;
    }

    @Override
    public boolean isDefinitionDeployed(NodeRef workflowDefinition) {
        if (!this.nodeService.getType(workflowDefinition).equals((Object)WorkflowModel.TYPE_WORKFLOW_DEF)) {
            throw new WorkflowException("Node " + String.valueOf(workflowDefinition) + " is not of type 'bpm:workflowDefinition'");
        }
        String engineId = (String)((Object)this.nodeService.getProperty(workflowDefinition, WorkflowModel.PROP_WORKFLOW_DEF_ENGINE_ID));
        ContentReader contentReader = this.contentService.getReader(workflowDefinition, ContentModel.PROP_CONTENT);
        return this.isDefinitionDeployed(engineId, contentReader.getContentInputStream(), contentReader.getMimetype());
    }

    @Override
    public boolean isDefinitionDeployed(String engineId, InputStream workflowDefinition, String mimetype) {
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.isDefinitionDeployed(workflowDefinition, mimetype);
    }

    @Override
    public void checkDeploymentCategory(String engineId, InputStream workflowDefinition) {
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        component.checkDeploymentCategory(workflowDefinition);
    }

    @Override
    public WorkflowDeployment deployDefinition(NodeRef definitionContent) {
        if (!this.nodeService.getType(definitionContent).equals((Object)WorkflowModel.TYPE_WORKFLOW_DEF)) {
            throw new WorkflowException("Node " + String.valueOf(definitionContent) + " is not of type 'bpm:workflowDefinition'");
        }
        String engineId = (String)((Object)this.nodeService.getProperty(definitionContent, WorkflowModel.PROP_WORKFLOW_DEF_ENGINE_ID));
        ContentReader contentReader = this.contentService.getReader(definitionContent, ContentModel.PROP_CONTENT);
        return this.deployDefinition(engineId, contentReader.getContentInputStream(), contentReader.getMimetype());
    }

    @Override
    public void undeployDefinition(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        component.undeployDefinition(workflowDefinitionId);
    }

    @Override
    public List<WorkflowDefinition> getDefinitions() {
        String[] ids;
        ArrayList<WorkflowDefinition> definitions = new ArrayList<WorkflowDefinition>(10);
        String[] stringArray = ids = this.registry.getWorkflowComponents();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (this.workflowAdminService.isEngineVisible(id)) {
                WorkflowComponent component = this.registry.getWorkflowComponent(id);
                definitions.addAll(component.getDefinitions());
            }
            ++n2;
        }
        return Collections.unmodifiableList(definitions);
    }

    @Override
    public List<WorkflowDefinition> getAllDefinitions() {
        String[] ids;
        ArrayList<WorkflowDefinition> definitions = new ArrayList<WorkflowDefinition>(10);
        String[] stringArray = ids = this.registry.getWorkflowComponents();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (this.workflowAdminService.isEngineVisible(id)) {
                WorkflowComponent component = this.registry.getWorkflowComponent(id);
                definitions.addAll(component.getAllDefinitions());
            }
            ++n2;
        }
        return Collections.unmodifiableList(definitions);
    }

    @Override
    public WorkflowDefinition getDefinitionById(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getDefinitionById(workflowDefinitionId);
    }

    @Override
    public WorkflowDefinition getDefinitionByName(String workflowName) {
        String engineId = BPMEngineRegistry.getEngineId(workflowName);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getDefinitionByName(workflowName);
    }

    @Override
    public List<WorkflowDefinition> getAllDefinitionsByName(String workflowName) {
        String engineId = BPMEngineRegistry.getEngineId(workflowName);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getAllDefinitionsByName(workflowName);
    }

    @Override
    public byte[] getDefinitionImage(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        byte[] definitionImage = component.getDefinitionImage(workflowDefinitionId);
        if (definitionImage == null) {
            definitionImage = new byte[]{};
        }
        return definitionImage;
    }

    @Override
    public List<WorkflowTaskDefinition> getTaskDefinitions(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getTaskDefinitions(workflowDefinitionId);
    }

    @Override
    public WorkflowPath startWorkflow(String workflowDefinitionId, Map<QName, Serializable> parameters) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        WorkflowPath path = component.startWorkflow(workflowDefinitionId, parameters);
        if (path != null && parameters != null && parameters.containsKey(WorkflowModel.ASSOC_PACKAGE)) {
            WorkflowInstance instance = path.getInstance();
            this.workflowPackageComponent.setWorkflowForPackage(instance);
        }
        return path;
    }

    @Override
    public WorkflowPath startWorkflowFromTemplate(NodeRef templateDefinition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<WorkflowInstance> getActiveWorkflows(String workflowDefinitionId) {
        return this.getWorkflows(new WorkflowInstanceQuery(workflowDefinitionId, true));
    }

    @Override
    public List<WorkflowInstance> getCompletedWorkflows(String workflowDefinitionId) {
        return this.getWorkflows(new WorkflowInstanceQuery(workflowDefinitionId, false));
    }

    @Override
    public List<WorkflowInstance> getWorkflows(String workflowDefinitionId) {
        return this.getWorkflows(new WorkflowInstanceQuery(workflowDefinitionId));
    }

    @Override
    public List<WorkflowInstance> getWorkflows(WorkflowInstanceQuery workflowInstanceQuery) {
        return this.getWorkflows(workflowInstanceQuery, 0, 0);
    }

    @Override
    public List<WorkflowInstance> getWorkflows(final WorkflowInstanceQuery workflowInstanceQuery, final int maxItems, final int skipCount) {
        if (workflowInstanceQuery.getWorkflowDefinitionId() == null && workflowInstanceQuery.getEngineId() == null) {
            List<String> ids = Arrays.asList(this.registry.getWorkflowComponents());
            return CollectionUtils.transformFlat(ids, (Function)new Function<String, Collection<WorkflowInstance>>(){

                public List<WorkflowInstance> apply(String id) {
                    WorkflowComponent component = WorkflowServiceImpl.this.registry.getWorkflowComponent(id);
                    return component.getWorkflows(workflowInstanceQuery, maxItems, skipCount);
                }
            });
        }
        String engineId = workflowInstanceQuery.getEngineId();
        if (engineId == null) {
            engineId = BPMEngineRegistry.getEngineId(workflowInstanceQuery.getWorkflowDefinitionId());
        }
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getWorkflows(workflowInstanceQuery, maxItems, skipCount);
    }

    @Override
    public long countWorkflows(WorkflowInstanceQuery workflowInstanceQuery) {
        if (workflowInstanceQuery.getWorkflowDefinitionId() == null && workflowInstanceQuery.getEngineId() == null) {
            List<String> ids = Arrays.asList(this.registry.getWorkflowComponents());
            long total = 0L;
            for (String id : ids) {
                WorkflowComponent component = this.registry.getWorkflowComponent(id);
                total += component.countWorkflows(workflowInstanceQuery);
            }
            return total;
        }
        String engineId = workflowInstanceQuery.getEngineId();
        if (engineId == null) {
            engineId = BPMEngineRegistry.getEngineId(workflowInstanceQuery.getWorkflowDefinitionId());
        }
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.countWorkflows(workflowInstanceQuery);
    }

    @Override
    public long countTasks(WorkflowTaskQuery workflowTaskQuery) {
        long total = 0L;
        if (workflowTaskQuery.getEngineId() != null) {
            TaskComponent component = this.registry.getTaskComponent(workflowTaskQuery.getEngineId());
            total = component.countTasks(workflowTaskQuery);
        } else {
            List<String> ids = Arrays.asList(this.registry.getTaskComponents());
            for (String id : ids) {
                TaskComponent component = this.registry.getTaskComponent(id);
                total += component.countTasks(workflowTaskQuery);
            }
        }
        return total;
    }

    @Override
    public List<WorkflowInstance> getActiveWorkflows() {
        return this.getWorkflows(new WorkflowInstanceQuery(true));
    }

    @Override
    public List<WorkflowInstance> getCompletedWorkflows() {
        return this.getWorkflows(new WorkflowInstanceQuery(false));
    }

    @Override
    public List<WorkflowInstance> getWorkflows() {
        return this.getWorkflows(new WorkflowInstanceQuery());
    }

    @Override
    public WorkflowInstance getWorkflowById(String workflowId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getWorkflowById(workflowId);
    }

    @Override
    public List<WorkflowPath> getWorkflowPaths(String workflowId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getWorkflowPaths(workflowId);
    }

    @Override
    public Map<QName, Serializable> getPathProperties(String pathId) {
        String engineId = BPMEngineRegistry.getEngineId(pathId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getPathProperties(pathId);
    }

    @Override
    public WorkflowInstance cancelWorkflow(String workflowId) {
        return this.cancelWorkflows(Collections.singletonList(workflowId)).get(0);
    }

    @Override
    public List<WorkflowInstance> cancelWorkflows(List<String> workflowIds) {
        if (workflowIds == null) {
            workflowIds = Collections.emptyList();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Cancelling " + workflowIds.size() + " workflowIds..."));
        }
        ArrayList<WorkflowInstance> result = new ArrayList<WorkflowInstance>(workflowIds.size());
        Map<String, List<String>> workflows = this.batchByEngineId(workflowIds);
        for (Map.Entry<String, List<String>> entry : workflows.entrySet()) {
            String engineId = entry.getKey();
            WorkflowComponent component = this.getWorkflowComponent(engineId);
            List<WorkflowInstance> instances = component.cancelWorkflows(entry.getValue());
            for (WorkflowInstance instance : instances) {
                this.workflowPackageComponent.deletePackage(instance.getWorkflowPackage());
                result.add(instance);
            }
        }
        return result;
    }

    public void setMultiTenantWorkflowDeploymentEnabled(boolean deployWorkflowsInTenant) {
        this.deployWorkflowsInTenant = deployWorkflowsInTenant;
    }

    @Override
    public boolean isMultiTenantWorkflowDeploymentEnabled() {
        return this.deployWorkflowsInTenant;
    }

    private Map<String, List<String>> batchByEngineId(List<String> workflowIds) {
        LinkedHashMap<String, List<String>> workflows = new LinkedHashMap<String, List<String>>(workflowIds.size() * 2);
        for (String workflowId : workflowIds) {
            String engineId = BPMEngineRegistry.getEngineId(workflowId);
            LinkedList<String> engineWorkflows = (LinkedList<String>)workflows.get(engineId);
            if (engineWorkflows == null) {
                engineWorkflows = new LinkedList<String>();
                workflows.put(engineId, engineWorkflows);
            }
            engineWorkflows.add(workflowId);
        }
        return workflows;
    }

    @Override
    public WorkflowInstance deleteWorkflow(String workflowId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        WorkflowInstance instance = component.deleteWorkflow(workflowId);
        this.workflowPackageComponent.deletePackage(instance.getWorkflowPackage());
        return instance;
    }

    @Override
    public WorkflowPath signal(String pathId, String transition) {
        String engineId = BPMEngineRegistry.getEngineId(pathId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.signal(pathId, transition);
    }

    @Override
    public WorkflowPath fireEvent(String pathId, String event) {
        String engineId = BPMEngineRegistry.getEngineId(pathId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.fireEvent(pathId, event);
    }

    @Override
    public List<WorkflowTimer> getTimers(String workflowId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getTimers(workflowId);
    }

    @Override
    public List<WorkflowTask> getTasksForWorkflowPath(String pathId) {
        String engineId = BPMEngineRegistry.getEngineId(pathId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getTasksForWorkflowPath(pathId);
    }

    @Override
    public WorkflowTask getStartTask(String workflowInstanceId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowInstanceId);
        TaskComponent component = this.getTaskComponent(engineId);
        return component.getStartTask(workflowInstanceId);
    }

    @Override
    public List<WorkflowTask> getStartTasks(List<String> workflowInstanceIds, boolean sameSession) {
        ArrayList<WorkflowTask> result = new ArrayList<WorkflowTask>(workflowInstanceIds.size());
        Map<String, List<String>> workflows = this.batchByEngineId(workflowInstanceIds);
        for (Map.Entry<String, List<String>> entry : workflows.entrySet()) {
            String engineId = entry.getKey();
            TaskComponent component = this.getTaskComponent(engineId);
            List<WorkflowTask> startTasks = component.getStartTasks(entry.getValue(), sameSession);
            if (workflows.size() == 1) {
                return startTasks;
            }
            result.addAll(startTasks);
        }
        return result;
    }

    @Override
    public boolean hasWorkflowImage(String workflowInstanceId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowInstanceId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.hasWorkflowImage(workflowInstanceId);
    }

    @Override
    public InputStream getWorkflowImage(String workflowInstanceId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowInstanceId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getWorkflowImage(workflowInstanceId);
    }

    @Override
    public List<WorkflowTask> getAssignedTasks(String authority, WorkflowTaskState state) {
        return this.getAssignedTasks(authority, state, false);
    }

    @Override
    public List<WorkflowTask> getAssignedTasks(String authority, WorkflowTaskState state, boolean lazyInitialization) {
        String[] ids;
        ArrayList<WorkflowTask> tasks = new ArrayList<WorkflowTask>(10);
        String[] stringArray = ids = this.registry.getTaskComponents();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TaskComponent component = this.registry.getTaskComponent(id);
            tasks.addAll(component.getAssignedTasks(authority, state, lazyInitialization));
            ++n2;
        }
        return Collections.unmodifiableList(tasks);
    }

    @Override
    public List<WorkflowTask> getPooledTasks(String authority) {
        return this.getPooledTasks(authority, false);
    }

    @Override
    public List<WorkflowTask> getPooledTasks(String authority, boolean lazyinitialization) {
        String[] ids;
        List authorities = new ArrayList<String>();
        authorities.add(authority);
        Set<String> parents = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, authority, false);
        authorities.addAll(parents);
        if (this.maxAuthoritiesForPooledTasks > 0 && authorities.size() > this.maxAuthoritiesForPooledTasks) {
            authorities = authorities.subList(0, this.maxAuthoritiesForPooledTasks);
        }
        ArrayList<WorkflowTask> tasks = new ArrayList<WorkflowTask>(10);
        int taskCount = 0;
        String[] stringArray = ids = this.registry.getTaskComponents();
        int n = ids.length;
        int n2 = 0;
        block0: while (n2 < n) {
            String id = stringArray[n2];
            TaskComponent component = this.registry.getTaskComponent(id);
            int i = 0;
            while (i < authorities.size()) {
                List<WorkflowTask> pooledTasks = component.getPooledTasks(authorities.subList(i, Math.min(i + 1000, authorities.size())), lazyinitialization);
                if (this.maxPooledTasks > 0) {
                    for (WorkflowTask pooledTask : pooledTasks) {
                        tasks.add(pooledTask);
                        if (++taskCount >= this.maxPooledTasks) break block0;
                    }
                } else {
                    tasks.addAll(pooledTasks);
                }
                i += 1000;
            }
            ++n2;
        }
        return Collections.unmodifiableList(tasks);
    }

    @Override
    public List<WorkflowTask> queryTasks(WorkflowTaskQuery query) {
        return this.queryTasks(query, false);
    }

    @Override
    public List<WorkflowTask> queryTasks(WorkflowTaskQuery query, boolean sameSession) {
        List<Object> tasks;
        String taskId;
        String engineId = query.getEngineId();
        String processId = query.getProcessId();
        if (processId != null) {
            String workflowEngineId = BPMEngineRegistry.getEngineId(processId);
            if (engineId != null && !engineId.equals(workflowEngineId)) {
                throw new WorkflowException("Cannot query for tasks across multiple task components: " + engineId + ", " + workflowEngineId);
            }
            engineId = workflowEngineId;
        }
        if ((taskId = query.getTaskId()) != null) {
            String taskEngineId = BPMEngineRegistry.getEngineId(taskId);
            if (engineId != null && !engineId.equals(taskEngineId)) {
                throw new WorkflowException("Cannot query for tasks across multiple task components: " + engineId + ", " + taskEngineId);
            }
            engineId = taskEngineId;
        }
        String[] ids = this.registry.getTaskComponents();
        ArrayList<TaskComponent> taskComponents = new ArrayList<TaskComponent>(ids.length);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TaskComponent component = this.registry.getTaskComponent(id);
            if (engineId == null || engineId.equals(id)) {
                taskComponents.add(component);
            }
            ++n2;
        }
        if (taskComponents.size() == 1) {
            tasks = ((TaskComponent)taskComponents.get(0)).queryTasks(query, sameSession);
        } else {
            tasks = new ArrayList(10);
            for (TaskComponent component : taskComponents) {
                tasks.addAll(component.queryTasks(query, sameSession));
            }
        }
        return Collections.unmodifiableList(tasks);
    }

    @Override
    public WorkflowTask updateTask(String taskId, Map<QName, Serializable> properties, Map<QName, List<NodeRef>> add, Map<QName, List<NodeRef>> remove) {
        Boolean sendEMailNotification;
        String instanceId;
        WorkflowTask startTask;
        String assignee;
        if (properties.containsKey(WorkflowModel.PROP_STATUS)) {
            LinkedList<String> validTaskStatus = new LinkedList<String>();
            validTaskStatus.add("Not Yet Started");
            validTaskStatus.add("In Progress");
            validTaskStatus.add("On Hold");
            validTaskStatus.add("Cancelled");
            validTaskStatus.add("Completed");
            if (!validTaskStatus.contains(properties.get(WorkflowModel.PROP_STATUS))) {
                throw new WorkflowException("Invalid Value is Passed for Task Status.");
            }
        }
        String engineId = BPMEngineRegistry.getEngineId(taskId);
        TaskComponent component = this.getTaskComponent(engineId);
        String originalAsignee = (String)((Object)component.getTaskById(taskId).getProperties().get(ContentModel.PROP_OWNER));
        WorkflowTask task = component.updateTask(taskId, properties, add, remove);
        if (add != null && add.containsKey(WorkflowModel.ASSOC_PACKAGE)) {
            WorkflowInstance instance = task.getPath().getInstance();
            this.workflowPackageComponent.setWorkflowForPackage(instance);
        }
        if ((assignee = (String)((Object)properties.get(ContentModel.PROP_OWNER))) != null && assignee.length() != 0 && !assignee.equals(originalAsignee) && (startTask = component.getStartTask(instanceId = task.getPath().getInstance().getId())) != null && Boolean.TRUE.equals(sendEMailNotification = (Boolean)startTask.getProperties().get(WorkflowModel.PROP_SEND_EMAIL_NOTIFICATIONS))) {
            String workflowDefId = task.getPath().getInstance().getDefinition().getName();
            if (workflowDefId.indexOf(36) != -1 && workflowDefId.indexOf(36) < workflowDefId.length() - 1) {
                workflowDefId = workflowDefId.substring(workflowDefId.indexOf(36) + 1);
            }
            this.workflowNotificationUtils.sendWorkflowAssignedNotificationEMail(taskId, null, assignee, false);
        }
        return task;
    }

    @Override
    public WorkflowTask endTask(String taskId, String transition) {
        String engineId = BPMEngineRegistry.getEngineId(taskId);
        TaskComponent component = this.getTaskComponent(engineId);
        return component.endTask(taskId, transition);
    }

    @Override
    public boolean isTaskEditable(WorkflowTask task, String username) {
        return this.isTaskEditable(task, username, true);
    }

    @Override
    public boolean isTaskEditable(WorkflowTask task, String username, boolean refreshTask) {
        if (!this.transactionService.getAllowWrite()) {
            return false;
        }
        if (refreshTask) {
            task = this.getTaskById(task.getId());
        }
        if (task == null) {
            return false;
        }
        if (task.getState() == WorkflowTaskState.COMPLETED) {
            return false;
        }
        if (this.isUserOwnerOrInitiator(task, username)) {
            return true;
        }
        if (task.getProperties().get(ContentModel.PROP_OWNER) == null) {
            return this.isUserInPooledActors(task, username);
        }
        return false;
    }

    @Override
    public boolean isTaskReassignable(WorkflowTask task, String username) {
        return this.isTaskReassignable(task, username, true);
    }

    @Override
    public boolean isTaskReassignable(WorkflowTask task, String username, boolean refreshTask) {
        if (!this.transactionService.getAllowWrite()) {
            return false;
        }
        if (refreshTask) {
            task = this.getTaskById(task.getId());
        }
        if (task == null) {
            return false;
        }
        if (task.getState() == WorkflowTaskState.COMPLETED) {
            return false;
        }
        if (task.getProperties().get(ContentModel.PROP_OWNER) == null) {
            return false;
        }
        Map<QName, Serializable> properties = task.getProperties();
        Boolean reassignable = (Boolean)properties.get(WorkflowModel.PROP_REASSIGNABLE);
        if (reassignable != null && !reassignable.booleanValue()) {
            return false;
        }
        Collection actors = (Collection)((Object)properties.get(WorkflowModel.ASSOC_POOLED_ACTORS));
        String owner = (String)((Object)properties.get(ContentModel.PROP_OWNER));
        if (actors != null && !actors.isEmpty() && owner != null) {
            return false;
        }
        return this.isUserOwnerOrInitiator(task, username);
    }

    @Override
    public boolean isTaskClaimable(WorkflowTask task, String username) {
        return this.isTaskClaimable(task, username, true);
    }

    @Override
    public boolean isTaskClaimable(WorkflowTask task, String username, boolean refreshTask) {
        if (!this.transactionService.getAllowWrite()) {
            return false;
        }
        if (refreshTask) {
            task = this.getTaskById(task.getId());
        }
        if (task == null) {
            return false;
        }
        if (task.getState() == WorkflowTaskState.COMPLETED) {
            return false;
        }
        if (task.getProperties().get(ContentModel.PROP_OWNER) != null) {
            return false;
        }
        return this.isUserInPooledActors(task, username);
    }

    @Override
    public boolean isTaskReleasable(WorkflowTask task, String username) {
        return this.isTaskReleasable(task, username, true);
    }

    @Override
    public boolean isTaskReleasable(WorkflowTask task, String username, boolean refreshTask) {
        if (!this.transactionService.getAllowWrite()) {
            return false;
        }
        if (refreshTask) {
            task = this.getTaskById(task.getId());
        }
        if (task == null) {
            return false;
        }
        if (task.getState() == WorkflowTaskState.COMPLETED) {
            return false;
        }
        Map<QName, Serializable> properties = task.getProperties();
        Collection actors = (Collection)((Object)properties.get(WorkflowModel.ASSOC_POOLED_ACTORS));
        if (actors == null || actors.isEmpty()) {
            return false;
        }
        String owner = (String)((Object)properties.get(ContentModel.PROP_OWNER));
        if (owner == null) {
            return false;
        }
        return this.isUserOwnerOrInitiator(task, username);
    }

    @Override
    public WorkflowTask getTaskById(String taskId) {
        String engineId = BPMEngineRegistry.getEngineId(taskId);
        TaskComponent component = this.getTaskComponent(engineId);
        return component.getTaskById(taskId);
    }

    @Override
    public NodeRef createPackage(NodeRef container) {
        return this.workflowPackageComponent.createPackage(container);
    }

    @Override
    public List<WorkflowInstance> getWorkflowsForContent(NodeRef packageItem, boolean active) {
        List<String> workflowIds = this.workflowPackageComponent.getWorkflowIdsForContent(packageItem);
        ArrayList<WorkflowInstance> workflowInstances = new ArrayList<WorkflowInstance>(workflowIds.size());
        for (String workflowId : workflowIds) {
            try {
                String engineId = BPMEngineRegistry.getEngineId(workflowId);
                WorkflowComponent component = this.getWorkflowComponent(engineId);
                WorkflowInstance instance = component.getWorkflowById(workflowId);
                if (instance == null || instance.isActive() != active) continue;
                workflowInstances.add(instance);
            }
            catch (WorkflowException componentForEngineNotRegistered) {
                String message = componentForEngineNotRegistered.getMessage();
                logger.debug((Object)(message + ". Ignored workflow on " + String.valueOf(packageItem)));
            }
        }
        return workflowInstances;
    }

    private WorkflowComponent getWorkflowComponent(String engineId) {
        WorkflowComponent component = this.registry.getWorkflowComponent(engineId);
        if (component == null) {
            throw new WorkflowException("Workflow Component for engine id '" + engineId + "' is not registered");
        }
        return component;
    }

    private TaskComponent getTaskComponent(String engineId) {
        TaskComponent component = this.registry.getTaskComponent(engineId);
        if (component == null) {
            throw new WorkflowException("Task Component for engine id '" + engineId + "' is not registered");
        }
        return component;
    }

    @Override
    public List<NodeRef> getPackageContents(String taskId) {
        NodeRef workflowPackage = this.getWorkflowPackageIfExists(taskId);
        if (workflowPackage == null) {
            return Collections.emptyList();
        }
        return this.getPackageContents(workflowPackage);
    }

    @Override
    public List<NodeRef> getPackageContents(NodeRef packageRef) {
        return this.getRepositoryPackageContents(packageRef);
    }

    private NodeRef getWorkflowPackageIfExists(String taskId) {
        WorkflowTask workflowTask = this.getTaskById(taskId);
        if (workflowTask != null) {
            return (NodeRef)workflowTask.getProperties().get(WorkflowModel.ASSOC_PACKAGE);
        }
        return null;
    }

    private List<NodeRef> getRepositoryPackageContents(NodeRef workflowPackage) {
        ArrayList<NodeRef> contents = new ArrayList<NodeRef>();
        List packageAssocs = this.protectedNodeService.getChildAssocs(workflowPackage);
        for (ChildAssociationRef assoc : packageAssocs) {
            NodeRef nodeRef = assoc.getChildRef();
            QName assocType = assoc.getTypeQName();
            if (!this.protectedNodeService.exists(nodeRef)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ignoring " + String.valueOf(nodeRef) + " as it has been removed from the repository"));
                continue;
            }
            if (!ContentModel.ASSOC_CONTAINS.equals((Object)assocType) && !WorkflowModel.ASSOC_PACKAGE_CONTAINS.equals((Object)assocType)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ignoring " + String.valueOf(nodeRef) + " as it has an invalid association type: " + String.valueOf(assocType)));
                continue;
            }
            if (!this.checkTypeIsInDataDictionary(nodeRef)) continue;
            contents.add(nodeRef);
        }
        return contents;
    }

    private boolean checkTypeIsInDataDictionary(NodeRef nodeRef) {
        QName type = this.protectedNodeService.getType(nodeRef);
        if (this.dictionaryService.getType(type) == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Found invalid object in database: id = " + String.valueOf(nodeRef) + ", type = " + String.valueOf(type)));
            }
            return false;
        }
        return true;
    }

    private boolean isUserInPooledActors(WorkflowTask task, String username) {
        Collection actors = (Collection)((Object)task.getProperties().get(WorkflowModel.ASSOC_POOLED_ACTORS));
        if (actors != null) {
            for (NodeRef actor : actors) {
                Serializable name;
                QName type = this.nodeService.getType(actor);
                if (!(this.dictionaryService.isSubClass(type, ContentModel.TYPE_PERSON) ? (name = this.nodeService.getProperty(actor, ContentModel.PROP_USERNAME)) != null && name.equals(username) : this.dictionaryService.isSubClass(type, ContentModel.TYPE_AUTHORITY_CONTAINER) && this.isUserInGroup(username, actor))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUserInGroup(String username, NodeRef group) {
        String name = (String)((Object)this.nodeService.getProperty(group, ContentModel.PROP_AUTHORITY_NAME));
        Set<String> groupMembers = this.authorityService.getContainedAuthorities(AuthorityType.USER, name, false);
        return groupMembers != null && groupMembers.contains(username);
    }

    private boolean isUserOwnerOrInitiator(WorkflowTask task, String username) {
        boolean result = false;
        String owner = (String)((Object)task.getProperties().get(ContentModel.PROP_OWNER));
        if (username.equals(owner)) {
            result = true;
        } else if (username.equals(this.getWorkflowInitiatorUsername(task))) {
            result = true;
        }
        return result;
    }

    private String getWorkflowInitiatorUsername(WorkflowTask task) {
        String initiator = null;
        NodeRef initiatorRef = task.getPath().getInstance().getInitiator();
        if (initiatorRef != null && this.nodeService.exists(initiatorRef)) {
            initiator = (String)((Object)this.nodeService.getProperty(initiatorRef, ContentModel.PROP_USERNAME));
        }
        return initiator;
    }
}

