/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.math.BigInteger;
import org.alfresco.repo.virtual.ref.NodeIdHasher;
import org.apache.commons.lang3.StringUtils;

class UuidNodeIdRadixHasher
implements NodeIdHasher {
    private final int radix;

    public UuidNodeIdRadixHasher(int radix) {
        this.radix = radix;
    }

    @Override
    public String lookup(String hashUuid) {
        BigInteger nodeId = new BigInteger(hashUuid, this.radix);
        String nodeIdHex = nodeId.toString(16);
        String paddedNodeIdHex = StringUtils.leftPad((String)nodeIdHex, (int)32, (String)"0");
        return String.join((CharSequence)"-", paddedNodeIdHex.substring(0, 8), paddedNodeIdHex.substring(8, 12), paddedNodeIdHex.substring(12, 16), paddedNodeIdHex.substring(16, 20), paddedNodeIdHex.substring(20, 32));
    }

    @Override
    public String hash(String uuid) {
        String uuidWithoutDashes = uuid.replaceAll("-", "");
        BigInteger bigIntUuidWithoutDashesHex = new BigInteger(uuidWithoutDashes, 16);
        return bigIntUuidWithoutDashesHex.toString(this.radix);
    }
}

