/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.List;
import java.util.Map;
import org.alfresco.heartbeat.SessionsUsageDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.admin.RepoServerMgmtMBean;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.service.cmr.repository.HBDataCollectorService;
import org.alfresco.service.descriptor.Descriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SessionsUsageDataCollectorTest {
    private SessionsUsageDataCollector sessionsUsageDataCollector;
    private HBDataCollectorService mockCollectorService;
    private DescriptorDAO mockDescriptorDAO;
    private List<HBData> collectedData;
    private HeartBeatJobScheduler mockScheduler;
    private RepoServerMgmtMBean repoServerMgmtMBean;
    private static final int TICKET_NON_EXPIRED = 10;

    @Before
    public void setUp() {
        this.mockDescriptorDAO = (DescriptorDAO)Mockito.mock(DescriptorDAO.class);
        this.mockCollectorService = (HBDataCollectorService)Mockito.mock(HBDataCollectorService.class);
        this.mockScheduler = (HeartBeatJobScheduler)Mockito.mock(HeartBeatJobScheduler.class);
        this.repoServerMgmtMBean = (RepoServerMgmtMBean)Mockito.mock(RepoServerMgmtMBean.class);
        Mockito.when((Object)this.repoServerMgmtMBean.getTicketCountNonExpired()).thenReturn((Object)10);
        Descriptor mockDescriptor = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)mockDescriptor.getId()).thenReturn((Object)"mock_id");
        Mockito.when((Object)this.mockDescriptorDAO.getDescriptor()).thenReturn((Object)mockDescriptor);
        this.sessionsUsageDataCollector = new SessionsUsageDataCollector("acs.repository.usage.sessions", "1.0", "0 0 0/1 ? * *", this.mockScheduler);
        this.sessionsUsageDataCollector.setHbDataCollectorService(this.mockCollectorService);
        this.sessionsUsageDataCollector.setCurrentRepoDescriptorDAO(this.mockDescriptorDAO);
        this.sessionsUsageDataCollector.setRepoServerMgmt(this.repoServerMgmtMBean);
        this.collectedData = this.sessionsUsageDataCollector.collectData();
    }

    @Test
    public void testHBDataFields() {
        for (HBData data : this.collectedData) {
            Assert.assertNotNull((Object)data.getCollectorId());
            Assert.assertNotNull((Object)data.getCollectorVersion());
            Assert.assertNotNull((Object)data.getSchemaVersion());
            Assert.assertNotNull((Object)data.getSystemId());
            Assert.assertNotNull((Object)data.getTimestamp());
        }
    }

    @Test
    public void testSystemUsageDataIsCollected() {
        HBData sessionsUsage = this.grabDataByCollectorId(this.sessionsUsageDataCollector.getCollectorId());
        Assert.assertNotNull((String)"Sessions usage data missing.", (Object)sessionsUsage);
        Map data = sessionsUsage.getData();
        Assert.assertTrue((boolean)data.containsKey("activeTickets"));
        Assert.assertEquals((String)"Wrong number of active tickets", (Object)10, data.get("activeTickets"));
    }

    private HBData grabDataByCollectorId(String collectorId) {
        for (HBData d : this.collectedData) {
            if (d.getCollectorId() == null || !d.getCollectorId().equals(collectorId)) continue;
            return d;
        }
        return null;
    }
}

