/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.admin;

import org.alfresco.util.EqualsHelper;
import org.alfresco.util.ParameterCheck;

public class RepoUsage {
    private final Long lastUpdate;
    private final Long users;
    private final Long documents;
    private final LicenseMode licenseMode;
    private final Long licenseExpiryDate;
    private final boolean readOnly;

    public RepoUsage(Long lastUpdate, Long users, Long documents, LicenseMode licenseMode, Long licenseExpiryDate, boolean readOnly) {
        ParameterCheck.mandatory((String)"licenseMode", (Object)((Object)licenseMode));
        this.lastUpdate = lastUpdate;
        this.users = users;
        this.documents = documents;
        this.licenseMode = licenseMode;
        this.licenseExpiryDate = licenseExpiryDate;
        this.readOnly = readOnly;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepoUsage that = (RepoUsage)obj;
        return EqualsHelper.nullSafeEquals((Object)this.users, (Object)that.users) && EqualsHelper.nullSafeEquals((Object)this.documents, (Object)that.documents) && EqualsHelper.nullSafeEquals((Object)((Object)this.licenseMode), (Object)((Object)that.licenseMode)) && EqualsHelper.nullSafeEquals((Object)this.licenseExpiryDate, (Object)that.licenseExpiryDate) && this.readOnly == that.readOnly;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("RepoUsage").append("[lastUpdate=").append(this.lastUpdate).append(", users=").append(this.users).append(", documents=").append(this.documents).append(", licenseMode=").append((Object)this.licenseMode).append(", licenseExpiryDate=").append(this.licenseExpiryDate).append(", readOnly=").append(this.readOnly).append("]");
        return sb.toString();
    }

    public Long getLastUpdate() {
        return this.lastUpdate;
    }

    public Long getUsers() {
        return this.users;
    }

    public Long getDocuments() {
        return this.documents;
    }

    public LicenseMode getLicenseMode() {
        return this.licenseMode;
    }

    public Long getLicenseExpiryDate() {
        return this.licenseExpiryDate;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static enum LicenseMode {
        ENTERPRISE,
        TEAM,
        UNKNOWN;

    }

    public static enum UsageType {
        USAGE_USERS,
        USAGE_DOCUMENTS,
        USAGE_ALL;

    }
}

