/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.SetPropertyValueActionExecuter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class SetPropertyValueActionExecuterTest
extends BaseSpringTest {
    private NodeService nodeService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private SetPropertyValueActionExecuter executer;
    private static final String ID = GUID.generate();
    private static final String TEST_VALUE = "TestValue";

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.executer = (SetPropertyValueActionExecuter)this.applicationContext.getBean("set-property-value");
    }

    @Test
    public void testExecution() {
        ActionImpl action = new ActionImpl(null, ID, "set-property-value", null);
        action.setParameterValue("property", (Serializable)ContentModel.PROP_NAME);
        action.setParameterValue("value", (Serializable)((Object)TEST_VALUE));
        this.executer.execute((Action)action, this.nodeRef);
        SetPropertyValueActionExecuterTest.assertEquals((Object)TEST_VALUE, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_NAME));
        action.setParameterValue("property", (Serializable)QName.createQName((String)"{test}badProperty"));
        try {
            this.executer.execute((Action)action, this.nodeRef);
            SetPropertyValueActionExecuterTest.fail((String)"We would expect and exception to be thrown since the property name is invalid.");
        }
        catch (Throwable throwable) {}
    }
}

