/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.calendar.cannedqueries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.calendar.CalendarModel;
import org.alfresco.repo.calendar.cannedqueries.CalendarEntity;
import org.alfresco.repo.calendar.cannedqueries.GetCalendarEntriesCannedQueryParams;
import org.alfresco.repo.calendar.cannedqueries.GetCalendarEntriesCannedQueryTestHook;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.query.AbstractQNameAwareCannedQueryFactory;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarRecurrenceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetCalendarEntriesCannedQuery
extends AbstractCannedQueryPermissions<CalendarEntry> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String QUERY_NAMESPACE = "alfresco.query.calendar";
    private static final String QUERY_SELECT_GET_BLOGS = "select_GetCalendarEntriesCannedQuery";
    private final CannedQueryDAO cannedQueryDAO;
    private final TaggingService taggingService;
    private final NodeService nodeService;
    private GetCalendarEntriesCannedQueryTestHook testHook;

    public GetCalendarEntriesCannedQuery(CannedQueryDAO cannedQueryDAO, NodeService nodeService, TaggingService taggingService, MethodSecurityBean<CalendarEntry> methodSecurity, CannedQueryParameters params) {
        super(params, methodSecurity);
        this.cannedQueryDAO = cannedQueryDAO;
        this.taggingService = taggingService;
        this.nodeService = nodeService;
    }

    private boolean isMidnightUTC(String isoDate) {
        return isoDate.endsWith("Z") && isoDate.indexOf("T00:00:00") != -1;
    }

    protected List<CalendarEntry> queryAndFilter(CannedQueryParameters parameters) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        Object paramBeanObj = parameters.getParameterBean();
        if (paramBeanObj == null) {
            throw new NullPointerException("Null GetCalendarEntries query params");
        }
        GetCalendarEntriesCannedQueryParams paramBean = (GetCalendarEntriesCannedQueryParams)paramBeanObj;
        Date entriesFromDate = paramBean.getEntriesFromDate();
        Date entriesToDate = paramBean.getEntriesToDate();
        List<CalendarEntity> results = this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_BLOGS, paramBean, 0, Integer.MAX_VALUE);
        ArrayList<CalendarEntity> filtered = new ArrayList<CalendarEntity>(results.size());
        for (CalendarEntity result : results) {
            boolean nextNodeIsAcceptable = true;
            Date fromDate = null;
            Date toDate = null;
            String strFromDate = result.getFromDate();
            String strToDate = result.getToDate();
            if (strFromDate != null && strFromDate.equals(strToDate) && this.isMidnightUTC(strFromDate)) {
                toDate = fromDate = ISO8601DateFormat.parseDayOnly((String)strFromDate, (TimeZone)TimeZone.getDefault());
            } else {
                fromDate = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)strFromDate);
                toDate = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)strToDate);
            }
            if (toDate == null) {
                toDate = fromDate;
            }
            String recurringRule = result.getRecurrenceRule();
            Date recurringLastDate = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)result.getRecurrenceLastMeeting());
            if (entriesFromDate != null && (toDate == null || toDate.before(entriesFromDate))) {
                nextNodeIsAcceptable = false;
            }
            if (entriesToDate != null && (fromDate == null || fromDate.after(entriesToDate))) {
                nextNodeIsAcceptable = false;
            }
            if (!(recurringRule == null || nextNodeIsAcceptable || entriesToDate == null && recurringLastDate == null)) {
                Date searchTo;
                Date searchFrom = entriesFromDate;
                if (searchFrom == null) {
                    searchFrom = fromDate;
                }
                if ((searchTo = entriesToDate) == null) {
                    searchTo = recurringLastDate;
                }
                HashSet<QName> childNodeTypeQNames = new HashSet<QName>();
                childNodeTypeQNames.add(CalendarModel.TYPE_IGNORE_EVENT);
                List ignoreEventList = this.nodeService.getChildAssocs(result.getNodeRef(), childNodeTypeQNames);
                HashSet<Date> ignoredDates = new HashSet<Date>();
                for (ChildAssociationRef ignoreEvent : ignoreEventList) {
                    NodeRef nodeRef = ignoreEvent.getChildRef();
                    Date ignoredDate = (Date)this.nodeService.getProperty(nodeRef, CalendarModel.PROP_IGNORE_EVENT_DATE);
                    ignoredDates.add(ignoredDate);
                }
                List<Date> dates = CalendarRecurrenceHelper.getRecurrencesOnOrAfter(recurringRule, fromDate, toDate, recurringLastDate, searchFrom, searchTo, false, ignoredDates);
                if (dates != null && dates.size() > 0) {
                    for (Date date : dates) {
                        if (entriesFromDate != null && entriesToDate != null) {
                            if (entriesFromDate.getTime() > date.getTime() || date.getTime() > entriesToDate.getTime()) continue;
                            nextNodeIsAcceptable = true;
                            break;
                        }
                        if (entriesFromDate != null) {
                            if (entriesFromDate.getTime() > date.getTime()) continue;
                            nextNodeIsAcceptable = true;
                            break;
                        }
                        if (entriesToDate == null || date.getTime() > entriesToDate.getTime()) continue;
                        nextNodeIsAcceptable = true;
                        break;
                    }
                }
            }
            if (!nextNodeIsAcceptable) continue;
            filtered.add(result);
        }
        List sortPairs = parameters.getSortDetails().getSortPairs();
        if (sortPairs != null && !sortPairs.isEmpty()) {
            ArrayList comparators = new ArrayList();
            for (Pair sortPair : sortPairs) {
                QName sortProperty = (QName)sortPair.getFirst();
                CalendarEntityComparator comparator = new CalendarEntityComparator(sortProperty);
                comparators.add(new Pair((Object)comparator, (Object)((CannedQuerySortDetails.SortOrder)sortPair.getSecond())));
            }
            AbstractQNameAwareCannedQueryFactory.NestedComparator comparator = new AbstractQNameAwareCannedQueryFactory.NestedComparator(comparators);
            Collections.sort(filtered, comparator);
        }
        ArrayList<CalendarEntry> calendarEntries = new ArrayList<CalendarEntry>(filtered.size());
        for (CalendarEntity result : filtered) {
            calendarEntries.add(new CalendarEntryImpl(result));
        }
        if (start != null) {
            this.logger.debug((Object)("Base query: " + calendarEntries.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        if (this.testHook != null) {
            this.testHook.notifyComplete(results, filtered);
        }
        return calendarEntries;
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }

    public void setTestHook(GetCalendarEntriesCannedQueryTestHook hook) {
        this.testHook = hook;
    }

    protected static class CalendarEntityComparator
    extends AbstractQNameAwareCannedQueryFactory.PropertyBasedComparator<CalendarEntity> {
        protected CalendarEntityComparator(QName property) {
            super(property);
        }

        @Override
        protected Comparable getProperty(CalendarEntity entity) {
            if (this.comparableProperty.equals((Object)CalendarModel.PROP_FROM_DATE)) {
                return entity.getFromDate();
            }
            if (this.comparableProperty.equals((Object)CalendarModel.PROP_TO_DATE)) {
                return entity.getToDate();
            }
            if (this.comparableProperty.equals((Object)ContentModel.PROP_CREATED)) {
                return entity.getCreatedDate();
            }
            throw new IllegalArgumentException("Unsupported calendar sort property: " + String.valueOf(this.comparableProperty));
        }
    }

    private class CalendarEntryImpl
    extends org.alfresco.repo.calendar.CalendarEntryImpl {
        private static final long serialVersionUID = 5717119409619436964L;

        private CalendarEntryImpl(CalendarEntity entity) {
            super(entity.getNodeRef(), GetCalendarEntriesCannedQuery.this.nodeService.getPrimaryParent(entity.getNodeRef()).getParentRef(), entity.getName());
            super.populate(GetCalendarEntriesCannedQuery.this.nodeService.getProperties(entity.getNodeRef()));
            super.setTags(GetCalendarEntriesCannedQuery.this.taggingService.getTags(entity.getNodeRef()));
        }
    }
}

