/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.DynamicallySizedThreadPoolExecutor;
import org.alfresco.util.TraceableThreadFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ThreadPoolExecutorFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final int DEFAULT_CORE_POOL_SIZE = 20;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = -1;
    private static final int DEFAULT_KEEP_ALIVE_TIME = 90;
    private static final int DEFAULT_THREAD_PRIORITY = 5;
    private static final boolean DEFAULT_THREAD_DAEMON = Boolean.TRUE;
    private static final int DEFAULT_WORK_QUEUE_SIZE = -1;
    private static final RejectedExecutionHandler DEFAULT_REJECTED_EXECUTION_HANDLER = new ThreadPoolExecutor.CallerRunsPolicy();
    private String poolName = "";
    private int corePoolSize = 20;
    private int maximumPoolSize = -1;
    private int keepAliveTime = 90;
    private int threadPriority = 5;
    private boolean threadDaemon = DEFAULT_THREAD_DAEMON;
    private int workQueueSize = -1;
    private RejectedExecutionHandler rejectedExecutionHandler = DEFAULT_REJECTED_EXECUTION_HANDLER;
    private DynamicallySizedThreadPoolExecutor instance;

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public void setThreadDaemon(boolean threadDaemon) {
        this.threadDaemon = threadDaemon;
    }

    public void setWorkQueueSize(int workQueueSize) {
        this.workQueueSize = workQueueSize;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.maximumPoolSize == -1) {
            this.maximumPoolSize = this.corePoolSize;
        }
        TraceableThreadFactory threadFactory = new TraceableThreadFactory();
        threadFactory.setThreadDaemon(this.threadDaemon);
        threadFactory.setThreadPriority(this.threadPriority);
        if (this.poolName.length() > 0) {
            threadFactory.setNamePrefix(this.poolName);
        }
        AbstractQueue workQueue = this.workQueueSize < 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.workQueueSize);
        this.instance = new DynamicallySizedThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.SECONDS, workQueue, (ThreadFactory)threadFactory, this.rejectedExecutionHandler);
    }

    public boolean isSingleton() {
        return false;
    }

    public Object getObject() throws Exception {
        if (this.instance == null) {
            throw new AlfrescoRuntimeException("The ThreadPoolExecutor instance has not been created");
        }
        return this.instance;
    }

    public Class getObjectType() {
        return DynamicallySizedThreadPoolExecutor.class;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void destroy() {
        this.instance.shutdown();
    }
}

