/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.BasePathResultsMap;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class NamePathResultsMap
extends BasePathResultsMap {
    public NamePathResultsMap(TemplateNode parent, ServiceRegistry services) {
        super(parent, services);
    }

    @Override
    public Object get(Object key) {
        String path = key.toString();
        final StringTokenizer t = new StringTokenizer(path, "/");
        if (this.services.getDictionaryService().isSubClass(this.parent.getType(), ContentModel.TYPE_FOLDER)) {
            NodeRef result = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    NodeRef child = NamePathResultsMap.this.parent.nodeRef;
                    while (t.hasMoreTokens() && child != null) {
                        String name = t.nextToken();
                        child = NamePathResultsMap.this.services.getNodeService().getChildByName(child, ContentModel.ASSOC_CONTAINS, name);
                    }
                    return child;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            if (result != null && this.services.getPublicServiceAccessService().hasAccess("NodeService", "getProperties", result) != AccessStatus.ALLOWED) {
                result = null;
            }
            return result != null ? new TemplateNode(result, this.services, this.parent.getImageResolver()) : null;
        }
        StringBuilder xpath = new StringBuilder(path.length() << 1);
        int count = 0;
        QueryParameterDefinition[] params = new QueryParameterDefinition[t.countTokens()];
        DataTypeDefinition ddText = this.services.getDictionaryService().getDataType(DataTypeDefinition.TEXT);
        NamespaceService ns = this.services.getNamespaceService();
        while (t.hasMoreTokens()) {
            if (xpath.length() != 0) {
                xpath.append('/');
            }
            String strCount = Integer.toString(count);
            xpath.append("*[@cm:name=$cm:name").append(strCount).append(']');
            params[count++] = new QueryParameterDefImpl(QName.createQName((String)"cm", (String)("name" + strCount), (NamespacePrefixResolver)ns), ddText, true, t.nextToken());
        }
        List<TemplateNode> nodes = this.getChildrenByXPath(xpath.toString(), params, true);
        return nodes.size() != 0 ? nodes.get(0) : null;
    }
}

