/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import jakarta.annotation.Resource;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.activiti.ActivitiWorkflowEngine;
import org.alfresco.repo.workflow.activiti.variable.ScriptNodeVariableType;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:test-database-context.xml", "classpath:activiti/test-activiti-component-context.xml", "classpath:alfresco/activiti-context.xml"})
@Transactional
@Category(value={NeverRunsTests.class})
public class AbstractActivitiComponentTest {
    protected static final String TEST_GROUP = "GROUP_testGroup";
    protected static final String TEST_USER = "testUser";
    protected static final String TEST_TASK_DEF = "activiti/testTransaction.bpmn20.xml";
    protected static final String TEST_TASK_KEY = "testTask";
    protected static final String TEST_ADHOC_DEF = "activiti/testAdhoc.bpmn20.xml";
    protected static final String TEST_SIGNALLING_DEF = "activiti/testSignalling.bpmn20.xml";
    protected static final String TEST_REVIEW_DEF = "activiti/testReview.bpmn20.xml";
    protected static final String TEST_ADHOC_KEY = "testAdhoc";
    protected static final String TEST_JOB_KEY = "testAdhoc";
    protected static final String TEST_JOB_DEF = "activiti/testJob.bpmn20.xml";
    protected static final String TEST_DIAGRAM_DEF = "activiti/testDiagram.bpmn20.xml";
    protected static final String XML = "text/xml";
    @Autowired
    protected ProcessEngine processEngine;
    @Resource(name="activitiWorkflowEngine")
    protected ActivitiWorkflowEngine workflowEngine;
    @Resource(name="activitiRuntimeService")
    protected RuntimeService runtime;
    @Resource(name="activitiRepositoryService")
    protected RepositoryService repo;
    @Resource(name="activitiTaskService")
    protected TaskService taskService;
    @Resource(name="activitiHistoryService")
    protected HistoryService historyService;
    @Resource(name="activitiManagementService")
    protected ManagementService managementService;
    @Resource
    protected MessageService messageService;
    @Resource(name="NamespaceService")
    protected NamespaceService namespaceService;
    @Resource(name="DictionaryService")
    protected DictionaryService dictionaryService;
    @Resource(name="NodeService")
    protected NodeService nodeService;
    @Resource(name="searchService")
    protected SearchService unprotectedSearchService;
    @Resource
    protected PermissionService permissionService;
    @Resource(name="PersonService")
    protected PersonService personService;
    @Resource
    protected AuthorityDAO authorityDAO;
    @Resource
    protected ServiceRegistry serviceRegistry;
    protected static final NodeRef rootNode = new NodeRef("workspace://root/");
    protected static final NodeRef companyHomeNode = new NodeRef("workspace://companyHome/");
    protected static final NodeRef adminPersonNode = new NodeRef("workspace://admin/");
    protected static final NodeRef adminHomeNode = new NodeRef("workspace://admin-home/");
    protected static final NodeRef testUserNode = new NodeRef("workspace://testUser/");
    protected static final NodeRef testGroupNode = new NodeRef("workspace://testGroup/");
    protected static final NodeRef testWorkflowPackage = new NodeRef("workspace://testPackage/");
    protected static final NodeRef testWorkflowContext = new NodeRef("workspace://testContext/");

    protected WorkflowDefinition deployTestTaskDefinition() {
        return this.deployDefinition(TEST_TASK_DEF);
    }

    protected WorkflowDefinition deployTestAdhocDefinition() {
        return this.deployDefinition(TEST_ADHOC_DEF);
    }

    protected WorkflowDefinition deployTestSignallingDefinition() {
        return this.deployDefinition(TEST_SIGNALLING_DEF);
    }

    protected WorkflowDefinition deployTestJobDefinition() {
        return this.deployDefinition(TEST_JOB_DEF);
    }

    protected WorkflowDefinition deployTestDiagramDefinition() {
        return this.deployDefinition(TEST_DIAGRAM_DEF);
    }

    protected WorkflowDefinition deployDefinition(String resource) {
        InputStream input = this.getInputStream(resource);
        WorkflowDeployment deployment = this.workflowEngine.deployDefinition(input, XML);
        WorkflowDefinition definition = deployment.getDefinition();
        return definition;
    }

    protected InputStream getInputStream(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream input = classLoader.getResourceAsStream(resource);
        return input;
    }

    @Before
    public void setUp() throws Exception {
        this.mockNamespaceService();
        this.mockDictionaryService();
        this.mockNodeService();
        this.mockSearchService();
        this.mockPermissionService();
        this.mockPersonService();
        this.mockAuthorityDAO();
        this.mockServiceRegistry();
        Repository repoHelper = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repoHelper.getCompanyHome()).thenReturn((Object)companyHomeNode);
        this.workflowEngine.setRepositoryHelper(repoHelper);
        ScriptNodeVariableType variableType = new ScriptNodeVariableType();
        variableType.setServiceRegistry(this.serviceRegistry);
        AuthenticationUtil.setFullyAuthenticatedUser((String)"admin");
        this.workflowEngine.afterPropertiesSet();
    }

    private void mockServiceRegistry() {
        Mockito.when((Object)this.serviceRegistry.getNodeService()).thenReturn((Object)this.nodeService);
        Mockito.when((Object)this.serviceRegistry.getDictionaryService()).thenReturn((Object)this.dictionaryService);
        Mockito.when((Object)this.serviceRegistry.getPermissionService()).thenReturn((Object)this.permissionService);
    }

    private void mockAuthorityDAO() {
        Mockito.when((Object)this.authorityDAO.authorityExists(TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.authorityDAO.authorityExists(TEST_GROUP)).thenReturn((Object)true);
        Mockito.when((Object)this.authorityDAO.getAuthorityNodeRefOrNull(TEST_USER)).thenReturn((Object)testUserNode);
        Mockito.when((Object)this.authorityDAO.getAuthorityNodeRefOrNull(TEST_GROUP)).thenReturn((Object)testGroupNode);
    }

    private void mockPersonService() {
        Mockito.when((Object)this.personService.personExists("admin")).thenReturn((Object)true);
        Mockito.when((Object)this.personService.getPerson("admin")).thenReturn((Object)adminPersonNode);
        Mockito.when((Object)this.personService.personExists(TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.personService.getPerson(TEST_USER)).thenReturn((Object)testUserNode);
    }

    private void mockPermissionService() {
        Mockito.when((Object)this.permissionService.hasPermission((NodeRef)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)AccessStatus.ALLOWED);
    }

    private void mockNodeService() {
        Mockito.when((Object)this.nodeService.getRootNode(new StoreRef("workspace://SpacesStore"))).thenReturn((Object)rootNode);
        Mockito.when((Object)this.nodeService.exists(companyHomeNode)).thenReturn((Object)true);
        Mockito.when((Object)this.nodeService.getType((NodeRef)ArgumentMatchers.any())).thenReturn((Object)QName.createQName((String)"cm:folder"));
        Mockito.when((Object)this.nodeService.getProperty(adminPersonNode, ContentModel.PROP_HOMEFOLDER)).thenReturn((Object)adminHomeNode);
        Mockito.when((Object)this.nodeService.getType(testUserNode)).thenReturn((Object)ContentModel.TYPE_PERSON);
        Mockito.when((Object)this.nodeService.getType(testGroupNode)).thenReturn((Object)ContentModel.TYPE_AUTHORITY);
    }

    private void mockSearchService() {
        Mockito.when((Object)this.unprotectedSearchService.selectNodes(rootNode, "spaces.company_home.childname", null, (NamespacePrefixResolver)this.namespaceService, false)).thenReturn(Arrays.asList(companyHomeNode));
    }

    private void mockDictionaryService() {
        Mockito.reset((Object[])new DictionaryService[]{this.dictionaryService});
        Mockito.when((Object)this.dictionaryService.getType((QName)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<TypeDefinition>(){

            public TypeDefinition answer(InvocationOnMock invocation) throws Throwable {
                QName name = (QName)invocation.getArguments()[0];
                TypeDefinition type = (TypeDefinition)Mockito.mock(TypeDefinition.class);
                Mockito.when((Object)type.getName()).thenReturn((Object)name);
                return type;
            }
        });
        Mockito.when((Object)this.dictionaryService.getAnonymousType((QName)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<TypeDefinition>(){

            public TypeDefinition answer(InvocationOnMock invocation) throws Throwable {
                QName name = (QName)invocation.getArguments()[0];
                TypeDefinition type = (TypeDefinition)Mockito.mock(TypeDefinition.class);
                Mockito.when((Object)type.getName()).thenReturn((Object)name);
                HashMap<QName, PropertyDefinition> props = new HashMap<QName, PropertyDefinition>();
                QName qname = QName.createQName((String)"http://test", (String)"myProp");
                DataTypeDefinition qNameDef = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
                Mockito.when((Object)qNameDef.getName()).thenReturn((Object)DataTypeDefinition.QNAME);
                Mockito.when((Object)qNameDef.getJavaClassName()).thenReturn((Object)QName.class.getName());
                DataTypeDefinition def = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
                Mockito.when((Object)def.getName()).thenReturn((Object)DataTypeDefinition.TEXT);
                Mockito.when((Object)def.getJavaClassName()).thenReturn((Object)String.class.getName());
                PropertyDefinition prop = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
                Mockito.when((Object)prop.getName()).thenReturn((Object)qname);
                Mockito.when((Object)prop.getDefaultValue()).thenReturn((Object)"Default value");
                Mockito.when((Object)prop.getDataType()).thenReturn((Object)def);
                PropertyDefinition description = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
                Mockito.when((Object)description.getName()).thenReturn((Object)WorkflowModel.PROP_DESCRIPTION);
                Mockito.when((Object)description.getDataType()).thenReturn((Object)def);
                PropertyDefinition outcomePropertyName = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
                Mockito.when((Object)outcomePropertyName.getName()).thenReturn((Object)WorkflowModel.PROP_OUTCOME_PROPERTY_NAME);
                Mockito.when((Object)outcomePropertyName.getDataType()).thenReturn((Object)qNameDef);
                Mockito.when((Object)outcomePropertyName.getDefaultValue()).thenReturn((Object)"{http://test}testOutcome");
                PropertyDefinition outcomeProperty = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
                Mockito.when((Object)outcomeProperty.getName()).thenReturn((Object)QName.createQName((String)"http://test", (String)"testOutcome"));
                Mockito.when((Object)outcomeProperty.getDataType()).thenReturn((Object)def);
                props.put(qname, prop);
                props.put(WorkflowModel.PROP_DESCRIPTION, description);
                props.put(WorkflowModel.PROP_OUTCOME_PROPERTY_NAME, outcomePropertyName);
                props.put(QName.createQName((String)"http://test", (String)"testOutcome"), outcomeProperty);
                Mockito.when((Object)type.getProperties()).thenReturn(props);
                return type;
            }
        });
        Mockito.when((Object)this.dictionaryService.isSubClass(ContentModel.TYPE_PERSON, ContentModel.TYPE_PERSON)).thenReturn((Object)true);
    }

    private void mockNamespaceService() {
        this.namespaceService.registerNamespace("bpm", "http://www.alfresco.org/model/bpm/1.0");
        this.namespaceService.registerNamespace("", "");
        this.namespaceService.registerNamespace("wf", "http://www.alfresco.org/model/workflow/1.0");
        this.namespaceService.registerNamespace("test", "http://test");
    }

    @After
    public void tearDown() {
        List defs = this.repo.createProcessDefinitionQuery().processDefinitionKey(TEST_TASK_KEY).list();
        HashSet<String> deployments = new HashSet<String>(defs.size());
        for (ProcessDefinition def : defs) {
            deployments.add(def.getDeploymentId());
        }
        for (String deployment : deployments) {
            List definitions = this.repo.createProcessDefinitionQuery().deploymentId(deployment).list();
            for (ProcessDefinition def : definitions) {
                this.killInstances(def);
            }
            this.repo.deleteDeployment(deployment);
        }
    }

    public String mapQNameToName(QName name) {
        String nameStr = name.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        if (nameStr.indexOf(95) != -1 && nameStr.indexOf(95) < nameStr.indexOf(58)) {
            return nameStr.replace(':', '}');
        }
        return nameStr.replace(':', '_');
    }

    private void killInstances(ProcessDefinition def) {
        List instances = this.runtime.createProcessInstanceQuery().processDefinitionId(def.getId()).list();
        for (ProcessInstance instance : instances) {
            this.runtime.deleteProcessInstance(instance.getId(), "For test");
        }
    }
}

