/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.acegisecurity.AccessDeniedException;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.dictionary.CMISObjectVariant;
import org.alfresco.opencmis.dictionary.DocumentTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.FolderTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.ItemTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.RelationshipTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionDoesNotExistException;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;

public class CMISNodeInfoImpl
implements CMISNodeInfo {
    private static final GregorianCalendar DUMMY_DATE = new GregorianCalendar(2010, 4, 1);
    private CMISConnector connector;
    private String objectId;
    private String currentObjectId;
    private String currentNodeId;
    private CMISObjectVariant objecVariant;
    private NodeRef nodeRef;
    private String versionLabel;
    private AssociationRef associationRef;
    private TypeDefinitionWrapper type;
    private String name;
    private boolean hasPWC;
    private Boolean isRootFolder;
    private String cmisPath;
    private VersionHistory versionHistory;
    private Version version;
    private Boolean isLatestMajorVersion;
    private Map<String, Serializable> properties;
    private List<CMISNodeInfo> parents;
    private Map<QName, Serializable> nodeProps;
    private Set<QName> nodeAspects;

    public CMISNodeInfoImpl() {
    }

    public CMISNodeInfoImpl(CMISConnector connector, String objectId) {
        this.connector = connector;
        this.objectId = connector.constructObjectId(objectId);
        this.analyseObjectId();
    }

    public CMISNodeInfoImpl(CMISConnector connector, NodeRef nodeRef, QName nodeType, Map<QName, Serializable> nodeProps, VersionHistory versionHistory, boolean checkExists) {
        this.connector = connector;
        this.nodeRef = nodeRef;
        this.versionHistory = versionHistory;
        if (nodeType != null) {
            this.determineType(nodeType);
        }
        this.nodeProps = nodeProps;
        this.analyseNodeRef(checkExists);
    }

    public CMISNodeInfoImpl(CMISConnector connector, NodeRef nodeRef) {
        this.connector = connector;
        this.nodeRef = nodeRef;
        this.analyseNodeRef(true);
    }

    public CMISNodeInfoImpl(CMISConnector connector, AssociationRef associationRef) {
        this.connector = connector;
        this.associationRef = associationRef;
        this.analyseAssociationRef();
    }

    private boolean isCurrentNode() {
        return this.objecVariant != CMISObjectVariant.VERSION;
    }

    protected void analyseVersionNode() {
        this.versionHistory = this.getVersionHistory();
        if (this.versionHistory == null) {
            this.objecVariant = CMISObjectVariant.CURRENT_VERSION;
            this.objectId = this.connector.constructObjectId(this.nodeRef, "1.0");
            this.versionLabel = "1.0";
            this.currentObjectId = this.objectId;
            this.hasPWC = this.isNodeCheckedOut();
        } else {
            this.versionLabel = (String)((Object)this.getNodeProps().get(ContentModel.PROP_VERSION_LABEL));
            Version headVersion = this.versionHistory.getHeadVersion();
            this.objectId = this.connector.constructObjectId(headVersion.getVersionedNodeRef(), this.versionLabel);
            this.currentObjectId = this.connector.constructObjectId(headVersion.getVersionedNodeRef(), headVersion.getVersionLabel());
            this.currentNodeId = headVersion.getVersionedNodeRef().toString();
            this.objecVariant = headVersion.getVersionLabel().equals(this.versionLabel) ? CMISObjectVariant.CURRENT_VERSION : CMISObjectVariant.VERSION;
            this.hasPWC = this.connector.getCheckOutCheckInService().isCheckedOut(headVersion.getVersionedNodeRef());
        }
    }

    protected void analyseCurrentVersion() {
        if (this.isNodeVersioned(this.nodeRef)) {
            this.versionLabel = (String)((Object)this.connector.getNodeService().getProperty(this.nodeRef, ContentModel.PROP_VERSION_LABEL));
            if (this.versionLabel == null) {
                this.versionLabel = "1.0";
            }
            this.currentObjectId = this.objectId = this.connector.constructObjectId(this.nodeRef, this.versionLabel);
            this.currentNodeId = this.nodeRef.toString();
            this.objecVariant = CMISObjectVariant.CURRENT_VERSION;
            this.hasPWC = this.isNodeCheckedOut();
        } else {
            this.setUnversioned();
        }
    }

    protected void setUnversioned() {
        this.objecVariant = CMISObjectVariant.CURRENT_VERSION;
        this.objectId = this.connector.constructObjectId(this.nodeRef, "1.0");
        this.versionLabel = "1.0";
        this.currentObjectId = this.objectId;
        this.hasPWC = this.isNodeCheckedOut();
    }

    protected void analyseObjectId() {
        block29: {
            this.currentNodeId = this.objectId;
            this.currentObjectId = this.objectId;
            this.versionLabel = null;
            this.nodeRef = null;
            this.hasPWC = false;
            if (this.objectId == null) {
                this.objecVariant = CMISObjectVariant.INVALID_ID;
                return;
            }
            try {
                int sepIndex = this.objectId.lastIndexOf(59);
                if (sepIndex > -1) {
                    this.currentNodeId = this.objectId.substring(0, sepIndex);
                    this.versionLabel = this.objectId.substring(sepIndex + 1);
                }
                if (this.objectId.startsWith("assoc:")) {
                    Long assocId = null;
                    try {
                        assocId = Long.valueOf(this.objectId.substring("assoc:".length()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.objecVariant = CMISObjectVariant.INVALID_ID;
                        return;
                    }
                    this.associationRef = this.connector.getNodeService().getAssoc(assocId);
                    this.objecVariant = this.associationRef == null ? CMISObjectVariant.NOT_EXISTING : CMISObjectVariant.ASSOC;
                    break block29;
                }
                if (NodeRef.isNodeRef((String)this.objectId)) {
                    NodeRef tmpNodeRef = new NodeRef(this.objectId);
                    this.objectId = this.connector.constructObjectId(tmpNodeRef, null);
                }
                if (!NodeRef.isNodeRef((String)this.currentNodeId)) {
                    this.currentNodeId = String.valueOf(this.connector.getRootStoreRef()) + "/" + this.currentNodeId;
                }
                this.nodeRef = new NodeRef(this.currentNodeId);
                if (!this.connector.getNodeService().exists(this.nodeRef)) {
                    this.objecVariant = CMISObjectVariant.NOT_EXISTING;
                    return;
                }
                if (this.isNodeWorkingCopy()) {
                    NodeRef checkedOut = this.connector.getCheckOutCheckInService().getCheckedOut(this.nodeRef);
                    this.objecVariant = this.connector.filter(this.nodeRef) ? CMISObjectVariant.NOT_EXISTING : CMISObjectVariant.PWC;
                    this.currentObjectId = this.connector.createObjectId(checkedOut);
                    this.currentNodeId = checkedOut.toString();
                    this.versionLabel = "pwc";
                    this.hasPWC = true;
                    return;
                }
                if (this.isFolder()) {
                    this.objecVariant = this.connector.filter(this.nodeRef) ? CMISObjectVariant.NOT_EXISTING : CMISObjectVariant.FOLDER;
                    return;
                }
                if (this.isItem()) {
                    this.objecVariant = CMISObjectVariant.ITEM;
                    return;
                }
                if (this.versionLabel == null) {
                    if (this.isDocument()) {
                        this.objecVariant = this.connector.filter(this.nodeRef) ? CMISObjectVariant.NOT_EXISTING : CMISObjectVariant.CURRENT_VERSION;
                        Version currentVersion = this.connector.getVersionService().getCurrentVersion(this.nodeRef);
                        if (currentVersion != null) {
                            this.versionLabel = currentVersion.getVersionLabel();
                            this.versionHistory = this.connector.getVersionService().getVersionHistory(this.nodeRef);
                        } else {
                            this.versionLabel = "1.0";
                        }
                        this.currentObjectId = this.objectId = this.connector.constructObjectId(this.objectId, this.versionLabel);
                        this.hasPWC = this.isNodeCheckedOut();
                    } else {
                        this.objecVariant = CMISObjectVariant.NOT_A_CMIS_OBJECT;
                    }
                    return;
                }
                if (this.versionLabel.equals("pwc")) {
                    NodeRef pwcNodeRef = this.connector.getCheckOutCheckInService().getWorkingCopy(this.nodeRef);
                    if (pwcNodeRef == null) {
                        this.objecVariant = CMISObjectVariant.NOT_EXISTING;
                        return;
                    }
                    this.objecVariant = this.connector.filter(this.nodeRef) ? CMISObjectVariant.NOT_EXISTING : CMISObjectVariant.PWC;
                    this.currentObjectId = this.connector.createObjectId(this.nodeRef);
                    this.currentNodeId = this.nodeRef.toString();
                    this.hasPWC = true;
                    this.nodeRef = pwcNodeRef;
                    return;
                }
                if (!this.isNodeVersioned(this.nodeRef)) {
                    this.objecVariant = this.connector.filter(this.nodeRef) ? CMISObjectVariant.NOT_EXISTING : (this.versionLabel.equals("1.0") ? CMISObjectVariant.CURRENT_VERSION : CMISObjectVariant.NOT_EXISTING);
                } else {
                    String headVersionLabel = (String)((Object)this.connector.getNodeService().getProperty(this.nodeRef, ContentModel.PROP_VERSION_LABEL));
                    this.currentObjectId = this.connector.constructObjectId(this.currentNodeId, headVersionLabel);
                    if (this.versionLabel.equals(headVersionLabel)) {
                        this.objecVariant = CMISObjectVariant.CURRENT_VERSION;
                    } else {
                        this.versionHistory = this.connector.getVersionService().getVersionHistory(this.nodeRef);
                        if (this.versionHistory == null) {
                            this.objecVariant = this.versionLabel.equals("1.0") ? CMISObjectVariant.CURRENT_VERSION : CMISObjectVariant.NOT_EXISTING;
                        } else {
                            try {
                                this.version = this.versionHistory.getVersion(this.versionLabel);
                                this.nodeRef = this.version.getFrozenStateNodeRef();
                                this.objecVariant = CMISObjectVariant.VERSION;
                            }
                            catch (VersionDoesNotExistException versionDoesNotExistException) {
                                this.objecVariant = CMISObjectVariant.NOT_EXISTING;
                            }
                        }
                    }
                }
                this.hasPWC = this.connector.getCheckOutCheckInService().isCheckedOut(this.getCurrentNodeNodeRef());
            }
            catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
                this.objecVariant = CMISObjectVariant.PERMISSION_DENIED;
            }
            catch (AccessDeniedException accessDeniedException) {
                this.objecVariant = CMISObjectVariant.PERMISSION_DENIED;
            }
        }
    }

    protected void analyseNodeRef(boolean checkExists) {
        this.objectId = null;
        this.currentNodeId = this.nodeRef.toString();
        this.currentObjectId = null;
        this.versionLabel = null;
        this.hasPWC = false;
        if (checkExists && !this.connector.getNodeService().exists(this.nodeRef)) {
            this.objecVariant = CMISObjectVariant.NOT_EXISTING;
            return;
        }
        if (this.connector.filter(this.nodeRef)) {
            this.objecVariant = CMISObjectVariant.NOT_EXISTING;
            return;
        }
        if (this.isFolder()) {
            this.objecVariant = CMISObjectVariant.FOLDER;
            this.currentObjectId = this.objectId = this.connector.constructObjectId(this.nodeRef, null);
            return;
        }
        if (this.isItem()) {
            this.objecVariant = CMISObjectVariant.ITEM;
            this.currentObjectId = this.objectId = this.connector.constructObjectId(this.nodeRef, null);
            return;
        }
        if (this.getType() == null) {
            this.objecVariant = CMISObjectVariant.NOT_A_CMIS_OBJECT;
            return;
        }
        if (this.isNodeWorkingCopy()) {
            NodeRef checkedOut = this.connector.getCheckOutCheckInService().getCheckedOut(this.nodeRef);
            if (checkedOut == null) {
                checkedOut = this.nodeRef;
            }
            this.objecVariant = CMISObjectVariant.PWC;
            this.objectId = this.connector.constructObjectId(checkedOut, "pwc");
            this.versionLabel = "pwc";
            this.currentObjectId = this.connector.createObjectId(checkedOut);
            this.currentNodeId = checkedOut.toString();
            this.hasPWC = true;
            return;
        }
        if (this.isNodeAVersion(this.nodeRef)) {
            this.analyseVersionNode();
        } else {
            this.analyseCurrentVersion();
        }
    }

    private boolean isNodeWorkingCopy() {
        return this.getNodeAspects().contains(ContentModel.ASPECT_WORKING_COPY);
    }

    private boolean isNodeCheckedOut() {
        return this.getNodeAspects().contains(ContentModel.ASPECT_CHECKED_OUT);
    }

    private boolean isNodeAVersion(NodeRef nodeRef) {
        if (nodeRef.getStoreRef().getProtocol().equals("versionStore")) {
            NodeRef realNodeRef = VersionUtil.convertNodeRef(nodeRef);
            return this.connector.getVersionService().isAVersion(realNodeRef);
        }
        return this.getNodeAspects().contains(Version2Model.ASPECT_VERSION);
    }

    private boolean isNodeVersioned(NodeRef nodeRef) {
        if (nodeRef.getStoreRef().getProtocol().equals("versionStore")) {
            NodeRef realNodeRef = VersionUtil.convertNodeRef(nodeRef);
            return this.connector.getVersionService().isVersioned(realNodeRef);
        }
        return this.getNodeAspects().contains(ContentModel.ASPECT_VERSIONABLE);
    }

    protected void analyseAssociationRef() {
        this.objectId = null;
        this.currentNodeId = null;
        this.currentObjectId = null;
        this.versionLabel = null;
        this.hasPWC = false;
        if (this.associationRef == null) {
            this.objecVariant = CMISObjectVariant.NOT_EXISTING;
            return;
        }
        this.objecVariant = CMISObjectVariant.ASSOC;
        this.objectId = "assoc:" + String.valueOf(this.associationRef.getId());
    }

    private void determineType(QName nodeType) {
        this.type = null;
        if (this.objecVariant == CMISObjectVariant.INVALID_ID || this.objecVariant == CMISObjectVariant.NOT_A_CMIS_OBJECT || this.objecVariant == CMISObjectVariant.NOT_EXISTING || this.objecVariant == CMISObjectVariant.PERMISSION_DENIED) {
            return;
        }
        if (this.nodeRef != null) {
            QName typeQName = nodeType != null ? nodeType : this.connector.getNodeService().getType(this.nodeRef);
            this.type = this.connector.getOpenCMISDictionaryService().findNodeType(typeQName);
        } else if (this.associationRef != null) {
            QName typeQName = this.associationRef.getTypeQName();
            this.type = this.connector.getOpenCMISDictionaryService().findAssocType(typeQName);
        }
    }

    public String getObjectId() {
        return this.objectId;
    }

    public CMISObjectVariant getObjectVariant() {
        return this.objecVariant;
    }

    public boolean isVariant(CMISObjectVariant var) {
        return this.objecVariant == var;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public String getCurrentNodeId() {
        return this.currentNodeId;
    }

    public NodeRef getCurrentNodeNodeRef() {
        return new NodeRef(this.currentNodeId);
    }

    public String getCurrentObjectId() {
        return this.currentObjectId;
    }

    public boolean isCurrentVersion() {
        return this.objecVariant == CMISObjectVariant.CURRENT_VERSION;
    }

    public boolean isPWC() {
        return this.objecVariant == CMISObjectVariant.PWC;
    }

    public boolean hasPWC() {
        return this.hasPWC;
    }

    public boolean isVersion() {
        return this.objecVariant == CMISObjectVariant.VERSION;
    }

    public boolean isLatestVersion() {
        return this.isCurrentVersion();
    }

    public boolean isLatestMajorVersion() {
        if (this.isLatestMajorVersion == null) {
            this.isLatestMajorVersion = Boolean.FALSE;
            if (!this.isPWC()) {
                Version version = this.getVersion();
                if (this.isCurrentNode() && version != null && version.getVersionType() == VersionType.MAJOR) {
                    this.isLatestMajorVersion = Boolean.TRUE;
                } else {
                    VersionHistory versionHistory = this.getVersionHistory();
                    if (versionHistory == null) {
                        this.isLatestMajorVersion = Boolean.TRUE;
                    } else {
                        Version currentVersion = versionHistory.getHeadVersion();
                        while (currentVersion != null) {
                            if (currentVersion.getVersionType() == VersionType.MAJOR) {
                                if (!this.nodeRef.getStoreRef().getIdentifier().equals("version2Store") && !this.nodeRef.getStoreRef().getIdentifier().equals("lightWeightVersionStore")) break;
                                this.isLatestMajorVersion = currentVersion.getFrozenStateNodeRef().equals((Object)this.nodeRef);
                                break;
                            }
                            currentVersion = versionHistory.getPredecessor(currentVersion);
                        }
                    }
                }
            }
        }
        return this.isLatestMajorVersion;
    }

    public boolean isMajorVersion() {
        if (this.isPWC()) {
            return false;
        }
        if ("1.0".equals(this.versionLabel)) {
            return true;
        }
        Version version = this.getVersion();
        if (version == null) {
            return true;
        }
        return version.getVersionType() == VersionType.MAJOR;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public String getCheckinComment() {
        if (!this.isDocument() || this.isPWC()) {
            return null;
        }
        Version version = this.getVersion();
        if (version != null) {
            return this.getVersion().getDescription();
        }
        return null;
    }

    public AssociationRef getAssociationRef() {
        return this.associationRef;
    }

    public TypeDefinitionWrapper getType() {
        if (this.type == null) {
            this.determineType(null);
        }
        return this.type;
    }

    public boolean isFolder() {
        return this.getType() instanceof FolderTypeDefintionWrapper;
    }

    public boolean isItem() {
        return this.getType() instanceof ItemTypeDefinitionWrapper;
    }

    public boolean isRootFolder() {
        if (this.isRootFolder == null) {
            this.isRootFolder = this.isFolder() && this.connector.getRootNodeRef().equals((Object)this.nodeRef);
        }
        return this.isRootFolder;
    }

    public boolean isDocument() {
        return this.getType() instanceof DocumentTypeDefinitionWrapper;
    }

    public boolean isRelationship() {
        return this.getType() instanceof RelationshipTypeDefintionWrapper;
    }

    public String getName() {
        if (this.objecVariant == CMISObjectVariant.INVALID_ID || this.objecVariant == CMISObjectVariant.NOT_A_CMIS_OBJECT || this.objecVariant == CMISObjectVariant.NOT_EXISTING || this.objecVariant == CMISObjectVariant.PERMISSION_DENIED) {
            return null;
        }
        if (this.name == null) {
            Serializable nameObj;
            this.name = this.isRelationship() ? this.associationRef.toString() : ((nameObj = this.getNodeProps().get(ContentModel.PROP_NAME)) instanceof String ? (String)((Object)nameObj) : "");
        }
        return this.name;
    }

    public String getPath() {
        if (this.objecVariant == CMISObjectVariant.INVALID_ID || this.objecVariant == CMISObjectVariant.NOT_A_CMIS_OBJECT || this.objecVariant == CMISObjectVariant.NOT_EXISTING || this.objecVariant == CMISObjectVariant.PERMISSION_DENIED) {
            return null;
        }
        if (this.cmisPath == null) {
            ChildAssociationRef assocRef;
            NodeRef node;
            Path.Element element;
            StringBuilder displayPath = new StringBuilder(64);
            Path path = this.connector.getNodeService().getPath(this.nodeRef);
            NodeRef rootNode = this.connector.getRootNodeRef();
            int i = 0;
            while (i < path.size()) {
                element = path.get(i);
                if (element instanceof Path.ChildAssocElement && (node = (assocRef = ((Path.ChildAssocElement)element).getRef()).getChildRef()).equals((Object)rootNode)) break;
                ++i;
            }
            path.size();
            if (path.size() - i == 1) {
                displayPath.append("/");
            } else {
                ++i;
                while (i < path.size() - 1) {
                    element = path.get(i);
                    if (element instanceof Path.ChildAssocElement) {
                        assocRef = ((Path.ChildAssocElement)element).getRef();
                        node = assocRef.getChildRef();
                        displayPath.append("/");
                        try {
                            String propertyName = (String)((Object)this.connector.getNodeService().getProperty(node, ContentModel.PROP_NAME));
                            displayPath.append(propertyName);
                        }
                        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
                            return null;
                        }
                        catch (AccessDeniedException accessDeniedException) {
                            return null;
                        }
                    }
                    ++i;
                }
                displayPath.append("/");
                displayPath.append(this.getName());
            }
            this.cmisPath = displayPath.toString();
        }
        return this.cmisPath;
    }

    public Serializable getCreationDate() {
        if (this.isDocument() || this.isFolder()) {
            return this.getNodeProps().get(ContentModel.PROP_CREATED);
        }
        return DUMMY_DATE;
    }

    public Serializable getModificationDate() {
        if (this.isDocument()) {
            if (this.isCurrentVersion() || this.isPWC()) {
                return this.getNodeProps().get(ContentModel.PROP_MODIFIED);
            }
            return this.getVersion().getVersionProperty(ContentModel.PROP_MODIFIED.getLocalName());
        }
        if (this.isFolder() || this.isItem()) {
            return this.getNodeProps().get(ContentModel.PROP_MODIFIED);
        }
        return DUMMY_DATE;
    }

    public NodeRef getLatestVersionNodeRef(boolean major) {
        if (!major) {
            return this.getLatestNonMajorVersionNodeRef();
        }
        VersionHistory versionHistory = this.getVersionHistory();
        if (versionHistory == null) {
            return this.getLatestNonMajorVersionNodeRef();
        }
        for (Version version : versionHistory.getAllVersions()) {
            if (version.getVersionType() != VersionType.MAJOR) continue;
            return version.getFrozenStateNodeRef();
        }
        throw new CmisObjectNotFoundException("There is no major version!");
    }

    private NodeRef getLatestNonMajorVersionNodeRef() {
        return this.getCurrentNodeNodeRef();
    }

    public VersionHistory getVersionHistory() {
        if (this.versionHistory == null && this.isDocument()) {
            try {
                this.versionHistory = this.connector.getVersionService().getVersionHistory(this.nodeRef);
            }
            catch (Exception exception) {}
        }
        return this.versionHistory;
    }

    public void deleteNode() {
        Version version = this.getVersion();
        if (this.getVersionHistory().getPredecessor(version) == null) {
            this.connector.getNodeService().deleteNode(this.nodeRef);
        } else {
            this.connector.getVersionService().deleteVersion(this.nodeRef, version);
        }
    }

    public void deleteVersion() {
        Version version = this.getVersion();
        this.connector.getVersionService().deleteVersion(this.nodeRef, version);
    }

    protected Version getVersion() {
        if (this.version == null && this.isDocument()) {
            VersionHistory versionHistory;
            block4: {
                try {
                    versionHistory = this.getVersionHistory();
                    if (versionHistory != null) break block4;
                    return null;
                }
                catch (Exception exception) {}
            }
            this.version = versionHistory.getVersion(this.versionLabel);
        }
        return this.version;
    }

    public void checkIfUseful(String what) {
        switch (this.objecVariant) {
            case INVALID_ID: {
                throw new CmisInvalidArgumentException(what + " id is invalid: " + this.objectId);
            }
            case NOT_EXISTING: {
                throw new CmisObjectNotFoundException(what + " not found: " + this.objectId);
            }
            case NOT_A_CMIS_OBJECT: {
                throw new CmisObjectNotFoundException(what + " is not a CMIS object: " + this.objectId);
            }
            case PERMISSION_DENIED: {
                throw new CmisPermissionDeniedException("Permission denied!");
            }
        }
    }

    public void checkIfFolder(String what) {
        this.checkIfUseful(what);
        if (this.objecVariant != CMISObjectVariant.FOLDER) {
            throw new CmisInvalidArgumentException(what + " is not a folder!");
        }
    }

    public Serializable getPropertyValue(String id) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(id);
    }

    public boolean containsPropertyValue(String id) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(id);
    }

    public void putPropertyValue(String id, Serializable value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
        }
        this.properties.put(id, value);
    }

    public String toString() {
        return this.getObjectId() + " (" + String.valueOf(this.getNodeRef()) + ")";
    }

    public List<CMISNodeInfo> getParents() {
        if (this.objecVariant == CMISObjectVariant.INVALID_ID || this.objecVariant == CMISObjectVariant.NOT_A_CMIS_OBJECT || this.objecVariant == CMISObjectVariant.NOT_EXISTING || this.objecVariant == CMISObjectVariant.PERMISSION_DENIED) {
            return Collections.emptyList();
        }
        if (this.parents == null) {
            this.parents = new ArrayList<CMISNodeInfo>();
            NodeRef nodeRefForParent = this.isCurrentVersion() ? this.getCurrentNodeNodeRef() : this.nodeRef;
            List nodeParents = this.connector.getNodeService().getParentAssocs(nodeRefForParent, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            if (nodeParents != null) {
                for (ChildAssociationRef parent : nodeParents) {
                    if (!(this.connector.getType(parent.getParentRef()) instanceof FolderTypeDefintionWrapper)) continue;
                    this.parents.add(new CMISNodeInfoImpl(this.connector, parent.getParentRef()));
                }
            }
        }
        return this.parents;
    }

    public Map<QName, Serializable> getNodeProps() {
        if (this.nodeProps == null && this.nodeRef != null) {
            this.nodeProps = this.connector.getNodeService().getProperties(this.nodeRef);
        }
        return this.nodeProps;
    }

    public Set<QName> getNodeAspects() {
        if (this.nodeAspects == null && this.nodeRef != null) {
            this.nodeAspects = this.connector.getNodeService().getAspects(this.nodeRef);
        } else if (this.versionLabel != null && this.versionLabel.equals("pwc") && this.nodeRef != null && !this.nodeRef.getId().equals(this.currentNodeId)) {
            this.nodeAspects = this.connector.getNodeService().getAspects(this.nodeRef);
        }
        return this.nodeAspects;
    }
}

