/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;

public class AccessPermissionImpl
implements AccessPermission {
    private String permission;
    private AccessStatus accessStatus;
    private String authority;
    private AuthorityType authorityType;
    private int position;

    public AccessPermissionImpl(String permission, AccessStatus accessStatus, String authority, int position) {
        this.permission = permission;
        this.accessStatus = accessStatus;
        this.authority = authority;
        this.authorityType = AuthorityType.getAuthorityType((String)authority);
        this.position = position;
    }

    public String getPermission() {
        return this.permission;
    }

    public AccessStatus getAccessStatus() {
        return this.accessStatus;
    }

    public String getAuthority() {
        return this.authority;
    }

    public AuthorityType getAuthorityType() {
        return this.authorityType;
    }

    public String toString() {
        return String.valueOf(this.accessStatus) + " " + this.permission + " - " + this.authority + " (" + String.valueOf(this.authorityType) + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.accessStatus == null ? 0 : this.accessStatus.hashCode());
        result = 31 * result + (this.authority == null ? 0 : this.authority.hashCode());
        result = 31 * result + (this.permission == null ? 0 : this.permission.hashCode());
        result = 31 * result + this.position;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPermissionImpl other = (AccessPermissionImpl)obj;
        if (this.accessStatus == null ? other.accessStatus != null : !this.accessStatus.equals((Object)other.accessStatus)) {
            return false;
        }
        if (this.authority == null ? other.authority != null : !this.authority.equals(other.authority)) {
            return false;
        }
        if (this.permission == null ? other.permission != null : !this.permission.equals(other.permission)) {
            return false;
        }
        return this.position == other.position;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isInherited() {
        return this.position > 0;
    }

    public boolean isSetDirectly() {
        return this.position == 0;
    }
}

