/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.constraint;

import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.action.constraint.BaseParameterConstraint;

public class EnumParameterConstraint
extends BaseParameterConstraint {
    private String enumClassName;
    private Class<?> enumClass;

    public void setEnumClassName(String enumClassName) {
        this.enumClassName = enumClassName;
    }

    @Override
    protected Map<String, String> getAllowableValuesImpl() {
        Class<?> enumClass = this.getEnumClass();
        ?[] enumValues = enumClass.getEnumConstants();
        LinkedHashMap<String, String> allowableValues = new LinkedHashMap<String, String>(enumValues.length);
        ?[] objArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object enumValue = objArray[n2];
            String displayLabel = this.getI18NLabel(enumValue.toString());
            allowableValues.put(enumValue.toString(), displayLabel);
            ++n2;
        }
        return allowableValues;
    }

    private Class<?> getEnumClass() {
        if (this.enumClass == null) {
            try {
                if (this.enumClassName == null || this.enumClassName.length() == 0) {
                    throw new AlfrescoRuntimeException("No enum class has been defined");
                }
                Class<?> enumClass = Class.forName(this.enumClassName);
                if (enumClass.isEnum()) {
                    this.enumClass = enumClass;
                }
            }
            catch (ClassNotFoundException e) {
                throw new AlfrescoRuntimeException("Unable to find enum class " + this.enumClassName, (Throwable)e);
            }
        }
        return this.enumClass;
    }
}

