/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.SearchEngineResultMetadata;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SpellCheckResult;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SolrSQLJSONResultSet
implements ResultSet,
SearchEngineResultMetadata {
    private static final String SOLR_STREAM_EXCEPTION = "EXCEPTION";
    private static Log logger = LogFactory.getLog(SolrSQLJSONResultSet.class);
    private Long queryTime;
    private SimpleResultSetMetaData resultSetMetaData;
    private String solrResponse;
    private int length;
    ResultSet wrapped;
    private JSONArray docs;
    private long numberFound;

    public SolrSQLJSONResultSet(JSONObject json, SearchParameters searchParameters) {
        try {
            this.solrResponse = json.toString();
            JSONObject res = (JSONObject)json.get("result-set");
            this.docs = (JSONArray)res.get("docs");
            JSONObject obj1 = this.docs.getJSONObject(0);
            if (obj1.has(SOLR_STREAM_EXCEPTION)) {
                String error = obj1.get(SOLR_STREAM_EXCEPTION).toString();
                if (error.equalsIgnoreCase("/sql handler only works in Solr Cloud mode")) {
                    throw new RuntimeException("Unable to execute the query, this API requires InsightEngine.");
                }
                throw new RuntimeException("Unable to execute the query, error caused by: " + error);
            }
            this.length = this.docs.length();
            JSONObject time = (JSONObject)this.docs.get(this.length - 1);
            this.numberFound = this.length - 1;
            this.queryTime = (long)((Integer)time.get("RESPONSE_TIME"));
            this.resultSetMetaData = new SimpleResultSetMetaData(LimitBy.FINAL_SIZE, PermissionEvaluationMode.EAGER, searchParameters);
        }
        catch (JSONException e) {
            logger.info((Object)e.getMessage());
        }
    }

    public int length() {
        return this.length;
    }

    @Override
    public long getNumberFound() {
        return this.numberFound;
    }

    public NodeRef getNodeRef(int n) {
        return null;
    }

    public float getScore(int n) {
        return 0.0f;
    }

    public void close() {
    }

    public ResultSetRow getRow(int i) {
        return null;
    }

    public List<NodeRef> getNodeRefs() {
        return null;
    }

    public List<ChildAssociationRef> getChildAssocRefs() {
        return null;
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        return null;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public int getStart() {
        return 0;
    }

    public boolean hasMore() {
        return false;
    }

    public boolean setBulkFetch(boolean bulkFetch) {
        return false;
    }

    public boolean getBulkFetch() {
        return false;
    }

    public int setBulkFetchSize(int bulkFetchSize) {
        return 0;
    }

    public int getBulkFetchSize() {
        return 0;
    }

    public List<Pair<String, Integer>> getFieldFacet(String field) {
        return null;
    }

    public Map<String, Integer> getFacetQueries() {
        return null;
    }

    public Map<NodeRef, List<Pair<String, List<String>>>> getHighlighting() {
        return null;
    }

    public SpellCheckResult getSpellCheckResult() {
        return null;
    }

    public Iterator<ResultSetRow> iterator() {
        return null;
    }

    @Override
    public Long getQueryTime() {
        return this.queryTime;
    }

    public String getSolrResponse() {
        return this.solrResponse;
    }

    public JSONArray getDocs() {
        return this.docs;
    }
}

