/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.security.authority.AuthorityInfo;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.repo.security.authority.script.ScriptGroup;
import org.alfresco.repo.security.authority.script.ScriptUser;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ScriptPagingDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptAuthorityService
extends BaseScopableProcessorExtension {
    public static final String ON_FIRST_SPACE = " +";
    private static final Log logger = LogFactory.getLog(ScriptAuthorityService.class);
    private AuthorityService authorityService;
    private PersonService personService;
    private ServiceRegistry serviceRegistry;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.authorityService = serviceRegistry.getAuthorityService();
        this.personService = serviceRegistry.getPersonService();
    }

    public AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public ScriptGroup[] searchRootGroupsInZone(String displayNamePattern, String zone) {
        return this.searchRootGroupsInZone(displayNamePattern, zone, -1, -1);
    }

    public ScriptGroup[] searchRootGroupsInZone(String displayNamePattern, String zone, int maxItems, int skipCount) {
        return this.searchRootGroupsInZone(displayNamePattern, zone, new ScriptPagingDetails(maxItems, skipCount), null);
    }

    public ScriptGroup[] searchRootGroupsInZone(String displayNamePattern, String zone, ScriptPagingDetails paging, String sortBy) {
        Set<String> authorities;
        try {
            authorities = this.authorityService.findAuthorities(AuthorityType.GROUP, null, true, displayNamePattern, zone);
        }
        catch (UnknownAuthorityException unknownAuthorityException) {
            authorities = Collections.emptySet();
        }
        return ScriptGroup.makeScriptGroups(authorities, paging, sortBy, this.serviceRegistry, this.getScope());
    }

    public ScriptGroup[] searchRootGroups(String displayNamePattern) {
        return this.searchRootGroupsInZone(displayNamePattern, null);
    }

    public ScriptGroup[] searchRootGroups(String displayNamePattern, ScriptPagingDetails paging, String sortBy) {
        return this.searchRootGroupsInZone(displayNamePattern, null, paging, sortBy);
    }

    public ScriptGroup[] getAllRootGroups() {
        return this.getAllRootGroups(-1, -1);
    }

    public ScriptGroup[] getAllRootGroups(int maxItems, int skipCount) {
        return this.getAllRootGroups(new ScriptPagingDetails(maxItems, skipCount));
    }

    public ScriptGroup[] getAllRootGroups(ScriptPagingDetails paging) {
        Set<String> authorities;
        try {
            authorities = this.authorityService.getAllRootAuthorities(AuthorityType.GROUP);
        }
        catch (UnknownAuthorityException unknownAuthorityException) {
            authorities = Collections.emptySet();
        }
        return ScriptGroup.makeScriptGroups(authorities, paging, this.serviceRegistry, this.getScope());
    }

    public ScriptGroup[] getAllRootGroupsInZone(String zone) {
        return this.getAllRootGroupsInZone(zone, -1, -1);
    }

    public ScriptGroup[] getAllRootGroupsInZone(String zone, int maxItems, int skipCount) {
        Set<String> authorities;
        try {
            authorities = this.authorityService.getAllRootAuthoritiesInZone(zone, AuthorityType.GROUP);
        }
        catch (UnknownAuthorityException unknownAuthorityException) {
            authorities = Collections.emptySet();
        }
        return ScriptGroup.makeScriptGroups(authorities, new ScriptPagingDetails(maxItems, skipCount), null, this.serviceRegistry, this.getScope());
    }

    public ScriptGroup[] getAllRootGroupsInZone(String zone, ScriptPagingDetails paging, String sortBy) {
        Set<String> authorities;
        try {
            authorities = this.authorityService.getAllRootAuthoritiesInZone(zone, AuthorityType.GROUP);
        }
        catch (UnknownAuthorityException unknownAuthorityException) {
            authorities = Collections.emptySet();
        }
        return ScriptGroup.makeScriptGroups(authorities, paging, sortBy, this.serviceRegistry, this.getScope());
    }

    public ScriptGroup[] getGroups(String filter, ScriptPagingDetails paging) {
        return this.getGroupsInZone(filter, null, paging, null);
    }

    public ScriptGroup[] getGroups(String filter, ScriptPagingDetails paging, String sortBy) {
        return this.getGroupsInZone(filter, null, paging, sortBy);
    }

    public ScriptGroup[] getGroupsInZone(String filter, String zone, ScriptPagingDetails paging, String sortBy) {
        return this.getGroupsInZone(filter, zone, paging, sortBy, true);
    }

    public ScriptGroup[] getGroupsInZone(String filter, String zone, ScriptPagingDetails paging, String sortBy, boolean sortAsc) {
        if (sortBy == null) {
            sortBy = "displayName";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start getGroupsInZone(" + (String)(filter == null ? "null" : "\"" + filter + "\"") + ", " + zone + ", {" + paging.getMaxItems() + " " + paging.getSkipCount() + "}, " + sortBy + ")"));
        }
        if (filter != null && (filter.length() == 0 || filter.equals("*"))) {
            filter = null;
        }
        ScriptGroup[] scriptGroups = null;
        try {
            paging.setRequestTotalCountMax(10000);
            PagingResults<AuthorityInfo> groups = this.authorityService.getAuthoritiesInfo(AuthorityType.GROUP, zone, filter, sortBy, sortAsc, paging);
            scriptGroups = ScriptGroup.makeScriptGroupsInfo(groups, paging, sortBy, sortAsc, this.serviceRegistry, this.getScope());
        }
        catch (UnknownAuthorityException unknownAuthorityException) {
            scriptGroups = new ScriptGroup[]{};
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("End   getGroupsInZone(" + (String)(filter == null ? "null" : "\"" + filter + "\"") + ", " + zone + ", {" + paging.getMaxItems() + " " + paging.getSkipCount() + "}, " + sortBy + ") returns " + scriptGroups.length + "\n"));
        }
        return scriptGroups;
    }

    public ScriptGroup getGroup(String shortName) {
        String fullName = this.authorityService.getName(AuthorityType.GROUP, shortName);
        if (this.authorityService.authorityExists(fullName)) {
            ScriptGroup group = new ScriptGroup(fullName, this.serviceRegistry, this.getScope());
            return group;
        }
        return null;
    }

    public ScriptGroup getGroupForFullAuthorityName(String fullAuthorityName) {
        if (this.authorityService.authorityExists(fullAuthorityName)) {
            ScriptGroup group = new ScriptGroup(fullAuthorityName, this.serviceRegistry, this.getScope());
            return group;
        }
        return null;
    }

    public ScriptGroup createRootGroup(String shortName, String displayName) {
        this.authorityService.createAuthority(AuthorityType.GROUP, shortName, displayName, this.authorityService.getDefaultZones());
        return this.getGroup(shortName);
    }

    public ScriptGroup[] searchGroups(String shortNameFilter) {
        return this.searchGroupsInZone(shortNameFilter, null);
    }

    public ScriptGroup[] searchGroups(String shortNameFilter, ScriptPagingDetails paging, String sortBy) {
        return this.searchGroupsInZone(shortNameFilter, null, paging, sortBy);
    }

    public ScriptGroup[] searchGroupsInZone(String shortNameFilter, String zone) {
        return this.searchGroupsInZone(shortNameFilter, zone, -1, -1);
    }

    public ScriptGroup[] searchGroupsInZone(String shortNameFilter, String zone, int maxItems, int skipCount) {
        return this.searchGroupsInZone(shortNameFilter, zone, new ScriptPagingDetails(maxItems, skipCount), null);
    }

    public ScriptGroup[] searchGroupsInZone(String shortNameFilter, String zone, ScriptPagingDetails paging, String sortBy) {
        Set<String> authorities;
        String filter = shortNameFilter;
        if (shortNameFilter.length() != 0) {
            filter = filter.replace("\"", "");
        }
        try {
            authorities = this.authorityService.findAuthorities(AuthorityType.GROUP, null, false, filter, zone);
        }
        catch (UnknownAuthorityException unknownAuthorityException) {
            authorities = Collections.emptySet();
        }
        return ScriptGroup.makeScriptGroups(authorities, paging, sortBy, this.serviceRegistry, this.getScope());
    }

    public ScriptUser getUser(String username) {
        try {
            NodeRef person = this.personService.getPerson(username, false);
            return new ScriptUser(username, person, this.serviceRegistry, this.getScope());
        }
        catch (NoSuchPersonException noSuchPersonException) {
            return null;
        }
    }

    public ScriptUser[] searchUsers(String nameFilter, ScriptPagingDetails paging, String sortBy) {
        ArrayList<Pair<QName, String>> filter = new ArrayList<Pair<QName, String>>();
        filter.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)nameFilter));
        filter.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)nameFilter));
        filter.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)nameFilter));
        Pair<String, String> tokenisedName = this.tokeniseName(nameFilter);
        if (tokenisedName != null) {
            filter.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)((String)tokenisedName.getFirst())));
            filter.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)((String)tokenisedName.getSecond())));
        }
        ArrayList<Pair<QName, Boolean>> sort = new ArrayList<Pair<QName, Boolean>>();
        if ("lastName".equals(sortBy)) {
            sort.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
        } else if ("firstName".equals(sortBy)) {
            sort.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
        } else {
            sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)true));
        }
        List people = this.personService.getPeople(filter, true, sort, (PagingRequest)paging).getPage();
        paging.setTotalItems(people.size());
        ScriptUser[] users = new ScriptUser[people.size()];
        int i = 0;
        while (i < users.length) {
            PersonService.PersonInfo person = (PersonService.PersonInfo)people.get(i);
            users[i] = new ScriptUser(person.getUserName(), person.getNodeRef(), this.serviceRegistry, this.getScope());
            ++i;
        }
        return users;
    }

    private Pair<String, String> tokeniseName(String nameFilter) {
        String[] tokens;
        String trimmedNameFilter;
        Pair result = null;
        if (nameFilter != null && (trimmedNameFilter = nameFilter.trim()).length() > 3 && (tokens = trimmedNameFilter.split(ON_FIRST_SPACE, 2)).length == 2) {
            result = new Pair((Object)tokens[0], (Object)tokens[1]);
        }
        return result;
    }
}

