/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.alfresco.repo.cache.SimpleCacheTestBase;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSimpleCacheTest
extends SimpleCacheTestBase<DefaultSimpleCache<Integer, String>> {
    protected DefaultSimpleCache<Integer, String> createCache() {
        return new DefaultSimpleCache(100, true, 0, 0, ((Object)((Object)this)).getClass().getName());
    }

    @Test
    public void boundedSizeCache() throws Exception {
        this.cache = new DefaultSimpleCache(3, true, 0, 0, ((Object)((Object)this)).getClass().getName());
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(1), (Object)"1");
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(2), (Object)"2");
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(3), (Object)"3");
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(4), (Object)"4");
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(5), (Object)"5");
        Assert.assertNull((Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(1)));
        Assert.assertFalse((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(1)));
        Assert.assertNull((Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(2)));
        Assert.assertFalse((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(2)));
        Assert.assertEquals((Object)"3", (Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(3)));
        Assert.assertEquals((Object)"4", (Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(4)));
        Assert.assertEquals((Object)"5", (Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(5)));
        Assert.assertTrue((boolean)((DefaultSimpleCache)this.cache).isUseMaxItems());
    }

    @Test
    public void defaultMaxItems() {
        this.cache = new DefaultSimpleCache(0, true, 0, 0, ((Object)((Object)this)).getClass().getName());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((DefaultSimpleCache)this.cache).getMaxItems());
        Assert.assertTrue((boolean)((DefaultSimpleCache)this.cache).isUseMaxItems());
    }

    @Test
    public void sizeLimitConstructor() {
        this.cache = new DefaultSimpleCache(123, ((Object)((Object)this)).getClass().getName());
        Assert.assertEquals((long)123L, (long)((DefaultSimpleCache)this.cache).getMaxItems());
        Assert.assertTrue((boolean)((DefaultSimpleCache)this.cache).isUseMaxItems());
    }

    @Test(expected=IllegalArgumentException.class)
    public void noNegativeMaxItems() {
        this.cache = new DefaultSimpleCache(-1, true, 0, 0, ((Object)((Object)this)).getClass().getName());
    }

    @Test
    public void putAndCheckUpdate() {
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(101), (Object)"101");
        Assert.assertEquals((Object)true, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(101), (Object)"99101"));
        Assert.assertEquals((Object)"99101", (Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(101)));
        Assert.assertFalse((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(102)));
        Assert.assertEquals((Object)false, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(102), (Object)"102"));
        Assert.assertEquals((Object)"102", (Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(102)));
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(103), null);
        Assert.assertEquals((Object)true, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(103), (Object)"103"));
        Assert.assertEquals((Object)false, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(103), (Object)"103"));
        Assert.assertFalse((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(104)));
        Assert.assertEquals((Object)false, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(104), null));
        Assert.assertEquals((Object)false, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(104), null));
        Assert.assertEquals((Object)true, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(104), (Object)"104"));
        Assert.assertEquals((Object)true, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(104), (Object)"99104"));
        Assert.assertEquals((Object)true, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(104), null));
        Assert.assertEquals((Object)false, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(104), null));
        ((DefaultSimpleCache)this.cache).remove((Serializable)Integer.valueOf(104));
        Assert.assertEquals((Object)false, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(104), (Object)"104"));
        Assert.assertEquals((Object)true, (Object)((DefaultSimpleCache)this.cache).putAndCheckUpdate((Serializable)Integer.valueOf(104), null));
    }

    @Test
    public void cachesCanHaveTTL() {
        this.cache = new DefaultSimpleCache(0, false, 2, 0, ((Object)((Object)this)).getClass().getName());
        Assert.assertFalse((boolean)((DefaultSimpleCache)this.cache).isUseMaxItems());
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(1), (Object)"1");
        Assert.assertTrue((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(1)));
        Assert.assertFalse((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(2)));
        Assert.assertFalse((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(3)));
        this.sleep(1500L);
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(2), (Object)"2");
        Assert.assertTrue((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(1)));
        Assert.assertTrue((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(2)));
        Assert.assertFalse((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(3)));
        this.sleep(1500L);
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(3), (Object)"3");
        Assert.assertFalse((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(1)));
        Assert.assertTrue((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(2)));
        Assert.assertTrue((boolean)((DefaultSimpleCache)this.cache).contains((Serializable)Integer.valueOf(3)));
    }

    @Test
    public void cachesCanHaveTTI() {
        this.cache = new DefaultSimpleCache(0, false, 0, 2, ((Object)((Object)this)).getClass().getName());
        Assert.assertFalse((boolean)((DefaultSimpleCache)this.cache).isUseMaxItems());
        Assert.assertEquals((long)0L, (long)((DefaultSimpleCache)this.cache).getTTLSecs());
        Assert.assertEquals((long)2L, (long)((DefaultSimpleCache)this.cache).getMaxIdleSecs());
        ((DefaultSimpleCache)this.cache).put((Serializable)Integer.valueOf(1), (Object)"1");
        Assert.assertEquals((Object)"1", (Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(1)));
        this.sleep(1000L);
        Assert.assertEquals((Object)"1", (Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(1)));
        this.sleep(1000L);
        Assert.assertEquals((Object)"1", (Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(1)));
        this.sleep(1000L);
        Assert.assertEquals((Object)"1", (Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(1)));
        this.sleep(2500L);
        Assert.assertNotEquals((Object)"1", (Object)((DefaultSimpleCache)this.cache).get((Serializable)Integer.valueOf(1)));
    }

    private void sleep(long miliseconds) {
        try {
            Thread.sleep(miliseconds);
        }
        catch (InterruptedException error) {
            throw new RuntimeException(error);
        }
    }
}

