/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class GuessMimetypeTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private ContentService contentService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;

    public void setUp() throws Exception {
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.contentService = (ContentService)ctx.getBean("ContentService");
        this.retryingTransactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper");
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                GuessMimetypeTest.this.storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
                GuessMimetypeTest.this.rootNodeRef = GuessMimetypeTest.this.nodeService.getRootNode(GuessMimetypeTest.this.storeRef);
                return null;
            }
        });
    }

    public void testAppleMimetype() throws Exception {
        String content = "This is some content";
        String fileName = "._myfile.pdf";
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                HashMap<QName, String> properties = new HashMap<QName, String>(13);
                properties.put(ContentModel.PROP_NAME, "test.txt");
                GuessMimetypeTest.this.nodeRef = GuessMimetypeTest.this.nodeService.createNode(GuessMimetypeTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
                return null;
            }
        });
        ContentWriter writer = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        writer.putContent(content);
        writer.guessMimetype(fileName);
        GuessMimetypeTest.assertEquals((String)"application/applefile", (String)writer.getMimetype());
        fileName = "myfile.pdf";
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                HashMap<QName, String> properties = new HashMap<QName, String>(13);
                properties.put(ContentModel.PROP_NAME, "test.txt");
                GuessMimetypeTest.this.nodeRef = GuessMimetypeTest.this.nodeService.createNode(GuessMimetypeTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
                return null;
            }
        });
        ContentWriter writer2 = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        content = "This is other content";
        writer2.putContent(content);
        writer2.guessMimetype(fileName);
        GuessMimetypeTest.assertNotSame((Object)"application/applefile", (Object)writer2.getMimetype());
    }
}

