/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating;

import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class RatingNamingConventionsUtil {
    private static final String RATING_ASSOC_SEPARATOR = "__";
    private NamespaceService namespaceService;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public QName getRatingAssocNameFor(String username, String ratingSchemeName) {
        StringBuilder compoundString = new StringBuilder();
        compoundString.append("cm:").append(username).append(RATING_ASSOC_SEPARATOR).append(ratingSchemeName);
        QName result = QName.createQName((String)compoundString.toString(), (NamespacePrefixResolver)this.namespaceService);
        return result;
    }

    public QNamePattern getRatingAssocPatternForUser(String username, String ratingSchemeName) {
        if (username == null) {
            username = ".*";
        }
        if (ratingSchemeName == null) {
            ratingSchemeName = ".*";
        }
        return new RegexQNamePattern("http://www.alfresco.org/model/content/1.0", username + RATING_ASSOC_SEPARATOR + ratingSchemeName);
    }

    public QName getRollupAspectNameFor(String ratingSchemeName) {
        String result = "cm:" + ratingSchemeName + "Rollups";
        return QName.createQName((String)result, (NamespacePrefixResolver)this.namespaceService);
    }

    public QName getRollupAspectNameFor(RatingScheme ratingScheme) {
        String modelPrefix = ratingScheme.getModelPrefix();
        String ratingSchemeName = ratingScheme.getName();
        String result = modelPrefix + ":" + ratingSchemeName + "Rollups";
        return QName.createQName((String)result, (NamespacePrefixResolver)this.namespaceService);
    }

    public QName getRollupPropertyNameFor(String ratingSchemeName, String rollupName) {
        String result = "cm:" + ratingSchemeName + rollupName;
        return QName.createQName((String)result, (NamespacePrefixResolver)this.namespaceService);
    }

    public QName getRollupPropertyNameFor(RatingScheme ratingScheme, String rollupName) {
        String modelPrefix = ratingScheme.getModelPrefix();
        String ratingSchemeName = ratingScheme.getName();
        String result = modelPrefix + ":" + ratingSchemeName + rollupName;
        return QName.createQName((String)result, (NamespacePrefixResolver)this.namespaceService);
    }
}

