/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import jakarta.transaction.UserTransaction;
import java.util.Date;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.ActionServiceImplTest;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.action.scheduled.ScheduledPersistedActionImpl;
import org.alfresco.repo.action.scheduled.ScheduledPersistedActionServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.scheduled.SchedulableAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.quartz.CalendarIntervalTrigger;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ScheduledPersistedActionServiceTest
extends BaseSpringTest {
    private ScheduledPersistedActionServiceImpl.ScheduledPersistedActionServiceBootstrap bootstrap;
    private ScheduledPersistedActionService service;
    private ScheduledPersistedActionServiceImpl serviceImpl;
    private Scheduler scheduler;
    private TransactionService transactionService;
    private RuntimeActionService runtimeActionService;
    private ActionService actionService;
    private NodeService nodeService;
    private Action testAction;
    private Action testAction2;
    private Action testAction3;

    @Before
    public void setUp() throws Exception {
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        this.runtimeActionService = (RuntimeActionService)this.applicationContext.getBean("actionService");
        this.service = (ScheduledPersistedActionService)this.applicationContext.getBean("ScheduledPersistedActionService");
        this.serviceImpl = (ScheduledPersistedActionServiceImpl)this.applicationContext.getBean("scheduledPersistedActionService");
        this.scheduler = (Scheduler)this.applicationContext.getBean("schedulerFactory");
        this.bootstrap = (ScheduledPersistedActionServiceImpl.ScheduledPersistedActionServiceBootstrap)this.applicationContext.getBean("scheduledPersistedActionServiceBootstrap");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        ActionServiceImplTest.SleepActionExecuter.registerIfNeeded(this.applicationContext);
        List schedules = this.service.listSchedules();
        for (ScheduledPersistedAction schedule : schedules) {
            this.service.deleteSchedule(schedule);
        }
        this.testAction = new TestAction(this.actionService.createAction("sleep-action"));
        this.runtimeActionService.createActionNodeRef(this.testAction, this.serviceImpl.SCHEDULED_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TestAction"));
        this.testAction2 = new TestAction(this.actionService.createAction("sleep-action"));
        this.runtimeActionService.createActionNodeRef(this.testAction2, this.serviceImpl.SCHEDULED_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TestAction2"));
        this.testAction3 = new TestAction(this.actionService.createAction("sleep-action"));
        txn.commit();
        this.scheduler.standby();
    }

    @After
    public void tearDown() throws Exception {
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        List schedules = this.service.listSchedules();
        for (ScheduledPersistedAction schedule : schedules) {
            this.service.deleteSchedule(schedule);
        }
        txn.commit();
        this.scheduler.start();
    }

    @Test
    public void testPersistedActionImpl() throws Exception {
        ScheduledPersistedActionImpl schedule = new ScheduledPersistedActionImpl(this.testAction);
        ScheduledPersistedActionImpl schedule3 = new ScheduledPersistedActionImpl(this.testAction3);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction, (Object)schedule.getAction());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)schedule.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule3.getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction3, (Object)schedule3.getAction());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule3.getActionNodeRef());
        this.runtimeActionService.createActionNodeRef(this.testAction3, this.serviceImpl.SCHEDULED_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TestAction3"));
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction, (Object)schedule.getAction());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)schedule.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule3.getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction3, (Object)schedule3.getAction());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction3.getNodeRef(), (Object)schedule3.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule3.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleEnd());
        schedule.setScheduleStart(new Date(1234L));
        ScheduledPersistedActionServiceTest.assertEquals((long)1234L, (long)schedule.getScheduleStart().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleEnd());
        schedule.setScheduleEnd(new Date(4321L));
        ScheduledPersistedActionServiceTest.assertEquals((long)1234L, (long)schedule.getScheduleStart().getTime());
        ScheduledPersistedActionServiceTest.assertEquals((long)4321L, (long)schedule.getScheduleEnd().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule3.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule3.getScheduleEnd());
        schedule.setScheduleStart(null);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((long)4321L, (long)schedule.getScheduleEnd().getTime());
        schedule.setScheduleEnd(null);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleEnd());
        ScheduledPersistedActionServiceTest.assertEquals(null, (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalPeriod());
        schedule.setScheduleIntervalCount(Integer.valueOf(3));
        ScheduledPersistedActionServiceTest.assertEquals(null, (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals((int)3, (int)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalPeriod());
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        ScheduledPersistedActionServiceTest.assertEquals((String)"3Hour", (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals((int)3, (int)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)SchedulableAction.IntervalPeriod.Hour, (Object)schedule.getScheduleIntervalPeriod());
        schedule.setScheduleIntervalCount(Integer.valueOf(8));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Month);
        ScheduledPersistedActionServiceTest.assertEquals((String)"8Month", (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals((int)8, (int)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)SchedulableAction.IntervalPeriod.Month, (Object)schedule.getScheduleIntervalPeriod());
        schedule.setScheduleIntervalCount(null);
        ScheduledPersistedActionServiceTest.assertEquals(null, (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)SchedulableAction.IntervalPeriod.Month, (Object)schedule.getScheduleIntervalPeriod());
        schedule.setScheduleIntervalPeriod(null);
        ScheduledPersistedActionServiceTest.assertEquals(null, (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalPeriod());
    }

    @Test
    public void testActionToTrigger() throws Exception {
        ScheduledPersistedActionImpl schedule = (ScheduledPersistedActionImpl)this.service.createSchedule(this.testAction);
        try {
            schedule.asTrigger();
            ScheduledPersistedActionServiceTest.fail((String)"Should require persistence first");
        }
        catch (IllegalStateException illegalStateException) {}
        this.service.saveSchedule((ScheduledPersistedAction)schedule);
        schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertEquals(null, (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalPeriod());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.asTrigger());
        schedule.setScheduleStart(new Date(12345L));
        Trigger t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)12345L, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        ScheduledPersistedActionServiceTest.assertEquals(SimpleTriggerImpl.class, t.getClass());
        schedule.setScheduleStart(null);
        schedule.setScheduleEnd(new Date(12345L));
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t);
        schedule.setScheduleStart(null);
        schedule.setScheduleEnd(null);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Second);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)t.getStartTime().getTime(), (double)10.0);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        ScheduledPersistedActionServiceTest.assertEquals(CalendarIntervalTriggerImpl.class, t.getClass());
        ScheduledPersistedActionServiceTest.assertEquals((int)2, (int)((CalendarIntervalTrigger)t).getRepeatInterval());
        ScheduledPersistedActionServiceTest.assertEquals((Object)DateBuilder.IntervalUnit.SECOND, (Object)((CalendarIntervalTrigger)t).getRepeatIntervalUnit());
        schedule.setScheduleStart(new Date(12345L));
        schedule.setScheduleEnd(null);
        schedule.setScheduleIntervalCount(Integer.valueOf(3));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Month);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)12345L, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        ScheduledPersistedActionServiceTest.assertEquals(CalendarIntervalTriggerImpl.class, t.getClass());
        ScheduledPersistedActionServiceTest.assertEquals((int)3, (int)((CalendarIntervalTrigger)t).getRepeatInterval());
        ScheduledPersistedActionServiceTest.assertEquals((Object)DateBuilder.IntervalUnit.MONTH, (Object)((CalendarIntervalTrigger)t).getRepeatIntervalUnit());
        schedule.setScheduleStart(new Date(12345L));
        schedule.setScheduleEnd(new Date(54321L));
        schedule.setScheduleIntervalCount(Integer.valueOf(12));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Week);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t);
        long future = System.currentTimeMillis() + 1234567L;
        schedule.setScheduleStart(new Date(12345L));
        schedule.setScheduleEnd(new Date(future));
        schedule.setScheduleIntervalCount(Integer.valueOf(12));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Week);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)12345L, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals((long)future, (long)t.getEndTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(CalendarIntervalTriggerImpl.class, t.getClass());
        ScheduledPersistedActionServiceTest.assertEquals((int)12, (int)((CalendarIntervalTrigger)t).getRepeatInterval());
        ScheduledPersistedActionServiceTest.assertEquals((Object)DateBuilder.IntervalUnit.WEEK, (Object)((CalendarIntervalTrigger)t).getRepeatIntervalUnit());
        schedule.setScheduleStart(null);
        schedule.setScheduleEnd(new Date(future));
        schedule.setScheduleIntervalCount(Integer.valueOf(6));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)t.getStartTime().getTime(), (double)2.0);
        ScheduledPersistedActionServiceTest.assertEquals((long)future, (long)t.getEndTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(CalendarIntervalTriggerImpl.class, t.getClass());
        ScheduledPersistedActionServiceTest.assertEquals((int)6, (int)((CalendarIntervalTrigger)t).getRepeatInterval());
        ScheduledPersistedActionServiceTest.assertEquals((Object)DateBuilder.IntervalUnit.HOUR, (Object)((CalendarIntervalTrigger)t).getRepeatIntervalUnit());
        schedule.setScheduleStart(new Date(12345L));
        schedule.setScheduleEnd(new Date(54321L));
        schedule.setScheduleIntervalCount(null);
        schedule.setScheduleIntervalPeriod(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t);
        schedule.setScheduleStart(new Date(12345L));
        schedule.setScheduleEnd(new Date(future));
        schedule.setScheduleIntervalCount(null);
        schedule.setScheduleIntervalPeriod(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)12345L, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        ScheduledPersistedActionServiceTest.assertEquals(SimpleTriggerImpl.class, t.getClass());
    }

    @Test
    public void testAsTriggerLastRun() throws Exception {
        long future = System.currentTimeMillis() + 1234567L;
        long future90mins = System.currentTimeMillis() + 5400000L;
        long past30mins = System.currentTimeMillis() - 1800000L;
        long past90mins = System.currentTimeMillis() - 5400000L;
        long past150mins = System.currentTimeMillis() - 9000000L;
        ScheduledPersistedActionImpl schedule = (ScheduledPersistedActionImpl)this.service.createSchedule(this.testAction);
        this.service.saveSchedule((ScheduledPersistedAction)schedule);
        schedule.setScheduleStart(null);
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(null);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        Trigger t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)t.getStartTime().getTime(), (double)10.0);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(null);
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past30mins));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)t.getStartTime().getTime(), (double)10.0);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past30mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(null);
        schedule.setScheduleIntervalPeriod(null);
        schedule.setScheduleIntervalCount(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)past30mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(future));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(null);
        schedule.setScheduleIntervalPeriod(null);
        schedule.setScheduleIntervalCount(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)future, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past90mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past30mins));
        schedule.setScheduleIntervalPeriod(null);
        schedule.setScheduleIntervalCount(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t);
        schedule.setScheduleStart(new Date(past30mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past90mins));
        schedule.setScheduleIntervalPeriod(null);
        schedule.setScheduleIntervalCount(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)past30mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(future));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past30mins));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)future, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past30mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(null);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)past30mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(future));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(null);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)future, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past30mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past90mins));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)past30mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past150mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past30mins));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)future90mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past150mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past90mins));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)past150mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals((long)future90mins, (long)t.getFireTimeAfter(new Date()).getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
    }

    @Test
    public void testCreation() {
        ScheduledPersistedAction schedule = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule);
        ScheduledPersistedActionServiceTest.assertTrue((this.testAction == schedule.getAction() ? 1 : 0) != 0);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)schedule.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleIntervalPeriod());
        Date now = new Date();
        schedule.setScheduleStart(now);
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)schedule.getScheduleStart());
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        ScheduledPersistedActionServiceTest.assertEquals((Object)2, (Object)schedule.getScheduleIntervalCount());
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Day);
        ScheduledPersistedActionServiceTest.assertEquals((Object)SchedulableAction.IntervalPeriod.Day, (Object)schedule.getScheduleIntervalPeriod());
    }

    @Test
    public void testCreateSaveLoad() throws Exception {
        ScheduledPersistedAction schedule = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule);
        Date now = new Date();
        schedule.setScheduleStart(now);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Day);
        ScheduledPersistedActionServiceTest.assertNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        this.service.saveSchedule(schedule);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        ScheduledPersistedActionImpl retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)retrieved.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)2, (Object)retrieved.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)SchedulableAction.IntervalPeriod.Day, (Object)retrieved.getScheduleIntervalPeriod());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        ScheduledPersistedActionImpl second = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)second);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)second.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)second.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)2, (Object)second.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)SchedulableAction.IntervalPeriod.Day, (Object)second.getScheduleIntervalPeriod());
        schedule = this.service.createSchedule(this.testAction3);
        ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        this.runtimeActionService.createActionNodeRef(this.testAction3, this.serviceImpl.SCHEDULED_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TestAction3"));
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        this.service.saveSchedule(schedule);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
    }

    @Test
    public void testEditing() throws Exception {
        ScheduledPersistedAction schedule = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule);
        Date now = new Date();
        schedule.setScheduleStart(now);
        schedule.setScheduleIntervalCount(Integer.valueOf(2));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Day);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.service.saveSchedule(schedule);
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        ScheduledPersistedActionImpl retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        txn.commit();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)retrieved.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)2, (Object)retrieved.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)SchedulableAction.IntervalPeriod.Day, (Object)retrieved.getScheduleIntervalPeriod());
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.service.saveSchedule(schedule);
        retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        txn.commit();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)retrieved.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)2, (Object)retrieved.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)SchedulableAction.IntervalPeriod.Day, (Object)retrieved.getScheduleIntervalPeriod());
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        retrieved.setScheduleIntervalCount(Integer.valueOf(3));
        this.service.saveSchedule((ScheduledPersistedAction)retrieved);
        retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        txn.commit();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)retrieved.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)3, (Object)retrieved.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)SchedulableAction.IntervalPeriod.Day, (Object)retrieved.getScheduleIntervalPeriod());
        retrieved.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Month);
        now = new Date();
        retrieved.setScheduleStart(now);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.service.saveSchedule((ScheduledPersistedAction)retrieved);
        retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        txn.commit();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)retrieved.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)3, (Object)retrieved.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)SchedulableAction.IntervalPeriod.Month, (Object)retrieved.getScheduleIntervalPeriod());
    }

    @Test
    public void testLoadList() throws Exception {
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        ScheduledPersistedAction schedule1 = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule1);
        ScheduledPersistedAction schedule2 = this.service.createSchedule(this.testAction2);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule2);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        this.service.saveSchedule(schedule1);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)((ScheduledPersistedAction)this.service.listSchedules().get(0)).getActionNodeRef());
        this.service.saveSchedule(schedule2);
        ScheduledPersistedActionServiceTest.assertEquals((int)2, (int)this.service.listSchedules().size());
    }

    @Test
    public void testLoadFromAction() throws Exception {
        ScheduledPersistedAction schedule1 = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule1);
        this.service.saveSchedule(schedule1);
        ScheduledPersistedAction retrieved = this.service.getSchedule(this.testAction2);
        ScheduledPersistedActionServiceTest.assertNull((Object)retrieved);
        retrieved = this.service.getSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getActionNodeRef());
    }

    @Test
    public void testStartup() throws Exception {
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        this.bootstrap.onBootstrap(null);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        long future = System.currentTimeMillis() + 1234567L;
        ScheduledPersistedAction schedule = this.service.createSchedule(this.testAction);
        schedule.setScheduleStart(new Date(future));
        this.service.saveSchedule(schedule);
        ((ScheduledPersistedActionServiceImpl)this.applicationContext.getBean("scheduledPersistedActionService")).removeFromScheduler((ScheduledPersistedActionImpl)schedule);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        this.bootstrap.onBootstrap(null);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
    }

    @Test
    public void testDeletion() throws Exception {
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        ScheduledPersistedAction schedule1 = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        this.service.deleteSchedule(schedule1);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        ScheduledPersistedAction schedule2 = this.service.createSchedule(this.testAction2);
        this.service.saveSchedule(schedule1);
        this.service.saveSchedule(schedule2);
        ScheduledPersistedActionServiceTest.assertEquals((int)2, (int)this.service.listSchedules().size());
        NodeRef schedule1NodeRef = ((ScheduledPersistedActionImpl)schedule1).getPersistedAtNodeRef();
        NodeRef schedule2NodeRef = ((ScheduledPersistedActionImpl)schedule2).getPersistedAtNodeRef();
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getTargetAssocs(schedule1NodeRef, RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getTargetAssocs(schedule2NodeRef, RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getSourceAssocs(this.testAction.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getSourceAssocs(this.testAction2.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        this.service.deleteSchedule(schedule2);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)((ScheduledPersistedAction)this.service.listSchedules().get(0)).getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)this.serviceImpl.loadPersistentSchedule(schedule1NodeRef));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.serviceImpl.loadPersistentSchedule(schedule2NodeRef));
        ScheduledPersistedActionServiceTest.assertNotNull((Object)this.service.getSchedule(this.testAction));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.service.getSchedule(this.testAction2));
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getTargetAssocs(schedule1NodeRef, RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getSourceAssocs(this.testAction.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.nodeService.getSourceAssocs(this.testAction2.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        this.service.deleteSchedule(schedule2);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)((ScheduledPersistedAction)this.service.listSchedules().get(0)).getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)this.serviceImpl.loadPersistentSchedule(schedule1NodeRef));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.serviceImpl.loadPersistentSchedule(schedule2NodeRef));
        ScheduledPersistedActionServiceTest.assertNotNull((Object)this.service.getSchedule(this.testAction));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.service.getSchedule(this.testAction2));
        this.service.deleteSchedule(schedule1);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertNull((Object)this.serviceImpl.loadPersistentSchedule(schedule1NodeRef));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.serviceImpl.loadPersistentSchedule(schedule2NodeRef));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.service.getSchedule(this.testAction));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.service.getSchedule(this.testAction2));
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.nodeService.getSourceAssocs(this.testAction.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.nodeService.getSourceAssocs(this.testAction2.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        this.service.saveSchedule(schedule1);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)((ScheduledPersistedAction)this.service.listSchedules().get(0)).getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)this.service.getSchedule(this.testAction));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.service.getSchedule(this.testAction2));
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.nodeService.deleteNode(this.testAction.getNodeRef());
        txn.commit();
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
    }

    @Test
    public void testJobBeanInjection() throws Exception {
        this.scheduler.start();
        TestJob job = new TestJob();
        JobDetail details = JobBuilder.newJob().withIdentity("ThisIsATest").ofType(job.getClass()).build();
        Trigger now = TriggerBuilder.newTrigger().withIdentity("TestTrigger").startAt(new Date(1L)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow()).build();
        Scheduler scheduler = (Scheduler)this.applicationContext.getBean("schedulerFactory");
        scheduler.scheduleJob(details, now);
        int i = 0;
        while (i < 20) {
            if (!TestJob.ran) {
                Thread.sleep(50L);
            }
            ++i;
        }
        ScheduledPersistedActionServiceTest.assertEquals((boolean)true, (boolean)TestJob.ran);
        ScheduledPersistedActionServiceTest.assertEquals((boolean)true, (boolean)TestJob.gotContext);
    }

    @Test
    public void testExecution() throws Exception {
        final ActionServiceImplTest.SleepActionExecuter sleepActionExec = (ActionServiceImplTest.SleepActionExecuter)((Object)this.applicationContext.getBean("sleep-action"));
        sleepActionExec.resetTimesExecuted();
        sleepActionExec.setSleepMs(1);
        this.scheduler.start();
        this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.createSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                schedule.setScheduleStart(new Date(System.currentTimeMillis() + 1000L));
                ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleInterval());
                ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleIntervalCount());
                ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleIntervalPeriod());
                ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleLastExecutedAt());
                System.out.println("Job starts in 1 second, no repeat...");
                ScheduledPersistedActionServiceTest.this.service.saveSchedule(schedule);
                return null;
            }
        }, false, true);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
        Thread.sleep(2000L);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)sleepActionExec.getTimesExecuted());
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.getSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)schedule.getScheduleLastExecutedAt().getTime(), (double)2500.0);
                ScheduledPersistedActionServiceTest.this.service.deleteSchedule(schedule);
                ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)ScheduledPersistedActionServiceTest.this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.createSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                schedule.setScheduleStart(new Date(System.currentTimeMillis() - 50L));
                ((ScheduledPersistedActionImpl)schedule).setScheduleEnd(new Date(System.currentTimeMillis() + 3500L));
                schedule.setScheduleIntervalCount(Integer.valueOf(2));
                schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Second);
                ScheduledPersistedActionServiceTest.assertEquals((String)"2Second", (String)schedule.getScheduleInterval());
                sleepActionExec.resetTimesExecuted();
                ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)sleepActionExec.getTimesExecuted());
                ScheduledPersistedActionServiceTest.this.service.saveSchedule(schedule);
                System.out.println("Job " + String.valueOf(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef()) + " starts now, repeats twice @ 2s");
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Thread.sleep(4250L);
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.getSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                if (sleepActionExec.getTimesExecuted() == 3) {
                    ScheduledPersistedActionServiceTest.assertEquals((int)3, (int)sleepActionExec.getTimesExecuted());
                } else {
                    ScheduledPersistedActionServiceTest.assertEquals((int)2, (int)sleepActionExec.getTimesExecuted());
                }
                ScheduledPersistedActionServiceTest.this.service.deleteSchedule(schedule);
                ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)ScheduledPersistedActionServiceTest.this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.createSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                schedule.setScheduleStart(new Date(System.currentTimeMillis() + 2000L));
                schedule.setScheduleIntervalCount(Integer.valueOf(1));
                schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Second);
                ScheduledPersistedActionServiceTest.assertEquals((String)"1Second", (String)schedule.getScheduleInterval());
                sleepActionExec.resetTimesExecuted();
                ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)sleepActionExec.getTimesExecuted());
                System.out.println("Job starts in 2s, repeats @ 1s");
                ScheduledPersistedActionServiceTest.this.service.saveSchedule(schedule);
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Thread.sleep(5000L);
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.getSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)ScheduledPersistedActionServiceTest.this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
                ScheduledPersistedActionServiceTest.this.service.deleteSchedule(schedule);
                ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)ScheduledPersistedActionServiceTest.this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)"PersistedActions")).size());
                ScheduledPersistedActionServiceTest.assertEquals((String)("Didn't run enough - " + sleepActionExec.getTimesExecuted()), (boolean)true, (sleepActionExec.getTimesExecuted() >= 3 ? 1 : 0) != 0);
                ScheduledPersistedActionServiceTest.assertEquals((String)("Ran too much - " + sleepActionExec.getTimesExecuted()), (boolean)true, (sleepActionExec.getTimesExecuted() < 5 ? 1 : 0) != 0);
                Thread.sleep(500L);
                return null;
            }
        }, false, true);
    }

    @Test
    public void testMultipleExecutions() throws Exception {
        final ActionServiceImplTest.SleepActionExecuter sleepActionExec = (ActionServiceImplTest.SleepActionExecuter)((Object)this.applicationContext.getBean("sleep-action"));
        sleepActionExec.resetTimesExecuted();
        sleepActionExec.setSleepMs(1);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ScheduledPersistedActionImpl scheduleA = (ScheduledPersistedActionImpl)ScheduledPersistedActionServiceTest.this.service.createSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                scheduleA.setScheduleStart(new Date(System.currentTimeMillis() + 2000L));
                scheduleA.setScheduleEnd(new Date(System.currentTimeMillis() + 9000L));
                scheduleA.setScheduleIntervalCount(Integer.valueOf(2));
                scheduleA.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Second);
                ScheduledPersistedActionServiceTest.this.service.saveSchedule((ScheduledPersistedAction)scheduleA);
                ScheduledPersistedActionImpl scheduleB = (ScheduledPersistedActionImpl)ScheduledPersistedActionServiceTest.this.service.createSchedule(ScheduledPersistedActionServiceTest.this.testAction2);
                scheduleB.setScheduleStart(new Date(System.currentTimeMillis()));
                scheduleB.setScheduleEnd(new Date(System.currentTimeMillis() + 9500L));
                scheduleB.setScheduleIntervalCount(Integer.valueOf(1));
                scheduleB.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Second);
                ScheduledPersistedActionServiceTest.this.service.saveSchedule((ScheduledPersistedAction)scheduleB);
                return null;
            }
        }, false, true);
        this.scheduler.start();
        Thread.sleep(10000L);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ScheduledPersistedAction scheduleA = ScheduledPersistedActionServiceTest.this.service.getSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                ScheduledPersistedAction scheduleB = ScheduledPersistedActionServiceTest.this.service.getSchedule(ScheduledPersistedActionServiceTest.this.testAction2);
                ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)scheduleA.getScheduleLastExecutedAt().getTime(), (double)2500.0);
                ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)scheduleB.getScheduleLastExecutedAt().getTime(), (double)2500.0);
                ScheduledPersistedActionServiceTest.assertEquals((String)("Didn't run enough - " + sleepActionExec.getTimesExecuted()), (boolean)true, (sleepActionExec.getTimesExecuted() >= 11 ? 1 : 0) != 0);
                ScheduledPersistedActionServiceTest.assertEquals((String)("Ran too much - " + sleepActionExec.getTimesExecuted()), (boolean)true, (sleepActionExec.getTimesExecuted() < 16 ? 1 : 0) != 0);
                return null;
            }
        }, false, true);
    }

    protected static class TestAction
    extends ActionImpl {
        private static final long serialVersionUID = -4648866728324635763L;

        protected TestAction(Action action) {
            super(action);
        }
    }

    public static class TestJob
    implements Job,
    ApplicationContextAware {
        private static boolean gotContext = false;
        private static boolean ran = false;

        public TestJob() {
            gotContext = false;
            ran = false;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            gotContext = true;
        }

        public void execute(JobExecutionContext paramJobExecutionContext) throws JobExecutionException {
            ran = true;
        }
    }
}

