/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.acegisecurity.providers.encoding.PasswordEncoder;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositePasswordEncoder {
    private static Log logger = LogFactory.getLog(CompositePasswordEncoder.class);
    private Map<String, Object> encoders;
    private String preferredEncoding;
    public static final String MD4_KEY = "md4";
    public static final List<String> SHA256 = Arrays.asList("sha256");
    public static final List<String> MD4 = Arrays.asList("md4");

    public String getPreferredEncoding() {
        return this.preferredEncoding;
    }

    public void setPreferredEncoding(String preferredEncoding) {
        this.preferredEncoding = preferredEncoding;
    }

    public void setEncoders(Map<String, Object> encoders) {
        this.encoders = encoders;
    }

    public boolean lastEncodingIsPreferred(List<String> hashIndicator) {
        return hashIndicator != null && hashIndicator.size() > 0 && this.preferredEncoding.equals(hashIndicator.get(hashIndicator.size() - 1));
    }

    public boolean isSafeToEncodeChain(List<String> encodingChain) {
        if (encodingChain != null && encodingChain.size() > 0) {
            ArrayList<String> unsafeEncoders = new ArrayList<String>();
            for (String encoderKey : encodingChain) {
                Object encoder = this.encoders.get(encoderKey);
                if (encoder == null) {
                    throw new AlfrescoRuntimeException("Invalid encoder specified: " + encoderKey);
                }
                if (!(encoder instanceof org.springframework.security.crypto.password.PasswordEncoder)) continue;
                unsafeEncoders.add(encoderKey);
            }
            if (unsafeEncoders.isEmpty()) {
                return true;
            }
            if (unsafeEncoders.size() == 1 && ((String)unsafeEncoders.get(0)).equals(encodingChain.get(encodingChain.size() - 1))) {
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Non-upgradable encoders in the encoding chain: " + Arrays.toString(unsafeEncoders.toArray()) + ". Only 1 non-upgradable encoder is allowed at the end of the chain: " + Arrays.toString(encodingChain.toArray())));
            }
        }
        return false;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"encoders", this.encoders);
        PropertyCheck.mandatory((Object)this, (String)"preferredEncoding", (Object)this.preferredEncoding);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Preferred password encoding set to " + this.preferredEncoding));
        }
        if (!this.encoders.containsKey(this.preferredEncoding)) {
            throw new AlfrescoRuntimeException("Invalid preferredEncoding specified: " + this.preferredEncoding + ". Permissible encoders are " + String.valueOf(this.encoders.keySet()));
        }
    }

    public String encodePassword(String rawPassword, Object salt, List<String> encodingChain) {
        ParameterCheck.mandatoryString((String)"rawPassword", (String)rawPassword);
        ParameterCheck.mandatoryCollection((String)"encodingChain", encodingChain);
        String encoded = new String(rawPassword);
        for (String encoderKey : encodingChain) {
            encoded = this.encode(encoderKey, encoded, salt);
        }
        if (encoded == rawPassword) {
            throw new AlfrescoRuntimeException("No password encoding specified. " + String.valueOf(encodingChain));
        }
        return encoded;
    }

    public String encodePreferred(String rawPassword, Object salt) {
        return this.encode(this.getPreferredEncoding(), rawPassword, salt);
    }

    protected String encode(String encoderKey, String rawPassword, Object salt) {
        ParameterCheck.mandatoryString((String)"rawPassword", (String)rawPassword);
        ParameterCheck.mandatoryString((String)"encoderKey", (String)encoderKey);
        Object encoder = this.encoders.get(encoderKey);
        if (encoder == null) {
            throw new AlfrescoRuntimeException("Invalid encoder specified: " + encoderKey);
        }
        if (encoder instanceof PasswordEncoder) {
            PasswordEncoder pEncoder = (PasswordEncoder)encoder;
            if (MD4_KEY.equals(encoderKey)) {
                salt = null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Encoding using acegis PasswordEncoder: " + encoderKey));
            }
            return pEncoder.encodePassword(rawPassword, salt);
        }
        if (encoder instanceof org.springframework.security.crypto.password.PasswordEncoder) {
            org.springframework.security.crypto.password.PasswordEncoder passEncoder = (org.springframework.security.crypto.password.PasswordEncoder)encoder;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Encoding using spring PasswordEncoder: " + encoderKey));
            }
            return passEncoder.encode((CharSequence)rawPassword);
        }
        throw new AlfrescoRuntimeException("Unsupported encoder specified: " + encoderKey);
    }

    public boolean matchesPassword(String rawPassword, String encodedPassword, Object salt, List<String> encodingChain) {
        ParameterCheck.mandatoryString((String)"rawPassword", (String)rawPassword);
        ParameterCheck.mandatoryString((String)"encodedPassword", (String)encodedPassword);
        ParameterCheck.mandatoryCollection((String)"encodingChain", encodingChain);
        if (encodingChain.size() > 1) {
            String lastEncoder = encodingChain.get(encodingChain.size() - 1);
            String encoded = this.encodePassword(rawPassword, salt, encodingChain.subList(0, encodingChain.size() - 1));
            return this.matches(lastEncoder, encoded, encodedPassword, salt);
        }
        if (encodingChain.size() == 1) {
            return this.matches(encodingChain.get(0), rawPassword, encodedPassword, salt);
        }
        return false;
    }

    protected boolean matches(String encoderKey, String rawPassword, String encodedPassword, Object salt) {
        ParameterCheck.mandatoryString((String)"rawPassword", (String)rawPassword);
        ParameterCheck.mandatoryString((String)"encodedPassword", (String)encodedPassword);
        ParameterCheck.mandatoryString((String)"encoderKey", (String)encoderKey);
        Object encoder = this.encoders.get(encoderKey);
        if (encoder == null) {
            throw new AlfrescoRuntimeException("Invalid matches encoder specified: " + encoderKey);
        }
        if (encoder instanceof PasswordEncoder) {
            PasswordEncoder pEncoder = (PasswordEncoder)encoder;
            if (MD4_KEY.equals(encoderKey)) {
                salt = null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Matching using acegis PasswordEncoder: " + encoderKey));
            }
            return pEncoder.isPasswordValid(encodedPassword, rawPassword, salt);
        }
        if (encoder instanceof org.springframework.security.crypto.password.PasswordEncoder) {
            org.springframework.security.crypto.password.PasswordEncoder passEncoder = (org.springframework.security.crypto.password.PasswordEncoder)encoder;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Matching using spring PasswordEncoder: " + encoderKey));
            }
            return passEncoder.matches((CharSequence)rawPassword, encodedPassword);
        }
        throw new AlfrescoRuntimeException("Unsupported encoder for matching: " + encoderKey);
    }
}

