/*
 * #%L
 * Alfresco Repository
 * %%
 * Copyright (C) 2005 - 2016 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.repo.transfer.report;

import java.io.File;
import java.util.List;

import org.alfresco.repo.transfer.Transfer;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferTarget;

/**
 * Provides methods to create transfer report.
 */
public interface TransferReporter
{

    /**
     * Create a transfer report of success
     * 
     * @param transferName
     *            - the unique name of this transfer - probably based upon the time of transfer.
     * @param transfer
     *            the transfer.
     * @param target
     *            the target of the transfer
     * @param definition
     *            the definition of the transfer
     * @param events
     *            the transfer events generated by the transfer.
     * @param snapshotFile
     *            the snapshot file
     *
     * @return the node ref of the transfer report
     */
    public NodeRef createTransferReport(String transferName,
            Transfer transfer,
            TransferTarget target,
            TransferDefinition definition,
            List<TransferEvent> events,
            File snapshotFile);

    /**
     * Create a transfer report of failure
     * 
     * @param transferName
     *            - the unique name of this transfer - probably based upon the time of transfer.
     * @param e
     *            the exception
     * @param target
     *            the target of the transfer
     * @param definition
     *            the definition of the transfer
     * @param events
     * @param snapshotFile
     *            the snapshot file
     * @return the node ref of the transfer report
     */
    public NodeRef createTransferReport(String transferName,
            Exception e,
            TransferTarget target,
            TransferDefinition definition,
            List<TransferEvent> events,
            File snapshotFile);

    /**
     * Write the destination transfer report into the local repo.
     * 
     * @param transferName
     *            the unique name of this transfer - probably based upon the time of transfer.
     * @param target
     *            the target of the transfer
     * @param tempFile
     *            the temporary file containing the contents of the destination side transfer report.
     * @return the node ref of the transfer report
     */
    public NodeRef writeDestinationReport(String transferName,
            TransferTarget target,
            File tempFile);

}
