/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.user;

import org.alfresco.repo.security.authentication.identityservice.user.DecodedTokenUser;
import org.alfresco.repo.security.authentication.identityservice.user.OIDCUserInfo;
import org.alfresco.repo.security.authentication.identityservice.user.TokenUserToOIDCUserMapper;
import org.alfresco.service.cmr.security.PersonService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TokenUserToOIDCUserMapperUnitTest {
    @Mock
    private PersonService personService;
    @InjectMocks
    private TokenUserToOIDCUserMapper tokenUserToOIDCUserMapper;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void shouldMapToOIDCUserWithAllFieldsPopulated() {
        DecodedTokenUser decodedTokenUser = new DecodedTokenUser("JOHNY123", "John", "Doe", "johny123@email.com");
        Mockito.when((Object)this.personService.getUserIdentifier("JOHNY123")).thenReturn((Object)"johny123");
        OIDCUserInfo oidcUserInfo = this.tokenUserToOIDCUserMapper.toOIDCUser(decodedTokenUser);
        Assert.assertEquals((Object)"johny123", (Object)oidcUserInfo.username());
        Assert.assertEquals((Object)"John", (Object)oidcUserInfo.firstName());
        Assert.assertEquals((Object)"Doe", (Object)oidcUserInfo.lastName());
        Assert.assertEquals((Object)"johny123@email.com", (Object)oidcUserInfo.email());
    }

    @Test
    public void shouldMapToOIDCUserWithSomeFieldsEmpty() {
        DecodedTokenUser decodedTokenUser = new DecodedTokenUser("johny123", "", "Doe", "");
        Mockito.when((Object)this.personService.getUserIdentifier("johny123")).thenReturn((Object)"johny123");
        OIDCUserInfo oidcUserInfo = this.tokenUserToOIDCUserMapper.toOIDCUser(decodedTokenUser);
        Assert.assertEquals((Object)"johny123", (Object)oidcUserInfo.username());
        Assert.assertEquals((Object)"", (Object)oidcUserInfo.firstName());
        Assert.assertEquals((Object)"Doe", (Object)oidcUserInfo.lastName());
        Assert.assertEquals((Object)"", (Object)oidcUserInfo.email());
    }

    @Test
    public void shouldReturnNullForNullUsername() {
        DecodedTokenUser decodedTokenUser = new DecodedTokenUser(null, "John", "Doe", "johny123@email.com");
        OIDCUserInfo oidcUserInfo = this.tokenUserToOIDCUserMapper.toOIDCUser(decodedTokenUser);
        Assert.assertNull((Object)oidcUserInfo.username());
        Assert.assertEquals((Object)"John", (Object)oidcUserInfo.firstName());
        Assert.assertEquals((Object)"Doe", (Object)oidcUserInfo.lastName());
        Assert.assertEquals((Object)"johny123@email.com", (Object)oidcUserInfo.email());
    }
}

