/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.rule.RuleServiceImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.collections.MapUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RuleServiceImplUnitTest {
    private static final NodeRef FOLDER_NODE = new NodeRef("folder://node/");
    private static final NodeRef RULE_SET_NODE = new NodeRef("rule://set/node");
    private static final NodeRef RULE_NODE = new NodeRef("rule://node/");
    private static final NodeRef ACTION_NODE = new NodeRef("action://node/");
    @InjectMocks
    private RuleService ruleService = new RuleServiceImpl();
    @Mock
    private NodeService nodeService;
    @Mock
    private PermissionService permissionService;
    @Mock
    private SimpleCache<NodeRef, List<Rule>> nodeRulesCache;
    @Mock
    private NodeService runtimeNodeService;
    @Mock
    private RuntimeActionService runtimeActionService;
    @Mock
    private DictionaryService dictionaryService;
    @Mock
    private Rule mockRule;
    @Mock
    private Action mockAction;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        Mockito.when((Object)this.dictionaryService.isSubClass(ContentModel.TYPE_FOLDER, ContentModel.TYPE_FOLDER)).thenReturn((Object)true);
        Mockito.when((Object)this.dictionaryService.isSubClass(ContentModel.TYPE_CONTENT, ContentModel.TYPE_FOLDER)).thenReturn((Object)false);
        Mockito.when((Object)this.permissionService.hasReadPermission((NodeRef)ArgumentMatchers.any())).thenReturn((Object)AccessStatus.ALLOWED);
    }

    @Test
    public void saveRule() {
        Mockito.when((Object)this.permissionService.hasPermission(FOLDER_NODE, "ChangePermissions")).thenReturn((Object)AccessStatus.ALLOWED);
        Mockito.when((Object)this.nodeService.exists(FOLDER_NODE)).thenReturn((Object)true);
        ChildAssociationRef ruleSet = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)ruleSet.getChildRef()).thenReturn((Object)RULE_SET_NODE);
        Mockito.when((Object)this.runtimeNodeService.getChildAssocs(FOLDER_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER)).thenReturn(List.of(ruleSet));
        ChildAssociationRef ruleAssociation = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)ruleAssociation.getChildRef()).thenReturn((Object)RULE_NODE);
        Mockito.when((Object)this.nodeService.createNode((NodeRef)ArgumentMatchers.eq((Object)RULE_SET_NODE), (QName)ArgumentMatchers.eq((Object)ContentModel.ASSOC_CONTAINS), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)RuleModel.TYPE_RULE))).thenReturn((Object)ruleAssociation);
        Mockito.when((Object)this.mockRule.getTitle()).thenReturn((Object)"Rule title");
        Mockito.when((Object)this.mockRule.getAction()).thenReturn((Object)this.mockAction);
        Mockito.when((Object)this.runtimeActionService.createActionNodeRef(this.mockAction, RULE_NODE, RuleModel.ASSOC_ACTION, RuleModel.ASSOC_ACTION)).thenReturn((Object)ACTION_NODE);
        this.ruleService.saveRule(FOLDER_NODE, this.mockRule);
        ((NodeService)BDDMockito.then((Object)this.nodeService).should(Mockito.times((int)2))).hasAspect(FOLDER_NODE, RuleModel.ASPECT_RULES);
        ((NodeService)BDDMockito.then((Object)this.nodeService).should()).exists(FOLDER_NODE);
        ((NodeService)BDDMockito.then((Object)this.nodeService).should()).addAspect(FOLDER_NODE, RuleModel.ASPECT_RULES, null);
        ((NodeService)BDDMockito.then((Object)this.nodeService).should()).createNode((NodeRef)ArgumentMatchers.eq((Object)RULE_SET_NODE), (QName)ArgumentMatchers.eq((Object)ContentModel.ASSOC_CONTAINS), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)RuleModel.TYPE_RULE));
        ((NodeService)BDDMockito.then((Object)this.nodeService).should(Mockito.atLeastOnce())).setProperty((NodeRef)ArgumentMatchers.eq((Object)RULE_NODE), (QName)ArgumentMatchers.any(QName.class), (Serializable)ArgumentMatchers.nullable(Serializable.class));
        ((NodeService)BDDMockito.then((Object)this.nodeService).should()).getChildAssocs(RULE_NODE, (QNamePattern)RuleModel.ASSOC_ACTION, (QNamePattern)RuleModel.ASSOC_ACTION);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeService});
    }

    @Test
    public void saveRule_missingAction() {
        Mockito.when((Object)this.permissionService.hasPermission(FOLDER_NODE, "ChangePermissions")).thenReturn((Object)AccessStatus.ALLOWED);
        Mockito.when((Object)this.nodeService.exists(FOLDER_NODE)).thenReturn((Object)true);
        ChildAssociationRef ruleSet = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)ruleSet.getChildRef()).thenReturn((Object)RULE_SET_NODE);
        Mockito.when((Object)this.runtimeNodeService.getChildAssocs(FOLDER_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER)).thenReturn(List.of(ruleSet));
        ChildAssociationRef ruleAssociation = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)this.nodeService.createNode((NodeRef)ArgumentMatchers.eq((Object)RULE_SET_NODE), (QName)ArgumentMatchers.eq((Object)ContentModel.ASSOC_CONTAINS), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)RuleModel.TYPE_RULE))).thenReturn((Object)ruleAssociation);
        Mockito.when((Object)this.mockRule.getTitle()).thenReturn((Object)"Rule title");
        Mockito.when((Object)this.mockRule.getAction()).thenReturn(null);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Rule rule = this.ruleService.saveRule(FOLDER_NODE, this.mockRule);
        });
    }

    @Test
    public void saveRule_missingTitle() {
        Mockito.when((Object)this.permissionService.hasPermission(FOLDER_NODE, "ChangePermissions")).thenReturn((Object)AccessStatus.ALLOWED);
        Mockito.when((Object)this.nodeService.exists(FOLDER_NODE)).thenReturn((Object)true);
        ChildAssociationRef ruleSet = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)ruleSet.getChildRef()).thenReturn((Object)RULE_SET_NODE);
        Mockito.when((Object)this.runtimeNodeService.getChildAssocs(FOLDER_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER)).thenReturn(List.of(ruleSet));
        ChildAssociationRef ruleAssociation = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)this.nodeService.createNode((NodeRef)ArgumentMatchers.eq((Object)RULE_SET_NODE), (QName)ArgumentMatchers.eq((Object)ContentModel.ASSOC_CONTAINS), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)RuleModel.TYPE_RULE))).thenReturn((Object)ruleAssociation);
        Mockito.when((Object)this.mockRule.getTitle()).thenReturn((Object)"");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Rule rule = this.ruleService.saveRule(FOLDER_NODE, this.mockRule);
        });
    }

    @Test
    public void saveRule_errorIfFolderHasMultipleRuleSets() {
        Mockito.when((Object)this.permissionService.hasPermission(FOLDER_NODE, "ChangePermissions")).thenReturn((Object)AccessStatus.ALLOWED);
        Mockito.when((Object)this.nodeService.exists(FOLDER_NODE)).thenReturn((Object)true);
        ChildAssociationRef childA = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        ChildAssociationRef childB = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)this.runtimeNodeService.getChildAssocs(FOLDER_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER)).thenReturn(List.of(childA, childB));
        Assertions.assertThatExceptionOfType(ActionServiceException.class).isThrownBy(() -> {
            Rule rule = this.ruleService.saveRule(FOLDER_NODE, this.mockRule);
        });
    }

    @Test
    public void saveRule_nodeDoesNotExist() {
        Mockito.when((Object)this.permissionService.hasPermission(FOLDER_NODE, "ChangePermissions")).thenReturn((Object)AccessStatus.ALLOWED);
        Mockito.when((Object)this.nodeService.exists(FOLDER_NODE)).thenReturn((Object)false);
        Assertions.assertThatExceptionOfType(RuleServiceException.class).isThrownBy(() -> {
            Rule rule = this.ruleService.saveRule(FOLDER_NODE, this.mockRule);
        });
    }

    @Test
    public void saveRule_accessDenied() {
        Mockito.when((Object)this.permissionService.hasPermission(FOLDER_NODE, "ChangePermissions")).thenReturn((Object)AccessStatus.DENIED);
        Assertions.assertThatExceptionOfType(RuleServiceException.class).isThrownBy(() -> {
            Rule rule = this.ruleService.saveRule(FOLDER_NODE, this.mockRule);
        });
    }

    @Test
    public void testGetRuleSetNode() {
        BDDMockito.given((Object)this.runtimeNodeService.getChildAssocs((NodeRef)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any())).willReturn(List.of(RuleServiceImplUnitTest.createAssociation(FOLDER_NODE, RULE_SET_NODE)));
        NodeRef actualNode = this.ruleService.getRuleSetNode(FOLDER_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getChildAssocs(FOLDER_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((Object)actualNode).isNotNull();
    }

    @Test
    public void testGetRuleSetNode_emptyAssociation() {
        BDDMockito.given((Object)this.runtimeNodeService.getChildAssocs((NodeRef)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any())).willReturn(Collections.emptyList());
        NodeRef actualNode = this.ruleService.getRuleSetNode(FOLDER_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getChildAssocs(FOLDER_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((Object)actualNode).isNull();
    }

    @Test
    public void testGetRuleSetNode_notPrimaryAssociation() {
        BDDMockito.given((Object)this.runtimeNodeService.getChildAssocs((NodeRef)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any())).willReturn(List.of(RuleServiceImplUnitTest.createAssociation(FOLDER_NODE, RULE_SET_NODE, false)));
        NodeRef actualNode = this.ruleService.getRuleSetNode(FOLDER_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getChildAssocs(FOLDER_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((Object)actualNode).isNotNull();
    }

    @Test
    public void testIsRuleSetAssociatedWithFolder() {
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs((NodeRef)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any())).willReturn(List.of(RuleServiceImplUnitTest.createAssociation(FOLDER_NODE, RULE_SET_NODE)));
        boolean associated = this.ruleService.isRuleSetAssociatedWithFolder(RULE_SET_NODE, FOLDER_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(RULE_SET_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).hasAspect(FOLDER_NODE, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(FOLDER_NODE);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((boolean)associated).isTrue();
    }

    @Test
    public void testIsRuleSetAssociatedWithFolder_emptyAssociation() {
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs((NodeRef)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any())).willReturn(Collections.emptyList());
        boolean associated = this.ruleService.isRuleSetAssociatedWithFolder(RULE_SET_NODE, FOLDER_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(RULE_SET_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).hasAspect(FOLDER_NODE, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(FOLDER_NODE);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((boolean)associated).isFalse();
    }

    @Test
    public void testIsRuleSetAssociatedWithFolder_improperAssociation() {
        NodeRef fakeFolderNode = new NodeRef("folder://node/fake");
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs((NodeRef)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any(), (QNamePattern)ArgumentMatchers.any())).willReturn(List.of(RuleServiceImplUnitTest.createAssociation(fakeFolderNode, RULE_SET_NODE)));
        boolean associated = this.ruleService.isRuleSetAssociatedWithFolder(RULE_SET_NODE, FOLDER_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(RULE_SET_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).hasAspect(FOLDER_NODE, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(FOLDER_NODE);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((boolean)associated).isFalse();
    }

    @Test
    public void testIsRuleSetAssociatedWithFolder_inheritedLinkedAssociation() {
        NodeRef owningFolder = new NodeRef("owning://node/");
        NodeRef parent = new NodeRef("parent://node/");
        List<ChildAssociationRef> ruleAssociations = List.of(RuleServiceImplUnitTest.createAssociation(owningFolder, RULE_SET_NODE), RuleServiceImplUnitTest.createAssociation(parent, RULE_SET_NODE));
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs(RULE_SET_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER)).willReturn(ruleAssociations);
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs(FOLDER_NODE)).willReturn(List.of(RuleServiceImplUnitTest.createAssociation(parent, FOLDER_NODE)));
        boolean associated = this.ruleService.isRuleSetAssociatedWithFolder(RULE_SET_NODE, FOLDER_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(RULE_SET_NODE, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).hasAspect(FOLDER_NODE, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(FOLDER_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).hasAspect(parent, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(parent);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((boolean)associated).isTrue();
    }

    @Test
    public void testIsRuleAssociatedWithRuleSet() {
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs((NodeRef)ArgumentMatchers.any())).willReturn(List.of(RuleServiceImplUnitTest.createAssociation(RULE_SET_NODE, RULE_NODE)));
        boolean associated = this.ruleService.isRuleAssociatedWithRuleSet(RULE_NODE, RULE_SET_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(RULE_NODE);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((boolean)associated).isTrue();
    }

    @Test
    public void testIsRuleAssociatedWithRuleSet_emptyAssociation() {
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs((NodeRef)ArgumentMatchers.any())).willReturn(Collections.emptyList());
        boolean associated = this.ruleService.isRuleAssociatedWithRuleSet(RULE_NODE, RULE_SET_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(RULE_NODE);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((boolean)associated).isFalse();
    }

    @Test
    public void testIsRuleAssociatedWithRuleSet_improperAssociation() {
        NodeRef fakeRuleSetNode = new NodeRef("rule://set/node/fake");
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs((NodeRef)ArgumentMatchers.any())).willReturn(List.of(RuleServiceImplUnitTest.createAssociation(fakeRuleSetNode, RULE_NODE)));
        boolean associated = this.ruleService.isRuleAssociatedWithRuleSet(RULE_NODE, RULE_SET_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(RULE_NODE);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((boolean)associated).isFalse();
    }

    @Test
    public void testIsRuleSetShared() {
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs((NodeRef)ArgumentMatchers.any())).willReturn(List.of(RuleServiceImplUnitTest.createAssociation(FOLDER_NODE, RULE_SET_NODE, false)));
        boolean shared = this.ruleService.isRuleSetShared(RULE_SET_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(RULE_SET_NODE);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((boolean)shared).isTrue();
    }

    @Test
    public void testIsRuleSetShared_notShared() {
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs((NodeRef)ArgumentMatchers.any())).willReturn(List.of(RuleServiceImplUnitTest.createAssociation(FOLDER_NODE, RULE_SET_NODE)));
        boolean shared = this.ruleService.isRuleSetShared(RULE_SET_NODE);
        ((NodeService)BDDMockito.then((Object)this.runtimeNodeService).should()).getParentAssocs(RULE_SET_NODE);
        BDDMockito.then((Object)this.runtimeNodeService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeService).shouldHaveNoInteractions();
        Assertions.assertThat((boolean)shared).isFalse();
    }

    private static ChildAssociationRef createAssociation(NodeRef parentRef, NodeRef childRef) {
        return RuleServiceImplUnitTest.createAssociation(parentRef, childRef, true);
    }

    private static ChildAssociationRef createAssociation(NodeRef parentRef, NodeRef childRef, boolean isPrimary) {
        return new ChildAssociationRef(null, parentRef, null, childRef, isPrimary, 1);
    }

    @Test
    public void testGetNodesSupplyingRuleSets_chain() {
        Map<String, NodeRef> nodes = this.createParentChildHierarchy("A,B", "B,C", "C,D", "D,E");
        List actual = this.ruleService.getNodesSupplyingRuleSets(nodes.get("E"));
        Map invertedMap = MapUtils.invertMap(nodes);
        String nodeNames = actual.stream().map(invertedMap::get).collect(Collectors.joining(","));
        Assert.assertEquals((String)"Node names should match expected string", (Object)"A,B,C,D,E", (Object)nodeNames);
    }

    @Test
    public void testGetNodesSupplyingRuleSets_multipleParents() {
        Map<String, NodeRef> nodes = this.createParentChildHierarchy("A,E", "B,E", "C,E", "D,E");
        List actual = this.ruleService.getNodesSupplyingRuleSets(nodes.get("E"));
        Map invertedMap = MapUtils.invertMap(nodes);
        String nodeNames = actual.stream().map(invertedMap::get).collect(Collectors.joining(","));
        Assert.assertEquals((String)"Node names should match expected string", (Object)"A,B,C,D,E", (Object)nodeNames);
    }

    @Test
    public void testGetNodesSupplyingRuleSets_brokenChain() {
        Map<String, NodeRef> nodes = this.createParentChildHierarchy("A,B", "B,C", "C,D", "D,E");
        BDDMockito.given((Object)this.runtimeNodeService.hasAspect(nodes.get("C"), RuleModel.ASPECT_IGNORE_INHERITED_RULES)).willReturn((Object)true);
        List actual = this.ruleService.getNodesSupplyingRuleSets(nodes.get("E"));
        Map invertedMap = MapUtils.invertMap(nodes);
        String nodeNames = actual.stream().map(invertedMap::get).collect(Collectors.joining(","));
        Assert.assertEquals((String)"Node names should match expected string", (Object)"C,D,E", (Object)nodeNames);
    }

    @Test
    public void testGetNodesSupplyingRuleSets_userGroupHierarchy() {
        Map<String, NodeRef> nodes = this.createParentChildHierarchy("A,B", "B,C", "C,D", "D,E");
        ChildAssociationRef memberAssoc = new ChildAssociationRef(ContentModel.ASSOC_MEMBER, nodes.get("B"), ContentModel.TYPE_FOLDER, nodes.get("C"));
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs(nodes.get("C"))).willReturn(List.of(memberAssoc));
        List actual = this.ruleService.getNodesSupplyingRuleSets(nodes.get("E"));
        Map invertedMap = MapUtils.invertMap(nodes);
        String nodeNames = actual.stream().map(invertedMap::get).collect(Collectors.joining(","));
        Assert.assertEquals((String)"Node names should match expected string", (Object)"C,D,E", (Object)nodeNames);
    }

    @Test
    public void testGetNodesSupplyingRuleSets_infiniteCycle() {
        Map<String, NodeRef> nodes = this.createParentChildHierarchy("A,B", "B,C", "C,A");
        List actual = this.ruleService.getNodesSupplyingRuleSets(nodes.get("C"));
        Map invertedMap = MapUtils.invertMap(nodes);
        String nodeNames = actual.stream().map(invertedMap::get).collect(Collectors.joining(","));
        Assert.assertEquals((String)"Node names should match expected string", (Object)"A,B,C", (Object)nodeNames);
    }

    @Test
    public void testGetNodesSupplyingRuleSets_diamond() {
        Map<String, NodeRef> nodes = this.createParentChildHierarchy("A,B", "A,C", "B,D", "C,D");
        List actual = this.ruleService.getNodesSupplyingRuleSets(nodes.get("D"));
        Map invertedMap = MapUtils.invertMap(nodes);
        String nodeNames = actual.stream().map(invertedMap::get).collect(Collectors.joining(","));
        Assert.assertEquals((String)"Node names should match expected string", (Object)"A,B,C,D", (Object)nodeNames);
    }

    @Test
    public void testGetNodesSupplyingRuleSets_alphabetical() {
        Map<String, NodeRef> nodes = this.createParentChildHierarchy("A,B", "A,C", "A,D", "B,E", "C,F", "C,G", "D,F", "E,G", "F,G");
        List actual = this.ruleService.getNodesSupplyingRuleSets(nodes.get("G"));
        Map invertedMap = MapUtils.invertMap(nodes);
        String nodeNames = actual.stream().map(invertedMap::get).collect(Collectors.joining(","));
        Assert.assertEquals((String)"Node names should match expected string", (Object)"A,C,B,E,D,F,G", (Object)nodeNames);
    }

    @Test
    public void testGetNodesSupplyingRuleSets_reversedAssociationOrder() {
        Map<String, NodeRef> nodes = this.createParentChildHierarchy("F,G", "E,G", "D,F", "C,G", "C,F", "B,E", "A,D", "A,C", "A,B");
        List actual = this.ruleService.getNodesSupplyingRuleSets(nodes.get("G"));
        Map invertedMap = MapUtils.invertMap(nodes);
        String nodeNames = actual.stream().map(invertedMap::get).collect(Collectors.joining(","));
        Assert.assertEquals((String)"Node names should match expected string", (Object)"A,D,C,F,B,E,G", (Object)nodeNames);
    }

    private Map<String, NodeRef> createParentChildHierarchy(String ... parentChildAssociations) {
        HashSet nodeNames = new HashSet();
        List.of(parentChildAssociations).forEach(parentChildAssociation -> {
            String[] parentChildPair = parentChildAssociation.split(",");
            nodeNames.addAll(List.of(parentChildPair));
        });
        Map<String, NodeRef> nodeRefMap = nodeNames.stream().collect(Collectors.toMap(nodeName -> nodeName, nodeName -> new NodeRef("node://" + nodeName + "/")));
        nodeNames.forEach(nodeName -> {
            NodeRef nodeRef = (NodeRef)nodeRefMap.get(nodeName);
            List parentAssocs = List.of(parentChildAssociations).stream().filter(assoc -> assoc.endsWith((String)nodeName)).map(assoc -> assoc.split(",")[0]).map(nodeRefMap::get).map(parentRef -> new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentRef, ContentModel.TYPE_FOLDER, nodeRef)).collect(Collectors.toList());
            BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs(nodeRef)).willReturn(parentAssocs);
        });
        return nodeRefMap;
    }

    @Test
    public void testGetFoldersInheritingRuleSet() {
        NodeRef parent = new NodeRef("parent://node/");
        NodeRef ruleSetNode = new NodeRef("rule://set/");
        ChildAssociationRef ruleSetAssociation = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs(ruleSetNode)).willReturn(List.of(ruleSetAssociation));
        BDDMockito.given((Object)ruleSetAssociation.getParentRef()).willReturn((Object)parent);
        NodeRef child = new NodeRef("child://node/");
        ChildAssociationRef childAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.runtimeNodeService.getChildAssocs(parent, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)).willReturn(List.of(childAssocMock));
        BDDMockito.given((Object)childAssocMock.getChildRef()).willReturn((Object)child);
        BDDMockito.given((Object)this.runtimeNodeService.getType(child)).willReturn((Object)ContentModel.TYPE_FOLDER);
        List actual = this.ruleService.getFoldersInheritingRuleSet(ruleSetNode, 100);
        Assert.assertEquals((String)"Unexpected list of inheriting folders.", List.of(child), (Object)actual);
    }

    @Test
    public void testGetFoldersInheritingRuleSet_ignoreInheritedRules() {
        NodeRef parent = new NodeRef("parent://node/");
        NodeRef ruleSetNode = new NodeRef("rule://set/");
        ChildAssociationRef ruleSetAssociation = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs(ruleSetNode)).willReturn(List.of(ruleSetAssociation));
        BDDMockito.given((Object)ruleSetAssociation.getParentRef()).willReturn((Object)parent);
        NodeRef child = new NodeRef("child://node/");
        ChildAssociationRef childAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.runtimeNodeService.getChildAssocs(parent, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)).willReturn(List.of(childAssocMock));
        BDDMockito.given((Object)childAssocMock.getChildRef()).willReturn((Object)child);
        BDDMockito.given((Object)this.runtimeNodeService.getType(child)).willReturn((Object)ContentModel.TYPE_FOLDER);
        BDDMockito.given((Object)this.runtimeNodeService.hasAspect(child, RuleModel.ASPECT_IGNORE_INHERITED_RULES)).willReturn((Object)true);
        List actual = this.ruleService.getFoldersInheritingRuleSet(ruleSetNode, 100);
        Assert.assertEquals((String)"Unexpected list of inheriting folders.", Collections.emptyList(), (Object)actual);
    }

    @Test
    public void testGetFoldersExceedsLimit() {
        NodeRef root = new NodeRef("root://node/");
        NodeRef ruleSetNode = new NodeRef("rule://set/");
        ChildAssociationRef ruleSetAssociation = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs(ruleSetNode)).willReturn(List.of(ruleSetAssociation));
        BDDMockito.given((Object)ruleSetAssociation.getParentRef()).willReturn((Object)root);
        ArrayList<NodeRef> nodeChain = new ArrayList<NodeRef>();
        nodeChain.add(root);
        IntStream.range(0, 10).forEach(index -> {
            NodeRef parent = (NodeRef)nodeChain.get(nodeChain.size() - 1);
            NodeRef child = new NodeRef("chain://node/" + index);
            nodeChain.add(child);
            ChildAssociationRef childAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
            BDDMockito.given((Object)this.runtimeNodeService.getChildAssocs(parent, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)).willReturn(List.of(childAssocMock));
            BDDMockito.given((Object)childAssocMock.getChildRef()).willReturn((Object)child);
            BDDMockito.given((Object)this.runtimeNodeService.getType(child)).willReturn((Object)ContentModel.TYPE_FOLDER);
        });
        List actual = this.ruleService.getFoldersInheritingRuleSet(ruleSetNode, 9);
        Assert.assertEquals((String)"Unexpected list of inheriting folders.", nodeChain.subList(1, 10), (Object)actual);
    }

    @Test
    public void testGetFoldersInheritingRuleSet_ignoreFiles() {
        NodeRef parent = new NodeRef("parent://node/");
        NodeRef ruleSetNode = new NodeRef("rule://set/");
        ChildAssociationRef ruleSetAssociation = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs(ruleSetNode)).willReturn(List.of(ruleSetAssociation));
        BDDMockito.given((Object)ruleSetAssociation.getParentRef()).willReturn((Object)parent);
        NodeRef childDocument = new NodeRef("child://document/");
        ChildAssociationRef childAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.runtimeNodeService.getChildAssocs(parent, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)).willReturn(List.of(childAssocMock));
        BDDMockito.given((Object)childAssocMock.getChildRef()).willReturn((Object)childDocument);
        BDDMockito.given((Object)this.runtimeNodeService.getType(childDocument)).willReturn((Object)ContentModel.TYPE_CONTENT);
        List actual = this.ruleService.getFoldersInheritingRuleSet(ruleSetNode, 100);
        Assert.assertEquals((String)"Unexpected list of inheriting folders.", Collections.emptyList(), (Object)actual);
    }

    @Test
    public void testGetFoldersInheritingRuleSet_omitFoldersWithoutReadPermission() {
        NodeRef grandparent = new NodeRef("grandparent://node/");
        NodeRef ruleSetNode = new NodeRef("rule://set/");
        ChildAssociationRef ruleSetAssociation = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.runtimeNodeService.getParentAssocs(ruleSetNode)).willReturn(List.of(ruleSetAssociation));
        BDDMockito.given((Object)ruleSetAssociation.getParentRef()).willReturn((Object)grandparent);
        NodeRef parent = new NodeRef("parent://node/");
        ChildAssociationRef parentAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.runtimeNodeService.getChildAssocs(grandparent, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)).willReturn(List.of(parentAssocMock));
        BDDMockito.given((Object)parentAssocMock.getChildRef()).willReturn((Object)parent);
        BDDMockito.given((Object)this.runtimeNodeService.getType(parent)).willReturn((Object)ContentModel.TYPE_FOLDER);
        NodeRef child = new NodeRef("child://node/");
        ChildAssociationRef childAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.runtimeNodeService.getChildAssocs(grandparent, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)).willReturn(List.of(childAssocMock));
        BDDMockito.given((Object)childAssocMock.getChildRef()).willReturn((Object)child);
        BDDMockito.given((Object)this.runtimeNodeService.getType(child)).willReturn((Object)ContentModel.TYPE_FOLDER);
        BDDMockito.given((Object)this.permissionService.hasReadPermission(parent)).willReturn((Object)AccessStatus.DENIED);
        List actual = this.ruleService.getFoldersInheritingRuleSet(ruleSetNode, 100);
        Assert.assertEquals((String)"Unexpected list of inheriting folders.", List.of(child), (Object)actual);
    }

    @Test
    public void testGetFoldersLinkingToRuleSet() {
        NodeRef ruleSetNode = new NodeRef("rule://set/");
        NodeRef owningFolder = new NodeRef("owning://folder/");
        ChildAssociationRef owningAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)owningAssocMock.getParentRef()).willReturn((Object)owningFolder);
        BDDMockito.given((Object)this.nodeService.getPrimaryParent(ruleSetNode)).willReturn((Object)owningAssocMock);
        NodeRef linkingFolder = new NodeRef("linking://folder/");
        ChildAssociationRef linkingAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)linkingAssocMock.getParentRef()).willReturn((Object)linkingFolder);
        BDDMockito.given((Object)this.nodeService.getParentAssocs(ruleSetNode)).willReturn(List.of(owningAssocMock, linkingAssocMock));
        List linkingFolders = this.ruleService.getFoldersLinkingToRuleSet(ruleSetNode, 100);
        Assert.assertEquals((String)"Unexpected list of linking folders.", List.of(linkingFolder), (Object)linkingFolders);
    }

    @Test
    public void testGetFoldersLinkingToRuleSet_respectsPermissions() {
        NodeRef ruleSetNode = new NodeRef("rule://set/");
        NodeRef owningFolder = new NodeRef("owning://folder/");
        ChildAssociationRef owningAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)owningAssocMock.getParentRef()).willReturn((Object)owningFolder);
        BDDMockito.given((Object)this.nodeService.getPrimaryParent(ruleSetNode)).willReturn((Object)owningAssocMock);
        NodeRef linkingFolder = new NodeRef("linking://folder/");
        ChildAssociationRef linkingAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)linkingAssocMock.getParentRef()).willReturn((Object)linkingFolder);
        BDDMockito.given((Object)this.nodeService.getParentAssocs(ruleSetNode)).willReturn(List.of(owningAssocMock, linkingAssocMock));
        BDDMockito.given((Object)this.permissionService.hasReadPermission(linkingFolder)).willReturn((Object)AccessStatus.DENIED);
        List linkingFolders = this.ruleService.getFoldersLinkingToRuleSet(ruleSetNode, 100);
        Assert.assertEquals((String)"Unexpected list of linking folders.", Collections.emptyList(), (Object)linkingFolders);
    }
}

