/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.concurrent.TimeUnit;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event2.AbstractContextAwareRepoEvent;
import org.alfresco.repo.event2.EventGeneratorTest;
import org.awaitility.Awaitility;
import org.junit.Test;

public class EventGeneratorDisabledTest
extends EventGeneratorTest {
    @Test
    public void shouldNotReceiveEvent2EventsOnNodeCreation() {
        if (this.eventGenerator.isEnabled()) {
            this.eventGenerator.disable();
        }
        this.createNode(ContentModel.TYPE_CONTENT);
        Awaitility.await().pollDelay(6L, TimeUnit.SECONDS).until(() -> this.receivedEvents.size() == 0);
        EventGeneratorDisabledTest.assertTrue((AbstractContextAwareRepoEvent.EVENT_CONTAINER.getEvents().size() == 0 ? 1 : 0) != 0);
        EventGeneratorDisabledTest.assertTrue((this.receivedEvents.size() == 0 ? 1 : 0) != 0);
        this.eventGenerator.enable();
    }

    @Override
    @Test
    public void shouldReceiveEvent2EventsOnNodeCreation() {
        if (!this.eventGenerator.isEnabled()) {
            this.eventGenerator.enable();
        }
        super.shouldReceiveEvent2EventsOnNodeCreation();
    }

    @Override
    @Test
    public void shouldReceiveEvent2EventsInOrder() {
        if (!this.eventGenerator.isEnabled()) {
            this.eventGenerator.enable();
        }
        super.shouldReceiveEvent2EventsInOrder();
    }
}

