/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.contentdata;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.content.cleanup.EagerContentStoreCleaner;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.contentdata.ContentDataEntity;
import org.alfresco.repo.domain.contentdata.ContentUrlEntity;
import org.alfresco.repo.domain.contentdata.ContentUrlKeyEntity;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.encoding.EncodingDAO;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.mimetype.MimetypeDAO;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;

public abstract class AbstractContentDataDAOImpl
implements ContentDataDAO {
    private static final String CACHE_REGION_CONTENT_DATA = "ContentData";
    private static final String CACHE_REGION_CONTENT_URL = "ContentUrl";
    private static final String KEY_PRE_COMMIT_CONTENT_URL_DELETIONS = "AbstractContentDataDAOImpl.PreCommitContentUrlDeletions";
    private static Log logger = LogFactory.getLog(AbstractContentDataDAOImpl.class);
    private final ContentDataCallbackDAO contentDataCallbackDAO = new ContentDataCallbackDAO();
    private final ContentUrlCallbackDAO contentUrlCallbackDAO = new ContentUrlCallbackDAO();
    protected ControlDAO controlDAO;
    protected MimetypeDAO mimetypeDAO;
    protected EncodingDAO encodingDAO;
    protected LocaleDAO localeDAO;
    private EagerContentStoreCleaner contentStoreCleaner;
    private EntityLookupCache<Long, ContentData, Serializable> contentDataCache = new EntityLookupCache<Long, ContentData, Serializable>(this.contentDataCallbackDAO);
    private EntityLookupCache<Long, ContentUrlEntity, String> contentUrlCache = new EntityLookupCache<Long, ContentUrlEntity, String>(this.contentUrlCallbackDAO);

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    public void setMimetypeDAO(MimetypeDAO mimetypeDAO) {
        this.mimetypeDAO = mimetypeDAO;
    }

    public void setEncodingDAO(EncodingDAO encodingDAO) {
        this.encodingDAO = encodingDAO;
    }

    public void setLocaleDAO(LocaleDAO localeDAO) {
        this.localeDAO = localeDAO;
    }

    public void setContentStoreCleaner(EagerContentStoreCleaner contentStoreCleaner) {
        this.contentStoreCleaner = contentStoreCleaner;
    }

    public void setContentDataCache(SimpleCache<Long, ContentData> contentDataCache) {
        this.contentDataCache = new EntityLookupCache<Long, ContentData, Serializable>(contentDataCache, CACHE_REGION_CONTENT_DATA, this.contentDataCallbackDAO);
    }

    public void setContentUrlCache(SimpleCache<Long, ContentUrlEntity> contentUrlCache) {
        this.contentUrlCache = new EntityLookupCache<Long, ContentUrlEntity, String>(contentUrlCache, CACHE_REGION_CONTENT_URL, this.contentUrlCallbackDAO);
    }

    protected void registerDereferencedContentUrl(String contentUrl) {
        Set contentUrls = TransactionalResourceHelper.getSet(KEY_PRE_COMMIT_CONTENT_URL_DELETIONS);
        if (contentUrls.size() == 0) {
            ContentUrlDeleteTransactionListener listener = new ContentUrlDeleteTransactionListener();
            AlfrescoTransactionSupport.bindListener((TransactionListener)listener);
        }
        contentUrls.add(contentUrl);
    }

    @Override
    public Pair<Long, ContentData> createContentData(ContentData contentData) {
        if (contentData == null) {
            throw new IllegalArgumentException("ContentData values cannot be null");
        }
        Pair<Long, ContentData> entityPair = this.contentDataCache.getOrCreateByValue(contentData);
        return entityPair;
    }

    @Override
    public Pair<Long, ContentData> getContentData(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up ContentData by null ID.");
        }
        Pair<Long, ContentData> entityPair = this.contentDataCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No ContentData value exists for ID " + String.valueOf(id));
        }
        return entityPair;
    }

    private boolean updateContentUrl(ContentUrlEntity contentUrl) {
        int result = 0;
        if (contentUrl == null) {
            throw new IllegalArgumentException("Cannot look up ContentData by null ID.");
        }
        Pair<Long, ContentUrlEntity> pair = this.contentUrlCache.getByValue(contentUrl);
        if (pair != null) {
            result = this.contentUrlCache.updateValue((Long)pair.getFirst(), contentUrl);
        } else {
            pair = this.contentUrlCache.getOrCreateByValue(contentUrl);
            result = this.contentUrlCache.updateValue((Long)pair.getFirst(), contentUrl);
        }
        return result == 1;
    }

    @Override
    public ContentUrlEntity getContentUrl(String contentUrl) {
        if (contentUrl == null) {
            throw new IllegalArgumentException("Cannot look up ContentData by null ID.");
        }
        ContentUrlEntity entity = new ContentUrlEntity();
        entity.setContentUrl(contentUrl);
        Pair<Long, ContentUrlEntity> pair = this.contentUrlCache.getByValue(entity);
        return pair == null ? null : (ContentUrlEntity)pair.getSecond();
    }

    @Override
    public ContentUrlEntity getContentUrl(Long contentUrlId) {
        if (contentUrlId == null) {
            throw new IllegalArgumentException("Cannot look up ContentData by null ID.");
        }
        Pair<Long, ContentUrlEntity> pair = this.contentUrlCache.getByKey(contentUrlId);
        return pair == null ? null : (ContentUrlEntity)pair.getSecond();
    }

    @Override
    public void cacheContentDataForNodes(Set<Long> nodeIds) {
        for (ContentDataEntity entity : this.getContentDataEntitiesForNodes(nodeIds)) {
            this.contentDataCache.setValue(entity.getId(), this.makeContentData(entity));
        }
    }

    @Override
    public void updateContentData(Long id, ContentData contentData) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up ContentData by null ID.");
        }
        if (contentData == null) {
            throw new IllegalArgumentException("Cannot update ContentData with a null.");
        }
        int updated = this.contentDataCache.updateValue(id, contentData = this.sanitizeMimetype(contentData));
        if (updated < 1) {
            throw new ConcurrencyFailureException("ContentData with ID " + String.valueOf(id) + " not updated");
        }
    }

    private ContentData sanitizeMimetype(ContentData contentData) {
        String mimetype = contentData.getMimetype();
        if (mimetype != null) {
            mimetype = mimetype.toLowerCase();
            contentData = ContentData.setMimetype((ContentData)contentData, (String)mimetype);
        }
        return contentData;
    }

    @Override
    public void deleteContentData(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot delete ContentData by null ID.");
        }
        int deleted = this.contentDataCache.deleteByKey(id);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("ContentData with ID " + String.valueOf(id) + " no longer exists");
        }
    }

    private ContentData makeContentData(ContentDataEntity contentDataEntity) {
        Long contentUrlId = contentDataEntity.getContentUrlId();
        String contentUrl = null;
        if (contentUrlId != null) {
            Pair<Long, ContentUrlEntity> entityPair = this.contentUrlCache.getByKey(contentUrlId);
            if (entityPair == null) {
                throw new DataIntegrityViolationException("No ContentUrl value exists for ID " + String.valueOf(contentUrlId));
            }
            ContentUrlEntity contentUrlEntity = (ContentUrlEntity)entityPair.getSecond();
            contentUrl = contentUrlEntity.getContentUrl();
        }
        long size = contentDataEntity.getSize() == null ? 0L : contentDataEntity.getSize();
        Long mimetypeId = contentDataEntity.getMimetypeId();
        String mimetype = null;
        if (mimetypeId != null) {
            mimetype = (String)this.mimetypeDAO.getMimetype(mimetypeId).getSecond();
        }
        Long encodingId = contentDataEntity.getEncodingId();
        String encoding = null;
        if (encodingId != null) {
            encoding = (String)this.encodingDAO.getEncoding(encodingId).getSecond();
        }
        Long localeId = contentDataEntity.getLocaleId();
        Locale locale = null;
        if (localeId != null) {
            locale = (Locale)this.localeDAO.getLocalePair(localeId).getSecond();
        }
        ContentData contentData = new ContentData(contentUrl, mimetype, size, encoding, locale);
        return contentData;
    }

    protected ContentDataEntity createContentDataEntity(ContentData contentData) {
        Long contentUrlId = null;
        String contentUrl = contentData.getContentUrl();
        long size = contentData.getSize();
        if (contentUrl != null) {
            ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
            contentUrlEntity.setContentUrl(contentUrl);
            contentUrlEntity.setSize(size);
            Pair<Long, ContentUrlEntity> pair = this.contentUrlCache.getCachedEntityByValue(contentUrlEntity);
            if (pair == null) {
                pair = this.contentUrlCache.createOrGetByValue(contentUrlEntity, this.controlDAO);
            }
            contentUrlId = (Long)pair.getFirst();
        }
        Long mimetypeId = null;
        String mimetype = contentData.getMimetype();
        if (mimetype != null) {
            mimetypeId = (Long)this.mimetypeDAO.getOrCreateMimetype(mimetype).getFirst();
        }
        Long encodingId = null;
        String encoding = contentData.getEncoding();
        if (encoding != null) {
            encodingId = (Long)this.encodingDAO.getOrCreateEncoding(encoding).getFirst();
        }
        Long localeId = null;
        Locale locale = contentData.getLocale();
        if (locale != null) {
            localeId = (Long)this.localeDAO.getOrCreateLocalePair(locale).getFirst();
        }
        ContentDataEntity contentDataEntity = this.createContentDataEntity(contentUrlId, mimetypeId, encodingId, localeId);
        return contentDataEntity;
    }

    protected int updateContentDataEntity(ContentDataEntity contentDataEntity, ContentData contentData) {
        String newContentUrl;
        String oldContentUrl;
        Long oldContentUrlId = contentDataEntity.getContentUrlId();
        ContentUrlEntity contentUrlEntity = null;
        if (oldContentUrlId != null) {
            Pair<Long, ContentUrlEntity> entityPair = this.contentUrlCache.getByKey(oldContentUrlId);
            if (entityPair == null) {
                throw new DataIntegrityViolationException("No ContentUrl value exists for ID " + String.valueOf(oldContentUrlId));
            }
            contentUrlEntity = (ContentUrlEntity)entityPair.getSecond();
        }
        if (!EqualsHelper.nullSafeEquals((Object)(oldContentUrl = contentUrlEntity != null ? contentUrlEntity.getContentUrl() : null), (Object)(newContentUrl = contentData.getContentUrl()))) {
            if (oldContentUrl != null) {
                this.registerDereferencedContentUrl(oldContentUrl);
            }
            if (newContentUrl != null) {
                if (contentUrlEntity == null) {
                    contentUrlEntity = new ContentUrlEntity();
                    contentUrlEntity.setContentUrl(newContentUrl);
                }
                Pair<Long, ContentUrlEntity> pair = this.contentUrlCache.getOrCreateByValue(contentUrlEntity);
                Long newContentUrlId = (Long)pair.getFirst();
                contentUrlEntity.setId(newContentUrlId);
                contentDataEntity.setContentUrlId(newContentUrlId);
            } else {
                contentDataEntity.setId(null);
                contentDataEntity.setContentUrlId(null);
            }
        }
        Long mimetypeId = null;
        String mimetype = contentData.getMimetype();
        if (mimetype != null) {
            mimetypeId = (Long)this.mimetypeDAO.getOrCreateMimetype(mimetype).getFirst();
        }
        Long encodingId = null;
        String encoding = contentData.getEncoding();
        if (encoding != null) {
            encodingId = (Long)this.encodingDAO.getOrCreateEncoding(encoding).getFirst();
        }
        Long localeId = null;
        Locale locale = contentData.getLocale();
        if (locale != null) {
            localeId = (Long)this.localeDAO.getOrCreateLocalePair(locale).getFirst();
        }
        contentDataEntity.setMimetypeId(mimetypeId);
        contentDataEntity.setEncodingId(encodingId);
        contentDataEntity.setLocaleId(localeId);
        return this.updateContentDataEntity(contentDataEntity);
    }

    @Override
    public boolean updateContentUrlKey(String contentUrl, ContentUrlKeyEntity contentUrlKey) {
        ContentUrlEntity existing = this.getContentUrl(contentUrl);
        if (existing == null) {
            existing = this.getOrCreateContentUrl(contentUrl, contentUrlKey.getUnencryptedFileSize());
        }
        ContentUrlEntity entity = ContentUrlEntity.setContentUrlKey(existing, contentUrlKey);
        return this.updateContentUrl(entity);
    }

    @Override
    public boolean updateContentUrlKey(long contentUrlId, ContentUrlKeyEntity contentUrlKey) {
        boolean success = true;
        ContentUrlEntity existing = this.getContentUrl(contentUrlId);
        if (existing != null) {
            ContentUrlEntity entity = ContentUrlEntity.setContentUrlKey(existing, contentUrlKey);
            this.updateContentUrl(entity);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No content url, not updating symmetric key");
            }
            success = false;
        }
        return success;
    }

    @Override
    public ContentUrlEntity getOrCreateContentUrl(String contentUrl) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl);
        Pair<Long, ContentUrlEntity> pair = this.contentUrlCache.getOrCreateByValue(contentUrlEntity);
        Long newContentUrlId = (Long)pair.getFirst();
        contentUrlEntity.setId(newContentUrlId);
        return contentUrlEntity;
    }

    @Override
    public ContentUrlEntity getOrCreateContentUrl(String contentUrl, long size) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl);
        contentUrlEntity.setSize(size);
        Pair<Long, ContentUrlEntity> pair = this.contentUrlCache.getOrCreateByValue(contentUrlEntity);
        Long newContentUrlId = (Long)pair.getFirst();
        contentUrlEntity.setId(newContentUrlId);
        return contentUrlEntity;
    }

    protected abstract ContentUrlEntity createContentUrlEntity(String var1, long var2, ContentUrlKeyEntity var4);

    protected abstract ContentUrlEntity getContentUrlEntity(Long var1);

    protected abstract ContentUrlEntity getContentUrlEntity(String var1);

    protected abstract ContentUrlEntity getContentUrlEntityUnreferenced(String var1);

    protected abstract int updateContentUrlOrphanTime(Long var1, Long var2, Long var3);

    protected abstract ContentDataEntity createContentDataEntity(Long var1, Long var2, Long var3, Long var4);

    protected abstract ContentDataEntity getContentDataEntity(Long var1);

    protected abstract List<ContentDataEntity> getContentDataEntitiesForNodes(Set<Long> var1);

    protected abstract int updateContentDataEntity(ContentDataEntity var1);

    protected abstract int deleteContentDataEntity(Long var1);

    protected abstract int deleteContentUrlEntity(long var1);

    protected abstract int updateContentUrlEntity(ContentUrlEntity var1, ContentUrlEntity var2);

    private class ContentDataCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, ContentData, Serializable> {
        private ContentDataCallbackDAO() {
        }

        @Override
        public Pair<Long, ContentData> createValue(ContentData value) {
            value = AbstractContentDataDAOImpl.this.sanitizeMimetype(value);
            ContentDataEntity contentDataEntity = AbstractContentDataDAOImpl.this.createContentDataEntity(value);
            return new Pair((Object)contentDataEntity.getId(), (Object)value);
        }

        @Override
        public Pair<Long, ContentData> findByKey(Long key) {
            ContentDataEntity contentDataEntity = AbstractContentDataDAOImpl.this.getContentDataEntity(key);
            if (contentDataEntity == null) {
                return null;
            }
            ContentData contentData = AbstractContentDataDAOImpl.this.makeContentData(contentDataEntity);
            return new Pair((Object)key, (Object)contentData);
        }

        @Override
        public int updateValue(Long key, ContentData value) {
            ContentDataEntity contentDataEntity = AbstractContentDataDAOImpl.this.getContentDataEntity(key);
            if (contentDataEntity == null) {
                return 0;
            }
            return AbstractContentDataDAOImpl.this.updateContentDataEntity(contentDataEntity, value);
        }

        @Override
        public int deleteByKey(Long key) {
            return AbstractContentDataDAOImpl.this.deleteContentDataEntity(key);
        }
    }

    private class ContentUrlCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, ContentUrlEntity, String> {
        private ContentUrlCallbackDAO() {
        }

        @Override
        public String getValueKey(ContentUrlEntity value) {
            return value.getContentUrl();
        }

        @Override
        public Pair<Long, ContentUrlEntity> findByValue(ContentUrlEntity entity) {
            String contentUrl = entity.getContentUrl();
            ContentUrlEntity ret = AbstractContentDataDAOImpl.this.getContentUrlEntity(contentUrl);
            if (ret != null && !entity.getContentUrl().equals(ret.getContentUrl())) {
                throw new IllegalArgumentException("Collision detected for this contentURL. '" + entity.getContentUrl() + "' collides with existing contentURL '" + ret.getContentUrl() + "'. (ContentUrlShort;ContentUrlCrc) pair collision: ('" + entity.getContentUrlShort() + "';'" + entity.getContentUrlCrc() + "')");
            }
            return ret != null ? new Pair((Object)ret.getId(), (Object)ret) : null;
        }

        @Override
        public Pair<Long, ContentUrlEntity> createValue(ContentUrlEntity value) {
            ContentUrlEntity contentUrlEntity = AbstractContentDataDAOImpl.this.createContentUrlEntity(value.getContentUrl(), value.getSize(), value.getContentUrlKey());
            return new Pair((Object)contentUrlEntity.getId(), (Object)contentUrlEntity);
        }

        @Override
        public Pair<Long, ContentUrlEntity> findByKey(Long id) {
            ContentUrlEntity contentUrlEntity = AbstractContentDataDAOImpl.this.getContentUrlEntity(id);
            if (contentUrlEntity == null) {
                return null;
            }
            return new Pair((Object)contentUrlEntity.getId(), (Object)contentUrlEntity);
        }

        @Override
        public int updateValue(Long id, ContentUrlEntity value) {
            ContentUrlEntity contentUrlEntity = AbstractContentDataDAOImpl.this.getContentUrlEntity(id);
            if (contentUrlEntity == null) {
                return 0;
            }
            return AbstractContentDataDAOImpl.this.updateContentUrlEntity(contentUrlEntity, value);
        }

        @Override
        public int deleteByKey(Long id) {
            return AbstractContentDataDAOImpl.this.deleteContentUrlEntity(id);
        }
    }

    public class ContentUrlDeleteTransactionListener
    extends TransactionListenerAdapter {
        public void beforeCommit(boolean readOnly) {
            if (readOnly) {
                return;
            }
            Set<String> contentUrls = TransactionalResourceHelper.getSet(AbstractContentDataDAOImpl.KEY_PRE_COMMIT_CONTENT_URL_DELETIONS);
            long orphanTime = System.currentTimeMillis();
            for (String contentUrl : contentUrls) {
                List<Long> contentUrlId;
                ContentUrlEntity contentUrlEntity = AbstractContentDataDAOImpl.this.getContentUrlEntityUnreferenced(contentUrl);
                if (contentUrlEntity == null) continue;
                boolean isEagerCleanup = AbstractContentDataDAOImpl.this.contentStoreCleaner.registerOrphanedContentUrl(contentUrl);
                if (!isEagerCleanup) {
                    contentUrlId = contentUrlEntity.getId();
                    Long oldOrphanTime = contentUrlEntity.getOrphanTime();
                    int updated = AbstractContentDataDAOImpl.this.updateContentUrlOrphanTime((Long)((Object)contentUrlId), orphanTime, oldOrphanTime);
                    if (updated == 1) continue;
                    throw new ConcurrencyFailureException("Failed to update content URL orphan time: " + String.valueOf(contentUrlEntity));
                }
                contentUrlId = Collections.singletonList(contentUrlEntity.getId());
                int deleted = AbstractContentDataDAOImpl.this.deleteContentUrls(contentUrlId);
                if (deleted == 1) continue;
                throw new ConcurrencyFailureException("Failed to delete eagerly-reaped content URL: " + String.valueOf(contentUrlEntity));
            }
            contentUrls.clear();
        }
    }
}

