/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ActualEnvironmentException;
import org.alfresco.repo.virtual.AlfrescoAPIFacet;
import org.alfresco.repo.virtual.AlfrescoScriptVirtualContext;
import org.alfresco.repo.virtual.VirtualContext;
import org.alfresco.repo.virtual.config.NodeRefResolver;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ChildAssocsSlice;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AlfrescoEnviroment
implements ActualEnvironment {
    private AlfrescoAPIFacet apiFacet;
    private ServiceRegistry serviceRegistry;
    private NamespacePrefixResolver namespacePrefixResolver;
    private Repository repositoryHelper;
    private NodeRefResolver nodeRefResolver;

    public void setNodeRefResolver(NodeRefResolver nodeRefResolver) {
        this.nodeRefResolver = nodeRefResolver;
    }

    public void setAlfrescoAPIFacet(AlfrescoAPIFacet apiFacet) {
        this.apiFacet = apiFacet;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setRepositoryHelper(Repository repository) {
        this.repositoryHelper = repository;
    }

    @Override
    public Object executeScript(String classpath, Map<String, Object> model) {
        return this.apiFacet.getScriptService().executeScript(new ClasspathScriptLocation(classpath.substring(1)), model);
    }

    @Override
    public Object executeScript(NodeRef templateNodeRef, Map<String, Object> model) {
        return this.apiFacet.getScriptService().executeScript(templateNodeRef, null, model);
    }

    @Override
    public boolean hasAspect(NodeRef nodeRef, QName aspectTypeQName) {
        return this.apiFacet.getNodeService().hasAspect(nodeRef, aspectTypeQName);
    }

    @Override
    public Set<QName> getAspects(NodeRef nodeRef) {
        NodeService nodeService = this.apiFacet.getNodeService();
        return nodeService.getAspects(nodeRef);
    }

    @Override
    public NodeRef getTargetAssocs(NodeRef nodeRef, QName associationQName) {
        List assocs = this.apiFacet.getNodeService().getTargetAssocs(nodeRef, (QNamePattern)associationQName);
        if (assocs != null && assocs.size() >= 1) {
            AssociationRef associationRef = (AssociationRef)assocs.get(0);
            NodeRef targetRef = associationRef.getTargetRef();
            return targetRef;
        }
        return null;
    }

    @Override
    public Serializable getProperty(NodeRef nodeRef, QName qname) {
        return this.apiFacet.getNodeService().getProperty(nodeRef, qname);
    }

    @Override
    public Map<QName, Serializable> getProperties(NodeRef nodeRef) {
        return this.apiFacet.getNodeService().getProperties(nodeRef);
    }

    @Override
    public InputStream openContentStream(NodeRef nodeRef) throws ActualEnvironmentException {
        ContentReader contentReader = this.apiFacet.getContentService().getReader(nodeRef, ContentModel.PROP_CONTENT);
        return contentReader.getContentInputStream();
    }

    @Override
    public InputStream openContentStream(String classpath) throws ActualEnvironmentException {
        return this.getClass().getResourceAsStream(classpath);
    }

    @Override
    public ResultSet query(SearchParameters searchParameters) {
        return this.apiFacet.getSearchService().query(searchParameters);
    }

    @Override
    public Object createScriptVirtualContext(VirtualContext context) throws ActualEnvironmentException {
        return new AlfrescoScriptVirtualContext(context, this.serviceRegistry);
    }

    @Override
    public QName getType(NodeRef nodeRef) {
        return this.apiFacet.getNodeService().getType(nodeRef);
    }

    @Override
    public boolean isSubClass(QName className, QName ofClassName) {
        return this.apiFacet.getDictionaryService().isSubClass(className, ofClassName);
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    @Override
    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }

    @Override
    public String getCurrentUser() {
        return this.serviceRegistry.getAuthenticationService().getCurrentUserName();
    }

    @Override
    public Path getPath(NodeRef nodeRef) {
        return this.apiFacet.getNodeService().getPath(nodeRef);
    }

    @Override
    public ChildAssociationRef getPrimaryParent(NodeRef nodeRef) {
        NodeService nodeService = this.apiFacet.getNodeService();
        return nodeService.getPrimaryParent(nodeRef);
    }

    @Override
    public ChildAssocsSlice getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern, int skipResults, int maxResults, boolean preload) throws InvalidNodeRefException {
        NodeService nodeService = this.apiFacet.getNodeService();
        return nodeService.getChildAssocs(nodeRef, typeQNamePattern, qnamePattern, skipResults, maxResults, preload);
    }

    @Override
    public NodeRef findNodeRef(String referenceType, String[] reference) {
        return this.repositoryHelper.findNodeRef(referenceType, reference);
    }

    @Override
    public boolean exists(NodeRef nodeRef) {
        return this.apiFacet.getNodeService().exists(nodeRef);
    }

    @Override
    public NodeRef getChildByName(NodeRef nodeRef, QName assocTypeQName, String childName) {
        return this.apiFacet.getNodeService().getChildByName(nodeRef, assocTypeQName, childName);
    }

    @Override
    public void delete(NodeRef nodeRef) {
        this.apiFacet.getNodeService().deleteNode(nodeRef);
    }

    @Override
    public FileInfo create(NodeRef parentNodeRef, String name, QName typeQName) throws FileExistsException {
        return this.apiFacet.getFileFolderService().create(parentNodeRef, name, typeQName);
    }

    @Override
    public ContentWriter getWriter(NodeRef nodeRef, QName propertyQName, boolean update) throws InvalidNodeRefException, InvalidTypeException {
        return this.apiFacet.getContentService().getWriter(nodeRef, propertyQName, update);
    }

    @Override
    public void addAspect(NodeRef nodeRef, QName aspectTypeQName, Map<QName, Serializable> aspectProperties) throws InvalidNodeRefException, InvalidAspectException {
        this.apiFacet.getNodeService().addAspect(nodeRef, aspectTypeQName, aspectProperties);
    }

    @Override
    public NodeRef findQNamePath(String[] patheElements) {
        return this.nodeRefResolver.resolveQNameReference(patheElements);
    }

    @Override
    public boolean exists(String classpath) {
        ClassLoader cl = this.getClass().getClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(cl);
        Resource resource = resolver.getResource("classpath:" + classpath);
        return resource.exists();
    }

    @Override
    public boolean hasPermission(NodeRef nodeRef, String perm) {
        return this.apiFacet.getPermissionService().hasPermission(nodeRef, perm).equals((Object)AccessStatus.ALLOWED);
    }
}

