/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ScriptPagingDetails
extends PagingRequest {
    private int totalItems = -1;
    private int totalItemsRangeMax = -1;
    private ItemsSizeConfidence confidence = ItemsSizeConfidence.UNKNOWN;

    public ScriptPagingDetails() {
        super(-1, null);
    }

    public ScriptPagingDetails(int maxItems, int skipCount) {
        this(maxItems, skipCount, null);
    }

    public ScriptPagingDetails(int maxItems, int skipCount, String queryExecutionId) {
        super(skipCount, maxItems, queryExecutionId);
    }

    public ScriptPagingDetails(PagingRequest paging) {
        super(paging.getSkipCount(), paging.getMaxItems(), paging.getQueryExecutionId());
        this.setRequestTotalCountMax(paging.getRequestTotalCountMax());
    }

    public ScriptPagingDetails(WebScriptRequest req, int maxResultCount) throws WebScriptException {
        this(ScriptPagingDetails.buildPagingRequest(req, maxResultCount));
    }

    public static PagingRequest buildPagingRequest(WebScriptRequest req, int maxResultCount) throws WebScriptException {
        String startIndexS;
        int pageSize = maxResultCount;
        int startIndex = 0;
        String queryId = req.getParameter("queryId");
        String pageSizeS = req.getParameter("pageSize");
        if (pageSizeS != null) {
            try {
                pageSize = Integer.parseInt(pageSizeS);
            }
            catch (NumberFormatException numberFormatException) {
                throw new WebScriptException(400, "Paging size parameters invalid");
            }
        }
        if ((startIndexS = req.getParameter("startIndex")) != null) {
            try {
                startIndex = Integer.parseInt(startIndexS);
            }
            catch (NumberFormatException numberFormatException) {
                throw new WebScriptException(400, "Paging size parameters invalid");
            }
        }
        String pageNumberS = req.getParameter("page");
        if (pageNumberS != null) {
            try {
                int pageNumber = Integer.parseInt(pageNumberS);
                startIndex = (pageNumber - 1) * pageSize;
            }
            catch (NumberFormatException numberFormatException) {
                throw new WebScriptException(400, "Paging size parameters invalid");
            }
        }
        PagingRequest paging = new PagingRequest(startIndex, pageSize, queryId);
        paging.setRequestTotalCountMax(Math.max(10 * pageSize, startIndex + 2 * pageSize));
        return paging;
    }

    public ItemsSizeConfidence getConfidence() {
        return this.confidence;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(int totalItems) {
        this.totalItems = totalItems;
        this.confidence = totalItems >= 0 ? ItemsSizeConfidence.EXACT : ItemsSizeConfidence.UNKNOWN;
    }

    public <R> void setTotalItems(PagingResults<R> results) {
        if (results.getTotalResultCount() == null) {
            this.totalItems = -1;
            this.confidence = ItemsSizeConfidence.UNKNOWN;
        } else {
            Integer min = (Integer)results.getTotalResultCount().getFirst();
            Integer max = (Integer)results.getTotalResultCount().getSecond();
            if (min == null) {
                this.totalItems = -1;
                this.confidence = ItemsSizeConfidence.UNKNOWN;
            } else if (max == null) {
                this.totalItems = min;
                this.confidence = ItemsSizeConfidence.AT_LEAST;
            } else if (min.equals(max)) {
                this.totalItems = min;
                this.confidence = ItemsSizeConfidence.EXACT;
            } else {
                this.totalItems = min;
                this.totalItemsRangeMax = max;
                this.confidence = ItemsSizeConfidence.RANGE;
            }
        }
        this.setQueryExecutionId(results.getQueryExecutionId());
    }

    public int getTotalItemsRangeMax() {
        return this.totalItemsRangeMax;
    }

    public void setMaxItems(int maxItems) {
        super.setMaxItems(maxItems);
    }

    public void setSkipCount(int skipCount) {
        super.setSkipCount(skipCount);
    }

    public void setQueryExecutionId(String queryExecutionId) {
        super.setQueryExecutionId(queryExecutionId);
    }

    public static enum ItemsSizeConfidence {
        EXACT,
        RANGE,
        AT_LEAST,
        UNKNOWN;

    }
}

