/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy.annotation;

import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
public class QNameTypeEditorTest {
    private static final String TEST_CONFIG_LOCATION = "classpath:org/alfresco/repo/policy/annotation/test-qname-type-editor-context.xml";
    private static final String[] CONFIG_LOCATIONS = (String[])ArrayUtils.add((Object[])ApplicationContextHelper.CONFIG_LOCATIONS, (Object)"classpath:org/alfresco/repo/policy/annotation/test-qname-type-editor-context.xml");
    private static ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext((String[])CONFIG_LOCATIONS);

    @Test
    public void testPopulateBeanWithNamespace() throws Exception {
        QNameContainer qNameContainer = (QNameContainer)applicationContext.getBean("qNameContainerWithNamespace");
        QName expectedQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"namespacedName");
        Assert.assertEquals((String)"Loading String as QName failed.", (Object)expectedQName, (Object)qNameContainer.getQName());
    }

    @Test
    public void testPopulateBeanWithoutNamespace() throws Exception {
        QNameContainer qNameContainer = (QNameContainer)applicationContext.getBean("qNameContainerNoNamespace");
        QName expectedQName = QName.createQName((String)"noNamespaceName");
        Assert.assertEquals((String)"Loading String as QName failed.", (Object)expectedQName, (Object)qNameContainer.getQName());
    }

    @AfterClass
    public static void tidyAfterTestClass() {
        ApplicationContextHelper.closeApplicationContext();
        applicationContext = null;
    }

    public static class QNameContainer {
        private QName qName;

        public void setQName(QName qName) {
            this.qName = qName;
        }

        public QName getQName() {
            return this.qName;
        }
    }
}

