/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema.script;

import java.util.List;
import javax.sql.DataSource;
import org.alfresco.repo.domain.schema.script.ScriptBundleExecutor;
import org.alfresco.repo.domain.schema.script.ScriptBundleExecutorImpl;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

public class ScriptBundleExecutorImplIntegrationTest {
    private static ApplicationContext ctx;
    private ScriptBundleExecutor bundleExecutor;
    private DataSource dataSource;
    private JdbcTemplate jdbcTmpl;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        String[] config = new String[]{"classpath:alfresco/application-context.xml", "classpath:scriptexec/script-exec-test.xml"};
        ctx = ApplicationContextHelper.getApplicationContext((String[])config);
    }

    @Before
    public void setUp() throws Exception {
        this.bundleExecutor = (ScriptBundleExecutor)ctx.getBean("bundleExecutor", ScriptBundleExecutorImpl.class);
        this.dataSource = (DataSource)ctx.getBean("dataSource", DataSource.class);
        this.jdbcTmpl = new JdbcTemplate(this.dataSource);
    }

    @Test
    public void canExecuteBundle() {
        this.bundleExecutor.exec("scriptexec/${db.script.dialect}/bundle", new String[]{"script_a.sql", "script_b.sql", "script_c.sql"});
        String select = "select message from alf_test_bundle order by message asc";
        List res = this.jdbcTmpl.queryForList(select, String.class);
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertEquals((Object)"script_a message 2", res.get(0));
        Assert.assertEquals((Object)"script_b", res.get(1));
    }

    @Test
    public void postScriptIsRunFinallyEvenAfterEarlierFailure() {
        this.bundleExecutor.execWithPostScript("scriptexec/${db.script.dialect}/bundle2", "post_script.sql", new String[]{"script_a.sql", "script_b.sql"});
        String select = "select message from alf_test_bundle2 order by message asc";
        List res = this.jdbcTmpl.queryForList(select, String.class);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((Object)"script_a message 2", res.get(0));
    }
}

