/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.alfresco.config.JndiPropertiesFactoryBean;
import org.alfresco.repo.management.subsystems.AbstractPropertyBackedBean;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.management.subsystems.CompositeDataBean;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRegistry;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanState;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanWithMonitor;
import org.alfresco.util.ResourceFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;

public class ChildApplicationContextFactory
extends AbstractPropertyBackedBean
implements ApplicationContextFactory,
PropertyBackedBeanWithMonitor {
    private static final String TYPE_NAME_PROPERTY = "$type";
    private static final String INSTANCE_PATH_PROPERTY = "instancePath";
    private static final String PROPERTIES_SUFFIX = "/*.properties";
    private static final String CONTEXT_SUFFIX = "/*-context.xml";
    private static final String ENTERPRISE_CONTEXT_SUFFIX = "/*-enterprise-context.xml";
    private static final String CLASSPATH_PREFIX = "classpath*:alfresco/subsystems/";
    private static final String EXTENSION_CLASSPATH_PREFIX = "classpath*:alfresco/extension/subsystems/";
    private static Log logger = LogFactory.getLog(ChildApplicationContextFactory.class);
    private String typeName;
    private Map<String, Class<?>> compositePropertyTypes = Collections.emptyMap();
    private PropertiesPersister persister = new DefaultPropertiesPersister();
    private Object monitor;

    public ChildApplicationContextFactory() {
    }

    public ChildApplicationContextFactory(ApplicationContext parent, PropertyBackedBeanRegistry registry, Properties propertyDefaults, Properties encryptedPropertyDefaults, String category, String typeName, List<String> instancePath) throws IOException {
        this.setApplicationContext(parent);
        this.setRegistry(registry);
        this.setPropertyDefaults(propertyDefaults);
        this.setEncryptedPropertyDefaults(encryptedPropertyDefaults);
        this.setCategory(category);
        this.setTypeName(typeName);
        this.setInstancePath(instancePath);
        try {
            this.afterPropertiesSet();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setCompositePropertyTypes(Map<String, Class<?>> compositePropertyTypes) {
        this.compositePropertyTypes = compositePropertyTypes;
    }

    public PropertiesPersister getPersister() {
        return this.persister;
    }

    public void setPersister(PropertiesPersister persister) {
        this.persister = persister;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        List<String> idList = this.getInstancePath();
        if (idList.isEmpty()) {
            throw new IllegalStateException("Invalid instance path");
        }
        if (this.getTypeName() == null) {
            this.setTypeName(idList.get(0));
        }
        super.afterPropertiesSet();
        if (new ResourceFinder((ResourceLoader)this.getParent()).getResources(this.getContextResourcePatterns()).length == 0) {
            throw new IllegalStateException("Invalid type " + this.getTypeName() + " specified for " + this.getCategory() + " subsystem. No context file found");
        }
    }

    @Override
    protected PropertyBackedBeanState createInitialState() throws IOException {
        return new ApplicationContextState(false);
    }

    @Override
    protected void applyDefaultOverrides(PropertyBackedBeanState state) throws IOException {
        super.applyDefaultOverrides(state);
        List<String> idList = this.getId();
        JndiPropertiesFactoryBean overrideFactory = new JndiPropertiesFactoryBean();
        overrideFactory.setPropertiesPersister(this.getPersister());
        overrideFactory.setSystemPropertiesMode(2);
        overrideFactory.setLocations(this.getParent().getResources(EXTENSION_CLASSPATH_PREFIX + this.getCategory() + "/" + this.getTypeName() + "/" + idList.get(idList.size() - 1) + PROPERTIES_SUFFIX));
        overrideFactory.setProperties(((ApplicationContextState)state).properties);
        overrideFactory.afterPropertiesSet();
        ((ApplicationContextState)state).properties = overrideFactory.getObject();
    }

    @Override
    public boolean isUpdateable(String name) {
        if (name.equals(TYPE_NAME_PROPERTY)) {
            return false;
        }
        return !name.equals(INSTANCE_PATH_PROPERTY);
    }

    @Override
    public String getDescription(String name) {
        if (name.equals(TYPE_NAME_PROPERTY)) {
            return "Read-only subsystem type name";
        }
        if (name.equals(INSTANCE_PATH_PROPERTY)) {
            return "Read-only instance path";
        }
        if (this.compositePropertyTypes.containsKey(name)) {
            return "Comma separated list of child object names";
        }
        return super.getDescription(name);
    }

    @Override
    protected void destroy(boolean permanent) {
        if (this.getState(false) != null) {
            boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
            if (!hadWriteLock) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
            }
            try {
                ApplicationContextState state = (ApplicationContextState)this.getState(false);
                if (state != null) {
                    state.destroy(permanent);
                }
                super.destroy(permanent);
            }
            finally {
                if (!hadWriteLock) {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
        } else {
            super.destroy(permanent);
        }
    }

    public ApplicationContext getReadOnlyApplicationContext() {
        this.lock.readLock().lock();
        try {
            ApplicationContext applicationContext = ((ApplicationContextState)this.getState(false)).getApplicationContext();
            return applicationContext;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ApplicationContext getApplicationContext() {
        this.lock.readLock().lock();
        try {
            ApplicationContext applicationContext = ((ApplicationContextState)this.getState(true)).getApplicationContext();
            return applicationContext;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private String[] getContextResourcePatterns() {
        return new String[]{CLASSPATH_PREFIX + this.getCategory() + "/" + this.getTypeName() + CONTEXT_SUFFIX, CLASSPATH_PREFIX + this.getCategory() + "/" + this.getTypeName() + ENTERPRISE_CONTEXT_SUFFIX, EXTENSION_CLASSPATH_PREFIX + this.getCategory() + "/" + this.getTypeName() + "/" + this.getId().get(this.getId().size() - 1) + CONTEXT_SUFFIX};
    }

    @Override
    public Object getMonitorObject() {
        return this.monitor;
    }

    protected class ApplicationContextState
    implements PropertyBackedBeanState {
        private boolean allowInitAccess = false;
        private Properties properties;
        private Map<String, Map<String, CompositeDataBean>> compositeProperties = new TreeMap<String, Map<String, CompositeDataBean>>();
        private ClassPathXmlApplicationContext applicationContext;
        private RuntimeException lastStartupError;

        protected ApplicationContextState(boolean allowInitAccess) throws IOException {
            this.allowInitAccess = allowInitAccess;
            PropertiesFactoryBean factory = new PropertiesFactoryBean();
            factory.setPropertiesPersister(ChildApplicationContextFactory.this.getPersister());
            factory.setLocations(ChildApplicationContextFactory.this.getParent().getResources(ChildApplicationContextFactory.CLASSPATH_PREFIX + ChildApplicationContextFactory.this.getCategory() + "/" + ChildApplicationContextFactory.this.getTypeName() + ChildApplicationContextFactory.PROPERTIES_SUFFIX));
            factory.afterPropertiesSet();
            this.properties = factory.getObject();
        }

        @Override
        public Set<String> getPropertyNames() {
            TreeSet<String> result = new TreeSet<String>(this.properties.keySet());
            result.add(ChildApplicationContextFactory.TYPE_NAME_PROPERTY);
            result.add(ChildApplicationContextFactory.INSTANCE_PATH_PROPERTY);
            result.addAll(ChildApplicationContextFactory.this.compositePropertyTypes.keySet());
            return result;
        }

        @Override
        public String getProperty(String name) {
            if (name.equals(ChildApplicationContextFactory.TYPE_NAME_PROPERTY)) {
                return ChildApplicationContextFactory.this.getTypeName();
            }
            if (name.equals(ChildApplicationContextFactory.INSTANCE_PATH_PROPERTY)) {
                return ChildApplicationContextFactory.this.getInstancePath().toString();
            }
            if (ChildApplicationContextFactory.this.compositePropertyTypes.containsKey(name)) {
                Map<String, CompositeDataBean> beans = this.compositeProperties.get(name);
                if (beans != null) {
                    StringBuilder list = new StringBuilder(100);
                    for (String id : beans.keySet()) {
                        if (list.length() > 0) {
                            list.append(',');
                        }
                        list.append(id);
                    }
                    return list.toString();
                }
                return "";
            }
            return this.properties.getProperty(name);
        }

        @Override
        public void setProperty(String name, String value) {
            if (name.equals(ChildApplicationContextFactory.TYPE_NAME_PROPERTY)) {
                throw new IllegalStateException("Illegal write to property \"$type\"");
            }
            if (name.equals(ChildApplicationContextFactory.INSTANCE_PATH_PROPERTY)) {
                throw new IllegalStateException("Illegal write to property \"instancePath\"");
            }
            this.lastStartupError = null;
            Class<?> type = ChildApplicationContextFactory.this.compositePropertyTypes.get(name);
            if (type != null) {
                this.updateCompositeProperty(name, value, type);
            } else {
                this.properties.setProperty(name, value);
            }
        }

        private void updateCompositeProperty(String name, String value, Class<?> type) {
            Map<String, CompositeDataBean> propertyValues = this.compositeProperties.get(name);
            if (propertyValues == null) {
                propertyValues = Collections.emptyMap();
            }
            try {
                LinkedHashMap<String, CompositeDataBean> newPropertyValues = new LinkedHashMap<String, CompositeDataBean>(11);
                StringTokenizer tkn = new StringTokenizer(value, ", \t\n\r\f");
                while (tkn.hasMoreTokens()) {
                    String id = tkn.nextToken();
                    ArrayList<String> childPath = new ArrayList<String>(4);
                    childPath.addAll(ChildApplicationContextFactory.this.getInstancePath());
                    childPath.add(name);
                    childPath.add(id);
                    CompositeDataBean child = propertyValues.get(id);
                    if (child == null) {
                        child = new CompositeDataBean(ChildApplicationContextFactory.this.getParent(), ChildApplicationContextFactory.this, ChildApplicationContextFactory.this.getRegistry(), ChildApplicationContextFactory.this.getPropertyDefaults(), ChildApplicationContextFactory.this.getCategory(), type, childPath);
                    }
                    newPropertyValues.put(id, child);
                }
                TreeSet<String> idsToRemove = new TreeSet<String>(propertyValues.keySet());
                idsToRemove.removeAll(newPropertyValues.keySet());
                for (String id : idsToRemove) {
                    CompositeDataBean child = propertyValues.get(id);
                    child.lock.writeLock().lock();
                    try {
                        child.destroy(true);
                    }
                    finally {
                        child.lock.writeLock().unlock();
                    }
                }
                this.compositeProperties.put(name, newPropertyValues);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void removeProperty(String name) {
            if (name.equals(ChildApplicationContextFactory.TYPE_NAME_PROPERTY)) {
                throw new IllegalStateException("Illegal write to property \"$type\"");
            }
            this.lastStartupError = null;
            Class<?> type = ChildApplicationContextFactory.this.compositePropertyTypes.get(name);
            if (type != null) {
                throw new UnsupportedOperationException();
            }
            this.properties.remove(name);
        }

        @Override
        public void start() {
            if (this.applicationContext == null) {
                if (this.lastStartupError != null) {
                    throw this.lastStartupError;
                }
                Properties prop = new Properties();
                prop.putAll((Map<?, ?>)this.properties);
                prop.put(ChildApplicationContextFactory.INSTANCE_PATH_PROPERTY, ChildApplicationContextFactory.this.getInstancePath().toString());
                logger.info((Object)("Starting '" + ChildApplicationContextFactory.this.getCategory() + "' subsystem, ID: " + String.valueOf(ChildApplicationContextFactory.this.getId())));
                ChildApplicationContextFactory childApplicationContextFactory = ChildApplicationContextFactory.this;
                childApplicationContextFactory.getClass();
                ChildApplicationContext applicationContext = childApplicationContextFactory.new ChildApplicationContext(prop, this.compositeProperties);
                try {
                    if (this.allowInitAccess) {
                        this.applicationContext = applicationContext;
                    }
                    applicationContext.refresh();
                    this.applicationContext = applicationContext;
                    logger.info((Object)("Startup of '" + ChildApplicationContextFactory.this.getCategory() + "' subsystem, ID: " + String.valueOf(ChildApplicationContextFactory.this.getId()) + " complete"));
                    if (applicationContext.containsBean("monitor")) {
                        Object m;
                        logger.debug((Object)"got a monitor object");
                        ChildApplicationContextFactory.this.monitor = m = applicationContext.getBean("monitor");
                    }
                }
                catch (RuntimeException e) {
                    logger.warn((Object)("Startup of '" + ChildApplicationContextFactory.this.getCategory() + "' subsystem, ID: " + String.valueOf(ChildApplicationContextFactory.this.getId()) + " failed"), (Throwable)e);
                    this.lastStartupError = e;
                    throw e;
                }
            }
        }

        @Override
        public void stop() {
            if (this.applicationContext != null) {
                logger.info((Object)("Stopping '" + ChildApplicationContextFactory.this.getCategory() + "' subsystem, ID: " + String.valueOf(ChildApplicationContextFactory.this.getId())));
                try {
                    this.applicationContext.close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                this.applicationContext = null;
                logger.info((Object)("Stopped '" + ChildApplicationContextFactory.this.getCategory() + "' subsystem, ID: " + String.valueOf(ChildApplicationContextFactory.this.getId())));
            }
        }

        public void destroy(boolean permanent) {
            for (Map<String, CompositeDataBean> beans : this.compositeProperties.values()) {
                for (CompositeDataBean bean : beans.values()) {
                    bean.lock.writeLock().lock();
                    try {
                        bean.destroy(permanent);
                    }
                    finally {
                        bean.lock.writeLock().unlock();
                    }
                }
            }
        }

        public ApplicationContext getReadOnlyApplicationContext() {
            return this.applicationContext;
        }

        public ApplicationContext getApplicationContext() {
            return this.getApplicationContext(true);
        }

        public ApplicationContext getApplicationContext(boolean start) {
            if (start) {
                this.start();
            }
            return this.applicationContext;
        }
    }

    private class ChildApplicationContext
    extends ClassPathXmlApplicationContext {
        private Map<String, Map<String, CompositeDataBean>> compositeProperties;

        private ChildApplicationContext(Properties properties, Map<String, Map<String, CompositeDataBean>> compositeProperties) throws BeansException {
            super(ChildApplicationContextFactory.this.getContextResourcePatterns(), false, ChildApplicationContextFactory.this.getParent());
            this.compositeProperties = compositeProperties;
            PropertyPlaceholderConfigurer configurer = new PropertyPlaceholderConfigurer();
            configurer.setPropertiesArray(new Properties[]{ChildApplicationContextFactory.this.getPropertyDefaults(), properties});
            configurer.setIgnoreUnresolvablePlaceholders(true);
            configurer.setSearchSystemEnvironment(false);
            this.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
            this.setClassLoader(ChildApplicationContextFactory.this.getParent().getClassLoader());
        }

        protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            beanFactory.addBeanPostProcessor(new BeanPostProcessor(){

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    if (bean instanceof ListFactoryBean && ((ChildApplicationContext)ChildApplicationContext.this).ChildApplicationContextFactory.this.compositePropertyTypes.containsKey(beanName)) {
                        List beanList;
                        Map<String, CompositeDataBean> beans = ChildApplicationContext.this.compositeProperties.get(beanName);
                        if (beans != null) {
                            beanList = new ArrayList(beans.size());
                            for (CompositeDataBean wrapped : beans.values()) {
                                beanList.add(wrapped.getBean());
                            }
                        } else {
                            beanList = Collections.emptyList();
                        }
                        ((ListFactoryBean)bean).setSourceList(beanList);
                    }
                    return bean;
                }
            });
        }

        public void publishEvent(ApplicationEvent event) {
            Assert.notNull((Object)event, (String)"Event must not be null");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Publishing event in " + this.getDisplayName() + ": " + String.valueOf(event)));
            }
            ((ApplicationEventMulticaster)this.getBean("applicationEventMulticaster")).multicastEvent(event);
            if (this.getParent() != null && !(event instanceof ContextRefreshedEvent) && !(event instanceof ContextClosedEvent)) {
                this.getParent().publishEvent(event);
            }
        }
    }
}

