/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.replication;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.action.ActionCancelledException;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.replication.ReplicationDefinitionImpl;
import org.alfresco.repo.replication.ReplicationDefinitionPersisterImpl;
import org.alfresco.repo.replication.ReplicationParams;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.ChildAssociatedNodeFinder;
import org.alfresco.repo.transfer.ContentClassFilter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.replication.DisabledReplicationJobException;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.transfer.NodeCrawler;
import org.alfresco.service.cmr.transfer.NodeCrawlerFactory;
import org.alfresco.service.cmr.transfer.TransferCallback;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEndEvent;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferEventBegin;
import org.alfresco.service.cmr.transfer.TransferEventCancelled;
import org.alfresco.service.cmr.transfer.TransferEventEnterState;
import org.alfresco.service.cmr.transfer.TransferEventError;
import org.alfresco.service.cmr.transfer.TransferFailureException;
import org.alfresco.service.cmr.transfer.TransferService2;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class ReplicationActionExecutor
extends ActionExecuterAbstractBase {
    private static final String MSG_ERR_TARGET_NOT_GIVEN = "replication.targetNotGiven";
    private static final String MSG_ERR_NO_PAYLOADS_SPECIFIED = "replication.exception.noPayloadsSpecified";
    private static final String MSG_ERR_REPLICATION_DEF_DISABLED = "replication.exception.replicationDefIsDisabled";
    private static final String MSG_ERR_UNABLE_TO_REPLICATE = "replication.exception.unableToReplicate";
    private static final String MSG_ERR_PROCESSING_PAYLOAD = "replication.exception.errorProcessingPayload";
    private static final String MSG_ERR_EXECUTING_TRANSFER = "replication.exception.errorExecutingTransfer";
    private static Log logger = LogFactory.getLog(ReplicationActionExecutor.class);
    private NodeService nodeService;
    private JobLockService jobLockService;
    private TransferService2 transferService;
    private NodeCrawlerFactory nodeCrawlerFactory;
    private ActionTrackingService actionTrackingService;
    private TransactionService transactionService;
    private ReplicationDefinitionPersisterImpl replicationDefinitionPersister;
    private ReplicationParams replicationParams;
    private List<QName> excludedAspects = new ArrayList<QName>();
    private long replicationActionLockDuration = 60000L;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setTransferService(TransferService2 transferService) {
        this.transferService = transferService;
    }

    public void setNodeCrawlerFactory(NodeCrawlerFactory nodeCrawlerFactory) {
        this.nodeCrawlerFactory = nodeCrawlerFactory;
    }

    public void setActionTrackingService(ActionTrackingService actionTrackingService) {
        this.actionTrackingService = actionTrackingService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setReplicationDefinitionPersister(ReplicationDefinitionPersisterImpl replicationDefinitionPersister) {
        this.replicationDefinitionPersister = replicationDefinitionPersister;
    }

    public void setReplicationParams(ReplicationParams replicationParams) {
        this.replicationParams = replicationParams;
    }

    public void setExcludedAspects(String[] excludedAspects) {
        String[] stringArray = excludedAspects;
        int n = excludedAspects.length;
        int n2 = 0;
        while (n2 < n) {
            String aspect = stringArray[n2];
            this.excludedAspects.add(QName.createQName((String)aspect));
            ++n2;
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }

    protected Set<NodeRef> expandPayload(ReplicationDefinition replicationDef) {
        HashSet<NodeRef> toTransfer = new HashSet<NodeRef>(89);
        NodeCrawler crawler = this.nodeCrawlerFactory.getNodeCrawler();
        crawler.setNodeFinders(new ChildAssociatedNodeFinder(ContentModel.ASSOC_CONTAINS, RenditionModel.ASSOC_RENDITION));
        crawler.setNodeFilters(new ContentClassFilter(ContentModel.TYPE_FOLDER, ContentModel.TYPE_CONTENT, ContentModel.TYPE_THUMBNAIL));
        for (NodeRef payload : replicationDef.getPayload()) {
            if (this.nodeService.exists(payload)) {
                Set<NodeRef> crawledNodes = crawler.crawl(payload);
                toTransfer.addAll(crawledNodes);
                continue;
            }
            logger.warn((Object)("Skipping replication of non-existant node " + String.valueOf(payload)));
        }
        return toTransfer;
    }

    protected TransferDefinition buildTransferDefinition(ReplicationDefinition replicationDef, Set<NodeRef> toTransfer) {
        TransferDefinition transferDefinition = new TransferDefinition();
        transferDefinition.setNodes(toTransfer);
        transferDefinition.setSync(true);
        transferDefinition.setReadOnly(this.replicationParams.getTransferReadOnly());
        transferDefinition.setExcludedAspects(this.excludedAspects);
        return transferDefinition;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        Set<NodeRef> toTransfer;
        ReplicationDefinition replicationDef;
        if (!(action instanceof ReplicationDefinition) && action.getActionDefinitionName().equals("replicationActionExecutor")) {
            action = new ReplicationDefinitionImpl(action);
        }
        if ((replicationDef = (ReplicationDefinition)action).getTargetName() == null || replicationDef.getTargetName().equals("")) {
            throw new ReplicationServiceException(I18NUtil.getMessage((String)MSG_ERR_TARGET_NOT_GIVEN));
        }
        if (replicationDef.getPayload().size() == 0) {
            throw new ReplicationServiceException(I18NUtil.getMessage((String)MSG_ERR_NO_PAYLOADS_SPECIFIED));
        }
        if (!replicationDef.isEnabled()) {
            throw new DisabledReplicationJobException(I18NUtil.getMessage((String)MSG_ERR_REPLICATION_DEF_DISABLED));
        }
        if (!this.replicationParams.isEnabled()) {
            throw new ReplicationServiceException(I18NUtil.getMessage((String)MSG_ERR_UNABLE_TO_REPLICATE));
        }
        ReplicationDefinitionLockExtender lock = new ReplicationDefinitionLockExtender(replicationDef);
        try {
            toTransfer = this.expandPayload(replicationDef);
        }
        catch (Exception e) {
            lock.close();
            throw new ReplicationServiceException(I18NUtil.getMessage((String)MSG_ERR_PROCESSING_PAYLOAD, (Object[])new Object[]{e.getMessage()}), e);
        }
        TransferEndEvent endEvent = null;
        try {
            try {
                TransferDefinition transferDefinition = this.buildTransferDefinition(replicationDef, toTransfer);
                endEvent = this.transferService.transfer(replicationDef.getTargetName(), transferDefinition, lock);
                if (endEvent instanceof TransferEventCancelled) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Cancelling replication job");
                    }
                    throw new ActionCancelledException(replicationDef);
                }
                replicationDef.setLocalTransferReport(endEvent.getSourceReport());
                replicationDef.setRemoteTransferReport(endEvent.getDestinationReport());
                this.replicationDefinitionPersister.saveReplicationDefinition(replicationDef);
            }
            catch (Exception e) {
                if (e instanceof ActionCancelledException) {
                    this.writeDefinitionReports(replicationDef, endEvent.getSourceReport(), endEvent.getDestinationReport());
                    throw (ActionCancelledException)((Object)e);
                }
                if (e instanceof TransferFailureException) {
                    TransferEventError failureEndEvent = ((TransferFailureException)((Object)e)).getErrorEvent();
                    this.writeDefinitionReports(replicationDef, failureEndEvent.getSourceReport(), failureEndEvent.getDestinationReport());
                    Throwable cause = e.getCause() == null ? e : e.getCause();
                    throw new ReplicationServiceException(I18NUtil.getMessage((String)MSG_ERR_EXECUTING_TRANSFER, (Object[])new Object[]{cause.getMessage()}), cause);
                }
                this.writeDefinitionReports(replicationDef, null, null);
                throw new ReplicationServiceException(I18NUtil.getMessage((String)MSG_ERR_EXECUTING_TRANSFER, (Object[])new Object[]{e.getMessage()}), e);
            }
        }
        finally {
            lock.close();
        }
    }

    private void writeDefinitionReports(final ReplicationDefinition replicationDef, NodeRef sourceReport, NodeRef destinationReport) {
        replicationDef.setLocalTransferReport(sourceReport);
        replicationDef.setRemoteTransferReport(destinationReport);
        if (replicationDef.getNodeRef() != null) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Exception - writing replication def reports");
                    }
                    ReplicationActionExecutor.this.replicationDefinitionPersister.saveReplicationDefinition(replicationDef);
                    return null;
                }
            }, false, true);
        }
    }

    @Override
    public boolean onLogException(Log logger, Throwable t, String message) {
        if (t instanceof ActionCancelledException || t instanceof DisabledReplicationJobException) {
            logger.debug((Object)message);
            return true;
        }
        return false;
    }

    protected class ReplicationDefinitionLockExtender
    implements TransferCallback,
    JobLockService.JobLockRefreshCallback {
        private ReplicationDefinition replicationDef;
        private String transferId;
        private String lockToken;
        private boolean active;

        protected ReplicationDefinitionLockExtender(ReplicationDefinition replicationDef) {
            this.replicationDef = replicationDef;
            this.acquireLock();
        }

        @Override
        public void processEvent(TransferEvent event) {
            if (event instanceof TransferEventEnterState) {
                return;
            }
            if (event instanceof TransferEventBegin) {
                this.transferId = ((TransferEventBegin)event).getTransferId();
            }
            this.checkCancel();
        }

        public void close() {
            this.releaseLock();
        }

        private void acquireLock() {
            block3: {
                try {
                    this.lockToken = ReplicationActionExecutor.this.jobLockService.getLock(this.replicationDef.getReplicationQName(), ReplicationActionExecutor.this.replicationActionLockDuration, 5000L, 6);
                    this.active = true;
                    ReplicationActionExecutor.this.jobLockService.refreshLock(this.lockToken, this.replicationDef.getReplicationQName(), ReplicationActionExecutor.this.replicationActionLockDuration, this);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("lock aquired:" + String.valueOf(this.replicationDef.getReplicationQName())));
                    }
                }
                catch (LockAcquisitionException lockAcquisitionException) {
                    long retryTime = 30000L;
                    int retries = 60;
                    logger.debug((Object)("Unable to get the replication job lock on " + String.valueOf(this.replicationDef.getReplicationQName()) + ", retrying every " + (int)(retryTime / 1000L) + " seconds"));
                    this.active = true;
                    this.lockToken = ReplicationActionExecutor.this.jobLockService.getLock(this.replicationDef.getReplicationQName(), ReplicationActionExecutor.this.replicationActionLockDuration, retryTime, retries);
                    ReplicationActionExecutor.this.jobLockService.refreshLock(this.lockToken, this.replicationDef.getReplicationQName(), ReplicationActionExecutor.this.replicationActionLockDuration, this);
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)("lock aquired (from long timeout):" + String.valueOf(this.replicationDef.getReplicationQName())));
                }
            }
        }

        private void releaseLock() {
            if (this.active) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("about to release lock:" + String.valueOf(this.replicationDef.getReplicationQName())));
                }
                ReplicationActionExecutor.this.jobLockService.releaseLock(this.lockToken, this.replicationDef.getReplicationQName());
                this.active = false;
            }
        }

        private void checkCancel() {
            if (ReplicationActionExecutor.this.actionTrackingService.isCancellationRequested(this.replicationDef)) {
                if (this.transferId != null) {
                    ReplicationActionExecutor.this.transferService.cancelAsync(this.transferId);
                    logger.debug((Object)("Replication cancel was requested for " + String.valueOf(this.replicationDef.getReplicationQName())));
                } else {
                    logger.warn((Object)"Unable to cancel replication as requested, as transfer has yet to reach a cancellable state");
                }
            }
        }

        @Override
        public boolean isActive() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("lock callback isActive:" + this.active + ", " + String.valueOf(this.replicationDef.getReplicationQName())));
            }
            return this.active;
        }

        @Override
        public void lockReleased() {
            logger.debug((Object)("lock released:" + String.valueOf(this.replicationDef.getReplicationQName())));
        }
    }
}

