/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import java.io.Serializable;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import org.alfresco.repo.domain.propval.PropertyDateValueEntity;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.util.Pair;
import org.junit.Assert;

public class PropValGenerator {
    private static final Random rand = new Random();
    private final PropertyValueDAO propertyValueDAO;
    private final DoubleGen doubleGen = new DoubleGen();
    private final DateGen dateGen = new DateGen();
    private final SerializableGen serGen = new SerializableGen();

    public PropValGenerator(PropertyValueDAO propertyValueDAO) {
        this.propertyValueDAO = propertyValueDAO;
    }

    public String createUniqueString() {
        return UUID.randomUUID().toString();
    }

    public Double createUniqueDouble() {
        return (Double)this.doubleGen.getUnusedValue();
    }

    public Date createUniqueDate() {
        return (Date)this.dateGen.getUnusedValue();
    }

    public Serializable createUniqueSerializable() {
        return (Serializable)this.serGen.getUnusedValue();
    }

    private class DateGen
    extends UniqueValueGenerator<Date> {
        private DateGen() {
        }

        @Override
        protected Date createValue() {
            Random rand = new Random();
            Date date = new Date(rand.nextLong());
            Date truncDate = PropertyDateValueEntity.truncateDate((Date)date);
            return truncDate;
        }

        @Override
        protected Pair<Long, Date> getExistingValue(Date value) {
            return PropValGenerator.this.propertyValueDAO.getPropertyDateValue(value);
        }
    }

    private class DoubleGen
    extends UniqueValueGenerator<Double> {
        private DoubleGen() {
        }

        @Override
        protected Double createValue() {
            return Math.pow(2.0, 32.0) + rand.nextDouble() * (Math.pow(2.0, 32.0) - Math.pow(2.0, 31.0));
        }

        @Override
        protected Pair<Long, Double> getExistingValue(Double value) {
            return PropValGenerator.this.propertyValueDAO.getPropertyDoubleValue(value);
        }
    }

    private static class MySerializable
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Long val = rand.nextLong();

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.val == null ? 0 : this.val.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MySerializable other = (MySerializable)obj;
            return !(this.val == null ? other.val != null : !this.val.equals(other.val));
        }
    }

    private class SerializableGen
    extends UniqueValueGenerator<Serializable> {
        private SerializableGen() {
        }

        @Override
        protected Serializable createValue() {
            return new MySerializable();
        }

        @Override
        protected Pair<Long, Serializable> getExistingValue(Serializable value) {
            return PropValGenerator.this.propertyValueDAO.getPropertyValue(value);
        }
    }

    private abstract class UniqueValueGenerator<T> {
        private final int maxTries = 5;

        private UniqueValueGenerator() {
        }

        protected abstract T createValue();

        protected abstract Pair<Long, T> getExistingValue(T var1);

        public T getUnusedValue() {
            int tries = 0;
            T value = null;
            boolean exists = true;
            while (exists) {
                if (++tries > 5) {
                    throw new RuntimeException("Unable to generate unused value in 5 tries.");
                }
                value = this.createValue();
                Assert.assertNotNull((String)"Value generator should not generate a null value, but did.", value);
                boolean bl = exists = this.getExistingValue(value) != null;
            }
            return value;
        }
    }
}

