/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.permissions.ACEType;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlEntry;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.SimpleAccessControlEntry;
import org.alfresco.repo.security.permissions.SimpleAccessControlListProperties;
import org.alfresco.repo.security.permissions.impl.AclChange;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.testing.category.DBTests;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class AclDaoComponentTest
extends TestCase {
    private static ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected PermissionServiceSPI permissionService;
    protected MutableAuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    protected NodeRef rootNodeRef;
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected ServiceRegistry serviceRegistry;
    protected NodeRef systemNodeRef;
    protected AuthenticationComponent authenticationComponent;
    protected ModelDAO permissionModelDAO;
    protected PersonService personService;
    protected AuthorityService authorityService;
    private AclDAO aclDaoComponent;
    private UserTransaction testTX;
    private TransactionService transactionService;

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        this.aclDaoComponent = (AclDAO)applicationContext.getBean("aclDAO");
        this.nodeService = (NodeService)applicationContext.getBean("nodeService");
        this.dictionaryService = (DictionaryService)applicationContext.getBean(ServiceRegistry.DICTIONARY_SERVICE.getLocalName());
        this.permissionService = (PermissionServiceSPI)applicationContext.getBean("permissionService");
        this.namespacePrefixResolver = (NamespacePrefixResolver)applicationContext.getBean(ServiceRegistry.NAMESPACE_SERVICE.getLocalName());
        this.authenticationService = (MutableAuthenticationService)applicationContext.getBean("authenticationService");
        this.authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        this.serviceRegistry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
        this.permissionModelDAO = (ModelDAO)applicationContext.getBean("permissionsModelDAO");
        this.personService = (PersonService)applicationContext.getBean("personService");
        this.authorityService = (AuthorityService)applicationContext.getBean("authorityService");
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        this.authenticationDAO = (MutableAuthenticationDao)applicationContext.getBean("authenticationDao");
        this.transactionService = (TransactionService)applicationContext.getBean("transactionComponent");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.nanoTime());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        QName children = ContentModel.ASSOC_CHILDREN;
        QName system = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"system");
        QName container = ContentModel.TYPE_CONTAINER;
        QName types = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"people");
        this.systemNodeRef = this.nodeService.createNode(this.rootNodeRef, children, system, container).getChildRef();
        NodeRef typesNodeRef = this.nodeService.createNode(this.systemNodeRef, children, types, container).getChildRef();
        Map<QName, Serializable> props = this.createPersonProperties("andy");
        this.nodeService.createNode(typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        props = this.createPersonProperties("lemur");
        this.nodeService.createNode(typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        if (this.authenticationDAO.userExists("andy")) {
            this.authenticationService.deleteAuthentication("andy");
        }
        this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        if (this.authenticationDAO.userExists("lemur")) {
            this.authenticationService.deleteAuthentication("lemur");
        }
        this.authenticationService.createAuthentication("lemur", "lemur".toCharArray());
        if (this.authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.deleteAuthentication(AuthenticationUtil.getAdminUserName());
        }
        this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    protected void tearDown() throws Exception {
        if (this.testTX.getStatus() == 0 || this.testTX.getStatus() == 1) {
            this.testTX.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    protected void runAs(String userName) {
        this.authenticationService.authenticate(userName, userName.toCharArray());
        AclDaoComponentTest.assertNotNull((Object)this.authenticationService.getCurrentUserName());
    }

    private Map<QName, Serializable> createPersonProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        return properties;
    }

    protected PermissionReference getPermission(String permission) {
        return this.permissionModelDAO.getPermissionReference(null, permission);
    }

    public void testCreateDefault() {
        Long id = this.aclDaoComponent.createAccessControlList();
        AccessControlListProperties aclProps = this.aclDaoComponent.getAccessControlListProperties(id);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclType(), (Object)ACLType.DEFINING);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclProps.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)aclProps.isVersioned(), (Object)Boolean.FALSE);
    }

    public void testCreateDefining() {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setVersioned(true);
        Acl aclProps = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclType(), (Object)ACLType.DEFINING);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclProps.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getAccessControlListProperties(aclProps.getId()), (Object)aclProps);
    }

    public void testGetCurrentACLChangeSet() throws HeuristicRollbackException, RollbackException, HeuristicMixedException, SystemException {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setVersioned(true);
        Long id = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        AccessControlListProperties aclProps = this.aclDaoComponent.getAccessControlListProperties(id);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclType(), (Object)ACLType.DEFINING);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclProps.getInherits(), (Object)Boolean.TRUE);
        final AtomicBoolean afterCommit = new AtomicBoolean();
        AlfrescoTransactionSupport.bindListener((TransactionListener)new TransactionListenerAdapter(){

            public void afterCommit() {
                AclDaoComponentTest.assertNotNull((Object)AclDaoComponentTest.this.aclDaoComponent.getCurrentChangeSetCommitTime());
                afterCommit.set(true);
            }
        });
        this.testTX.commit();
        Awaitility.await((String)"Commit time not null").atMost(3L, TimeUnit.SECONDS).untilAtomic(afterCommit, CoreMatchers.equalTo((Object)true));
    }

    public void testCreateShared() {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setVersioned(true);
        Acl aclProps = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclType(), (Object)ACLType.DEFINING);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclProps.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getAccessControlListProperties(aclProps.getId()), (Object)aclProps);
        Long shared = this.aclDaoComponent.getInheritedAccessControlList(aclProps.getId());
        AccessControlListProperties sharedProps = this.aclDaoComponent.getAccessControlListProperties(shared);
        AclDaoComponentTest.assertEquals((Object)sharedProps.getAclType(), (Object)ACLType.SHARED);
        AclDaoComponentTest.assertEquals((Object)sharedProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)sharedProps.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(aclProps.getId()), (Object)shared);
    }

    public void testCreateOld() {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.OLD);
        properties.setVersioned(false);
        Acl aclProps = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclType(), (Object)ACLType.OLD);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclProps.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getAccessControlListProperties(aclProps.getId()), (Object)aclProps);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(aclProps.getId()), null);
    }

    public void testFixed() {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.FIXED);
        properties.setVersioned(true);
        Acl aclProps = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties);
        Long id = aclProps.getId();
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclType(), (Object)ACLType.FIXED);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclProps.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getAccessControlListProperties(aclProps.getId()), (Object)aclProps);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(id), (Object)id);
    }

    public void testGlobal() {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.GLOBAL);
        properties.setVersioned(false);
        Acl aclProps = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties);
        Long id = aclProps.getId();
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclType(), (Object)ACLType.GLOBAL);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclProps.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getAccessControlListProperties(aclProps.getId()), (Object)aclProps);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(id), (Object)id);
    }

    public void testSimpleInheritFromDefining() {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setVersioned(true);
        Acl aclProps = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties);
        long id = aclProps.getId();
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclType(), (Object)ACLType.DEFINING);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclProps.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getAccessControlListProperties(Long.valueOf(id)), (Object)aclProps);
        SimpleAccessControlEntry ace1 = new SimpleAccessControlEntry();
        ace1.setAccessStatus(AccessStatus.ALLOWED);
        ace1.setAceType(ACEType.ALL);
        ace1.setAuthority("andy");
        ace1.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "Read"));
        ace1.setPosition(null);
        this.aclDaoComponent.setAccessControlEntry(Long.valueOf(id), (AccessControlEntry)ace1);
        AccessControlList defined = this.aclDaoComponent.getAccessControlList(Long.valueOf(id));
        AclDaoComponentTest.assertEquals((Object)defined.getProperties().getAclType(), (Object)ACLType.DEFINING);
        AclDaoComponentTest.assertEquals((Object)defined.getProperties().getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)defined.getProperties().getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((int)defined.getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(defined.getEntries(), (AccessControlEntry)ace1, 0));
        Long sharedId = this.aclDaoComponent.getInheritedAccessControlList(Long.valueOf(id));
        AccessControlListProperties sharedProps = this.aclDaoComponent.getAccessControlListProperties(sharedId);
        AclDaoComponentTest.assertEquals((Object)sharedProps.getAclType(), (Object)ACLType.SHARED);
        AclDaoComponentTest.assertEquals((Object)sharedProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)sharedProps.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(Long.valueOf(id)), (Object)sharedId);
        AccessControlList shared = this.aclDaoComponent.getAccessControlList(sharedId);
        AclDaoComponentTest.assertEquals((Object)shared.getProperties().getAclType(), (Object)ACLType.SHARED);
        AclDaoComponentTest.assertEquals((Object)shared.getProperties().getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)shared.getProperties().getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((int)shared.getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(shared.getEntries(), (AccessControlEntry)ace1, 1));
        SimpleAccessControlEntry ace2 = new SimpleAccessControlEntry();
        ace2.setAccessStatus(AccessStatus.ALLOWED);
        ace2.setAceType(ACEType.ALL);
        ace2.setAuthority("paul");
        ace2.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "Write"));
        ace2.setPosition(null);
        this.aclDaoComponent.setAccessControlEntry(Long.valueOf(id), (AccessControlEntry)ace2);
        defined = this.aclDaoComponent.getAccessControlList(Long.valueOf(id));
        AclDaoComponentTest.assertEquals((Object)defined.getProperties().getAclType(), (Object)ACLType.DEFINING);
        AclDaoComponentTest.assertEquals((Object)defined.getProperties().getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)defined.getProperties().getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((int)defined.getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(defined.getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(defined.getEntries(), (AccessControlEntry)ace2, 0));
        sharedId = this.aclDaoComponent.getInheritedAccessControlList(Long.valueOf(id));
        shared = this.aclDaoComponent.getAccessControlList(sharedId);
        AclDaoComponentTest.assertEquals((Object)shared.getProperties().getAclType(), (Object)ACLType.SHARED);
        AclDaoComponentTest.assertEquals((Object)shared.getProperties().getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)shared.getProperties().getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((int)shared.getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(shared.getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(shared.getEntries(), (AccessControlEntry)ace2, 1));
    }

    public void testInheritanceChainDefShared() {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setVersioned(true);
        Long def1 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long shared1 = this.aclDaoComponent.getInheritedAccessControlList(def1);
        Long def2 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        this.aclDaoComponent.mergeInheritedAccessControlList(shared1, def2);
        Long shared2 = this.aclDaoComponent.getInheritedAccessControlList(def2);
        Long def3 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        this.aclDaoComponent.mergeInheritedAccessControlList(shared2, def3);
        Long shared3 = this.aclDaoComponent.getInheritedAccessControlList(def3);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)0);
        SimpleAccessControlEntry ace1 = new SimpleAccessControlEntry();
        ace1.setAccessStatus(AccessStatus.ALLOWED);
        ace1.setAceType(ACEType.ALL);
        ace1.setAuthority("andy");
        ace1.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "Write"));
        ace1.setPosition(null);
        this.aclDaoComponent.setAccessControlEntry(def1, (AccessControlEntry)ace1);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        Long def4 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        this.aclDaoComponent.mergeInheritedAccessControlList(shared3, def4);
        Long shared4 = this.aclDaoComponent.getInheritedAccessControlList(def4);
        Long def5 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        this.aclDaoComponent.mergeInheritedAccessControlList(shared4, def5);
        Long shared5 = this.aclDaoComponent.getInheritedAccessControlList(def5);
        Long def6_1 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        this.aclDaoComponent.mergeInheritedAccessControlList(shared5, def6_1);
        Long shared6_1 = this.aclDaoComponent.getInheritedAccessControlList(def6_1);
        Long def6_2 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        this.aclDaoComponent.mergeInheritedAccessControlList(shared5, def6_2);
        Long shared6_2 = this.aclDaoComponent.getInheritedAccessControlList(def6_2);
        Long def6_3 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        this.aclDaoComponent.mergeInheritedAccessControlList(shared5, def6_3);
        Long shared6_3 = this.aclDaoComponent.getInheritedAccessControlList(def6_3);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 11));
        SimpleAccessControlEntry ace2 = new SimpleAccessControlEntry();
        ace2.setAccessStatus(AccessStatus.ALLOWED);
        ace2.setAceType(ACEType.ALL);
        ace2.setAuthority("paul");
        ace2.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "Write"));
        ace2.setPosition(null);
        this.aclDaoComponent.setAccessControlEntry(def4, (AccessControlEntry)ace2);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace2, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace2, 5));
        this.aclDaoComponent.disableInheritance(def4, false);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace2, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace2, 5));
        this.aclDaoComponent.enableInheritance(def4, shared3);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace2, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace2, 5));
        this.aclDaoComponent.enableInheritance(def4, shared2);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace2, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace2, 5));
        this.aclDaoComponent.disableInheritance(def4, true);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace2, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace2, 5));
        this.aclDaoComponent.deleteAccessControlEntries(def4, (AccessControlEntry)ace1);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace2, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace2, 5));
        this.aclDaoComponent.deleteLocalAccessControlEntries(def4);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)0);
        this.aclDaoComponent.enableInheritance(def4, shared3);
        this.aclDaoComponent.setAccessControlEntry(def4, (AccessControlEntry)ace2);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace2, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace2, 5));
        this.aclDaoComponent.deleteLocalAccessControlEntries(def4);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 11));
        this.aclDaoComponent.setAccessControlEntry(def4, (AccessControlEntry)ace2);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace2, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace2, 5));
        this.aclDaoComponent.deleteInheritedAccessControlEntries(def4);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace2, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace2, 5));
        this.aclDaoComponent.deleteLocalAccessControlEntries(def4);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)0);
        this.aclDaoComponent.enableInheritance(def4, shared3);
        this.aclDaoComponent.setAccessControlEntry(def4, (AccessControlEntry)ace2);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def4).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared4).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared4).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace2, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace2, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 10));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace2, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 11));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace2, 5));
        this.aclDaoComponent.deleteAccessControlList(def4);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def5).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared5).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared5).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 9));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 8));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 9));
        this.aclDaoComponent.deleteAccessControlList(def5);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_3).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_3).getEntries(), (AccessControlEntry)ace1, 7));
        this.aclDaoComponent.deleteAccessControlList(def6_3);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def3).getEntries(), (AccessControlEntry)ace1, 4));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared3).getEntries(), (AccessControlEntry)ace1, 5));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_1).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_1).getEntries(), (AccessControlEntry)ace1, 7));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(def6_2).getEntries(), (AccessControlEntry)ace1, 6));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared6_2).getEntries(), (AccessControlEntry)ace1, 7));
        this.aclDaoComponent.deleteAccessControlList(def1);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def2).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def3).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared3).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_1).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_1).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(def6_2).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared6_2).getEntries().size(), (int)0);
    }

    public void testDeleteAuthority() {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setVersioned(true);
        Long defined = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        SimpleAccessControlEntry ace1 = new SimpleAccessControlEntry();
        ace1.setAccessStatus(AccessStatus.ALLOWED);
        ace1.setAceType(ACEType.ALL);
        ace1.setAuthority("offski");
        ace1.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "P1"));
        ace1.setPosition(null);
        SimpleAccessControlEntry ace2 = new SimpleAccessControlEntry();
        ace2.setAccessStatus(AccessStatus.ALLOWED);
        ace2.setAceType(ACEType.ALL);
        ace2.setAuthority("offski");
        ace2.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "P2"));
        ace2.setPosition(null);
        SimpleAccessControlEntry ace3 = new SimpleAccessControlEntry();
        ace3.setAccessStatus(AccessStatus.ALLOWED);
        ace3.setAceType(ACEType.ALL);
        ace3.setAuthority("keepski");
        ace3.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "P3"));
        ace3.setPosition(null);
        Long shared = this.aclDaoComponent.getInheritedAccessControlList(defined);
        properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.FIXED);
        properties.setVersioned(true);
        Long fixed = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.GLOBAL);
        properties.setVersioned(true);
        Long global = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.OLD);
        properties.setVersioned(false);
        Long old = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        this.aclDaoComponent.setAccessControlEntry(defined, (AccessControlEntry)ace1);
        this.aclDaoComponent.setAccessControlEntry(defined, (AccessControlEntry)ace2);
        this.aclDaoComponent.setAccessControlEntry(defined, (AccessControlEntry)ace3);
        this.aclDaoComponent.setAccessControlEntry(fixed, (AccessControlEntry)ace1);
        this.aclDaoComponent.setAccessControlEntry(fixed, (AccessControlEntry)ace2);
        this.aclDaoComponent.setAccessControlEntry(fixed, (AccessControlEntry)ace3);
        this.aclDaoComponent.setAccessControlEntry(global, (AccessControlEntry)ace1);
        this.aclDaoComponent.setAccessControlEntry(global, (AccessControlEntry)ace2);
        this.aclDaoComponent.setAccessControlEntry(global, (AccessControlEntry)ace3);
        this.aclDaoComponent.setAccessControlEntry(old, (AccessControlEntry)ace1);
        this.aclDaoComponent.setAccessControlEntry(old, (AccessControlEntry)ace2);
        this.aclDaoComponent.setAccessControlEntry(old, (AccessControlEntry)ace3);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(defined).getEntries().size(), (int)3);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared).getEntries().size(), (int)3);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(fixed).getEntries().size(), (int)3);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(global).getEntries().size(), (int)3);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(old).getEntries().size(), (int)3);
        this.aclDaoComponent.deleteAccessControlEntries("offski");
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(defined).getEntries().size(), (int)1);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared).getEntries().size(), (int)1);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(fixed).getEntries().size(), (int)1);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(global).getEntries().size(), (int)1);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(old).getEntries().size(), (int)1);
    }

    public void testSimpleCow() throws Exception {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setVersioned(true);
        Long id = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        AccessControlListProperties aclProps = this.aclDaoComponent.getAccessControlListProperties(id);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclType(), (Object)ACLType.DEFINING);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclProps.getInherits(), (Object)Boolean.TRUE);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        AccessControlListProperties aclPropsBefore = this.aclDaoComponent.getAccessControlListProperties(id);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getAclType(), (Object)ACLType.DEFINING);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getInherits(), (Object)Boolean.TRUE);
        SimpleAccessControlEntry ace1 = new SimpleAccessControlEntry();
        ace1.setAccessStatus(AccessStatus.ALLOWED);
        ace1.setAceType(ACEType.ALL);
        ace1.setAuthority("andy");
        ace1.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "Read"));
        ace1.setPosition(null);
        List changes = this.aclDaoComponent.setAccessControlEntry(id, (AccessControlEntry)ace1);
        AclDaoComponentTest.assertEquals((int)changes.size(), (int)1);
        AclDaoComponentTest.assertEquals((Object)((AclChange)changes.get(0)).getBefore(), (Object)id);
        AclDaoComponentTest.assertFalse((boolean)((AclChange)changes.get(0)).getBefore().equals(((AclChange)changes.get(0)).getAfter()));
        aclPropsBefore = this.aclDaoComponent.getAccessControlListProperties(((AclChange)changes.get(0)).getBefore());
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getAclType(), (Object)ACLType.DEFINING);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.isLatest(), (Object)Boolean.FALSE);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.isVersioned(), (Object)Boolean.TRUE);
        AccessControlListProperties aclPropsAfter = this.aclDaoComponent.getAccessControlListProperties(((AclChange)changes.get(0)).getAfter());
        AclDaoComponentTest.assertEquals((Object)aclPropsAfter.getAclType(), (Object)aclPropsBefore.getAclType());
        AclDaoComponentTest.assertEquals((Object)aclPropsAfter.getAclVersion(), (Object)(aclPropsBefore.getAclVersion() + 1L));
        AclDaoComponentTest.assertEquals((Object)aclPropsAfter.getInherits(), (Object)aclPropsBefore.getInherits());
        AclDaoComponentTest.assertEquals((String)aclPropsAfter.getAclId(), (String)aclPropsBefore.getAclId());
        AclDaoComponentTest.assertEquals((Object)aclPropsAfter.isVersioned(), (Object)aclPropsBefore.isVersioned());
        AclDaoComponentTest.assertEquals((Object)aclPropsAfter.isLatest(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(((AclChange)changes.get(0)).getBefore()).getEntries().size(), (int)0);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(((AclChange)changes.get(0)).getAfter()).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(((AclChange)changes.get(0)).getAfter()).getEntries(), (AccessControlEntry)ace1, 0));
    }

    public void testSimpleCowHerd1() throws Exception {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setVersioned(true);
        Long i_1 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1 = this.aclDaoComponent.getInheritedAccessControlList(i_1);
        Long i_1_2 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_2 = this.aclDaoComponent.getInheritedAccessControlList(i_1_2);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1, i_1_2);
        Long i_1_3 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_3 = this.aclDaoComponent.getInheritedAccessControlList(i_1_3);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1, i_1_3);
        Long i_1_2_4 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_2_4 = this.aclDaoComponent.getInheritedAccessControlList(i_1_2_4);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1_2, i_1_2_4);
        Long i_1_2_4_5 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_2_4_5 = this.aclDaoComponent.getInheritedAccessControlList(i_1_2_4_5);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1_2_4, i_1_2_4_5);
        Long i_1_3_6 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_3_6 = this.aclDaoComponent.getInheritedAccessControlList(i_1_3_6);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1_3, i_1_3_6);
        Long i_1_3_6_7 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_3_6_7 = this.aclDaoComponent.getInheritedAccessControlList(i_1_3_6_7);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1_3_6, i_1_3_6_7);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        SimpleAccessControlEntry ace1 = new SimpleAccessControlEntry();
        ace1.setAccessStatus(AccessStatus.ALLOWED);
        ace1.setAceType(ACEType.ALL);
        ace1.setAuthority("andy");
        ace1.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "Read"));
        ace1.setPosition(null);
        List changes = this.aclDaoComponent.setAccessControlEntry(i_1, (AccessControlEntry)ace1);
        HashSet<Long> changed = new HashSet<Long>(changes.size());
        for (AclChange change : changes) {
            changed.add(change.getBefore());
            AclDaoComponentTest.assertFalse((boolean)change.getBefore().equals(change.getAfter()));
        }
        AclDaoComponentTest.assertTrue((boolean)changed.contains(i_1));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(s_1));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(i_1_2));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(s_1_2));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(i_1_3));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(s_1_3));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(i_1_2_4));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(s_1_2_4));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(i_1_2_4_5));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(s_1_2_4_5));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(i_1_3_6));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(s_1_3_6));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(i_1_3_6_7));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(s_1_3_6_7));
    }

    public void testSimpleCowHerd2() throws Exception {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setVersioned(true);
        Long i_1 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1 = this.aclDaoComponent.getInheritedAccessControlList(i_1);
        Long i_1_2 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_2 = this.aclDaoComponent.getInheritedAccessControlList(i_1_2);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1, i_1_2);
        Long i_1_3 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_3 = this.aclDaoComponent.getInheritedAccessControlList(i_1_3);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1, i_1_3);
        Long i_1_2_4 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_2_4 = this.aclDaoComponent.getInheritedAccessControlList(i_1_2_4);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1_2, i_1_2_4);
        Long i_1_2_4_5 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_2_4_5 = this.aclDaoComponent.getInheritedAccessControlList(i_1_2_4_5);
        AclDaoComponentTest.assertNotNull((Object)s_1_2_4_5);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1_2_4, i_1_2_4_5);
        Long i_1_3_6 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_3_6 = this.aclDaoComponent.getInheritedAccessControlList(i_1_3_6);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1_3, i_1_3_6);
        Long i_1_3_6_7 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long s_1_3_6_7 = this.aclDaoComponent.getInheritedAccessControlList(i_1_3_6_7);
        this.aclDaoComponent.mergeInheritedAccessControlList(s_1_3_6, i_1_3_6_7);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        SimpleAccessControlEntry ace1 = new SimpleAccessControlEntry();
        ace1.setAccessStatus(AccessStatus.ALLOWED);
        ace1.setAceType(ACEType.ALL);
        ace1.setAuthority("andy");
        ace1.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "Read"));
        ace1.setPosition(null);
        List changes = this.aclDaoComponent.setAccessControlEntry(i_1_3, (AccessControlEntry)ace1);
        HashSet<Long> changed = new HashSet<Long>(changes.size());
        for (AclChange change : changes) {
            changed.add(change.getBefore());
            AclDaoComponentTest.assertFalse((boolean)change.getBefore().equals(change.getAfter()));
        }
        AclDaoComponentTest.assertTrue((boolean)changed.contains(i_1_3));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(s_1_3));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(i_1_3_6));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(s_1_3_6));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(i_1_3_6_7));
        AclDaoComponentTest.assertTrue((boolean)changed.contains(s_1_3_6_7));
    }

    public void testOldDoesNotCow() throws Exception {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.OLD);
        properties.setVersioned(false);
        Long id = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        AccessControlListProperties aclProps = this.aclDaoComponent.getAccessControlListProperties(id);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclType(), (Object)ACLType.OLD);
        AclDaoComponentTest.assertEquals((Object)aclProps.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclProps.getInherits(), (Object)Boolean.TRUE);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        AccessControlListProperties aclPropsBefore = this.aclDaoComponent.getAccessControlListProperties(id);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getAclType(), (Object)ACLType.OLD);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getInherits(), (Object)Boolean.TRUE);
        SimpleAccessControlEntry ace1 = new SimpleAccessControlEntry();
        ace1.setAccessStatus(AccessStatus.ALLOWED);
        ace1.setAceType(ACEType.ALL);
        ace1.setAuthority("andy");
        ace1.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "Read"));
        ace1.setPosition(null);
        List changes = this.aclDaoComponent.setAccessControlEntry(id, (AccessControlEntry)ace1);
        AclDaoComponentTest.assertEquals((int)changes.size(), (int)1);
        AclDaoComponentTest.assertEquals((Object)((AclChange)changes.get(0)).getBefore(), (Object)id);
        AclDaoComponentTest.assertTrue((boolean)((AclChange)changes.get(0)).getBefore().equals(((AclChange)changes.get(0)).getAfter()));
        aclPropsBefore = this.aclDaoComponent.getAccessControlListProperties(((AclChange)changes.get(0)).getBefore());
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getAclType(), (Object)ACLType.OLD);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getAclVersion(), (Object)1L);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.getInherits(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.isLatest(), (Object)Boolean.TRUE);
        AclDaoComponentTest.assertEquals((Object)aclPropsBefore.isVersioned(), (Object)Boolean.FALSE);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(((AclChange)changes.get(0)).getBefore()).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(((AclChange)changes.get(0)).getBefore()).getEntries(), (AccessControlEntry)ace1, 0));
    }

    public void testAddSimilar() {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setVersioned(false);
        Long id1 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long shared1 = this.aclDaoComponent.getInheritedAccessControlList(id1);
        Long id2 = this.aclDaoComponent.createAccessControlList((AccessControlListProperties)properties).getId();
        Long shared2 = this.aclDaoComponent.getInheritedAccessControlList(id2);
        this.aclDaoComponent.mergeInheritedAccessControlList(shared1, id2);
        SimpleAccessControlEntry ace1 = new SimpleAccessControlEntry();
        ace1.setAccessStatus(AccessStatus.ALLOWED);
        ace1.setAceType(ACEType.ALL);
        ace1.setAuthority("andy");
        ace1.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "Read"));
        ace1.setPosition(null);
        SimpleAccessControlEntry ace2 = new SimpleAccessControlEntry();
        ace2.setAccessStatus(AccessStatus.ALLOWED);
        ace2.setAceType(ACEType.ALL);
        ace2.setAuthority("andy");
        ace2.setPermission((PermissionReference)new SimplePermissionReference(QName.createQName((String)"uri", (String)"local"), "Read"));
        ace2.setPosition(null);
        this.aclDaoComponent.setAccessControlEntry(id1, (AccessControlEntry)ace1);
        this.aclDaoComponent.setAccessControlEntry(id2, (AccessControlEntry)ace1);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(id1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(id2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id2).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        this.aclDaoComponent.setAccessControlEntry(id1, (AccessControlEntry)ace2);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(id1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id1).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(id2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id2).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
        this.aclDaoComponent.setAccessControlEntry(id1, (AccessControlEntry)ace1);
        this.aclDaoComponent.setAccessControlEntry(id2, (AccessControlEntry)ace2);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(id1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(id2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id2).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id2).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace2, 3));
        this.aclDaoComponent.setAccessControlEntry(id1, (AccessControlEntry)ace2);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(id1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id1).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(id2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id2).getEntries(), (AccessControlEntry)ace2, 0));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id2).getEntries(), (AccessControlEntry)ace2, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace2, 1));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace2, 3));
        this.aclDaoComponent.setAccessControlEntry(id1, (AccessControlEntry)ace1);
        this.aclDaoComponent.setAccessControlEntry(id2, (AccessControlEntry)ace1);
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(id1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id1).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared1).getEntries().size(), (int)1);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared1).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(id2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id2).getEntries(), (AccessControlEntry)ace1, 0));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(id2).getEntries(), (AccessControlEntry)ace1, 2));
        AclDaoComponentTest.assertEquals((int)this.aclDaoComponent.getAccessControlList(shared2).getEntries().size(), (int)2);
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 1));
        AclDaoComponentTest.assertTrue((boolean)this.hasAce(this.aclDaoComponent.getAccessControlList(shared2).getEntries(), (AccessControlEntry)ace1, 3));
    }

    private boolean hasAce(List<AccessControlEntry> aces, AccessControlEntry ace, int position) {
        for (AccessControlEntry test : aces) {
            if (!EqualsHelper.nullSafeEquals((Object)test.getAccessStatus(), (Object)ace.getAccessStatus()) || !EqualsHelper.nullSafeEquals((Object)test.getAceType(), (Object)ace.getAceType()) || !EqualsHelper.nullSafeEquals((Object)test.getAuthority(), (Object)ace.getAuthority()) || !EqualsHelper.nullSafeEquals((Object)test.getContext(), (Object)ace.getContext()) || !EqualsHelper.nullSafeEquals((Object)test.getPermission(), (Object)ace.getPermission()) || !EqualsHelper.nullSafeEquals((Object)test.getPosition(), (Object)position)) continue;
            return true;
        }
        return false;
    }
}

