/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.AlfrescoTenant;
import org.alfresco.util.test.junitrules.ApplicationContextInit;

public class TenantPerson
extends AlfrescoPerson {
    private AlfrescoTenant tenant;

    public TenantPerson(ApplicationContextInit appContextInit, String userName, AlfrescoTenant tenant) {
        super(appContextInit, userName + "@" + tenant.getTenantDomain());
        ParameterCheck.mandatory((String)"tenant", (Object)((Object)tenant));
        this.tenant = tenant;
    }

    @Override
    protected void before() {
        this.tenant.runAsSystem(new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                TenantPerson.super.before();
                return null;
            }
        });
    }

    @Override
    protected void after() {
        this.tenant.runAsSystem(new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                TenantPerson.super.after();
                return null;
            }
        });
    }

    public <T> T runAsFullyAuthenticated(TenantUtil.TenantRunAsWork<T> runAsWork) {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.getUsername());
        try {
            Object object = TenantUtil.runAsUserTenant(runAsWork, (String)this.getUsername(), (String)this.tenant.getTenantDomain());
            return (T)object;
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    public String getTenantName() {
        return this.tenant.getTenantDomain();
    }
}

